﻿<%@ Page Language="C#" Inherits="SpaceBuilder.Web.ChannelViewPage<ForumThread>" %>

<asp:content contentplaceholderid="setPageID" runat="server"> id="Forum-EditForumThread" </asp:content>
<asp:content runat="server" contentplaceholderid="subMenusContent">
  <%Html.RenderPartial("Controls/Forums/Submenu.ascx");%>
</asp:content>
<asp:content id="wideContent" contentplaceholderid="wideContent" runat="server">
  <spb:Script runat="server" ID="jqueryForm" Src="~/Utility/jquery/plugin/jquery.form.min-2.7.3.js" SetExpireDays="30" />
  <spb:Script runat="server" ID="CollapsibleBox" Src="~/Utility/jquery/plugin/jquery.spb.CollapsibleBox.js" SetExpireDays="30" />
  <spb:Script runat="server" ID="swfupload" Src="~/Utility/UploadFiles/js/swfupload.js"
    SetExpireDays="30" />
  <spb:Script runat="server" ID="swfupload_queue" Src="~/Utility/UploadFiles/js/swfupload.queue.js"
    SetExpireDays="30" />
  <spb:Script runat="server" ID="fileprogress" Src="~/Utility/UploadFiles/js/fileprogress.js"
    SetExpireDays="30" />
  <spb:Script runat="server" ID="handlers" Src="~/Utility/UploadFiles/js/handlers.js"
    SetExpireDays="30" />
  <%StatusMessageData statusMessageData = TempData.Get<StatusMessageData>("StatusMessageData", null);
    if (statusMessageData != null)
    {
        if (statusMessageData.MessageType == StatusMessageType.Success)
            Response.Write(SPBHtmlHelper.Instance().StatusMessage(statusMessageData.MessageType, statusMessageData.MessageContent, 3000, false));
        else
            Response.Write(SPBHtmlHelper.Instance().StatusMessage(statusMessageData, 3000, false));
        TempData["StatusMessageData"] = null;
    }

    bool validateCategoryID = false;
    int forumsApplication = ApplicationIDs.Instance().Forum();
    ForumSection section = ForumSections.GetSection(Request.QueryString.GetInt("sectionID", 0), false);
    if (section == null)
        section = new ForumSection();

    bool permissions = ForumPermission.Validate(section, CurrentUser, PermissionItemKeys.Instance().ApproveForumPost()) || (CurrentUser != null && CurrentUser.IsContentAdministrator);
       %>
  <div id="EditForumThread" class="tn-box tn-widget tn-widget-content tn-corner-all tn-publish">
    <div class="tn-box-header tn-widget-header tn-corner-top tn-border-bottom">
      <h3 class="tn-helper-reset">
        <% if (ViewData.Model.ThreadID > 0) Response.Write(GetResourceString("Title_EditThread", forumsApplication)); else Response.Write(GetResourceString("Title_AppearThread", forumsApplication)); %>
      </h3>
    </div>
    <div class="tn-box-content tn-widget-content tn-corner-bottom">
      <%  string formActionUrl = string.Empty;
          if (ViewData.Model.ThreadID > 0)
              formActionUrl = SPBUrlHelper.Action("UpdateForumThread", "ChannelForum", new RouteValueDictionary { { "threadID", ViewData.Model.ThreadID } });
          else
          {
              if (ViewData.Model.SectionID > 0)
                  formActionUrl = SPBUrlHelper.Action("CreateForumThread", "ChannelForum", new RouteValueDictionary { { "sectionID", ViewData.Model.SectionID } });
              else
                  formActionUrl = SPBUrlHelper.Action("CreateForumThread", "ChannelForum");
          } %>
      <form id="EditForumThreadForm" name="EditForumThreadForm" class="tn-form" action="<%=formActionUrl %>" method="post">
        <div class="tn-form tn-label-right">
          <div class="tn-form-row tn-title">
            <input name="subject" id="subject" type="text" class="tn-textbox tn-input-longest tn-border-gray" maxlength="80" size="80" value="<%=Formatter.FormatSingleLinePlainTextForEdit(Model.Subject) %>"  />
            <span id="subjectHint" class="tn-text-note"></span> &nbsp;&nbsp;
            <% if (Model.ForumSection != null && Model.ForumSection.ThreadCategoryStatus != ThreadCategoryStatuses.Disabled)
               {%>
            <%=SPBHtmlHelper.Instance().ShowDropDownList<int, string>("categoryID", Model.ForumSection.ThreadCategories.ToDictionary<ForumThreadCategory, int, string>(a => a.CategoryID, b => b.CategoryName), new RouteValueDictionary { { "Class", "tn-dropdownlist" } }, Model.CategoryID)%>
            <%if (Model.ForumSection.ThreadCategoryStatus == ThreadCategoryStatuses.ForceEnabled) { validateCategoryID = true; Response.Write("<span class=\"sure\">" + GetResourceString("Description_Required") + "</span>"); }
               } %>
          </div>
          <% if (ViewData.Model.SectionID <= 0)
             { %>
          <div class="tn-form-row">
            <label class="tn-form-label"> <%=GetResourceString("Label_SelectModule",forumsApplication)%><%=GetResourceString("Common_Colon") %></label>
            <%=SPBHtmlHelper.Instance().ForumSectionsDropDownList("sectionID", null, null, string.Empty, false, GetResourceString("Common_PleaseChoose"), new RouteValueDictionary { { "style", "width:100%;height:270px" }, { "id", "sectionID" } })%> </div>
          <%} %>
          <div class="tn-form-row tn-editor">
            <% string uploadPhotoUrl = SPBUrlHelper.Action("UserContentSelector_UpdateForumAttachments", "ChannelForum", new RouteValueDictionary { { "postID", Model.PostID }, { "sectionID", Model.SectionID }, { "isImage", true } });
               string uploadAttachmentUrl = SPBUrlHelper.Action("UserContentSelector_UpdateForumAttachments", "ChannelForum", new RouteValueDictionary { { "postID", Model.PostID }, { "sectionID", Model.SectionID }, { "isImage", false } });  %>
            <%=SPBHtmlHelper.Instance().HtmlEditor(HtmlEditorMode.Enhanced, "body", ViewData.Model.Body, new RouteValueDictionary { { "style", "width: 100%;height:270px" }, { "id", "body" } },uploadPhotoUrl,uploadAttachmentUrl)%>
            <div class="tn-text-note"><%=string.Format(GetResourceString("Description_ArticleWordCountMax",ApplicationIDs.Instance().Forum()), 1, 50000)%></div>
          </div>
          <div class="tn-form-row tn-write-tags tn-form-expanded tn-helper-clearfix">
            <label class="tn-form-label"> <%=GetResourceString("Common_UserTag")%><%=GetResourceString("Common_Colon") %></label>
            <%        
                ViewData["TagInputName"] = "forumTags";
                ViewData["applicationTagItemKey"] = ApplicationTagItemKeys.Instance().Forum();
                ViewData["SelectedUserTags"] = Model.Tags;
                Html.RenderPartial("Controls/ApplicationTagSelector.ascx", ViewData);
            %>
          </div>
          <div class="tn-collapsible tn-collapsible-closed">
            <div class="tn-border-bottom tn-border-gray tn-collapsible-header">
              <h4 class="tn-helper-reset"><a href="javascript:;;"><%=GetResourceString("Title_AdvancedSettings")%></a></h4>
            </div>
            <div class="tn-blank10"></div>
            <div class="tn-collapsible-content" style="display:block;">
              <div class="tn-form-row">
                <label class="tn-form-label"> <%=GetResourceString("Label_TopicSale",forumsApplication)%><%=GetResourceString("Common_Colon") %></label>
                <input class="tn-textbox tn-input-short tn-border-gray" type="text" id="Price" name="Price" value="<%=Model.Price %>"/>
                <span class="tn-text-note"> <%=GetResourceString("Description_PriceNotNull",forumsApplication)%></span> </div>
              <%if (permissions)
                { %>
              <div class="tn-form-row">
                <label class="tn-form-label"> <%=GetResourceString("Title_PostSettings", forumsApplication)%><%=GetResourceString("Common_Colon")%></label>
                <input name="isLocked" id="isLocked" type="checkbox" class="tn-checkbox" <%if(ViewData.Model.IsLocked) Response.Write("checked=\"checked\""); %> value="true" />
                <label for="isLocked"> <%=GetResourceString("Label_TopicLock", forumsApplication)%></label>
              </div>
              <%} %>
              <%  if (CurrentUser != null && ForumPermission.Validate(ViewData.Model.ForumSection, CurrentUser, PermissionItemKeys.Instance().StickyForumThread()))
                  { %>
              <div class="tn-form-row">
                <label class="tn-form-label"></label>
                <input name="isSticky" id="isSticky" type="checkbox" class="tn-checkbox" <%if(ViewData.Model.IsSticky) Response.Write("checked=\"checked\""); %> value="true" />
                <label for="isSticky"><%=GetResourceString("Label_TopicTop",forumsApplication)%></label>
                <% if (ViewData.Model.IsSticky)
                   { %>
                <span id="showStickyDateSpan"><%=GetResourceString("Label_TopTimeLimit",forumsApplication)%><%=GetResourceString("Common_Colon") %><%=Formatter.FormatDate(ViewData.Model.StickyDate) %>&nbsp;&nbsp; <a href="javascript:;" id="EditStickyDay" onclick="$('#setStickySpan').show();$('#showStickyDateSpan').hide();"  title="<%=GetResourceString("Description_Reinstall",forumsApplication) %>"><%=GetResourceString("Action_Edit")%></a></span>
                <%}%>
                <span id="setStickySpan" style="display:none">，<%=GetResourceString("Label_SetTopTime",forumsApplication) %><%=GetResourceString("Common_Colon") %>
                <select name="stickyDays" class="dropDownList">
                  <option value="1"><%=string.Format(GetResourceString("Enum_Pattern_TopDay",forumsApplication),1)%></option>
                  <option value="3"><%=string.Format(GetResourceString("Enum_Pattern_TopDay",forumsApplication),3)%></option>
                  <option value="7"><%=string.Format(GetResourceString("Enum_Pattern_TopWeek", forumsApplication), 1)%></option>
                  <option value="14"><%=string.Format(GetResourceString("Enum_Pattern_TopWeek", forumsApplication), 2)%></option>
                  <option value="30"><%=string.Format(GetResourceString("Enum_Pattern_TopMonth",forumsApplication),1)%></option>
                  <option value="90"><%=string.Format(GetResourceString("Enum_Pattern_TopMonth",forumsApplication),3)%></option>
                  <option value="180"><%=string.Format(GetResourceString("Enum_Pattern_TopMonth",forumsApplication),6)%></option>
                  <option value="365"><%=string.Format(GetResourceString("Enum_Pattern_TopYear",forumsApplication),1)%></option>
                </select>
                &nbsp;&nbsp; <a href="javascript:;" id="cancelSticky" onclick=" $('#setStickySpan').hide();$('#showStickyDateSpan').show();<% if (!ViewData.Model.IsSticky) Response.Write("$('#isSticky').removeAttr('checked');"); %>"
                     title="<%=GetResourceString("Description_CancelReinstall",forumsApplication) %>"><%=GetResourceString("Button_Cancel")%></a> </span> </div>
              <%} %>
              <%if (permissions)
                { %>
              <div class="tn-form-row">
                <label class="tn-form-label"></label>
                <input name="isEssential" id="isEssential" type="checkbox" class="tn-checkbox" <%if(ViewData.Model.IsEssential) Response.Write("checked=\"checked\""); %> value="true" />
                <label for="isEssential"> <%=GetResourceString("Label_SetEssential", forumsApplication)%></label>
              </div>
              <%} %>
              <div class="tn-form-row">
                <label class="tn-form-label"></label>
                <input name="IsHidden" id="IsHidden" type="checkbox" class="tn-checkbox" <%if(ViewData.Model.IsHidden) Response.Write("checked=\"checked\""); %>  value="true" />
                <label for="IsHidden"><%=GetResourceString("Title_IsHidden", forumsApplication)%></label>
              </div>
              <div class="tn-form-row">
                <label class="tn-form-label"></label>
                <input name="isUseSignature" id="isUseSignature" type="checkbox" class="tn-checkbox" <%if(ViewData.Model.IsUseSignature) Response.Write("checked=\"checked\""); %> value="true" />
                <label for="isUseSignature"><%=GetResourceString("Label_UseUnderwrite",forumsApplication)%></label>
              </div>
            </div>
          </div>
          <div class="tn-form-row tn-form-row-button">
            <label class="tn-form-label"> </label>
            <%=SPBHtmlHelper.Instance().SubmitButton("postButton", GetResourceString("Button_Submit"), ButtonSizes.Large, null,null)%>
            <% if (Request.UrlReferrer != null)
               {%>
            <%=SPBHtmlHelper.Instance().Button(string.Empty, GetResourceString("Button_Cancel"), ButtonSizes.Large, HighlightStyles.Secondary,new RouteValueDictionary() { { "onclick","window.location.href='" + Request.UrlReferrer.AbsoluteUri +"'"} },null)%>
            <%} %>
          </div>
        </div>
      </form>
    </div>
  </div>
  <script type="text/javascript">
        $(document).ready(function() {
        
            $(".tn-collapsible").collapsibleBox();
            
            $("#subject").focus();
            
            $("#subject").keyup(function() {
                $("#subjectHint").html('<%=GetResourceString("Message_Alsoenter", forumsApplication)%>' + (80 - this.value.length) + '<%=GetResourceString("Message_Words", forumsApplication)%>');  
            });
            
            $("#EditForumThreadForm").validate({
                rules: {
                    sectionID: { required: true, minBlength: 1 },
                    subject: { required: true, rangelength: [1, 80] },
                    Price:{ required : true,digits:true ,max : 9999},
                    body: { htmlEditorRequired: true, htmlEditorRange: [1, 50000] }
                    <% if(validateCategoryID){ %>
                    ,categoryID:{min: 1}
                    <%} %>
                },
                messages: {
                    sectionID: { required: "<%=GetResourceString("Validate_SectionModuel",forumsApplication) %>", minBlength: "<%=GetResourceString("Validate_SectionModuel",forumsApplication) %>" },
                    subject: { required: "<%=GetResourceString("Validate_InputTitle")%>", rangelength: "<%=string.Format(GetResourceString("Validate_Pattern_Subject_Rangelength",forumsApplication),60)%>" },
                    body: { htmlEditorRequired: "<%=GetResourceString("Validate_InputThreadContent",forumsApplication) %>", htmlEditorRange: "<%=string.Format(GetResourceString("Validate_Pattern_Subject_Rangelength",forumsApplication),50000)%>" }
                    <% if(validateCategoryID){ %>
                    ,categoryID:{min: "<%=GetResourceString("Validate_SelectThreadCategory",forumsApplication) %>"}
                    <%} %>
                }
            });
            
            $("#postButton").click(function() {
                if (!$("#EditForumThreadForm").valid())
                    return false;
            });
            
            isStickyClick();
            
            $("#isSticky").click(isStickyClick);  


        });
        function  isStickyClick(){
            if ($('#isSticky').attr('checked'))
               {
               <%if (ViewData.Model.IsSticky)
                { %>
                    $('#showStickyDateSpan').show();
               <%}
                else {%>
                    $('#setStickySpan').fadeIn('normal');
                    $('#showStickyDateSpan').hide();  
                <%} %>                  
                }
            else {
                $('#setStickySpan').fadeOut('fast');
                $('#showStickyDateSpan').hide();  
            }
        }
    </script>
</asp:content>
<asp:content id="templateContentRegion" contentplaceholderid="templateContentRegion"
    runat="server"> </asp:content>
