﻿<%@ Page Language="C#" Inherits="SpaceBuilder.Web.ChannelViewPage<Dictionary<ForumSectionGroup, IList<ForumSection>>>" %>

<asp:content contentplaceholderid="setPageID" runat="server">
    id="Forum-Home"
    </asp:content>
<asp:content runat="server" contentplaceholderid="subMenusContent">
    <%ViewData["ChannelForumSubMenu"] = ChannelForumSubMenu.ForumHome;
      Html.RenderPartial("Controls/Forums/Submenu.ascx", ViewData);%>          
</asp:content>
<asp:content id="wideContentRegion" runat="server" contentplaceholderid="wideContentRegion">
</asp:content>
<asp:content runat="server" contentplaceholderid="templateContentRegion">
<%=SPBHtmlHelper.Instance().ShowAdvertisingInChannel("001000000001", new RouteValueDictionary { { "class", "spb-ad-banner" } })%>
<div class="tn-wrapper tn-template-r-230 tn-helper-clearfix">
    <div class="tn-main">
        <div class="tn-block">
            <%  int applicationID = ApplicationIDs.Instance().Forum();
                int mode;
                if (Model != null && Model.Count > 0)
                {
                    foreach (KeyValuePair<ForumSectionGroup, IList<ForumSection>> pair in Model)
                    {
                        if (pair.Value == null || pair.Value.Count <= 0)
                            continue;
                        UserCookie userCookie = new UserCookie(CurrentUser, HttpContext.Current);
                        mode = userCookie.GetForumSectionListMode(pair.Key.GroupID);

                        ViewData["listID"] = pair.Key.GroupID;%>
            <div class="tn-widget tn-widget-content tn-corner-all tn-box tn-collapsible tn-collapsible-opened  <%if (mode == (int)BrowseMode.detail) Response.Write("spb-forum-group-detail"); else Response.Write("spb-forum-group-medium"); %>"
                id="forumSectionGroup_<%=pair.Key.GroupID %>">
                <div class="tn-widget-header tn-corner-top tn-border-bottom tn-box-header tn-collapsible-header tn-state-default tn-switch-right">
                    <h3 class="tn-helper-reset">
                        <a href="<%=SPBUrlHelper.Action("ShowForumGroup", "ChannelForum", new RouteValueDictionary { { "groupID", pair.Key.GroupID } })%>">
                            <%=pair.Key.GroupName%></a></h3>
                    <span class="tn-icon tn-switch tn-icon-collapse-close"></span>
                </div>
                <div class="tn-widget-content tn-corner-bottom tn-box-content tn-collapsible-content"
                    id="forumSectionDetailForLoad_<%=pair.Key.GroupID%>">
                    <div class="tn-list-header tn-helper-align-right">
                        <span class="tn-helper-left"><em>
                            <%=GetResourceString("Label_Thread", applicationID)%><%=GetResourceString("Common_Colon")%><%=pair.Key.ThreadCount%></em><em><%=GetResourceString("Label_Topic",applicationID)%><%=GetResourceString("Common_Colon")%><%=pair.Key.PostCount%></em></span>
                        <%=GetResourceString("Action_View")%><%=GetResourceString("Common_Colon") %><span
                            class="tn-action tn-action-text-icon <%if (mode == (int)BrowseMode.detail) Response.Write("tn-selected");%>"><span
                                class="tn-icon tn-icon-browse-detail"> </span>
                            <a class="tn-action-text" href="javascript:;" id="detail_<%=pair.Key.GroupID %>"
                                onclick="toggleMode(this,<%=pair.Key.GroupID%>,<%=(int)BrowseMode.detail %>);">
                                <%=GetResourceString("Action_detail",applicationID)%></a></span>
                        <span class="tn-action tn-action-text-icon <%if (mode == (int)BrowseMode.medium) Response.Write("tn-selected");%>">
                            <span class="tn-icon tn-icon-browse-medium"></span>
                            <a class="tn-action-text" href="javascript:;" onclick="toggleMode(this,<%=pair.Key.GroupID%>,<%=(int)BrowseMode.medium %>);"
                                id="medium_<%=pair.Key.GroupID %>">
                                <%=GetResourceString("Action_medium",applicationID)%></a></span>
                    </div>
                    <div id="forumSectionForLoad_<%=(int)BrowseMode.detail%>_<%=pair.Key.GroupID%>">
                        <% if (mode == (int)BrowseMode.detail)
                           {
                               ViewData["Mode"] = (int)BrowseMode.detail;
                               Html.RenderPartial("Controls/Forums/ListForumSections.ascx", pair.Value, ViewData);
                           }%>
                              
                    </div>
                    <div id="forumSectionForLoad_<%=(int)BrowseMode.medium%>_<%=pair.Key.GroupID%>">
                        <% if (mode == (int)BrowseMode.medium)
                           {
                               ViewData["Mode"] = (int)BrowseMode.medium;
                               Html.RenderPartial("Controls/Forums/ListForumSections.ascx", pair.Value, ViewData);
                           }%>
                    </div>
                </div>
            </div>
            <div class="tn-blank10">
            </div>
            <%}
                }%>
        </div>
    </div>
    <div class="tn-block">
        <% Html.RenderAction<ChannelForumController>(f => f.Control_SideThreadsBlock(ForumThreadSortBy.PostDate, null, 10, GetResourceString("Title_NewThread", ApplicationIDs.Instance().Forum()))); %>
        <% Html.RenderAction<ChannelForumController>(f => f.Control_SideThreadsBlock(ForumThreadSortBy.PostDate, true, 10, GetResourceString("Title_EssentialThread", ApplicationIDs.Instance().Forum()))); %>
        <% Html.RenderAction<ChannelForumController>(f => f.Control_SideThreadsBlock(ForumThreadSortBy.HitTimes, null, 10, GetResourceString("Title_HotThread", ApplicationIDs.Instance().Forum()))); %>
        <% Html.RenderAction<ChannelForumController>(f => f.Control_SideThreadsBlock(ForumThreadSortBy.ReplyCount, null, 10, "热评主题")); %>
        <% Html.RenderAction<ChannelForumController>(n => n.Control_ListForumsSiteTags(30, ApplicationTagsSortBy.ItemCount)); %>
    </div>
</div>
<script type="text/javascript">
    $(document).ready(function() {
        $(".tn-collapsible").collapsibleBox({ target: ".tn-switch" });
        $('.tn-state-default').hover(
        function() {
            $(this).removeClass('tn-state-default').addClass('tn-state-hover');
        },
        function() {
            $(this).removeClass('tn-state-hover').addClass('tn-state-default');
        });
    });
    function toggleMode(obj, listID, mode) {
        $("#forumSectionForLoad_" + mode + "_" + listID).siblings("div[id^='forumSectionForLoad']").hide();
        $("#" + obj.id).parent("span.tn-action").addClass("tn-selected").siblings("span.tn-selected").removeClass("tn-selected");
        if (mode == 0)
            $("#forumSectionGroup_" + listID).addClass("spb-forum-group-detail").removeClass("spb-forum-group-medium");
        else
            $("#forumSectionGroup_" + listID).removeClass("spb-forum-group-detail").addClass("spb-forum-group-medium");
        if ($("#forumSectionForLoad_" + mode + "_" + listID + "table").length <= 0)
            $("#forumSectionForLoad_" + mode + "_" + listID).show().load('<%=SPBUrlHelper.Action("Control_ListForumSection", "ChannelForum")%>?groupID=' + listID + '&mode=' + mode);
        else
            $("#forumSectionForLoad_" + mode + "_" + listID).show();
    }
  </script>
<%=SPBHtmlHelper.Instance().ShowAdvertisingInChannel("001000000002", new RouteValueDictionary { { "class", "spb-ad-banner-bottom" } })%>
</asp:content>
