﻿<%@ Page Language="C#" Inherits="SpaceBuilder.Web.ChannelViewPage<PagingDataSet<ForumThread>>" %>

<asp:content contentplaceholderid="setPageID" runat="server"> id="Forum-ManageForumThreads" </asp:content>
<asp:content contentplaceholderid="subMenusContent" runat="server">
  <%  ViewData["ChannelForumSubMenu"] = ChannelForumSubMenu.ManageForum;
      Html.RenderPartial("Controls/Forums/SubMenu.ascx", ViewData);%>
</asp:content>
<asp:content contentplaceholderid="wideFirstContent" runat="server">
  <spb:Script runat="server" ID="menuButton" Src="~/Utility/jquery/plugin/jquery.spb.menuButton.js"
    SetExpireDays="30" />
  <spb:Script runat="server" ID="iColorPicker" Src="~/Utility/jquery/plugin/iColorPicker-noLink.js"
    SetExpireDays="30" />
  <%int sideSubMenu = ViewData.GetInt("sideSubMenu", (int)ForumSubMenus.ManageThread);
    int applicationID = ApplicationIDs.Instance().Forum();%>
  <div id="manageMeun" class="tn-box tn-widget tn-widget-content tn-corner-all">
    <div class="tn-box-header tn-widget-header tn-corner-top tn-border-bottom">
      <h3 class="tn-helper-reset"> <%=GetResourceString("Action_ForumManage", applicationID)%> </h3>
    </div>
    <div class="tn-box-content tn-widget-content tn-corner-bottom">
      <ul class="tn-side-menu">
        <li <%if(sideSubMenu==(int)ForumSubMenus.ManageThread)Response.Write("class=\"tn-text-note tn-selected tn-widget-content tn-bg-light tn-corner-all\""); %>><a class="tn-menu-text" href="<%=SPBUrlHelper.Action("ManageForumThreads","ChannelForum") %>"> <%=GetResourceString("Action_ManageThread", applicationID)%></a></li>
        <li <%if(sideSubMenu==(int)ForumSubMenus.ManagePost)Response.Write("class=\"tn-text-note tn-selected tn-widget-content tn-bg-light tn-corner-all\""); %>><a class="tn-menu-text" href="<%=SPBUrlHelper.Action("ManageForumPosts","ChannelForum")%>"> <%=GetResourceString("Action_ManagePost",applicationID)%></a></li>
        <li <%if(sideSubMenu==(int)ForumSubMenus.ManageSections)Response.Write("class=\"tn-text-note tn-selected tn-widget-content tn-bg-light tn-corner-all\""); %>><a class="tn-menu-text" href="<%=SPBUrlHelper.Action("ManageForumSections", "ChannelForum")%>"> <%=GetResourceString("Action_ManageSections",applicationID)%></a></li>
        <li <%if (sideSubMenu == (int)ForumSubMenus.ManageForumCategories) Response.Write("class=\"tn-text-note tn-selected tn-widget-content tn-bg-light tn-corner-all\""); %>><a class="tn-menu-text" href="<%=SPBUrlHelper.Action("ManageForumCategories", "ChannelForum")%>"> <%=GetResourceString("Action_ManageForumCategories",applicationID)%></a></li>
      </ul>
    </div>
  </div>
</asp:content>
<asp:content contentplaceholderid="wideUnitContent" runat="server">
  <%int applicationID = ApplicationIDs.Instance().Forum();
    int? sectionID = Html.GetParameterFromRouteDateOrQueryString<int>("sectionID");
    int? pageIndex = Html.GetParameterFromRouteDateOrQueryString<int>("pageIndex");
    int? groupID = Html.GetParameterFromRouteDateOrQueryString<int>("groupID");
    string keywords = Html.GetParameterFromRouteDateOrQueryString("keywords");
    int? userID = Request.QueryString.GetInt("userID", 0);
    ForumSection section = ViewData["section"] as ForumSection;
    if (userID.HasValue && userID.Value == 0) userID = null;
    RouteValueDictionary routeDictionary = new RouteValueDictionary { { "sectionID", sectionID }, { "groupID", groupID }, { "keywords", keywords }, { "userID", userID }, { "pageIndex", pageIndex } };  %>
  <form method="Get" action="<%=SPBUrlHelper.Action("ManageForumThreads", "ChannelForum", new RouteValueDictionary { { "sectionID", sectionID }, { "groupID", groupID }})%>" id="ManageSearchForm">
    <div class="tn-form-box tn-border-gray tn-border-all">
      <table>
        <tbody>
          <tr>
            <th><%=GetResourceString("Label_Module",applicationID)%><%=GetResourceString("Common_Colon") %></th>
            <td><%=SPBHtmlHelper.Instance().ModerateForumSectionsDropDownList("SectionID", null, null, sectionID.ToString(), false, GetResourceString("Common_PleaseChoose"), new RouteValueDictionary { { "Class", "tn-dropdownlist" }, { "id", "sectionID" } })%></td>
          </tr>
          <tr>
            <th><%=GetResourceString("Label_KeyWords",applicationID)%><%=GetResourceString("Common_Colon") %></th>
            <td><input type="text" id="keywords" class="tn-textbox tn-input-medium tn-border-gray" name="keywords" value="<%=keywords %>"/></td>
            <th><%=GetResourceString("Label_AutoID",applicationID) %><%=GetResourceString("Common_Colon") %></th>
            <td><input type="text" id="userID" class="tn-textbox tn-input-medium tn-border-gray" name="userID" value="<%=userID %>"/></td>
            <td><%=SPBHtmlHelper.Instance().SubmitButton("", GetResourceString("Button_Search"), ButtonSizes.Default, null, null)%></td>
          </tr>
        </tbody>
      </table>
    </div>
  </form>
  <div class="tn-blank10"> </div>
  <div class="tn-box tn-widget tn-widget-content tn-corner-all">
    <%if (TempData["StatusMessageType"] != null)
      {
          StatusMessageType messageType = (StatusMessageType)TempData.GetInt("StatusMessageType", (int)StatusMessageType.Error);
          Response.Write(SPBHtmlHelper.Instance().StatusMessage(messageType, TempData.GetString("StatusMessageContent", string.Empty), 3000));
          TempData["StatusMessageType"] = null;
      } %>
    <div class="tn-box-content tn-widget-content tn-corner-bottom">
      <div class="tn-list-header">
        <div class="tn-toolbar-area tn-helper-clearfix">
          <label class="tn-check-all">
            <input type="checkbox" class="tn-checkbox" id="checkbox" name="checkbox"  onclick="checkAll(this,'threadIDCheckBox');" />
            <%=GetResourceString("Action_SelectAll",applicationID)%> </label>
          <%=SPBHtmlHelper.Instance().LinkButton("setEssential", GetResourceString("Label_SetEssential", applicationID), "javascript:;", ButtonSizes.Default, HighlightStyles.Default, IconTypes.Elite, TextIconLayout.IconText, null, null)%> 
          <%=SPBHtmlHelper.Instance().LinkButton("setSticky", GetResourceString("Label_TopSet",applicationID), "javascript:;", ButtonSizes.Default, HighlightStyles.Default, IconTypes.Top, TextIconLayout.IconText,null, null)%> <%=SPBHtmlHelper.Instance().LinkButton("setLock", GetResourceString("Action_SetLocked", applicationID), "javascript:;", ButtonSizes.Default, HighlightStyles.Default, IconTypes.Lock, TextIconLayout.IconText, new RouteValueDictionary { { "onclick", "if(isCheck()) return false;$('#manageForumThreadsForm').attr(\"action\",'" + SPBUrlHelper.Action("BatchSetLock", "ChannelForum", new RouteValueDictionary(routeDictionary) { { "isLocked", true } }) + "').submit();" } }, null)%> 
          <%=SPBHtmlHelper.Instance().LinkButton("move", GetResourceString("Action_Move",applicationID), "javascript:;", ButtonSizes.Default, HighlightStyles.Default, IconTypes.TriangleRight, TextIconLayout.IconText, null, null)%>
          <%if (section != null && section.ThreadCategories != null && section.ThreadCategories.Count > 0)
            { %>
          <%=SPBHtmlHelper.Instance().LinkButton(string.Empty, GetResourceString("Action_SetCategory",applicationID),"javascript:;", ButtonSizes.Default, HighlightStyles.Default, IconTypes.TriangleDown, TextIconLayout.MenuButton,null, new RouteValueDictionary { { "menu", "#forumCategoryControl" } })%>
          <div id="forumCategoryControl" class="tn-menu-button-position tn-menu tn-helper-reset tn-widget-content">
            <ul class="tn-menu-list">
              <%if (section != null && section.ThreadCategories != null)
                {
                    foreach (ForumThreadCategory category in section.ThreadCategories)
                    {
                  %>
              <li class="tn-menu-item"><a class="tn-menu-text" href="javascript:;" onclick="if(isCheck()) return false;$('#manageForumThreadsForm').attr('action','<%=SPBUrlHelper.Action("BatchSetThreadCategory", "ChannelForum", new RouteValueDictionary(routeDictionary) { { "categoryID",category.CategoryID } })%>').submit();"> <%=category.CategoryName%></a></li>
              <%}
                } %>
            </ul>
          </div>
          <%} %>
          <%=SPBHtmlHelper.Instance().LinkButton("deleteForumThreads", GetResourceString("Action_Delete"), "javascript:;", ButtonSizes.Default, HighlightStyles.Default, IconTypes.Cross, TextIconLayout.IconText, null, null)%> <%=SPBHtmlHelper.Instance().LinkButton("", GetResourceString("Action_MoreOption",applicationID),"javascript:;", ButtonSizes.Default, HighlightStyles.Lite, IconTypes.TriangleDown, TextIconLayout.MenuButton, null, new RouteValueDictionary { { "menu", "#moreSettings" } })%>
          <div id="moreSettings" class="tn-menu-button-position tn-menu tn-helper-reset tn-widget-content">
            <ul>
              <li class="tn-menu-item"><a id="cancelEssential" class="tn-menu-text" href="javascript:;" onclick="if(isCheck()) return false;$('#manageForumThreadsForm').attr('action','<%=SPBUrlHelper.Action("BatchSetEssential", "ChannelForum", new RouteValueDictionary(routeDictionary) { { "isEssential", false } }) %>').submit();"> <%=GetResourceString("Common_CancelEssential")%></a></li>
              <li class="tn-menu-item"><a id="cancelSticky" class="tn-menu-text" href="javascript:;" onclick="if(isCheck()) return false;$('#manageForumThreadsForm').attr('action', '<%=SPBUrlHelper.Action("BatchSetLock", "ChannelForum", new RouteValueDictionary(routeDictionary){ { "isLocked",false } })%>').submit();"> <%=GetResourceString("Action_CancelLocked",applicationID)%></a></li>
              <li class="tn-menu-item"><a id="setHighlight" class="tn-menu-text" href="javascript:;"> <%=GetResourceString("Action_SetHighlight",applicationID)%></a></li>
            </ul>
          </div>
        </div>
      </div>
      <form id="manageForumThreadsForm" action="" method="post">
        <table class="tn-table-grid">
          <tbody>
            <tr class="tn-table-grid-header">
              <th class="tn-border-gray tn-border-bottom tn-text-note">&nbsp;</th>
              <th class="tn-border-gray tn-border-bottom tn-text-note">主题</th>
              <th class="tn-border-gray tn-border-bottom tn-text-note">&nbsp;</th>
              <td class="tn-border-gray tn-border-bottom tn-text-note"><%=GetResourceString("Label_ModuleLocation",applicationID)%></td>
              <td class="tn-border-gray tn-border-bottom tn-text-note"><%=GetResourceString("Label_Author") %></td>
              <td class="tn-border-gray tn-border-bottom tn-text-note">主题分类</td>
              <td class="tn-border-gray tn-border-bottom tn-text-note"><%=GetResourceString("Label_PostDate")%></td>
            </tr>
            <%if (Model != null)
              {
                  foreach (ForumThread thread in Model.Records)
                  {%>
            <tr class="tn-table-grid-row">
              <td class="tn-border-gray tn-border-bottom tn-width-check"><input type="checkbox" class="tn-checkbox" name="threadIDCheckBox" value="<%=thread.ThreadID %>" /></td>
              <th class="tn-border-gray tn-border-bottom tn-width-auto"><a <%=thread.HighlightStyle %> title="<%=thread.Subject%>" href="<%=SiteUrls.Instance().ShowForumThread(thread.ThreadID) %>"><%=HtmlUtils.TrimHtml(thread.Subject,30) %></a></th>
              <th class="tn-border-gray tn-border-bottom tn-width-icon3">          
              <%if (thread.IsSticky) Response.Write(SPBHtmlHelper.Instance().Icon(IconTypes.Top, GetResourceString("Action_Top", applicationID)));
                if (thread.IsLocked) Response.Write(SPBHtmlHelper.Instance().Icon(IconTypes.Lock, GetResourceString("Action_Lock", applicationID)));
                if (thread.IsEssential) Response.Write(SPBHtmlHelper.Instance().Icon(IconTypes.Elite, GetResourceString("Action_Essential", applicationID)));%>
              </th>
              <td class="tn-border-gray tn-border-bottom tn-text-note"><%=thread.ForumSection != null ?  string.Format("<a href=\"{1}\">{0}</a>",thread.ForumSection.SectionName,SiteUrls.Instance().ShowForumSection(thread.ForumSection.SectionID)) : string.Empty %></td>
              <td class="tn-border-gray tn-border-bottom tn-width-user-name tn-nowrap"><cite> <%=SPBHtmlHelper.Instance().UserDisplayNameLink(thread.UserID,thread.Author,applicationID) %> </cite></td>
              <td class="tn-border-gray tn-border-bottom tn-text-note"><%=thread.Category == null ? string.Empty : thread.Category.CategoryName%></td>
              <td class="tn-border-gray tn-border-bottom tn-width-datetime tn-nowrap"><%=Formatter.FormatFriendlyDate(thread.PostDate) %></td>
            </tr>
            <%}
              } %>
          </tbody>
        </table>
        <input type="hidden" name="sectionID" value="<%=sectionID %>"/>
      </form>
      <div class="tn-pagination tn-helper-align-center">
        <%if (Model.TotalRecords > Model.PageSize)
          {%>
        <%=SPBHtmlHelper.Instance().PagingButton(PaginationMode.NumericNextPrevious, Model.TotalRecords, Model.PageSize, Model.PageIndex)%>
        <%} %>
        <div class="tn-page-results tn-text-note"><%=string.Format(GetResourceString("Label_Pattern_TotalRecords"),Model.TotalRecords) %></div>
      </div>
    </div>                   
  </div>
  <script type="text/javascript">
    $(document).ready(function() {
        $("div.tn-list-header span[menu]").menuButton({ clickTrigger: true, notTriggerClose: ".tn-menu-list,.tn-menu input" });
        $("#deleteForumThreads").click(function() {
            if(isCheck())
                return false;
            if(confirm('确认要删除选中的主题？'))
                $("#manageForumThreadsForm").attr("action", '<%=SPBUrlHelper.Action("DeleteForumThreads", "ChannelForum", routeDictionary)%>').submit();
            return false;
        });
        $("#setEssential").click(function(){
            if(isCheck()) 
              return false;
            $('#manageForumThreadsForm').attr("action",'<%=SPBUrlHelper.Action("BatchSetEssential", "ChannelForum", new RouteValueDictionary(routeDictionary) { { "isEssential", true } }) %>');
            $('#manageForumThreadsForm').submit();
        
        });

        $("#setSticky").click(function() {
            if(isCheck())
                return false;
            $("#manageForumThreadsForm").attr("action", "<%=SPBUrlHelper.Action("Control_BatchSetSticky","ChannelForum")%>");
            postFormToNyroModal();
            $("#manageForumThreadsForm").submit();
        });
        $("#move").click(function(){
            if(isCheck())
                return false;
            $("#manageForumThreadsForm").attr("action", "<%=SPBUrlHelper.Action("Control_MoveForumThreads","ChannelForum")%>");
            postFormToNyroModal();
            $("#manageForumThreadsForm").submit();
        });
        $("#setHighlight").click(function(){
            if(isCheck())
                return false;
            $("#manageForumThreadsForm").attr("action", "<%=SPBUrlHelper.Action("Control_BatchSetHighlight","ChannelForum")%>");
            postFormToNyroModal();
            $("#manageForumThreadsForm").submit();
        });
    });
    
    function isCheck()
    {
        if($("input[name='threadIDCheckBox']:checked").length <= 0)
        {
            alert("至少选择一个论坛主题！");
            return true;           
        }
        return false;
    }
         
    function postFormToNyroModal() {
        $(function() {
            $('#manageForumThreadsForm').submit(function(e) {
                e.preventDefault();
                $('#manageForumThreadsForm').nyroModalManual({
                    resizeable: true
                });
                return false;
            });
        });
    }  
</script>
</asp:content>
<asp:content id="mainContentRegion" contentplaceholderid="wideContentRegion" runat="server"></asp:content>
<asp:content id="sidebarContentRegion" contentplaceholderid="templateContentRegion"
    runat="server"></asp:content>
