﻿<%@ Page Language="C#" Inherits="SpaceBuilder.Web.ChannelViewPage<SearchResultDataSet<ForumThread>>" %>

<asp:content id="setPageID" contentplaceholderid="setPageID" runat="server">
    id="Forum-SearchForum"
</asp:content>
<asp:content id="subMenusContent" runat="server" contentplaceholderid="subMenusContent">
    <%Html.RenderPartial("Controls/Forums/Submenu.ascx", ViewData);%>
</asp:content>
<asp:content id="mainContent" contentplaceholderid="mainContent" runat="server">
  <spb:Script runat="server" ID="CollapsibleBox" Src="~/Utility/jquery/plugin/jquery.spb.CollapsibleBox.js" SetExpireDays="30" />
  <%  ForumPostFullTextQuery query = ViewData.Get<ForumPostFullTextQuery>("Query", null);
      int applicationID = ApplicationIDs.Instance().Forum(); %>
  <div class="tn-box tn-widget tn-widget-content tn-corner-all"
    id="FourmPostResult">
    <div class="tn-box-content tn-widget-content tn-corner-all">
        <div class="spb-search-results-box">
            <form action="<%=SPBUrlHelper.Action("Search","ChannelForum") %>" id="searchFourms" method="post">
            <div class="tn-collapsible tn-collapsible-closed">
                <div class="tn-collapsible-header tn-helper-right tn-switch-left">
                    <h4 class="tn-helper-reset">
                        <a href="javascript:;;"><%=GetResourceString("Action_MoreOption",applicationID)%></a></h4>
                    <span class="tn-icon tn-switch tn-icon-collapse-close"></span>
                </div>
                <div class="tn-form tn-form-single">
                    <input type="text" value="<%=query.Keyword %>" id="Keyword" name="Keyword" class="tn-textbox tn-border-gray" style="width: 475px; height:23px;" />
                    <%=SPBHtmlHelper.Instance().SubmitButton("", GetResourceString("Button_Search"), ButtonSizes.Large, null, null)%> 
                </div>
                <%if (CurrentUser != null)
                  { %>
                <div class="spb-search-results-select">
                    <input type="radio" checked="checked" class="tn-radiobutton" id="SearchAllTopic" name="UserID" value="-1" />
                    <label for="SearchAllTopic">
                        <%=GetResourceString("Label_SearchAllTopic", applicationID)%></label>
                    <input type="radio" class="tn-radiobutton"  name="UserID" id="SearchScopeUserID" <% if (query.UserID == CurrentUser.UserID) Response.Write("checked=\"checked\""); %> value="<%=CurrentUser.UserID %>"/>
                    <label for="SearchScopeUserID">
                        <%=GetResourceString("Label_DisplayMyTopic", applicationID)%></label>
                </div>
                <%} %>
                <div class="tn-blank10">
                </div>
                <div id="showMoreCondition" style="display:none;" class="tn-collapsible-content">
                    <div class="tn-form tn-label-right">
                        <div class="tn-form-row">
                          <label><%=GetResourceString("Action_DateRestriction",applicationID)%><%=GetResourceString("Common_Colon")%></label>
                          <span>
                          <select id="DateScopes" name="DateScopes" class="tn-dropdownlist">
                            <option value="<%=(int)ForumDateScopes.OneDay %>"><%=GetResourceString("Enum_Pattern_OneDay",applicationID)%></option>
                            <option value="<%=(int)ForumDateScopes.ThreeDay %>"><%=GetResourceString("Enum_Pattern_ThreeDay", applicationID)%></option>
                            <option value="<%=(int)ForumDateScopes.OneWeek %>"><%=GetResourceString("Enum_Pattern_OneWeek", applicationID)%></option>
                            <option value="<%=(int)ForumDateScopes.TwoWeek %>"><%=GetResourceString("Enum_Pattern_TowWeek", applicationID)%></option>
                            <option value="<%=(int)ForumDateScopes.OneMonth %>"><%=GetResourceString("Enum_Pattern_OneMonth", applicationID)%></option>
                            <option value="<%=(int)ForumDateScopes.ThreeMonth %>"><%=GetResourceString("Enum_Pattern_ThreeMonth", applicationID)%></option>
                            <option value="<%=(int)ForumDateScopes.HalfYear %>"><%=GetResourceString("Enum_Pattern_HalfYear", applicationID)%></option>
                            <option value="<%=(int)ForumDateScopes.OneYear %>"><%=GetResourceString("Enum_Pattern_OneYear", applicationID)%></option>
                          </select>
                          </span>
                        </div>
                        <div class="tn-form-row">
                           <label><%=GetResourceString("Label_BelogModule",applicationID)%><%=GetResourceString("Common_Colon") %></label>
                           <% string selectValue = query.SectionID > 0 ? query.SectionID.ToString() : string.Empty; %>
                           <%=SPBHtmlHelper.Instance().ForumSectionsDropDownList("SectionID", null, null, selectValue, false, GetResourceString("Common_PleaseChoose"), new RouteValueDictionary { { "Class", "tn-dropdownlist" }, { "id", "sectionID" } })%> 
                        </div>
                        <div class="tn-form-row">
                            <label><%=GetResourceString("Common_UserTag")%><%=GetResourceString("Common_Colon") %></label>
                            <input type="text" value="<%=query.TagName %>" name="tagName" id="tagName" class="tn-textbox tn-input-long tn-border-gray" />
                        </div>
                    </div>
                </div>
            </div>
            </form>
        </div>
        <%if (Model == null || (Model != null && Model.Records.Count <= 0))
          {%>
        <div class="tn-list-header">
            <%  Html.RenderPartial("Controls/Search/NoSearchResult.ascx");%>
        </div>
          <%}
          else
          { %>
         <div>
           <div class="tn-list-header">
               <div class="tn-list-header-row tn-helper-clearfix tn-border-gray tn-border-bottom">
                   <span class="tn-text-note"><%=string.Format(GetResourceString("Description_Pattern_SearchHint",applicationID),Model.TotalRecords,Model.SearchDuration)%></span>
               </div>
           </div>
           <ul class="tn-list tn-helper-reset">
           <%foreach (ForumThread thread in Model.Records)
             { %>
             <li class="tn-list-item tn-helper-clearfix tn-border-gray tn-border-bottom">
               <div class="tn-list-item-area-main">
                 <div class="tn-list-item-row tn-list-item-heading">
                   <h5 class="tn-helper-reset"> <a href="<%=SiteUrls.Instance().ShowForumThread(thread.ThreadID) %>" title="<%=HtmlUtils.StripAllTags(thread.Subject) %>"><%=thread.Subject %></a></h5>
                 </div>
                 <div class="tn-list-item-row tn-list-item-summary">
                   <p class="tn-helper-reset"><%=HtmlUtils.StripForPreview(thread.Body) %></p>
                 </div>                                                                                                   
                 <div class="tn-list-item-row"><cite>
                 <%=SPBHtmlHelper.Instance().UserDisplayNameLink(thread.UserID,thread.Author,applicationID) %>
                 </cite> <em class="tn-date tn-text-note"> <%=GetResourceString("Label_Issue",applicationID) %><%=Formatter.FormatFriendlyDate(thread.PostDate,false) %></em></div>
               </div>
             </li>
             <%} %>
           </ul>
           <div class="tn-pagination tn-helper-align-center">
           <%=SPBHtmlHelper.Instance().PagingButton(PaginationMode.NumericNextPrevious,Model.TotalRecords,Model.PageSize,Model.PageIndex) %>
           </div>
        </div>
        <%} %>
    </div>
</div>
  <script type="text/javascript">
      $(document).ready(function () {
          $(".tn-collapsible").collapsibleBox();
            <% if(query.IsShowMoreCondition()){ %>
             $("#showMoreCondition").show().parent().attr("class","tn-collapsible tn-collapsible-opened");
            <%} %>

          $("#DateScopes").val("<%=query.DateScopes %>");
      });
  </script> 
</asp:content>
<asp:content contentplaceholderid="sidebarContent" runat="server">
<%Html.RenderAction<ChannelForumController>(n => n.Control_ListForumsSiteTags(50, ApplicationTagsSortBy.ItemCount)); %>
</asp:content>
<asp:content id="wideContentRegion2" runat="server" contentplaceholderid="wideContentRegion2"></asp:content>
<asp:content id="wideContentRegion" runat="server" contentplaceholderid="wideContentRegion"></asp:content>
