﻿<%@ Page Language="C#" Inherits="SpaceBuilder.Web.ChannelViewPage" %>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<spb:header id="Header1" runat="server">
    <spb:Script runat="server" ID="jquery" Src="~/Utility/jquery/jquery.min-1.4.2.js"
        SetExpireDays="30" />
    <spb:Script runat="server" ID="cookie" Src="~/Utility/jquery/plugin/jquery.cookie.js"
        SetExpireDays="30" />
    <spb:Script runat="server" ID="core" Src="~/Utility/jquery/ui.core.min-1.8.12.js"
        SetExpireDays="30" />
    <spb:Script runat="server" ID="widget" Src="~/Utility/jquery/ui.widget.min-1.8.12.js"
        SetExpireDays="30" />
    <spb:Script runat="server" ID="position" Src="~/Utility/jquery/ui.position.min-1.8.12.js"
        SetExpireDays="30" />
    <spb:Script runat="server" ID="button" Src="~/Utility/jquery/ui.button.min-1.8.12.js"
        SetExpireDays="30" />
        <spb:Script runat="server" ID="global" Src="~/Utility/tunynet_web_ui/global.js" />
    <spb:Script runat="server" ID="nyroModal" Src="~/Utility/jquery/plugin/jquery.nyroModal-1.6.2.min.js"
        SetExpireDays="30" />
    <spb:Script runat="server" ID="tabs" Src="~/Utility/jquery/ui.tabs.min-1.8.12.js"
        SetExpireDays="30" />
    <spb:Script runat="server" ID="superfish" Src="~/Utility/jquery/plugin/jquery.superfish-1.4.8.js"
        SetExpireDays="30" />
    <spb:Script runat="server" ID="watermarkinput" Src="~/Utility/jquery/plugin/jquery.watermarkinput.js" />
    <spb:Script runat="server" ID="validate" Src="~/Utility/jquery/plugin/jquery.validate-1.7.js"
        SetExpireDays="30" />
    <spb:Script runat="server" ID="qtip" Src="~/Utility/jquery/plugin/jquery.qtip-1.0.0-rc3.js" SetExpireDays="30" />
    
</spb:header>
<body id="Home" class="tn-page-bg spb-home-page">
    <% 
        string pageCode = "1001";
        bool isDesignMode = false;
        int ownerID = Themes.SystemOwnerID;

        string currentTheme = ThemeManager.GetSelectedThemeName(ViewContext);

        Dictionary<string, int> usedWidgetIDs = WidgetInstances.GetUsedWidgetIDs(Themes.SystemOwnerID, pageCode, currentTheme);
        if (usedWidgetIDs.Count == 0)
            WidgetInstances.InitializeUserWidgetInstance(ownerID, currentTheme, pageCode);
            
    %>
    <div id="tn-doc" class="tn-doc-bg">
        <div id="tn-header" class="tn-header-bg">
            <div class="tn-wrapper">
                <%  Html.RenderPartial("Controls/Header.ascx"); %>
            </div>
        </div>
        <%
            string currentLayoutMode = Themes.GetOwnerLayout(ownerID, currentTheme, pageCode, false);
            string currentLayoutModes = string.Empty;
            foreach (char s in currentLayoutMode)
            {
                currentLayoutModes += ("-" + s);
            }
        %>
        <div class="tn-content-bg tn-doc2" id="tn-content">
            <div class="tn-wrapper">   
                   <%Html.RenderAction<ChannelController>(n => n.Control_AnnouncementsBlockForLong(PresentAreaIDs.Instance().Channel(), 10));%>
    
                <%=SPBHtmlHelper.Instance().ShowAdvertisingInChannel("001000000003",new RouteValueDictionary { { "class", "spb-ad-banner" } })%>
                <div class=" spb-layout<%=currentLayoutModes%> tn-helper-clearfix">
                    <div class="spb-column-left">
                        <%
                            IList<WidgetZone> widgetZoneOfColomn1 = Themes.GetWidgetZones(currentTheme, pageCode, 1, false);
                            foreach (var widgetZone in widgetZoneOfColomn1)
                            {
                        %>
                        <div class="spb-widget-zone" _zoneid="<%=widgetZone.ZoneID %>" id="widgetZone<%=widgetZone.ZoneID %>">
                            <%
                                IList<WidgetInstance> widgetInstancesOfZone = WidgetInstances.GetOwnerWidgetInstances(ownerID, widgetZone.ZoneID, false);
                                foreach (var widgetInstance in widgetInstancesOfZone)
                                {
                                    SPBHtmlHelper.Instance().RenderWidgetInstanceInChannel(Html, isDesignMode, widgetInstance);
                                }
                            %>
                        </div>
                        <%
                            }                                    
                        %>
                    </div>
                    <div class="spb-column-center">
                        <%
                            if (currentLayoutMode.Length == 3)
                            {
                                IList<WidgetZone> widgetZoneOfColomn2 = Themes.GetWidgetZones(currentTheme, pageCode, 2, false);
                                foreach (var widgetZone in widgetZoneOfColomn2)
                                {
                        %>
                        <div class="spb-widget-zone" _zoneid="<%=widgetZone.ZoneID %>" id="widgetZone<%=widgetZone.ZoneID %>">
                            <%
                                IList<WidgetInstance> widgetInstancesOfZone = WidgetInstances.GetOwnerWidgetInstances(ownerID, widgetZone.ZoneID, false);
                                foreach (var widgetInstance in widgetInstancesOfZone)
                                {
                                    SPBHtmlHelper.Instance().RenderWidgetInstanceInChannel(Html, isDesignMode, widgetInstance);
                                }
                            %>
                        </div>
                        <%
                            }
                            }
                        %>
                    </div>
                    <div class="spb-column-right">
                        <%
                            IList<WidgetZone> widgetZoneOfColomn3;
                            if (currentLayoutMode.Length == 3)
                                widgetZoneOfColomn3 = Themes.GetWidgetZones(currentTheme, pageCode, 3, false);
                            else
                                widgetZoneOfColomn3 = Themes.GetWidgetZones(currentTheme, pageCode, 2, false);

                            foreach (var widgetZone in widgetZoneOfColomn3)
                            {
                        %>
                        <div class="spb-widget-zone" _zoneid="<%=widgetZone.ZoneID %>" id="widgetZone<%=widgetZone.ZoneID %>">
                            <%
                                IList<WidgetInstance> widgetInstancesOfZone = WidgetInstances.GetOwnerWidgetInstances(ownerID, widgetZone.ZoneID, false);
                                foreach (var widgetInstance in widgetInstancesOfZone)
                                {
                                    SPBHtmlHelper.Instance().RenderWidgetInstanceInChannel(Html, isDesignMode, widgetInstance);
                                }
                            %>
                        </div>
                        <%
                            }
                        %>
                    </div>
                </div>
                <%=SPBHtmlHelper.Instance().ShowAdvertisingInChannel("001000000004", new RouteValueDictionary { { "class", "spb-ad-banner-bottom" } })%>
            </div>
        </div>
        <div class="tn-footer-bg" id="tn-footer">
            <div class="tn-wrapper">
                <% Html.RenderAction<ChannelController>(c => c.Control_ShowLinks(null)); %>
                <% Html.RenderPartial("Controls/Footer.ascx"); %>
            </div>
        </div>
    </div>
</body>
</html>
