﻿<%@ Page Language="C#" Inherits="SpaceBuilder.Web.ChannelViewPage<Job>" %>

<asp:content contentplaceholderid="wideContentRegion" runat="server" id="wideContentRegion"></asp:content>
<asp:content id="Content4" contentplaceholderid="subMenusContent" runat="server">
  <%  ViewData["ChannelJobSubMenu"] = ChannelJobSubMenu.ShowJob;
      Html.RenderPartial("Controls/Jobs/SubMenus.ascx", ViewData);%>
</asp:content>
<asp:content id="setPageID" runat="server" contentplaceholderid="setPageID"> id="Job-ShowJob" </asp:content>
<asp:content contentplaceholderid="mainContent" runat="server" id="mainContent">
  <% bool isInFavorite = ViewData.GetBool("isInFavorite", false);
     CompanyUser cu = Users.GetUser(Model.UserID, false) as CompanyUser;
     cu = cu == null ? new CompanyUser() : cu; %>
  <div class="tn-box tn-widget tn-widget-content tn-corner-all spb-job-view">
    <div class="tn-box-content tn-widget-content tn-corner-all">
        <div class="tn-head tn-border-gray tn-border-bottom">
            <div class="tn-info-part tn-text-note">
                <dl>
                    <dt>总浏览:</dt>
                    <dd>
                        <%=Model.HitTimes %></dd>
                </dl>
                <dl>
                    <dt>周浏览：</dt>
                    <dd>
                        <%=Model.WeekHitTimes %></dd>
                </dl>
            </div>
            <h1>
                <%=Model.JobName %><em><%=Model.JobTypeName %></em></h1>
        </div>
        <div class="spb-job-details tn-helper-clearfix">
            <h4>
                <a href="<%=SPBUrlHelper.Action("ShowCompany", "ChannelJob",new RouteValueDictionary{{"companyUserID",Model.UserID}})%>">
                    <%=Model.CompanyName %></a></h4>
            <div class="spb-job-company-info">
                <div class="tn-info-part">
                    <dl>
                        <dt class="tn-text-note">公司规模：</dt>
                        <dd>
                            <%=SPBHtmlHelper.Instance().ShowEmployee(cu.EmployeeNum)%></dd>
                    </dl>
                    <dl>
                        <dt class="tn-text-note">公司性质：</dt>
                        <dd>
                            <%=SPBHtmlHelper.Instance().ShowCompanyProperty(cu.CompanyProperty)%></dd>
                    </dl>
                    <dl>
                        <dt class="tn-text-note">公司行业：</dt>
                        <dd>
                            <%=SPBHtmlHelper.Instance().ShowTrade(cu.Trade)%></dd>
                    </dl>
                </div>
            </div>
            <%if (CurrentUser == null)
              { %>
            <div class="spb-job-user-actions">
                <%=SPBHtmlHelper.Instance().LinkButton("applyJobNoUser","申请职位",SiteUrls.Instance().Login(true),ButtonSizes.Large,HighlightStyles.Primary) %>
                <span class="tn-action"><a href="<%=SiteUrls.Instance().Login(true)%>" id="favoriteJobNoUser">
                    收藏</a> </span>
            </div>
            <%} %>
            <%else if (CurrentUser.UserType == UserTypes.PersonUser)
                { %>
            <div class="spb-job-user-actions">
                <%=SPBHtmlHelper.Instance().LinkButton("applyJob","申请职位",SPBUrlHelper.Action("Control_NewJobApply","ChannelJob",new RouteValueDictionary{{"jobID",Model.JobID}}),ButtonSizes.Large,HighlightStyles.Primary) %>
                <span class="tn-action">
                    <%
                        if (isInFavorite)
                        {
                    %>
              <a class="tn-action-text" href="<%=SPBUrlHelper.Action("DeleteFavoriteJobs","UserDomainJob", new RouteValueDictionary(){ { "userDomainName", CurrentUser.UserName },{ "jobID", Model.JobID },{ "returnUrl", Request.RawUrl } })%>" title="该职位已经被您收藏">取消收藏</a>
                    <%
                        }
                        else
                        {         
                    %>
                    <a  href="<%=SPBUrlHelper.Action("Control_ShowFavoriteJob","ChannelJob",new RouteValueDictionary {{"jobID",Model.JobID}}) %>"
                        id="favoriteJob">收藏</a>
                    <%} %>
                </span>
            </div>
            <%} %>
            <div class="tn-actions">
                <span class="tn-action"><a href="<%=SPBUrlHelper.Action("JobSearch", "ChannelJob", new RouteValueDictionary { { "WorkAreaCode",Model.WorkAreaCode },{"JobSort",Model.JobSort} })%>">
                    类似职位</a></span> <span class="tn-action"><a href="<%=SiteUrls.Instance().ShowCompany(Model.UserID) %>#listJobs">
                        该公司其他职位</a></span> <span class="tn-action"><a class="nyroModal" href="<%=SiteUrls.Instance().NewImpeachReport() %>">
                            职位举报</a></span>
                <%if (CurrentUser != null && CurrentUser.IsContentAdministrator)
                  { %>
                <span class="tn-action"><a class="nyroModal" href="<%=SiteUrls.Instance().RecommendItem(ApplicationIDs.Instance().Job(), Model.UserID, Model.JobID, Model.JobName)%>">
                    管理员推荐</a></span>
                <%} if (CurrentUser != null && (CurrentUser.IsContentAdministrator || CurrentUser.UserID == Model.UserID))
                  {%>
                <span class="tn-action"><a href="<%=SPBUrlHelper.Action("EditJob","UserDomainJob", new RouteValueDictionary{ { "userDomainName", UserID2UserNameDictionary.GetUserName(Model.UserID) },{"jobID", Model.JobID} })%>">
                    编辑</a></span>
                <%} %>
            </div>
        </div>
        <div class="tn-section spb-job-info">
            <div class="tn-text-heading tn-border-gray tn-border-bottom">
                <strong>职位信息</strong></div>
            <div class="tn-info-part tn-helper-clearfix">
                <dl>
                    <dt class="tn-text-note">职业类别：</dt>
                    <dd>
                        <%=SPBHtmlHelper.Instance().ShowJobSort(Model.JobSort) %></dd>
                </dl>
                <dl>
                    <dt class="tn-text-note">工作地点：</dt>
                    <dd>
                        <%=Formatter.FormatArea(Model.WorkAreaCode,true) %></dd>
                </dl>
                <dl>
                    <dt class="tn-text-note">提供月薪：</dt>
                    <dd>
                        <%=SPBHtmlHelper.Instance().ShowSalary(Model.Salary) %>
                    </dd>
                </dl>
                <dl>
                    <dt class="tn-text-note">招聘人数：</dt>
                    <dd>
                        <%=SPBHtmlHelper.Instance().ShowNumber(Model.Number) %>
                    </dd>
                </dl>
                <dl>
                    <dt class="tn-text-note">期望入职时间：</dt>
                    <dd>
                        <%=Formatter.FormatDate(Model.HopeJoinDate) %></dd>
                </dl>
                <dl>
                    <dt class="tn-text-note">
                        <%=GetResourceString("Label_UpdateDate")%><%=GetResourceString("Common_Colon") %></dt>
                    <dd>
                        <%=Formatter.FormatDate(Model.LastUpdatedDate) %></dd>
                </dl>
                <dl>
                    <dt class="tn-text-note">截止日期：</dt>
                    <dd>
                        <%= Formatter.FormatDate(Model.EndDate) %></dd>
                </dl>
            </div>
        </div>
        <div class="tn-section spb-job-descriptions">
            <div class="tn-text-heading tn-border-gray tn-border-bottom">
                <strong>职位描述</strong></div>
            <div class="spb-job-descriptions-cont">
                <%=Model.Description %>
            </div>
        </div>
        <div class="tn-section spb-job-requirements">
            <div class="tn-text-heading tn-border-gray tn-border-bottom">
                <strong>职位要求</strong></div>
            <div class="tn-info-part tn-helper-clearfix">
                <dl>
                    <dt class="tn-text-note">学历要求：</dt>
                    <dd>
                        <%=SPBHtmlHelper.Instance().ShowDegree(Model.Degree) %></dd>
                </dl>
                <dl>
                    <dt class="tn-text-note">工作经验：</dt>
                    <dd>
                    
                    <%  if (Model.WorkYears == -1)
                     %><% Response.Write("不限");
                        else %>
                        <%=SPBHtmlHelper.Instance().ShowWorkYearsScope(Model.WorkYears)%>
                        
                        </dd>
                </dl>
                <dl>
                    <dt class="tn-text-note">年龄要求：</dt>
                    <dd>
                        <%=SPBHtmlHelper.Instance().ShowAgeDescription(Model.AgeFrom,Model.AgeTo) %>
                    </dd>
                </dl>
                <dl>
                    <dt class="tn-text-note">性别要求：</dt>
                    <dd>
                        <%=string.IsNullOrEmpty(SPBHtmlHelper.Instance().ShowGender(Model.Gender))?"不限": SPBHtmlHelper.Instance().ShowGender(Model.Gender)%>
                    </dd>
                </dl>
                <dl>
                    <dt class="tn-text-note">外语语种：</dt>
                    <dd>
                        <%=SPBHtmlHelper.Instance().ShowLanguage(Model.ForeignLanguage) %></dd>
                </dl>
                 <dl>
                    <dt class="tn-text-note">外语水平：</dt>
                    <dd>
                        <%=SPBHtmlHelper.Instance().ShowLevelForLan(Model.LanguageLevel)%>
                    </dd>
                </dl>
            
                <dl>
                    <dt class="tn-text-note">计算机能力：</dt>
                    <dd>
                        <%=SPBHtmlHelper.Instance().ShowLevelSort(Model.ComputerLevel) %>
                    </dd>
                </dl>
            
            </div>
        </div>
        <% CompanyUser uc = Users.GetUser(Model.UserID, true) as CompanyUser;
           if (uc != null && uc.UserID > 0)
           {%>

        <div class="tn-section">
            <div class="tn-text-heading tn-border-gray tn-border-bottom">
                <strong>公司简介</strong></div>
            <div class="spb-company-profile">
                <%=uc.Intro %>
            </div>
        </div>
        <div class="tn-section">
            <div class="tn-text-heading tn-border-gray tn-border-bottom">
                <strong>联系方式</strong>
            </div>
            <div class="tn-info-part tn-h belper-clearfix">
                <%if (CurrentUser != null && (CurrentUser.UserID == Model.UserID || CurrentUser.IsContentAdministrator))
                  {%>
                <p class="tn-helper-align-right">
                    <a target="_blank" href="<%=SPBUrlHelper.Action("EditCompanyBasicInfo","UserDomainSettings", new RouteValueDictionary{{ "userDomainName",cu.UserName}}) %>">
                        编辑</a></p>
                <%} %>
                <dl >
                    <dt class="tn-text-note">联系人：</dt>
                    <dd>
                        <%=string.IsNullOrEmpty(uc.Linkman) ? "未填" : uc.Linkman%></dd>
                </dl>
                   <dl >
                    <dt class="tn-text-note">联系人职位：</dt>
                    <dd>
                        <%=string.IsNullOrEmpty(uc.LinkmanDuty) ? "未填" : uc.LinkmanDuty%></dd>
                </dl>
                <dl >
                    <dt class="tn-text-note">电话：</dt>
                    <dd>
                        <%=string.IsNullOrEmpty(uc.LinkTel) ? "未填" : uc.LinkTel%></dd>
                </dl>
                <dl >
                    <dt class="tn-text-note">公司传真：</dt>
                    <dd>
                        <%=string.IsNullOrEmpty(uc.Fax)?"未填" : uc.Fax %></dd>
                </dl>
                <dl >
                    <dt class="tn-text-note">通讯地址：</dt>
                    <dd>
                        <%=string.IsNullOrEmpty(uc.Address)?"未填":uc.Address %></dd>
                </dl>
            </div>
        </div>
        
        <%} %>
    </div>

  
  
  <script type="text/javascript">
      $(document).ready(function() {

          $('#applyJob').nyroModal({
              resizeable: true
          });
          $('#favoriteJob').dialog({ id: 'dialogidFavorite', title: '收藏', width: 400, resizable: false });
             

      });
</script>
</div>

</asp:content>
<asp:content runat="server" id="sidebarContent" contentplaceholderid="sidebarContent">
  <% Html.RenderAction<ChannelJobController>(n => n.Control_JobInterpersonal(Model.UserID));
   %>
</asp:content>
