﻿<%@ Page Language="C#" Inherits="SpaceBuilder.Web.ChannelViewPage<IList<PersonUser>>" %>

<asp:content contentplaceholderid="setPageID" runat="server"> id="User-Home" </asp:content>
<asp:content contentplaceholderid="outerContent" runat="server"> <%=SPBHtmlHelper.Instance().ShowAdvertisingInChannel("001000000001", new RouteValueDictionary { { "class", "spb-ad-banner" } })%>
  <div class="tn-main">
    <div class="tn-block">
      <spb:Script runat="server" ID="qtip" Src="~/Utility/jquery/plugin/jquery.qtip-1.0.0-rc3.js" SetExpireDays="30" />
      <% 
    
    int applicationID = ApplicationIDs.Instance().User();
    IList<UserActivity> userActivities = ViewData["userActivities"] as IList<UserActivity>;
%>
      <div id="MemberRankThisWeek" class="tn-box tn-widget tn-widget-content tn-corner-all spb-avatar-list-main spb-members-week-top">
        <div class="tn-box-header tn-widget-header tn-corner-top tn-border-bottom">
          <h3 class="tn-helper-reset"> <%=GetResourceString("Title_MemberRankThisWeek", applicationID)%></h3>
        </div>
        <div class="tn-box-content tn-widget-content tn-corner-bottom">
          <ul class="tn-avatar-list tn-helper-clearfix" id="MemberRankThisWeekUL">
            <%
                      foreach (var user in ViewData.Model)
                      {
                   %>
            <li class="tn-avatar-item">
              <div class="tn-avatar" value="<%=user.UserID %>"><%=SPBHtmlHelper.Instance().ShowUserAvatar(user.UserName,true, HyperLinkTarget._blank, AvatarSizeTypes.Small,true) %></div>
              <a href="<%=SiteUrls.Instance().UserDomainHome(user)%>" class="tn-user-name"><%=SPBHtmlHelper.Instance().UserDisplayName(user) %></a></li>
            <%
                       }
                    %>
          </ul>
          <p class="tn-more"><a href="<%=SPBUrlHelper.Action("MemberRanks","Channel",new RouteValueDictionary{{"sortBy",PersonUsersSortBy.StageHitTimes}}) %>"><%=GetResourceString("Action_More")%></a></p>
        </div>
      </div>
      <div class="tn-blank10"></div>
      <div id="MostActiveMembers" class="tn-box tn-widget tn-widget-content tn-corner-all spb-avatar-list-main spb-members-active">
        <div class="tn-box-header tn-widget-header tn-corner-top tn-border-bottom">
          <%if (CurrentUser != null)
        { %>
          <span class="tn-helper-right"><a href="<%=SiteUrls.Instance().UserChannelHome(CurrentUser.UserID, ApplicationIDs.Instance().Friend()) %>"><%=GetResourceString("Action_MyFriends",applicationID)%></a></span>
          <%} %>
          <h3 class="tn-helper-reset"> <%=GetResourceString("Title_MostActiveMembers",applicationID)%></h3>
        </div>
        <div id="listMemberForLoad" class="tn-box-content tn-widget-content tn-corner-bottom">
          <%Html.RenderAction<ChannelController>(n => n.Control_ListActiveMembers(16)); %>
        </div>
      </div>
      <div class="tn-blank10"></div>
      <div id="MembersDoWhat" class="tn-box tn-widget tn-widget-content tn-corner-all spb-members-doing">
        <div class="tn-box-header tn-widget-header tn-corner-top tn-border-bottom">
          <h3 class="tn-helper-reset"><%=GetResourceString("Title_MembersDoWhat",applicationID) %></h3>
        </div>
        <div class="tn-box-content tn-widget-content tn-corner-bottom">
          <ul class="tn-list tn-helper-reset">
            <% 
                  Dictionary<int, Application> applications = Applications.GetApplications();
                  string applicationKey = "default";
                  string applicationName = GetResourceString("Title_ActivityApplicationName", ApplicationIDs.Instance().User());
                  string userDomainName = Html.GetParameterFromRouteDateOrQueryString("userDomainName");
                  if (userActivities != null && userActivities.Count > 0)
                  {
                      foreach (UserActivity userActivity in userActivities)
                      {
                          if (applications.ContainsKey(userActivity.ApplicationID))
                          {
                              applicationKey = applications[userActivity.ApplicationID].ApplicationKey;
                              applicationName = applications[userActivity.ApplicationID].GetMultilingualApplicationName(CurrentUserLanguage);
                          }
                          string filePath = Globals.GetFullUrlInResourceSite(string.Format("~/Themes/Shared/Styles/Icons/activity_{0}.gif", applicationKey.ToLower()));%>
            <li class="tn-list-item tn-helper-clearfix tn-border-gray tn-border-bottom">
              <div class="tn-list-item-area-left"> <img src="<%=filePath %>" title="<%=applicationName %>" alt="<%=applicationName %>"
                    width="16" height="16" /> </div>
              <div class="tn-list-item-area-main">
                <div class="tn-list-item-row"> <%=userActivity.Subject%><em class="tn-text-note tn-date"><%= Convert.ToString(Formatter.FormatFriendlyDate(userActivity.DateCreated))%></em></div>
                <div class="tn-list-item-row tn-list-item-summary">
                  <% if (!string.IsNullOrEmpty(userActivity.Body))
                       {%>
                  <p class="tn-helper-reset"> <%=userActivity.Body%></p>
                  <%} %>
                </div>
              </div>
            </li>
            <%}
                  } %>
          </ul>
        </div>
      </div>
      <script type="text/javascript">
                $(document).ready(function() {
                    $("div.tn-avatar", $("#MemberRankThisWeekUL")).each(function() {
                        var self = $(this);
                        self.qtip({
                            content: '<div class="tn-loading"></div>',
                            position: {
                                corner: {
                                    target: 'rightTop',
                                    tooltip: 'leftTop'
                                },
                                adjust: {
                                    screen: true
                                }
                            },
                            show: {
                                when: 'mouseover',
                                solo: true,
                                delay: 1000
                            },
                            hide: { when: 'mouseout', fixed: true, delay: 480 },
                            style: {
                                tip: false,
                                border: {
                                    width: 0,
                                    radius: 0
                                },
                                background: 'none',
                                name: 'light',
                                width: 325,
                                padding: 1
                            },
                            api: { onShow: function() {
                                if (self.qtip('api').elements.content.is(":has(div.tn-loading)"))
                                    $.get('<%=SPBUrlHelper.Action("Control_MemberCard", "Channel")%>', { userID: self.attr("value") }, function(data) {
                                        self.qtip('api').updateContent(data);
                                    });
                            }
                            }
                        });
                    });
                });
</script>
    </div>
  </div>
  <div class="tn-block">
    <div id="MySearchBlock">
      <%Html.RenderPartial("Controls/Members/MySearchBlock.ascx");%>
    </div>
    <div id="RecommendUser">
      <%Html.RenderAction<ChannelController>(n => n.Control_RecommendUser(11001, 3));%>
    </div>
    <div id="ListMembers-CreateDate">
      <%Html.RenderAction<ChannelController>(n => n.Control_ListMembers(9, PersonUsersSortBy.CreateDate));%>
    </div>
    <div id="ListMembers-Rank">
      <%Html.RenderAction<ChannelController>(n => n.Control_ListMembers(9, PersonUsersSortBy.Rank));%>
    </div>
    <div id="OnlineMembersBlock">
      <%Html.RenderAction<ChannelController>(n => n.Control_OnlineMembersBlock(3));%>
    </div>
  </div>
  <%=SPBHtmlHelper.Instance().ShowAdvertisingInChannel("001000000002", new RouteValueDictionary { { "class", "spb-ad-banner-bottom" } })%> </asp:content>
