﻿<%@ Page Language="C#" Inherits="SpaceBuilder.Web.ChannelViewPage<PagingDataSet<PersonUser>>" %>

<asp:content contentplaceholderid="setPageID" runat="server">
    id="User-MemberRanks"
</asp:content>
<asp:content contentplaceholderid="mainContent" runat="server">
  <%
      
      PersonUsersSortBy sortBy = (PersonUsersSortBy)ViewData["sortBy"];
      int applicationID = ApplicationIDs.Instance().User();
      %> 
  <div id="tabs" class="ui-tabs ui-widget ui-widget-content ui-corner-all">
  <ul class="ui-tabs-nav ui-helper-reset ui-helper-clearfix ui-widget-header ui-corner-all">
    <li class="ui-state-default ui-corner-top <%if (PersonUsersSortBy.FriendCount == sortBy) { Response.Write("ui-tabs-selected ui-state-active"); } %>"><a href="<%=SPBUrlHelper.Action("MemberRanks","Channel",new RouteValueDictionary{{"sortBy",PersonUsersSortBy.FriendCount}}) %>"><span><%=GetResourceString("Title_RankByFriendCount",applicationID)%></span></a></li>
    <li class="ui-state-default ui-corner-top <%if (PersonUsersSortBy.CreateDate == sortBy) { Response.Write("ui-tabs-selected ui-state-active"); } %>"><a href="<%=SPBUrlHelper.Action("MemberRanks","Channel",new RouteValueDictionary{{"sortBy",PersonUsersSortBy.CreateDate}}) %>"><span><%=GetResourceString("Title_RankByJoinTime",applicationID)%></span></a></li>
    <li class="ui-state-default ui-corner-top <%if (PersonUsersSortBy.Rank == sortBy) { Response.Write("ui-tabs-selected ui-state-active"); } %>"><a href="<%=SPBUrlHelper.Action("MemberRanks","Channel",new RouteValueDictionary{{"sortBy",PersonUsersSortBy.Rank}}) %>"><span><%=GetResourceString("Title_RankByUserRank",applicationID)%></span></a></li>
    <li class="ui-state-default ui-corner-top <%if (PersonUsersSortBy.ReportPoints == sortBy) { Response.Write("ui-tabs-selected ui-state-active"); } %>"><a href="<%=SPBUrlHelper.Action("MemberRanks","Channel",new RouteValueDictionary{{"sortBy",PersonUsersSortBy.ReportPoints}}) %>"><span><%=GetResourceString("Title_RankByReportPoints",applicationID)%></span></a></li>
    <li class="ui-state-default ui-corner-top <%if (PersonUsersSortBy.CreditPoints == sortBy) { Response.Write("ui-tabs-selected ui-state-active"); } %>"><a href="<%=SPBUrlHelper.Action("MemberRanks","Channel",new RouteValueDictionary{{"sortBy",PersonUsersSortBy.CreditPoints}}) %>"><span><%=GetResourceString("Title_RankByCreditPoints",applicationID)%></span></a></li>
    <li class="ui-state-default ui-corner-top <%if (PersonUsersSortBy.StageHitTimes == sortBy) { Response.Write("ui-tabs-selected ui-state-active"); } %>"><a href="<%=SPBUrlHelper.Action("MemberRanks","Channel",new RouteValueDictionary{{"sortBy",PersonUsersSortBy.StageHitTimes}}) %>"><span><%=GetResourceString("Title_RankByWeekHitTimes",applicationID)%></span></a></li>
    <li class="ui-state-default ui-corner-top <%if (PersonUsersSortBy.HitTimes == sortBy) { Response.Write("ui-tabs-selected ui-state-active"); } %>"><a href="<%=SPBUrlHelper.Action("MemberRanks","Channel",new RouteValueDictionary{{"sortBy",PersonUsersSortBy.HitTimes}}) %>"><span><%=GetResourceString("Title_RankByHitTimes",applicationID)%></span></a></li>
  </ul>
  <div id="tabs-1" class="ui-tabs-panel ui-widget-content ui-corner-bottom"><ul class="tn-list tn-helper-reset">
          <%foreach (var user in ViewData.Model.Records)
            {%>
          <li class="tn-list-item tn-helper-clearfix tn-border-gray tn-border-bottom">
            <div class="tn-list-item-area-left">
              <div class="tn-avatar"><%=SPBHtmlHelper.Instance().ShowUserAvatar(user.UserID, true, HyperLinkTarget._blank, AvatarSizeTypes.Small)%></div>
            </div>
            <div class="tn-list-item-area-right">
              <ul class="tn-list-actions tn-helper-reset">
                <%if (CurrentUser != null && user.UserID != CurrentUser.UserID)
                  {
                      if (!Friends.IsFriend(CurrentUser.UserID, user.UserID))
                      {%>
              <li class="tn-list-action tn-border-gray tn-border-bottom"><a class="addFriendModal" href="<%=SiteUrls.Instance().NewFriendInvitation(CurrentUser.UserName,user.UserID)%>"> <%= GetResourceString("Action_AddFriend")%></a></li>
              <%} %>
              <li class="tn-list-action tn-border-gray tn-border-bottom"><a href="<%=SiteUrls.Instance().NewMessage(CurrentUser.UserName,user.UserID) %>">  <%=GetResourceString("Action_SendMessage",applicationID)%></a></li>
              <%} %>
              </ul>
            </div>
            <div class="tn-list-item-area-main">
              <div class="tn-list-item-row tn-list-item-heading">
                <h5 class="tn-helper-reset"> <a href="<%=SiteUrls.Instance().UserDomainHome(user) %>"><%=SPBHtmlHelper.Instance().UserDisplayName(user.UserID,true) %></a></h5>
              </div>
              <%string microblog = MicroBlogUserDatas.GetUserData(user.UserID, false).MostRecentThreadBody;
                if (!string.IsNullOrEmpty(microblog))
                { %>
              <div class="tn-list-item-row tn-list-item-summary">
                <div class="spb-i-said">&nbsp;<span class="tn-icon tn-icon-quotes-before tn-icon-inline"></span>
            <%=microblog %>
            <span class="tn-icon tn-icon-quotes-after tn-icon-inline"></span></div>
              </div>
              <%} %>
              <div class="tn-list-item-row">
                <span class="spb-user-type"> <% string roleIcons = SPBHtmlHelper.Instance().ShowUserRoleIcons(user);
                                                if (!string.IsNullOrEmpty(roleIcons))
                                                { %>
                 <%=roleIcons %>
                <%} %><a href="<%=SiteUrls.Instance().ListPointRecords(user.UserName) %>"> <%=SPBHtmlHelper.Instance().ShowUserRankIcons(user)  %></a> </span><em class="tn-count tn-text-note"> <%=string.Format(GetResourceString("Description_Pattern_FriendCount", applicationID), user.FriendCount)%></em><cite class="tn-text-note"><a class="tn-location" href="<%=SPBUrlHelper.Action("UserSearch","ChannelUser",new RouteValueDictionary{{"NowAreaCode",user.NowAreaCode}}) %>"> <%=Formatter.FormatArea(user.NowAreaCode,true)%></a></cite>
              </div>
            </div>
          </li>
          <%}%>
        </ul>
        <%if (Model.TotalRecords > Model.PageSize)
          {%>
                <div class="tn-pagination tn-helper-align-center">
                        <%=SPBHtmlHelper.Instance().PagingButton(PaginationMode.NumericNextPrevious,Model.TotalRecords, Model.PageSize, Model.PageIndex)%>
                    
<div class="tn-page-results tn-text-note"><%=string.Format(GetResourceString("Label_Pattern_TotalRecords"), ViewData.Model.TotalRecords)%></div>
                </div>
                <%}%>
                 </div>
</div>
  <script type="text/javascript">
      $(document).ready(function() {
          $('.addFriendModal').nyroModal({
              resizeable: true
          });
      }); 
    </script>
</asp:content>
<asp:content contentplaceholderid="sidebarContent" runat="server">
      <div id="MySearchBlock">
      <%Html.RenderPartial("Controls/Members/MySearchBlock.ascx");%>
      </div>
      <div id="RecommendUser">
      <%Html.RenderAction<ChannelController>(n => n.Control_RecommendUser(11001, 3));%>
      </div>
      <div id="OnlineMembersBlock">
      <%Html.RenderAction<ChannelController>(n => n.Control_OnlineMembersBlock(3));%>
      </div>
</asp:content>
