﻿<%@ Page Language="C#" Inherits="SpaceBuilder.Web.ChannelViewPage<ICollection<OnlineUser>>" %>

<asp:content contentplaceholderid="setPageID" runat="server">
    id="User-OnlineMembers"
</asp:content>
<asp:content id="Content1" contentplaceholderid="mainContent" runat="server">
    <%
        
        int applicationID = ApplicationIDs.Instance().User();
        %>
    <div id="OnlineMember" class="tn-box tn-widget tn-widget-content tn-corner-all spb-avatar-list-main spb-members-online">
              <div class="tn-box-header tn-widget-header tn-corner-top tn-border-bottom">
              <span class="tn-helper-right">
              <a href="<%=SiteUrls.Instance().ChannelMemberHome() %>"><%=GetResourceString("Action_GotoAllMembers",applicationID)%></a>
              </span>
                <h3 class="tn-helper-reset"><%=GetResourceString("Title_OnlineMember", applicationID)%></h3>
              </div>
              <div class="tn-box-content tn-widget-content tn-corner-bottom">
                <ul class="tn-avatar-list tn-helper-reset tn-helper-clearfix">
                  <%if (Model != null && Model.Count > 0)
                    {
                        foreach (OnlineUser user in Model)
                        {%>
                  <li class="tn-avatar-item">
                    <div class="tn-avatar"><%=SPBHtmlHelper.Instance().ShowUserAvatar(user.UserID, true, HyperLinkTarget._blank, AvatarSizeTypes.Small)%></div>
                    <a class="tn-user-name" href="<%=SiteUrls.Instance().UserDomainHome(user.UserID) %>"><%=SPBHtmlHelper.Instance().UserDisplayName(user.UserID) %></a></li>
                    <%}
                    } %>
                </ul>
              </div>
            </div>
</asp:content>
<asp:content id="Content2" contentplaceholderid="sidebarContent" runat="server">
    <div id="MySearchBlock">
    <%Html.RenderPartial("Controls/Members/MySearchBlock.ascx");%>
    </div>
    <div id="RecommendUser">
    <%Html.RenderAction<ChannelController>(n => n.Control_RecommendUser(11001, 3));%>
    </div>
    <div id="ListMembers-CreateDate">
    <%Html.RenderAction<ChannelController>(n => n.Control_ListMembers(9, PersonUsersSortBy.CreateDate));%>
    </div>
    <div id="ListMembers-Rank">
    <%Html.RenderAction<ChannelController>(n => n.Control_ListMembers(9, PersonUsersSortBy.Rank));%>
    </div>
</asp:content>
