﻿<%@ Page Language="C#" Inherits="SpaceBuilder.Web.ChannelViewPage<SearchResultDataSet<PersonUser>>" %>

<asp:content contentplaceholderid="setPageID" runat="server">
    id="User-Search"
</asp:content>
<asp:content id="Content1" contentplaceholderid="mainContent" runat="server">
  <%
      
      int applicationID = ApplicationIDs.Instance().User();
      PersonUserFullTextQuery query = ViewData.Get<PersonUserFullTextQuery>("Query", null);
      int searchScopeUserID = Html.GetParameterFromRouteDateOrQueryString("SearchScopeUserID", 0);
      string keyWords = Html.GetParameterFromRouteDateOrQueryString("NameKeyword");
      bool isShowSchoolAndCommpany = true;
      if (string.IsNullOrEmpty(keyWords))
      {
          isShowSchoolAndCommpany = false;
          keyWords = Html.GetParameterFromRouteDateOrQueryString("CompanyName");
      }
      if (string.IsNullOrEmpty(keyWords))
          keyWords = Html.GetParameterFromRouteDateOrQueryString("School");
      if (string.IsNullOrEmpty(keyWords))
          keyWords = Html.GetParameterFromRouteDateOrQueryString("TagName");
      keyWords = WebUtils.UrlDecode(keyWords);
   %>    
    <spb:Script runat="server" ID="CollapsibleBox" Src="~/Utility/jquery/plugin/jquery.spb.CollapsibleBox.js"
        SetExpireDays="30" />  
       <div id="MembersResult" class="tn-box tn-widget tn-widget-content tn-corner-all spb-search-results">
    <div class="tn-box-content tn-widget-content tn-corner-all">
        <div class=" spb-search-area">
            <form method="post" id="advancedSearchForm" action="<%=SPBUrlHelper.Action("UserAdvancedSearch","ChannelUser") %>">
            <div class="<%if(query.IsShowMoreCondition())  Response.Write("tn-collapsible tn-collapsible-opened tn-helper-clearfix"); else Response.Write("tn-collapsible tn-collapsible-closed tn-helper-clearfix"); %>">
                <div class="tn-form tn-form-single">
                    <input id="Keyword" type="text" class="tn-textbox tn-border-gray" name="Keyword" value="<%=keyWords %>">
                    <%=SPBHtmlHelper.Instance().SubmitButton("SearchButton",GetResourceString("Button_Search"))%>
                    <div class="tn-input-multiple">
                        <input type="radio" name="SearchCondition" id="name" value="Keyword" class="tn-radiobutton"
                            checked="checked"/>
                        <label for="name">
                            关键词</label>
                        <input type="radio" id="commpany" name="SearchCondition" value="companyName" class="tn-radiobutton"
                            <%if (!string.IsNullOrEmpty(Html.GetParameterFromRouteDateOrQueryString("CompanyName")) && string.IsNullOrEmpty(Html.GetParameterFromRouteDateOrQueryString("Keyword"))) Response.Write("checked=\"checked\""); %>/>
                        <label for="commpany">
                            公司</label>
                        <input type="radio" id="school" name="SearchCondition" value="school" class="tn-radiobutton"
                            <%if (!string.IsNullOrEmpty(Html.GetParameterFromRouteDateOrQueryString("School")) && string.IsNullOrEmpty(Html.GetParameterFromRouteDateOrQueryString("Keyword"))) Response.Write("checked=\"checked\""); %>/>
                        <label for="school">
                            学校</label>
                        <input type="radio" id="tagName" name="SearchCondition" value="tagName" class="tn-radiobutton"
                            <%if (!string.IsNullOrEmpty(Html.GetParameterFromRouteDateOrQueryString("TagName")) && string.IsNullOrEmpty(Html.GetParameterFromRouteDateOrQueryString("Keyword"))) Response.Write("checked=\"checked\""); %>/>
                        <label for="tagName">
                            标签</label>
                    </div>
                </div>
                <div class="tn-collapsible-header tn-switch-left">
                    <h4>
                        <a href="javascript:;;">
                            <%=GetResourceString("Label_MoreOptions",applicationID) %></a></h4>
                    <span class="tn-icon tn-switch tn-icon-collapse-close"></span>
                </div>
                <div class="tn-collapsible-content tn-border-top tn-border-gray" style="">
                    <div class="tn-form tn-label-right">
                        <div class="tn-form-row">
                            <label class="tn-form-label">
                                <%=GetResourceString("Label_UserAreaCode",applicationID)%><%=GetResourceString("Common_Colon") %></label>
                            <% Html.RenderAction<ChannelController>(n => n.Control_AreasDropDownList("NowAreaCode", UserDomainConfiguration.Instance().RootAreaCode, query == null ? string.Empty : query.NowAreaCode, UserDomainConfiguration.Instance().AreaLevel, "tn-dropdownlist")); %>
                        </div>
                        <div class="tn-form-row">
                            <label class="tn-form-label">
                                <%=GetResourceString("Label_UserHomeAreaCode", applicationID)%><%=GetResourceString("Common_Colon") %></label>
                            <% Html.RenderAction<ChannelController>(n => n.Control_AreasDropDownList("HomeAreaCode", UserDomainConfiguration.Instance().RootAreaCode, query == null ? string.Empty : query.HomeAreaCode, UserDomainConfiguration.Instance().AreaLevel, "tn-dropdownlist")); %>
                        </div>
                        <%--<div class="tn-form-row">
                            <label class="tn-form-label">
                                职位类别：</label>
                            <%=SPBHtmlHelper.Instance().ShowJobSortsDropDownList("jobSort", new RouteValueDictionary { {"Class","dropDownList" }}, query.JobSort) %>
                        </div>--%>
                        <%if (isShowSchoolAndCommpany)
                          { %>
                        <div class="tn-form-row">
                            <label class="tn-form-label">
                                <%=GetResourceString("Label_PersonUserCompanyName",applicationID)%><%=GetResourceString("Common_Colon") %></label>
                            <input type="text" class="tn-textbox tn-input-medium tn-border-gray" id="companyName1"
                                name="companyName" value="<%=query.CompanyName %>" maxlength="100" />
                                </div>
                            <div class="tn-form-row">    
                            <label class="tn-form-label">
                                <%=GetResourceString("Label_PersonUserSchool",applicationID)%><%=GetResourceString("Common_Colon") %></label>
                            <input type="text" class="tn-textbox tn-input-medium tn-border-gray" maxlength="100"
                                id="school1" name="school" value="<%=query.School %>"/>
                        </div>
                        <%} %>
                        <div class="tn-form-row">
                            <label class="tn-form-label">
                                <%=GetResourceString("Label_PersonUserGender",applicationID)%><%=GetResourceString("Common_Colon") %></label>
                            <div class="tn-input-multiple">
                                <input type="radio" class="tn-radiobutton" id="genderall" name="gender" <%if(query != null && query.Gender == Genders.All) Response.Write("checked=\"checked\"");  %>
                                    value="<%=(int)Genders.All %>"/>
                                <label for="genderall">
                                    <%=GetResourceString("Enum_Genders_All")%></label>
                                <input type="radio" class="tn-radiobutton" id="maleItem" name="gender" <%if(query != null && query.Gender == Genders.Male) Response.Write("checked=\"checked\"");  %>
                                    value="<%=(int)Genders.Male %>"/>
                                <label for="maleItem">
                                    <%=GetResourceString("Enum_Genders_Male")%></label>
                                <input type="radio" class="tn-radiobutton" id="femaleItem" name="gender" <%if(query != null && query.Gender == Genders.Female) Response.Write("checked=\"checked\"");  %>
                                    value="<%=(int)Genders.Female %>"/>
                                <label for="femaleItem">
                                    <%=GetResourceString("Enum_Genders_Female") %></label>
                            </div>
                        </div>
                        <div class="tn-form-row">
                            <label class="tn-form-label">
                                学历：</label>
                            <%Dictionary<int, CodeItem> Degrees = CodeItems.GetCodeItems(CodeSetCodes.Instance().Degree()); %>
                            <%=SPBHtmlHelper.Instance().ShowDropDownList<int, string>("degree", Degrees.ToDictionary(n => n.Key, n => n.Value.Name), new RouteValueDictionary { { "Class", "dropDownList" } }, query.Degree)%>
                        </div>
                        <div class="tn-form-row">
                            <label class="tn-form-label">
                                年龄<%=GetResourceString("Common_Colon") %></label>
                            <select class="" name="AgeScope">
                                <option value="-1" <%if (query.AgeScope == null || (int)query.AgeScope < 0) Response.Write("selected=\"selected\""); %>>
                                    请选择</option>
                                <option value="0" <%if (query.AgeScope != null && (int)query.AgeScope == (int)AgeScopes.Year18) Response.Write("selected=\"selected\""); %>>
                                    18岁以下</option>
                                <option value="1" <%if (query.AgeScope != null && (int)query.AgeScope == (int)AgeScopes.Year22) Response.Write("selected=\"selected\""); %>>
                                    19~22岁</option>
                                <option value="2" <%if (query.AgeScope != null && (int)query.AgeScope == (int)AgeScopes.Year29) Response.Write("selected=\"selected\""); %>>
                                    23~29岁</option>
                                <option value="3" <%if (query.AgeScope != null && (int)query.AgeScope == (int)AgeScopes.Year39) Response.Write("selected=\"selected\""); %>>
                                    30~39岁</option>
                                <option value="4" <%if (query.AgeScope != null && (int)query.AgeScope == (int)AgeScopes.Year40) Response.Write("selected=\"selected\""); %>>
                                    40岁以上</option>
                            </select>
                        </div>
                    </div>
                </div>
            </div>
            </form>
        </div>
        <% if (ViewData.Model != null)
           {
               if (ViewData.Model.TotalRecords == 0)
               {%>
        <div class="tn-list-header">
        <div class="tn-list-header-row tn-helper-clearfix tn-border-gray tn-border-bottom">
                </div>
        <% Html.RenderPartial("Controls/Search/NoSearchResult.ascx");%>

        </div>
        <%}
               else
               { %>
        <div class="tn-list-header">
            <div class="tn-list-header-row tn-helper-clearfix tn-border-gray tn-border-bottom">
                <span class="tn-text-note">
                    <%=string.Format(GetResourceString("Message_Pattern_UserSearchResult", applicationID), ViewData.Model.TotalRecords, ViewData.Model.SearchDuration)%>
                </span>
            </div>
        </div>
        <ul class="tn-list">
            <% foreach (var user in ViewData.Model.Records)
               {
                   if (user == null)
                       continue;
            %>
            <li class="tn-list-item tn-helper-clearfix tn-border-gray tn-border-bottom">
                <div class="tn-list-item-area-left">
                    <div class="tn-avatar-medium">
                        <%=SPBHtmlHelper.Instance().ShowUserAvatar(user.UserID, true, HyperLinkTarget._blank, AvatarSizeTypes.Card)%></div>
                </div>
                <div class="tn-list-item-area-right">
                    <ul class="tn-list-actions tn-helper-reset">
                        <%if (CurrentUser != null && user.UserID != CurrentUser.UserID)
                          {
                              if (!Friends.IsFriend(CurrentUser.UserID, user.UserID))
                              {%>
                        <li class="tn-list-action tn-border-gray tn-border-bottom"><a class="addFriendModal"
                            href="<%=SiteUrls.Instance().NewFriendInvitation(CurrentUser.UserName,user.UserID)%>">
                            <%= GetResourceString("Action_AddFriend")%></a></li>
                        <%} %>
                        <li class="tn-list-action tn-border-gray tn-border-bottom"><a href="<%=SiteUrls.Instance().NewMessage(CurrentUser.UserName,user.UserID) %>">
                            <%=GetResourceString("Action_SendMessage",applicationID)%></a></li>
                       
                        <%} %>
                    </ul>
                </div>
                <div class="tn-list-item-area-main">
                    <div class="tn-list-item-row tn-list-item-heading">
                        <h5 class="tn-helper-reset">
                            <a title="<%=user.DisplayName%>" href="<%=SiteUrls.Instance().UserDomainHome(user) %>">
                                <%=SPBHtmlHelper.Instance().UserDisplayName(user.UserID,true) %></a><em class="tn-gender"><%=user.GenderText%></em>
                                <%if (user.Age > 0)
                                  { %>
                                <em class="tn-age"><%=user.Age.ToString() %></em>
                                <%} %></h5>
                    </div>
                    <div class="tn-list-item-row">
                        <div class="tn-info-part tn-helper-clearfix">
                            <%if (!string.IsNullOrEmpty(user.School))
                              {%>
                            <dl>
                                <dt>
                                    <%=GetResourceString("Label_School", applicationID)%><%=GetResourceString("Common_Colon")%></dt>
                                <dd>
                                    <a title="<%=user.School%>" href="<%=SPBUrlHelper.Action("UserSearch", "ChannelUser", new RouteValueDictionary { { "School", WebUtils.UrlEncode(user.School) } })%>">
                                        <%=user.School%></a></dd>
                            </dl>
                            <%} %>
                            <%if (!string.IsNullOrEmpty(user.NowAreaCode))
                              {%>
                            <dl>
                                <dt>
                                    <%=GetResourceString("Label_UserAreaCode",applicationID)%><%=GetResourceString("Common_Colon")%></dt>
                                <dd>
                                    <a title="<%=Formatter.FormatArea(user.NowAreaCode, true)%>" href="<%=SPBUrlHelper.Action("UserSearch","ChannelUser",new RouteValueDictionary{{"NowAreaCode",user.NowAreaCode}}) %>">
                                        <%=Formatter.FormatArea(user.NowAreaCode, true)%></a></dd>
                            </dl>
                            <%} %>
                            <%if (!string.IsNullOrEmpty(user.CompanyName))
                              { %>
                            <dl>
                                <dt>
                                    <%=GetResourceString("Label_CompanyName",applicationID)%><%=GetResourceString("Common_Colon")%></dt>
                                <dd>
                                    <a title="<%=user.CompanyName%>" href="<%=WebUtils.HtmlEncode(SPBUrlHelper.Action("UserSearch", "ChannelUser", new RouteValueDictionary { { "CompanyName", WebUtils.UrlEncode(user.CompanyName) } }))%>">
                                        <%=user.CompanyName%></a></dd>
                            </dl>
                            <%} %>
                            <%if (user.CompanyTrade > 0)
                              { %>
                            <dl>
                                <dt>
                                    <%=GetResourceString("Label_CompanyTrade", applicationID)%><%=GetResourceString("Common_Colon")%></dt>
                                <dd>
                                    <%=SPBHtmlHelper.Instance().ShowTrade(user.CompanyTrade)%></dd>
                            </dl>
                            <%} %>
                            <%if (!string.IsNullOrEmpty(user.Expertise))
                              { %>
                            <dl>
                                <dt>
                                    <%=GetResourceString("Label_Expertise", applicationID)%><%=GetResourceString("Common_Colon")%></dt>
                                <dd>
                                  
                                        <%=user.Expertise%></dd>
                            </dl>
                            <%} %>
                            <%if (!string.IsNullOrEmpty(user.Interest))
                              {%>
                            <dl>
                                <dt>
                                    <%=GetResourceString("Label_Interest", applicationID)%><%=GetResourceString("Common_Colon")%></dt>
                                <dd>
                                    <%=user.Interest%></dd>
                            </dl>
                            <%} %>
                        </div>
                        <p class="tn-tags">
                            <%ICollection<UserTag> tags = UserTagManager.Instance(UserTagItemKeys.Instance().Person()).GetUserTags(user.UserID, false);
                              foreach (UserTag tag in tags)
                              { %>
                            <a href="<%=SiteUrls.Instance().ListUsersByTag(tag.TagName) %>">
                                <%=tag.TagName%></a>
                            <%}
                            %></p>
                    </div>
                </div>
            </li>
            <%	} %>
        </ul>

    <div class="tn-pagination tn-helper-align-center">
        <%= SPBHtmlHelper.Instance().PagingButton( PaginationMode.NumericNextPrevious, ViewData.Model.TotalRecords, ViewData.Model.PageSize, ViewData.Model.PageIndex)%>
    </div>
    <%} %>
    <%} %>
</div>
    </div>
<script type="text/javascript">
$(document).ready(function() {
    $("#Keyword").attr("name",$("input[name='SearchCondition']:checked").val());
     
    $("input[name='SearchCondition']").change(function() {
      $("#companyName1").attr("name","");
      $("#school1").attr("name","");
      $("#Keyword").attr("value","<%=keyWords %>");
         $("#Keyword").attr("name",$("input[name='SearchCondition']:checked").val());
         if($("#Keyword").val())
             $("#advancedSearchForm").submit();
    });
    
    
    
    $('a.addFriendModal').nyroModal({
          resizeable: true
      });
    $(".tn-collapsible").collapsibleBox();
        
        $('a.addFavorite').one("click",function() {
        var obj = $(this);
        $.getJSON('<%=SPBUrlHelper.Action("CreateFavorite","Channel") %>', { favoriteUserID: obj.attr("value") }, function(data) {
            if (data.isSuccess) {
                obj.text("<%=GetResourceString("Label_AlreadyCollected",applicationID)%>");
            }
        });
 });
});
</script>

</asp:content>
<asp:content id="Content3" contentplaceholderid="sidebarContent" runat="server">

    <div id="UserSiteTags">
    <%Html.RenderAction<ChannelUserController>(n => n.Control_ListUserSiteTags());%>
    <div class="tn-blank10"></div>
    </div>

    <div id="MySearchBlock">
    <%Html.RenderPartial("Controls/Members/MySearchBlock.ascx");%>
    </div>
    <div id="RecommendUser">
    <%Html.RenderAction<ChannelController>(n => n.Control_RecommendUser(11001, 3));%>
    </div>
    <div id="ListMembers-CreateDate">
    <%Html.RenderAction<ChannelController>(n => n.Control_ListMembers(9, PersonUsersSortBy.CreateDate));%>
    </div>
    <div id="ListMembers-Rank">
    <%Html.RenderAction<ChannelController>(n => n.Control_ListMembers(9, PersonUsersSortBy.Rank));%>
    </div>
    <div id="OnlineMembersBlock">
    <%Html.RenderAction<ChannelController>(n => n.Control_OnlineMembersBlock(3));%>
    </div>
</asp:content>
