﻿<%@ Page Language="C#" Inherits="SpaceBuilder.Web.ChannelViewPage<IList<NewsThread>>" %>

<asp:content id="Content1" contentplaceholderid="subMenusContent" runat="server">
    <%Html.RenderAction<ChannelNewsController>(n => n.Control_SubMenus()); %>
</asp:content>
<asp:content contentplaceholderid="setPageID" runat="server">
    id="News-ListNewsForChild"
</asp:content>
<asp:content contentplaceholderid="mainContent" runat="server">
<spb:Script runat="server" ID="CollapsibleBox" Src="~/Utility/jquery/plugin/jquery.spb.CollapsibleBox.js"
        SetExpireDays="30" />
    <%NewsSection section = ViewData["section"] as NewsSection;
      int NewsApplicationID = ApplicationIDs.Instance().News(); %>
<div id="ListNewsForChild" class="tn-box tn-widget tn-widget-content tn-corner-all">
          <div class="tn-box-content tn-widget-content tn-corner-all"> 
                <%if (ViewData.Model != null && ViewData.Model.Count > 0)
                  {%>
                <%NewsThread topThread = ViewData.Model[0]; %>
                   <ul class="tn-list tn-helper-reset">
          <li class="tn-list-item tn-helper-clearfix tn-border-gray tn-border-bottom">

                 <div class="tn-list-item-area-left">
         <%if (topThread.FeaturedImageAttachmentID > 0)
           {%>                   
              <a href="<%=SiteUrls.Instance().ShowNews(topThread.ThreadID) %>" class="storiesTopImg">
                        <img src="<%=SiteUrls.Instance().NewsPhotoUrl(topThread.FeaturedImageAttachmentID, NewsPhotoTypes.BigNews) %>" /></a>
                      <%} %>
                      </div>
            <div class="tn-list-item-area-main">
              <div class="tn-list-item-row tn-list-item-heading">
                <h5 class="tn-helper-reset"><a title="<%=topThread.Title%>" href="<%=SiteUrls.Instance().ShowNews(topThread.ThreadID) %>">
                            <%if (topThread.FeaturedImageAttachmentID > 0) { Response.Write(StringUtils.Trim(topThread.Title, 37)); } else { Response.Write(StringUtils.Trim(topThread.Title, 48)); } %></a>
                            <%if (topThread.IsSticky)
                                  SPBHtmlHelper.Instance().Icon(IconTypes.Top);
                              if (topThread.IsEssential)
                                  SPBHtmlHelper.Instance().Icon(IconTypes.Elite);
                                  %>

                </h5>
              </div>
              <div class="tn-list-item-row"> <cite class="tn-text-note"><em class="tn-date"> <%=Formatter.FormatDate(topThread.PostDate)%></em></cite> </div>
              <div class="tn-list-item-row tn-list-item-summary">
                <p class="tn-helper-reset"> <%if (string.IsNullOrEmpty(topThread.Excerpt)) { Response.Write(HtmlUtils.TrimHtml(topThread.ForcedExcerpt, 110)); } else { Response.Write(HtmlUtils.TrimHtml(topThread.Excerpt, 110)); }%></p>
              </div>
            </div>
         </li>
         </ul>
                <%if (ViewData.Model.Count > 1)
                  { %>
                <div class="tn-blank10"></div>
                    <span class="tn-helper-right">
                        <a href="<%=SPBUrlHelper.Action("ListNews","ChannelNews",new RouteValueDictionary{{"sectionID",section.SectionID}}) %>">
                            <%=GetResourceString("Action_More")%></a>
                    </span>
                    <h5>
                        <%=GetResourceString("Title_MostWonderfulRecommend",NewsApplicationID)%></h5>
                                      <div class="tn-blank10"></div>
        <ul class="tn-helper-reset tn-helper-clearfix tn-list tn-list-symmetry">
                        <%for (int i = 1; i < ViewData.Model.Count; i++)
                          {
                              NewsThread thread = ViewData.Model[i];%>
                        
                                 <li><em class="tn-text-note tn-date tn-helper-right"><%=Formatter.FormatDate(thread.PostDate)%></em>
                                 •&nbsp;&nbsp;<a title="<%=thread.Title%>"
                                href="<%=SiteUrls.Instance().ShowNews(thread.ThreadID) %>"><%=StringUtils.Trim(thread.Title, 50,string.Empty)%></a> </li>
                        <%}%>
                    </ul>
                     
                <%}
                  }%>
                  <div class="tn-blank10"></div>
                <div class="tn-list-header">
                <div id="NewsViewType" class="tn-list-header-row tn-helper-clearfix tn-border-gray tn-border-bottom">
                    <%=GetResourceString("Label_Display")%><%=GetResourceString("Common_Colon") %> 
                    <span id="headlines" class="tn-action">
                    <a class="tn-action-text" href="javascript:;"><%=GetResourceString("Label_Subject")%></a>
                    </span>
                    <span id="summaries" class="tn-action">
                    <a class="tn-action-text" href="javascript:;"><%=GetResourceString("Action_Summary",NewsApplicationID)%></a>
                    </span>
                    <span id="featureImg" class="tn-action">
                    <a class="tn-action-text" href="javascript:;"><%=GetResourceString("Action_PhotoView",NewsApplicationID)%></a>
                    </span>
                    </div>
                    </div>
                <%if (section.ChildCount > 0)
                  {
                      foreach (var dict in ViewData["sectionThread"] as Dictionary<NewsSection, IList<NewsThread>>)
                      {
                          if (dict.Value.Count > 0)
                          {
                              %>
                  <div class="tn-blank10"></div>
              <div class="tn-collapsible tn-collapsible-opened">
              <div class="tn-border-bottom tn-border-gray tn-collapsible-header">
                <h4 class="tn-helper-reset"><a href="javascript:;"><%=dict.Key.GetMultilingualSectionName(CurrentUserLanguage) %></a></h4>
                </div>
              <div class="tn-collapsible-content" style="display:block;">
                                      <ul  id="newsListUL" class="tn-list tn-helper-reset">

                   <%int i = 0;
                     foreach (var thread in dict.Value)
                     {
                         i++;
                                  %>
                          
                <li class="tn-list-item tn-helper-clearfix <%if (i ==1) Response.Write(""); else Response.Write(" tn-border-gray tn-border-top"); %>">
            <div class="tn-list-item-area-left img" style="display:none">
            <%if (thread.FeaturedImageAttachmentID > 0)
              {%><a href="<%=SiteUrls.Instance().ShowNews(thread.ThreadID) %>">
                                <img src="<%=SiteUrls.Instance().NewsPhotoUrl(thread.FeaturedImageAttachmentID, NewsPhotoTypes.Title) %>" /></a>
                                <%} %>
           </div>
            <div class="tn-list-item-area-main">
              <div class="tn-list-item-row tn-list-item-heading">
                <h5 class="tn-helper-reset"><a title="<%=thread.Title%>" href="<%=SiteUrls.Instance().ShowNews(thread.ThreadID) %>">
                                <%if (thread.FeaturedImageAttachmentID > 0) { Response.Write(StringUtils.Trim(thread.Title, 30)); } else { Response.Write(StringUtils.Trim(thread.Title, 30)); }  %></a>
                     <%if (thread.IsSticky)
                           SPBHtmlHelper.Instance().Icon(IconTypes.Top);
                       if (thread.IsEssential)
                           SPBHtmlHelper.Instance().Icon(IconTypes.Elite);
                                  %>
               
               <cite class="tn-text-note"><em class="tn-date"><%=Formatter.FormatDate(thread.PostDate)%></em></cite>  </h5></div>
              <div class="tn-list-item-row tn-list-item-summary summary">
                <p class="tn-helper-reset"><%if (string.IsNullOrEmpty(thread.Excerpt)) { Response.Write(HtmlUtils.TrimHtml(thread.ForcedExcerpt, 108)); } else { Response.Write(HtmlUtils.TrimHtml(thread.Excerpt, 108)); }%></p>
              </div>
            </div>
          </li>
                
                
                
                <%} %>
                </ul>
               <p class="tn-helper-align-right">
                        <a href="<%=SPBUrlHelper.Action("ListNews","ChannelNews",new RouteValueDictionary{{"sectionID",dict.Key.SectionID }}) %>">
                            <%=GetResourceString("Action_More")%>……</a></p>
            </div>
                               </div>
 
                <%}
                      }
                  }%>
            </div>


    <script type="text/javascript">
        $(document).ready(function() {  
                		$(".tn-collapsible").collapsibleBox();

 $("#headlines").click(function(){
           $('#newsListUL div.img').css('display','none');
                $('#newsListUL div.summary').css('display','none');
                 $('#NewsViewType span').removeClass('tn-selected');
                 $(this).addClass("tn-selected");
                ;$.cookie('ListNewsMode',1);
            });
            
            $("#summaries").click(function(){
            $('#newsListUL div.img').css('display','none');
                $('#newsListUL div.summary').css('display','block');
                $('#NewsViewType span').removeClass('tn-selected');
                 $(this).addClass("tn-selected");
                $.cookie('ListNewsMode',2);
            });
            
            $("#featureImg").click(function(){
            $('#newsListUL div.img').css('display','block');
                $('#newsListUL div.summary').css('display','block');
                $('#NewsViewType span').removeClass('tn-selected');
                 $(this).addClass("tn-selected");
                $.cookie('ListNewsMode',3);
            });
            
            <% int mode = 0;
            HttpCookie cookie = Request.Cookies["ListNewsMode"];
                   if (cookie != null)
                    {  
                     mode = Convert.ToInt32(cookie.Value);
                       if(mode == 1)
                        Response.Write("$('#headlines').click();");
                       else if(mode == 2)
                       Response.Write("$('#summaries').click();");
                       else
                        Response.Write("$('#featureImg').click();");
                        }
                   else
                       Response.Write("$('#featureImg').click();"); %>
            
        }); 

    </script>
</div>
</asp:content>
<asp:content contentplaceholderid="sidebarContent" runat="server">
 
  <div id="ListNewsBlock">
  <%Html.RenderAction<ChannelNewsController>(n => n.Control_ListNewsBlock(Html.GetParameterFromRouteDateOrQueryString("sectionID", 0), NewThreadsSortBy.StageHitTimes, "ListNewsBlockForSidebar", "本周热门", 10)); %>
    </div>
  <%=SPBHtmlHelper.Instance().ShowAdvertisingInChannel("001002010003", new RouteValueDictionary { { "class", "spb-ad-side-bottom" } })%>
  <div id="ListCommentsBlock">
            <%Html.RenderAction<ChannelNewsController>(n => n.Control_ListNewsBlock(0, NewThreadsSortBy.StageCommentCount, "ListNewsBlockForSidebar", "本周热评", 10)); %>
  </div>
    <div id="ListPhotoNewsBlock">
        <%Html.RenderAction<ChannelNewsController>(n => n.Control_ListPhotoNewsBlock(201002, "ListPhotoNewsBlockForSidebar", string.Empty, 5)); %>
  </div>
    <div id="TagMapBlock">
    <%Html.RenderAction<ChannelNewsController>(n => n.Control_TagMapBlock(15)); %>
    </div>
</asp:content>
