﻿<%@ Page Language="C#" Inherits="SpaceBuilder.Web.ChannelViewPage<PagingDataSet<NewsThread>>" %>

<asp:content id="Content1" contentplaceholderid="subMenusContent" runat="server">
        <%Html.RenderAction<ChannelNewsController>(n => n.Control_SubMenus()); %>
</asp:content>
<asp:content contentplaceholderid="setPageID" runat="server">
    id="News-ListNewsForTag"
</asp:content>
<asp:content id="Content2" contentplaceholderid="mainContent" runat="server">
    <%NewsSection section = ViewData["section"] as NewsSection;
      int NewsApplicationID = ApplicationIDs.Instance().News(); %>
<div id="ListNewsForTag" class="tn-box tn-widget tn-widget-content tn-corner-all">
          <div class="tn-box-content tn-widget-content tn-corner-all"> 
                <div class="tn-list-header">
                <div id="NewsViewType" class="tn-list-header-row tn-helper-clearfix tn-border-gray tn-border-bottom">
                    <%=GetResourceString("Label_Display")%><%=GetResourceString("Common_Colon") %> 
                    <span id="headlines" class="tn-action">
                    <a class="tn-action-text" href="javascript:;"><%=GetResourceString("Label_Subject")%></a>
                    </span>
                    <span id="summaries" class="tn-action">
                    <a class="tn-action-text" href="javascript:;"><%=GetResourceString("Action_Summary",NewsApplicationID)%></a>
                    </span>
                    <span id="featureImg" class="tn-action">
                    <a class="tn-action-text" href="javascript:;"><%=GetResourceString("Action_PhotoView",NewsApplicationID)%></a>
                    </span>
                    </div>
                    </div>
                     <ul id="newsListUL" class="tn-list tn-helper-reset">
                        <%foreach (var thread in ViewData.Model.Records)
                          {%>      
                             <li class="tn-list-item tn-helper-clearfix tn-border-gray tn-border-bottom">
            <div class="tn-list-item-area-left img" style="display:none">
            <%if (thread.FeaturedImageAttachmentID > 0)
              {%><a href="<%=SiteUrls.Instance().ShowNews(thread.ThreadID) %>">
                                <img src="<%=SiteUrls.Instance().NewsPhotoUrl(thread.FeaturedImageAttachmentID, NewsPhotoTypes.Title) %>" /></a>
                                <%} %>
           </div>
            <div class="tn-list-item-area-main">
              <div class="tn-list-item-row tn-list-item-heading">
                <h5 class="tn-helper-reset"><a title="<%=thread.Title%>" href="<%=SiteUrls.Instance().ShowNews(thread.ThreadID) %>">
                                <%if (thread.FeaturedImageAttachmentID > 0) { Response.Write(StringUtils.Trim(thread.Title, 40)); } else { Response.Write(StringUtils.Trim(thread.Title, 48)); }  %></a>
                     <%if (thread.IsSticky)
                           SPBHtmlHelper.Instance().Icon(IconTypes.Top);
                       if (thread.IsEssential)
                           SPBHtmlHelper.Instance().Icon(IconTypes.Elite);
                                  %>
               
               <cite class="tn-text-note"><em class="tn-date"><%=Formatter.FormatDate(thread.PostDate)%></em></cite>  </h5></div>
              <div class="tn-list-item-row tn-list-item-summary summary">
                <p class="tn-helper-reset"><%if (string.IsNullOrEmpty(thread.Excerpt)) { Response.Write(HtmlUtils.TrimHtml(thread.ForcedExcerpt, 108)); } else { Response.Write(HtmlUtils.TrimHtml(thread.Excerpt, 108)); }%></p>
              </div>
            </div>
          </li>

                        <%}%>
                    </ul>
                <%if (ViewData.Model.TotalRecords > ViewData.Model.PageSize)
                  {%>
                <div class="tn-pagination tn-helper-align-center">
                        <%= SPBHtmlHelper.Instance().PagingButton(ViewData.Model.TotalRecords, ViewData.Model.PageSize, ViewData.Model.PageIndex, 7, SPBUrlHelper.Action("ListNewsForTag", "ChannelNews", new RouteValueDictionary { { "tagName", Html.GetParameterFromRouteDateOrQueryString("tagName") }, { "pageIndex", "{0}" } }))%>
                    
<div class="tn-page-results tn-text-note"><%=string.Format(GetResourceString("Label_Pattern_TotalRecords"), ViewData.Model.TotalRecords)%></div>
                </div>
                <%}%>
            </div>
    </div>
    <script type="text/javascript">
        $(document).ready(function() {        
           $("#headlines").click(function(){
           $('#newsListUL div.img').css('display','none');
                $('#newsListUL div.summary').css('display','none');
                 $('#NewsViewType span').removeClass('tn-selected');
                 $(this).addClass("tn-selected");
                ;$.cookie('ListNewsMode',1);
            });
            
            $("#summaries").click(function(){
            $('#newsListUL div.img').css('display','none');
                $('#newsListUL div.summary').css('display','block');
                $('#NewsViewType span').removeClass('tn-selected');
                 $(this).addClass("tn-selected");
                $.cookie('ListNewsMode',2);
            });
            
            $("#featureImg").click(function(){
            $('#newsListUL div.img').css('display','block');
                $('#newsListUL div.summary').css('display','block');
                $('#NewsViewType span').removeClass('tn-selected');
                 $(this).addClass("tn-selected");
                $.cookie('ListNewsMode',3);
            });
            
            <% int mode = 0;
            HttpCookie cookie = Request.Cookies["ListNewsMode"];
                   if (cookie != null)
                    {  
                     mode = Convert.ToInt32(cookie.Value);
                       if(mode == 1)
                        Response.Write("$('#headlines').click();");
                       else if(mode == 2)
                       Response.Write("$('#summaries').click();");
                       else
                        Response.Write("$('#featureImg').click();");
                        }
                   else
                       Response.Write("$('#featureImg').click();"); %>
            
        });
    </script>
</asp:content>
<asp:content id="Content3" contentplaceholderid="sidebarContent" runat="server">
    <div id="TagMapBlock">
    <%Html.RenderAction<ChannelNewsController>(n => n.Control_TagMapBlock(15)); %>
    </div>
     <div id="ListPhotoNewsBlock">
        <%Html.RenderAction<ChannelNewsController>(n => n.Control_ListPhotoNewsBlock(201002, "ListPhotoNewsBlockForSidebar", string.Empty, 5)); %>
  </div>
  <div id="ListNewsBlock">
  <%Html.RenderAction<ChannelNewsController>(n => n.Control_ListNewsBlock(Html.GetParameterFromRouteDateOrQueryString("sectionID", 0), NewThreadsSortBy.StageHitTimes, "ListNewsBlockForSidebar", "本周热门", 10)); %>
    </div>
</asp:content>
