﻿<%@ Page Language="C#" Inherits="SpaceBuilder.Web.ChannelViewPage<PagingDataSet<NewsThread>>" %>
<asp:content id="Content1" contentplaceholderid="subMenusContent" runat="server">
  <%Html.RenderAction<ChannelNewsController>(n => n.Control_SubMenus()); %>
</asp:content>

<asp:content contentplaceholderid="setPageID" runat="server"> id="News-ListPhotoNews" </asp:content>
<asp:content id="Content2" contentplaceholderid="mainContent" runat="server">
  <div id="ListPhotoNews" class="tn-box tn-widget tn-widget-content tn-corner-all spb-photo-news-main">
    <div class="tn-box-content tn-widget-content tn-corner-all">
      <ul class="tn-photo-list tn-widget tn-helper-clearfix">
        <%foreach (var phtotThread in ViewData.Model.Records)
            {%>
        <li class="tn-photo-item">
          <p class="tn-photo-wrap tn-widget-content tn-border-gray">
            <%if (phtotThread.FeaturedImageAttachmentID > 0)
              {%>
            <a href="<%=SiteUrls.Instance().ShowNews(phtotThread.ThreadID) %>"> <img src="<%=SiteUrls.Instance().NewsPhotoUrl(phtotThread.FeaturedImageAttachmentID, NewsPhotoTypes.Title) %>" /></a>
            <%} %>
          </p>
          <p class="tn-text-heading"> <a href="<%=SiteUrls.Instance().ShowNews(phtotThread.ThreadID) %>"> <%=StringUtils.Trim(phtotThread.Title, 8)%></a></p>
        </li>
        <%} %>
      </ul>
      <%if (ViewData.Model.TotalRecords > ViewData.Model.PageSize)
              {%>
      <div class="tn-pagination tn-helper-align-center"> <%= SPBHtmlHelper.Instance().PagingButton(ViewData.Model.TotalRecords, ViewData.Model.PageSize, ViewData.Model.PageIndex, 7, SPBUrlHelper.Action("ListPhotoNews", "ChannelNews", new RouteValueDictionary { { "pageIndex", "{0}" } }))%>
        <div class="tn-page-results tn-text-note"> <%=string.Format(GetResourceString("Label_Pattern_TotalRecords"), ViewData.Model.TotalRecords)%></div>
      </div>
      <%}%>
    </div>
  </div>
</asp:content>
<asp:content id="Content3" contentplaceholderid="sidebarContent" runat="server">
  <div id="ListNewsBlock">
    <%Html.RenderAction<ChannelNewsController>(n => n.Control_ListNewsBlock(Html.GetParameterFromRouteDateOrQueryString("sectionID", 0), NewThreadsSortBy.StageHitTimes, "ListNewsBlockForSidebar", "本周热门", 10)); %>
  </div>
  <%=SPBHtmlHelper.Instance().ShowAdvertisingInChannel("001002010003", new RouteValueDictionary { { "class", "spb-ad-side-bottom" } })%>
  <div id="ListCommentsBlock">
    <%Html.RenderAction<ChannelNewsController>(n => n.Control_ListNewsBlock(0, NewThreadsSortBy.StageCommentCount, "ListNewsBlockForSidebar", "本周热评", 10)); %>
  </div>
  <div id="TagMapBlock">
    <%Html.RenderAction<ChannelNewsController>(n => n.Control_TagMapBlock(15)); %>
  </div>
</asp:content>
