﻿<%@ Page Language="C#" Inherits="SpaceBuilder.Web.ChannelViewPage<SearchResultDataSet<NewsThread>>" %>
<asp:content id="Content2" contentplaceholderid="subMenusContent" runat="server">
  <%Html.RenderAction<ChannelNewsController>(n => n.Control_SubMenus()); %>
</asp:content>

<asp:content contentplaceholderid="setPageID" runat="server"> id="News-Search" </asp:content>
<asp:content id="Content1" contentplaceholderid="mainContent" runat="server">
  <%
      NewsThreadFullTextQuery query = ViewData.Get<NewsThreadFullTextQuery>("Query", null);
    %>
  <div id="NewsSearch" class="tn-box tn-widget tn-widget-content tn-corner-all spb-news-search">
    <div class="tn-box-content tn-widget-content tn-corner-all">
      <form method="post" id="searchForm">
        <div class="spb-search-results-box">
          <div class="tn-form tn-form-single">
            <input type="text" name="Keyword" id="Keyword" class="tn-textbox tn-border-gray" value="<% if (query!=null) Response.Write(query.Keyword); %>">
            <%=SPBHtmlHelper.Instance().SubmitButton("SearchButton",GetResourceString("Button_Search"))%> </div>
        </div>
      </form>
      <% if (ViewData.Model != null && !string.IsNullOrEmpty(query.Keyword))
                   {
                       if (ViewData.Model.TotalRecords == 0)
                       {%>
      <div class="tn-list-header">
        <%  Html.RenderPartial("Controls/Search/NoSearchResult.ascx");%>
      </div>
      <%}
                       else
                       { %>
      <div class="tn-list-header">
        <div class="tn-list-header-row tn-helper-clearfix tn-border-gray tn-border-bottom"><span class="tn-text-note"><%=string.Format(GetResourceString("Description_Pattern_SatisfySearchConditionAndTimeNews",ApplicationIDs.Instance().News()), ViewData.Model.TotalRecords, ViewData.Model.SearchDuration)%> </span></div>
      </div>
      <ul class="tn-list tn-helper-reset">
        <% foreach (var newsThread in ViewData.Model.Records)
                     {%>
        <li class="tn-list-item tn-helper-clearfix tn-border-gray tn-border-bottom">
          <div class="tn-list-item-area-main">
            <div class="tn-list-item-row tn-list-item-heading">
              <h5 class="tn-helper-reset"><a href="<%=Globals.GetFullUrlInMainSite(SPBUrlHelper.Action("ShowNews","ChannelNews",new RouteValueDictionary{{"newsID",newsThread.ThreadID}})) %>"
                            target="_blank"> <%=newsThread.Title %></a></h5>
            </div>
            <div class="tn-list-item-row"> <cite><a href="<%=SiteUrls.Instance().UserDomainHome(newsThread.UserID) %>" class="tn-author"><%=newsThread.Contributor %></a></cite> <em class="tn-date tn-text-note"> <%=GetResourceString("Label_Date") %><%=GetResourceString("Common_Colon") %><%=Formatter.FormatDate(newsThread.PostDate) %></em> </div>
            <div class="tn-list-item-row tn-list-item-summary">
              <p><%=newsThread.Summary %> </p>
            </div>
          </div>
        </li>
        <%}%>
      </ul>
      <div class="tn-pagination tn-helper-align-center"> <%= SPBHtmlHelper.Instance().PagingButton(PaginationMode.NumericNextPrevious, ViewData.Model.TotalRecords, ViewData.Model.PageSize, ViewData.Model.PageIndex)%> </div>
      <%} %>
      <%} %>
    </div>
  </div>
</asp:content>
<asp:content id="Content3" contentplaceholderid="sidebarContent" runat="server">
  <div id="ListCommendsBlock">
    <%Html.RenderAction<ChannelNewsController>(n => n.Control_ListCommendsBlock()); %>
  </div>
  <div id="ListPhotoNewsBlock">
    <%Html.RenderAction<ChannelNewsController>(n => n.Control_ListPhotoNewsBlock(201002, "ListPhotoNewsBlockForSidebar", string.Empty, 5)); %>
  </div>
  <div id="TagMapBlock">
    <%Html.RenderAction<ChannelNewsController>(n => n.Control_TagMapBlock(15)); %>
  </div>
</asp:content>
