﻿<%@ Page Language="C#" Inherits="SpaceBuilder.Web.ChannelViewPage<NewsThread>" %>

<asp:content contentplaceholderid="subMenusContent" runat="server">
  <%Html.RenderAction<ChannelNewsController>(n => n.Control_SubMenus()); %>
</asp:content>
<asp:content contentplaceholderid="setPageID" runat="server"> id="News-ShowNews" </asp:content>
<asp:content contentplaceholderid="mainContent" runat="server">
  <spb:Script runat="server" ID="jquery_ui_stars" Src="~/Utility/jquery/plugin/jquery.ui.stars-3.0.1.js" SetExpireDays="30" />
  <spb:Script runat="server" ID="jqueryForm" Src="~/Utility/jquery/plugin/jquery.form.min-2.7.3.js" SetExpireDays="30" />
  <spb:Script runat="server" ID="blockUI" Src="~/Utility/jquery/plugin/jquery.blockUI-2.3.3.js" SetExpireDays="30" />
  <spb:Script runat="server" ID="shCore" Src="~/Utility/syntaxhighlighter/scripts/shCore-2.0.296.js" SetExpireDays="30" />
  <spb:Script runat="server" ID="shLegacy" Src="~/Utility/syntaxhighlighter/scripts/shLegacy-2.0.296.js" SetExpireDays="30" />
  <spb:Script runat="server" ID="shBrushAllLanguage" Src="~/Utility/syntaxhighlighter/scripts/shBrushAllLanguage-2.0.296.js" SetExpireDays="30" />
  <spb:Script runat="server" ID="CollapsibleBox" Src="~/Utility/jquery/plugin/jquery.spb.CollapsibleBox.js" SetExpireDays="30" />
  <spb:Style runat="server" ID="shCore_css" Href="~/Utility/syntaxhighlighter/styles/shCore.css" />
  <spb:Style runat="server" ID="shThemeDefault_css" Href="~/Utility/syntaxhighlighter/styles/shThemeDefault.css" />
<%
    int newsApplicationID = ApplicationIDs.Instance().News();
    NewsThread thread = ViewData.Model;

    bool hasManagePermission = ViewData.GetBool("hasManagePermission", false);
    bool errorAuditingStatus = ViewData.GetBool("errorAuditingStatus", false);
    string blogThreadBody = ViewData.GetString("blogThreadBody", string.Empty);
    int totalPage = ViewData.GetInt("totalPage", 0);
    if (errorAuditingStatus)
    {
        string errorMessage = ViewData.GetString("errorMessage", string.Empty);%>
<div class="tn-widget">
    <div class="tn-cue-highlight tn-corner-all tn-message-box">
        <span class="tn-helper-left"><span class="tn-icon tn-icon-exclamation"></span></span>
        <div class="tn-helper-flowfix">
            <% Response.Write(errorMessage); %>
            <%
        if (CurrentUser != null && CurrentUser.IsAdministrator || CurrentUser != null && CurrentUser.IsContentAdministrator)
        {%>
            <%  int threadid = Model.ThreadID; %>
            ,<%=GetResourceString("Description_IsAdministrator", newsApplicationID)%><a title="<%=GetResourceString("Description_NewsPassAuditing",newsApplicationID) %>"
                id="SetIsPassButton" href="<%=SPBUrlHelper.Action("UpdateNewsShareThread","ChannelNews",new RouteValueDictionary{{"threadid",threadid}}) %>"><%=GetResourceString("Common_PassAudit")%></a>
            <%}
            %>
        </div>
    </div>
</div>
<div class="tn-blank10">
</div>
<% }
    if (!errorAuditingStatus || hasManagePermission)
    {%>
<div id="showNews" class="tn-box tn-widget tn-widget-content tn-corner-all tn-detail spb-show-news">
    <div class="tn-box-content tn-widget-content tn-corner-all">
        <div class="tn-text-heading">
            <h1 class="tn-title">
                <%if (!string.IsNullOrEmpty(thread.PrefixName)) Response.Write(string.Format("{0} - ", thread.PrefixName)); %>
                <%=thread.Title%>
                <%if (thread.IsSticky)
                  { %>
                <%=SPBHtmlHelper.Instance().Icon(IconTypes.Top, string.Empty, new RouteValueDictionary { { "class", "tn-icon-inline" } })%>
                <%} if (thread.IsEssential)
                  {%>
                <%=SPBHtmlHelper.Instance().Icon(IconTypes.Elite, string.Empty, new RouteValueDictionary { { "class", "tn-icon-inline" } })%>
                <%} %>
            </h1>
            <%if (!string.IsNullOrEmpty(thread.Subtitle))
              { %>
            <h4 class="tn-subtitle">
                <%=thread.Subtitle%></h4>
            <%}%>
        </div>
        <%if (CurrentUser != null)
          {%>
        
        <div class="tn-actions tn-helper-align-right">
        <% if (CurrentUser.UserID == thread.UserID || NewsPermission.Validate(thread, CurrentUser, PermissionItemKeys.Instance().EditNewsThread()))
           { %>
            <span class="tn-action">
            <a target="_blank" href="<%=SPBUrlHelper.Action("EditNews","News",new RouteValueDictionary{{"userDomainName",WebUtils.UrlEncode(CurrentUser.UserName)},{"newsID",thread.ThreadID}}) %>">
                <%=GetResourceString("Action_Edit")%></a> </span>
                <%} %>
            <% if (CurrentUser.UserID == thread.UserID || NewsPermission.Validate(thread, CurrentUser, PermissionItemKeys.Instance().EditNewsThread()))
               { %><span class="tn-action"><a onclick="if (!confirm('<%=GetResourceString("Message_ConfirmDeleteNews",newsApplicationID) %>')) return false;"
                    href="<%=SPBUrlHelper.Action("DeleteNews","ChannelNews",new RouteValueDictionary{{"newsID",thread.ThreadID}}) %>">
                    <%=GetResourceString("Action_Delete")%></a></span> 
                    <%} %>
                    <%if (CurrentUser.IsContentAdministrator)
                      {%>
                    <span class="tn-action"><a class="nyroModal"
                        href="<%=SiteUrls.Instance().RecommendItem(newsApplicationID, thread.UserID, thread.ThreadID, thread.Title)%>">
                        <%=GetResourceString("Common_ManagerRecommend")%></a> </span>
                       
                        <span class="tn-action">
                            <a href="javascript:;" id="setTop" onclick="topManage();">
                                <% if (thread.SpecialOrder > 0) Response.Write(GetResourceString("Common_CancelPutter")); else Response.Write(GetResourceString("Common_SetTop")); %>
                            </a></span>
                    <%} %>
            <input type="hidden" id="topHideInputStore" value="<%=thread.SpecialOrder %>" />
        </div>
        <%} %>
        <div class="tn-info-part tn-text-note tn-border-gray tn-border-top tn-detail-info">
            <dl>
                <dt>
                    <%=GetResourceString("Label_Copy", newsApplicationID)%><%=GetResourceString("Common_Colon") %>
                </dt>
                <dd>
                    <a target="_blank" href="<%=SiteUrls.Instance().UserChannelHome(thread.UserID, UserDomainSpecialAppIDs.Instance().Home()) %>">
                        <%=thread.Contributor%></a></dd>
            </dl>
            <dl>
                <dt>
                    <%=GetResourceString("Label_ReleaseTo", newsApplicationID)%><%=GetResourceString("Common_Colon") %></dt>
                <dd>
                    <%=Formatter.FormatDate(thread.PostDate, true)%></dd>
            </dl>
            <%if (!string.IsNullOrEmpty(thread.OriginalAuthor))
              {%>
            <dl>
                <dt>
                    <%=GetResourceString("Label_Author")%><%=GetResourceString("Common_Colon") %></dt>
                <dd>
                    <%=thread.OriginalAuthor%></dd>
            </dl>
            <%} %>
            <%if (!string.IsNullOrEmpty(thread.CopyFrom))
              {%>
            <dl>
                <dt>
                    <%=GetResourceString("Label_Source", newsApplicationID)%><%=GetResourceString("Common_Colon") %></dt>
                <dd>
                    <%=thread.CopyFrom%></dd>
            </dl>
            <%}
              if (!string.IsNullOrEmpty(thread.OriginalLinks))
              { %>
             <dl>
                <dt>
                   </dt>
                <dd>
                  <a href="<%=thread.OriginalLinks%>" class="tn-text-note" target="_blank" >原文链接</a></dd>
            </dl>
            
            <%}%>
        </div>
        <%if (!string.IsNullOrEmpty(thread.Excerpt))
          {%>
        <div class="tn-summaries tn-bg-gray tn-border-gray">
            <%=thread.Excerpt%>
        </div>
        <%} %>
        <div class="tn-detail-text">
            <% if (TempData["StatusMessageType"] != null)
               {%>
          
            <%StatusMessageType messageType = (StatusMessageType)TempData.GetInt("StatusMessageType", (int)StatusMessageType.Hint);
              if (messageType == StatusMessageType.Success)
              {
                  Response.Write(SPBHtmlHelper.Instance().StatusMessage(messageType, TempData.GetString("StatusMessageContent", string.Empty)));%>
            <% if(CurrentUser.UserID!=thread.UserID && thread.PointConsumption!=0)
               {%>
            <p>
                <a href="<%=SPBUrlHelper.Action("CutPoint","ChannelNews",new RouteValueDictionary{{"newsID",thread.ThreadID}}) %>">
                    <%=GetResourceString("Button_AgreeDeductIntegralRead", newsApplicationID)%></a></p><%} %>
            <%}
              else if (messageType == StatusMessageType.Hint)
              {
                  Response.Write(SPBHtmlHelper.Instance().StatusMessage(messageType, TempData.GetString("StatusMessageContent", GetResourceString("Message_Failed", newsApplicationID))));
              }
                Response.Write(blogThreadBody);
              TempData.Remove("StatusMessageType");
               }
               else
               {
                   Response.Write(SPBHtmlHelper.Instance().ShowAdvertisingInChannel("001002010005", new RouteValueDictionary { { "class", "spb-ad-cont-block" } }));

                    %>
            <%=blogThreadBody %>
            <%if (totalPage > 1)
              {%>
            <div class="tn-pagination tn-helper-align-center">
                <%= SPBHtmlHelper.Instance().ContentPagingButton(totalPage, Html.GetParameterFromRouteDateOrQueryString("cPageIndex", 1), 7, SPBUrlHelper.Action("ShowNews", "ChannelNews", new RouteValueDictionary { { "newsID", Model.ThreadID }, { "cPageIndex", "{0}" } }))%>
            </div>
            <%}%>
            <%List<Attachment> attList = ViewData.Get<List<Attachment>>("attachmentList");
              if (attList != null && attList.Exists(n => !n.IsImage))
              {%>
            <div class="tn-annex-fix">
                <div class="tn-text-heading tn-border-bottom tn-border-gray">
                    <h4>
                        <%=GetResourceString("Label_Attachment")%><%=GetResourceString("Common_Colon") %></h4>
                    <span class="tn-icon tn-icon-paper-clip"></span>
                </div>
                <ul class="tn-helper-reset tn-list tn-annex-list">
                    <%foreach (var attachment in attList)
                      {
                          if (attachment.IsImage) { continue; }%>
                    <li class="tn-annex-item"><span>
                        <%=SPBHtmlHelper.Instance().ContentTypeThumbnail(attachment.FileName, ContentTypeThumbnailSize.Small)%>
                        <a target="_blank" href="<%=SiteUrls.Instance().DownloadNewsAttachment(attachment.AttachmentID) %>">
                            <%=attachment.FriendlyFileName%></a></span> <em class="tn-count tn-text-note"">(<%=attachment.Friendlylength%>)</em>
                    </li>
                    <%}%>
                </ul>
            </div>
            <%}
               } %>
        </div>

         

        <%if (Model.Tags.Count > 0)
          {%>
        <div class="tn-info-part tn-tags">
            <dl>
                <dt>
                    <%=GetResourceString("Common_UserTag")%><%=GetResourceString("Common_Colon") %></dt>
                <%foreach (string tagName in Model.Tags)
                  {%>
                <dd>
                    <a href="<%=SiteUrls.Instance().ListNewsForTag(tagName) %>">
                        <%=tagName%></a></dd>
                <%} %>
            </dl>
        </div>
        <%}%>
        <div class="tn-feedback tn-helper-clearfix tn-border-gray tn-border-top ">
            <div class="tn-helper-right">
                <%=SPBHtmlHelper.Instance().LinkButton("impeachReportModal", GetResourceString("Button_Report"), SiteUrls.Instance().NewImpeachReport(), ButtonSizes.Default, HighlightStyles.Default, IconTypes.Alert, TextIconLayout.IconText)%>
                <%if (CurrentUser != null && NewsPermission.Validate(thread, CurrentUser, PermissionItemKeys.Instance().CreateNewsComment()) && thread.EnableComments)
                  {%>
                <%=SPBHtmlHelper.Instance().LinkButton("comment", GetResourceString("Common_Comment"), "#comments", ButtonSizes.Default, HighlightStyles.Default, IconTypes.Bubble, TextIconLayout.IconText)%>
                <%} if (CurrentUser != null)
                  {
                      string imgUrl = string.Empty;
                      if (Model.FeaturedImageAttachmentID > 0)
                          imgUrl = SiteUrls.Instance().NewsPhotoUrl(thread.FeaturedImageAttachmentID, NewsPhotoTypes.Title);

                      %>
                <%=SPBHtmlHelper.Instance().LinkButton("shareLink", GetResourceString("Button_Share", newsApplicationID), SiteUrls.Instance().ShareInModal(true, Request.RawUrl, thread.Title, HtmlUtils.TrimHtml(thread.GetBody(hasManagePermission), 140), imgUrl, newsApplicationID, thread.UserID, thread.Contributor), ButtonSizes.Default, HighlightStyles.Default, IconTypes.Share, TextIconLayout.IconText)%>
                <%}
        else
        { %>
                <%=SPBHtmlHelper.Instance().LinkButton("shareLink1", GetResourceString("Button_Share", newsApplicationID), SiteUrls.Instance().Login(true), ButtonSizes.Default, HighlightStyles.Default, IconTypes.Share, TextIconLayout.IconText)%>
                <%} %>
            </div>
            <div class="tn-info-part tn-text-note tn-helper-left">
                <dl>
                    <dt>
                        <%=GetResourceString("Label_ReadConsumeIntegral", newsApplicationID)%><%=GetResourceString("Common_Colon") %></dt>
                    <dd>
                        <%=thread.PointConsumption%></dd>
                </dl>
                <dl>
                    <dt>
                        <%=GetResourceString("Label_BrowseCount")%><%=GetResourceString("Common_Colon") %></dt>
                    <dd>
                        <%=thread.HitTimes%></dd>
                </dl>
                <dl>
                    <dt>
                        <%=GetResourceString("Label_CommentCount",newsApplicationID)%><%=GetResourceString("Common_Colon") %></dt>
                    <dd>
                        <%=thread.CommentCount%></dd>
                </dl>
            </div>
        </div>
        <div class="tn-rating">
            <div class="tn-rating-cont tn-helper-clearfix">
                <% if (CurrentUser == null)
                   { %>
                <%=SPBHtmlHelper.Instance().ShowRating(thread.RatingSum, thread.TotalRatings, true, true)%>
                <%}
                   else
                   { %>
                <%=SPBHtmlHelper.Instance().RatingButton(thread.ThreadID, "newsStarRating", thread.RatingSum, thread.TotalRatings, SPBUrlHelper.Action("Rate", "ChannelNews"), "ratingCallback()")%>
                <%} %>
            </div>
        </div>
        <div id="ListRatingUsers">
            <%
                   IList<Rating> ratings = ViewData.Get<IList<Rating>>("ratings");
                   if (ratings != null && ratings.Count > 0)
                   {%>
            <% Html.RenderAction<ChannelNewsController>(n => n.Control_ListRatingUsers(thread.ThreadID, 30)); %>
            <%} %>
        </div>
        <div id="correlativeDiv">
        </div>
        <%=SPBHtmlHelper.Instance().ShowAdvertisingInChannel("001002010004", new RouteValueDictionary { { "class", "spb-ad-detail" } })%>
        <div id="commentForLoadDiv">
            <% Html.RenderAction<ChannelNewsController>(n => n.Control_ListComments(Html.GetParameterFromRouteDateOrQueryString("newsID", 0), Html.GetParameterFromRouteDateOrQueryString("pageIndex", 1))); %>
        </div>
        <div class="tn-blank10">
        </div>
        <div class="tn-widget">
            <div class="tn-cue-tips tn-corner-all tn-message-box tn-widget-content tn-border-gray tn-bg-gray">
                <span class="tn-helper-left">
                    <%=SPBHtmlHelper.Instance().Icon(IconTypes.Exclamation) %></span>
                <div class="tn-helper-flowfix">
                    <strong>
                        <%=GetResourceString("Description_FriendlyHint",ApplicationIDs.Instance().News()) %></strong>
                    <%=GetResourceString("Description_NoCanOnloadTortiousBody", newsApplicationID)%></div>
            </div>
        </div>
    </div>
</div>

<script type="text/javascript">
    $(document).ready(function () {
        $(".tn-collapsible").collapsibleBox();

        $('#impeachReportModal').nyroModal({
            resizeable: true,
            width: 300,
            height: 300
        });

        $('#shareLink').nyroModal({
            resizeable: true,
            width: 500
        });

        $("#correlativeDiv").load('<%=SearchConfiguration.Instance().SearchTypeSettingss[NewsSearchTypeSettings.CODE].GetSearchAtionFullUrl(SPBUrlHelper.Action("Control_CorrelativeNewsThreads", "ChannelNews", new RouteValueDictionary { { "ThreadID", thread.ThreadID },{"title",WebUtils.UrlEncode(GetResourceString("Title_CorrelativeNews",newsApplicationID))} }))%>');
    });

    SyntaxHighlighter.defaults['toolbar'] = false;
    SyntaxHighlighter.all();

    function ratingCallback() {
        $("#ListRatingUsers").load('<%=SPBUrlHelper.Action("Control_ListRatingUsers","ChannelNews",new RouteValueDictionary{{"itemID",thread.ThreadID},{"topNumber",30}}) %>');
    }

    function topManage() {
        if (($('#topHideInputStore').val()) > 0) {
            $.get('<%=SPBUrlHelper.Action("SetSticky","ChannelNews",new RouteValueDictionary{{"threadID",thread.ThreadID},{"isSticky",false}}) %>', function (data) {
                $("#setTop").text('<%=GetResourceString("Common_SetTop")  %>');
                $("#stickyImg").hide();
                $('#topHideInputStore').val("0");
            });
        }
        else {
            $.get('<%=SPBUrlHelper.Action("SetSticky","ChannelNews",new RouteValueDictionary{{"threadID",thread.ThreadID},{"isSticky",true}}) %>', function (data) {
                $("#setTop").text('<%=GetResourceString("Common_CancelPutter")%>');
                if ($("#stickyImg").length > 0)
                    $("#stickyImg").show();
                else
                    $("#titleH1").prepend('<span id="stickyImg" class="icon topIco" title="<%=GetResourceString("Common_SetTop") %>"></span>');
                $('#topHideInputStore').val('1');
            });
        }
    }
</script>

<% }%>
</asp:content>
<asp:content contentplaceholderid="sidebarContent" runat="server">
  <div id="ListPhotoNewsBlock">
        <%Html.RenderAction<ChannelNewsController>(n => n.Control_ListPhotoNewsBlock(201002, "ListPhotoNewsBlockForSidebar", string.Empty, 5)); %>
  </div>
  <div id="ListNewsBlock">
  <%Html.RenderAction<ChannelNewsController>(n => n.Control_ListNewsBlock(Html.GetParameterFromRouteDateOrQueryString("sectionID", 0), NewThreadsSortBy.StageHitTimes, "ListNewsBlockForSidebar", "本周热门", 10)); %>
    </div>
  <%=SPBHtmlHelper.Instance().ShowAdvertisingInChannel("001002010003", new RouteValueDictionary { { "class", "spb-ad-side-bottom" } })%>
  <div id="ListCommentsBlock">
            <%Html.RenderAction<ChannelNewsController>(n => n.Control_ListNewsBlock(0, NewThreadsSortBy.StageCommentCount, "ListNewsBlockForSidebar", "本周热评", 10)); %>
  </div>
  <div id="TagMapBlock">
    <%Html.RenderAction<ChannelNewsController>(n => n.Control_TagMapBlock(15)); %>
  </div>
</asp:content>
