﻿<%@ Page Language="C#" Inherits="SpaceBuilder.Web.ChannelViewPage<Dictionary<string, KeyValuePair<int, ApplicationTag>>>" %>

<asp:content id="Content1" contentplaceholderid="subMenusContent" runat="server">
        <%Html.RenderAction<ChannelNewsController>(n => n.Control_SubMenus()); %>
</asp:content>
<asp:content contentplaceholderid="setPageID" runat="server">
    id="News-TagMap"
</asp:content>
<asp:content contentplaceholderid="mainContent" runat="server">
    <div id="NewsTagMap" class="tn-box tn-widget tn-widget-content tn-corner-all">
        
          <div class="tn-box-content tn-widget-content tn-corner-bottom">
            <p class="tn-tags-cloud">
                <% 
                    if (Model != null && Model.Count > 0)
                    {
                        foreach (var pair in Model)
                        {                        
                            %>
                           <span class="tn-font-size-<%=pair.Value.Key %>">
                           <a title="<%=string.Format(GetResourceString("Description_Pattern_LocalLabelNews", ApplicationIDs.Instance().News()), pair.Value.Value.ItemCount)%>"
                    href="<%=Globals.GetFullUrlInMainSite(SiteUrls.Instance().ListNewsForTag(pair.Key))%>">
                    <%=pair.Key %></a>
             <%--<em class="tn-text-note">(<%=siteTag.ItemCount %>)</em>--%>
                </span>
                <% }
                    } %>
            </p>
          </div>
        </div>

    <script runat="server">
    
        private int tagHotMapLevel(int row)
        {
            if (row == 1)
                return 10;
            else if (row >= 2 && row <= 6)
                return 9;
            else if (row >= 7 && row <= 15)
                return 8;
            else if (row >= 16 && row <= 29)
                return 7;
            else if (row >= 30 && row <= 47)
                return 6;
            else if (row >= 48 && row <= 69)
                return 5;
            else if (row >= 70 && row <= 95)
                return 4;
            else if (row >= 96 && row <= 125)
                return 3;
            else if (row >= 126 && row <= 160)
                return 2;
            else
                return 1;
        }
        
    </script>

</asp:content>
<asp:content contentplaceholderid="sidebarContent" runat="server">
      <div id="ListNewsBlock">
  <%Html.RenderAction<ChannelNewsController>(n => n.Control_ListNewsBlock(Html.GetParameterFromRouteDateOrQueryString("sectionID", 0), NewThreadsSortBy.StageHitTimes, "ListNewsBlockForSidebar", "本周热门", 10)); %>
    </div>
     <div id="ListPhotoNewsBlock">
        <%Html.RenderAction<ChannelNewsController>(n => n.Control_ListPhotoNewsBlock(201002, "ListPhotoNewsBlockForSidebar", string.Empty, 5)); %>
  </div>
    <div id="ListCommendsBlock">
    <%Html.RenderAction<ChannelNewsController>(n => n.Control_ListCommendsBlock()); %>
    </div>
</asp:content>
