﻿<%@ Page Language="C#" Inherits="SpaceBuilder.Web.ChannelViewPage<SearchResultDataSet<PhotoThread>>" %>

<asp:content id="Content1" contentplaceholderid="subMenusContent" runat="server">
    <%Html.RenderAction<ChannelPhotoController>(n => n.Control_SubMenus()); %>
</asp:content>
<asp:content contentplaceholderid="setPageID" runat="server">
    id="Photo-Search"
</asp:content>
<asp:content id="mainContent" contentplaceholderid="mainContent" runat="server">
    <%
        PhotoFullTextQuery query = ViewData.Get<PhotoFullTextQuery>("Query", null);
    %>
    <div id="PhotoSearch" class="tn-box tn-widget tn-widget-content tn-corner-all spb-photos-main spb-photos-search-results">
              <div class="tn-box-content tn-widget-content tn-corner-all">
                <form method="post" id="searchForm">
                <div class="spb-search-results-box">
                  <div class="tn-form tn-form-single">
                    <input type="text" name="Keyword" id="Keyword" class="tn-textbox tn-input-longest tn-border-gray" value="<% if (query!=null) Response.Write(query.Keyword); %>">
                    <%=SPBHtmlHelper.Instance().SubmitButton("SearchButton",GetResourceString("Button_Search"))%> </div>
                  <%
                      if (Request.IsAuthenticated)
                      {
                          
                %>
                  <div class="spb-search-results-select">
                    <input type="radio" name="SearchScopeUserID" id="SearchScopeUserID_all" value="-1" class="tn-radiobutton" <%if(query == null || query.SearchScopeUserID <= 0){Response.Write("checked=\"checked\"");} %>>
                    <label for="SearchScopeUserID_all"><%=GetResourceString("Label_SearchAllImage",ApplicationIDs.Instance().Photo())%></label>
                    <input type="radio" <% if (query != null && query.SearchScopeUserID == (CurrentUser != null ? CurrentUser.UserID : 0)) Response.Write("checked=\"checked\""); %> id="SearchScopeUserID_my" name="SearchScopeUserID" value="<%=CurrentUser != null ? CurrentUser.UserID : 0 %>" class="tn-radiobutton">
                    <label for="SearchScopeUserID_my"><%=GetResourceString("Label_SearchMyImage", ApplicationIDs.Instance().Photo())%></label>
                    <%
                        if (CurrentUser != null && query != null && query.SearchScopeUserID > 0 && query.SearchScopeUserID != CurrentUser.UserID)
                        {
                            User searchScopeUser = Users.GetUser(query.SearchScopeUserID, false);
                %>
                    <input type="radio" checked="checked" id="SearchScopeUserID_other" name="SearchScopeUserID" value="<%=searchScopeUser.UserID %>" class="tn-radiobutton">
                    <label for="SearchScopeUserID_other"><%=string.Format(GetResourceString("Label_SearchImage", ApplicationIDs.Instance().Photo()), SPBHtmlHelper.Instance().UserDisplayName(searchScopeUser))%></label>
                    <%} %>
                  </div>
                  <%
                      }
                %>
                </div>
                </form>
                <% if (ViewData.Model != null && !string.IsNullOrEmpty(query.Keyword))
                   {
                       if (ViewData.Model.TotalRecords == 0)
                       {%>
                   <div class="tn-list-header">
                     <%  Html.RenderPartial("Controls/Search/NoSearchResult.ascx");%>
                     </div>
                   <%}
                       else
                       { %>
                <div class="tn-list-header">
                  <div class="tn-list-header-row tn-helper-clearfix tn-border-gray tn-border-bottom"><span class="tn-text-note"><%=string.Format(GetResourceString("Dscription_PhotoEnoughCondition",ApplicationIDs.Instance().Photo()), ViewData.Model.TotalRecords,  ViewData.Model.SearchDuration)%> </span> </div>
                </div>
                <ul class="tn-photo-list tn-widget tn-helper-reset tn-helper-clearfix">
                  <% foreach (var photo in ViewData.Model.Records)
                     {
                %>
               <li class="tn-photo-item">
                    <p class="tn-photo-wrap tn-widget-content tn-border-gray">
                        <%=SPBHtmlHelper.Instance().ShowPicture(photo, PhotoImageType.Thumbnail, SPBUrlHelper.Action("ShowPhoto", "Photo", new RouteValueDictionary { { "userDomainName", UserID2UserNameDictionary.GetUserName(photo.OwnerUserID) }, { "threadID", photo.ThreadID } }), "_self")%>
                    </p>
                    <p class="tn-text-heading">
                        <a href="<%=Globals.GetFullUrlInMainSite(SPBUrlHelper.Action("ShowPhoto","Photo",new RouteValueDictionary{{"userDomainName",UserID2UserNameDictionary.GetUserName(photo.OwnerUserID)},{"threadID",photo.ThreadID}})) %>">
                               <%=photo.Subject%></a></p>
                    <p class="tn-text-note tn-count">
                      <%=GetResourceString("Label_FromTo",ApplicationIDs.Instance().Photo())%><%=GetResourceString("Common_Colon") %>
                              <%=SPBHtmlHelper.Instance().UserDisplayNameLink(photo.OwnerUserID,photo.Author,ApplicationIDs.Instance().Photo()) %>
                    </p>
               </li>
                  <%	} %>
                </ul>
                <div class="tn-pagination tn-helper-align-center">
                    <%= SPBHtmlHelper.Instance().PagingButton(PaginationMode.NumericNextPrevious, ViewData.Model.TotalRecords, ViewData.Model.PageSize, ViewData.Model.PageIndex)%>
                </div>
                <%} %>
            <%} %>
              </div>
            </div>
</asp:content>
<asp:content id="sidebarContent" contentplaceholderid="sidebarContent" runat="server">
    <div id="ListGalleriesBlock">
    <% Html.RenderAction<ChannelPhotoController>(n => n.Control_ListGalleriesBlock(UserCategorySortBy.PhotoCount, "ListGalleriesBlockForSidebar", GetResourceString("Title_CalleryRank", ApplicationIDs.Instance().Photo()), 4)); %>
    </div>
    <div id="ListSiteTagsBlock">
    <% Html.RenderAction<ChannelPhotoController>(n => n.Control_ListSiteTagsBlock(20, SiteTagsSortBy.ItemCount, GetResourceString("Title_HotTag"))); %>
    </div>
</asp:content>
