﻿<%@ Page Language="C#" Inherits="SpaceBuilder.Web.ChannelViewPage" %>

<asp:content contentplaceholderid="setPageID" runat="server"> id="Share-Home" </asp:content>
<asp:content id="subMenusContent" contentplaceholderid="subMenusContent" runat="server">
  <% 
      Html.RenderAction<ChannelShareController>(n => n.Control_SubMenus(null, ShareChannelSubMenu.home));%>
</asp:content>
<asp:content id="templateContentRegion" contentplaceholderid="templateContentRegion"
    runat="server"></asp:content>
<asp:content id="wideContentRegion" contentplaceholderid="wideContentRegion" runat="server"> <%=SPBHtmlHelper.Instance().ShowAdvertisingInChannel("001000000001", new RouteValueDictionary { { "class", "spb-ad-banner" } })%>
  <div class="tn-grid-3-13">
    <div class="tn-unit tn-first">
      <div id="CategoriesNavigation">
        <%List<SiteCategory> siteCategories = ViewData["siteCategories"] as List<SiteCategory>;
      if (siteCategories != null)
      {%>
        <div class="tn-box tn-widget tn-widget-content tn-corner-all">
          <div class="tn-box-header tn-widget-header tn-corner-top tn-border-bottom">
            <h3 class="tn-helper-reset"> <%=GetResourceString("Title_CategoriesNavigation",ApplicationIDs.Instance().Share()) %></h3>
          </div>
          <div class="tn-box-content tn-widget-content tn-corner-bottom">
            <div class="tn-directory">
              <%foreach (SiteCategory parentCategory in siteCategories)
            { %>
              <%if (parentCategory.ChildCount > 0)
            {%>
              <h5 class="tn-directory-path"> <%=parentCategory.CategoryName%></h5>
              <%}
            else
            { %>
              <h5 class="tn-directory-path"> <a href="<%=SPBUrlHelper.Action("ListShareThreadsByCategories", "ChannelShare", new RouteValueDictionary {{ "categoryID", parentCategory.CategoryID }})%>"> <%=parentCategory.CategoryName%></a></h5>
              <%} %>
              <%if (parentCategory.Childs != null && parentCategory.Childs.Count > 0)
            { %>
              <div class="tn-directory-level">
                <% int i = 1;
               foreach (SiteCategory category in parentCategory.Childs)
               {
                   if (i > 2) break; %>
                <span class="tn-directory-item"><a href="<%=SPBUrlHelper.Action("ListShareThreadsByCategories", "ChannelShare", new RouteValueDictionary {{ "categoryID", category.CategoryID }})%>"> <%=category.CategoryName %></a> <em class="tn-text-note"><%=category.ChildCount %></em></span>
                <%i++;
                                           } %>
                <span class="tn-directory-item"><a href="<%=SPBUrlHelper.Action("ListShareThreadsByCategories", "ChannelShare", new RouteValueDictionary {{ "categoryID", parentCategory.CategoryID }})%>"> <%=GetResourceString("Action_More") %></a></span> </div>
              <%}
                                      }%>
            </div>
          </div>
        </div>
        <%} %>
      </div>
    </div>
    <div class="tn-grid-9-4">
      <div class="tn-unit tn-first">
        <div id="ListVideoShareThreadsBlock">
          <%Html.RenderAction("Control_ListVideoShareBlock", "ChannelShare", new RouteValueDictionary { { "mediaType", MediaTypes.Video }, { "sortBy", ShareThreadSortBy.StageUserCount }, { "displayCount", 6 }, { "moduleTitle", GetResourceString("Title_PopMediaShare", ApplicationIDs.Instance().Share()) } });%>
        </div>
        <div id="ListMusicShareThreadsBlock">
          <%Html.RenderAction("Control_ListMusicShareThreadsBlock", "ChannelShare", new RouteValueDictionary { { "mediaType", MediaTypes.Music }, { "sortBy", ShareThreadSortBy.StageUserCount }, { "displayCount", 8 }, { "hasBorder", true }, { "moduleTitle", GetResourceString("Title_PopMusicShare", ApplicationIDs.Instance().Share()) } });%>
        </div>
        <div id="ListStickyShareThreadsBlock">
          <%Html.RenderAction("Control_ListStickyShareThreadsBlock", "ChannelShare", new RouteValueDictionary { { "mediaType", MediaTypes.Website }, { "applicationID", 0 }, { "sortBy", ShareThreadSortBy.StageUserCount }, { "displayCount", 8 }, { "hasBorder", true }, { "moduleTitle", GetResourceString("Title_PopLinkShare", ApplicationIDs.Instance().Share()) } });%>
        </div>
      </div>
      <div class="tn-unit">
        <% Html.RenderAction<ChannelShareController>(n => n.Control_SiteShareTagsBlock(50, SiteTagsSortBy.ItemCount)); %>
        <div class="tn-box tn-widget tn-widget-content tn-corner-all spb-share-help">
          <div class="tn-box-header tn-widget-header tn-corner-top tn-border-bottom">
            <h3 class="tn-helper-reset"> <%=GetResourceString("Title_InstallSharePinouts", ApplicationIDs.Instance().Share())%></h3>
          </div>
          <div class="tn-box-content tn-widget-content tn-corner-bottom">
            <ul class="tn-list">
              <li> <%=GetResourceString("Description_BeatIE", ApplicationIDs.Instance().Share())%><a target="_blank" href="<%=WebUtils.ResolveUrl("~/Services/Share/Key-It-ForIE.reg")%>"><%=GetResourceString("Action_InstallIEPinouts", ApplicationIDs.Instance().Share())%></a><%=GetResourceString("Description_InstallIEPinouts", ApplicationIDs.Instance().Share())%><a target="_blank" href="<%=WebUtils.ResolveUrl("~/Services/Share/Remove-Key-It-ForIE.reg")%>"><%=GetResourceString("Action_UninstallIEPinouts", ApplicationIDs.Instance().Share())%></a><%=GetResourceString("Description_UninstallIEPinouts", ApplicationIDs.Instance().Share())%> </li>
              <li> <%=GetResourceString("Description_BeatFirefox", ApplicationIDs.Instance().Share())%><a href="javascript:void(InstallTrigger.install({'<%=GetResourceString("Description_InstallSpbPlug",ApplicationIDs.Instance().Share())%>':'<%=WebUtils.ResolveUrl("~/Services/Share/share.xpi")%>'}))"><%=GetResourceString("Action_InstallFirefoxPinouts", ApplicationIDs.Instance().Share())%></a><%=GetResourceString("Description_UninstallFirefoxPinouts", ApplicationIDs.Instance().Share())%> </li>
              <li> <%=GetResourceString("Description_PleasePutLink", ApplicationIDs.Instance().Share())%><a href="javascript:var d=document;var exc=d.selection?(d.selection.type!='None'?d.selection.createRange().text:''):(d.getSelection?d.getSelection():'');var url = document.location.href;var title = document.title;void(ToMyFavorite=window.open('<%=WebUtils.FullPath(SiteUrls.Instance().ShareDialog()) %>?subject=' + escape(title) + '&Url=' + escape(url) + '&body=' + escape(exc), '_blank', 'scrollbars=auto,width=925,height=650,left=75,top=20,status=no,resizable=yes,alwaysRaised=yes,dialog=window'));ToMyFavorite.focus();" title="<%=GetResourceString("Description_CollectionYourShare", ApplicationIDs.Instance().Share())%>"><%=string.Format( GetResourceString("Action_Pattern_ShareTo", ApplicationIDs.Instance().Share()),Globals.SiteName)%></a> <%=GetResourceString("Description_UseInTag", ApplicationIDs.Instance().Share())%> </li>
            </ul>
            <p class="tn-more"><a target="_blank" href="<%=WebUtils.ResolveUrl("~/Help/share/share.html") %>"><%=GetResourceString("Action_CheckExplain", ApplicationIDs.Instance().Share())%></a> </p>
          </div>
        </div>
        <div class="tn-blank10"> </div>
      </div>
    </div>
  </div>
  <%=SPBHtmlHelper.Instance().ShowAdvertisingInChannel("001000000002", new RouteValueDictionary { { "class", "spb-ad-banner-bottom" } })%> </asp:content>
