﻿<%@ Page Language="C#" Inherits="SpaceBuilder.Web.ChannelViewPage<List<SiteCategory>>" %>

<asp:content contentplaceholderid="setPageID" runat="server">
    id="Share-ListShareByCategories"
</asp:content>
<asp:content runat="server" contentplaceholderid="subMenusContent">
<% Html.RenderAction<ChannelShareController>(n => n.Control_SubMenus(null, null)); %>
</asp:content>
<asp:content runat="server" contentplaceholderid="mainContent">
  <%
      int? mediaType = Html.GetParameterFromRouteDateOrQueryString<int>("mediaType");
      int? applicationID = Html.GetParameterFromRouteDateOrQueryString<int>("applicationID");
      int sortBy = Html.GetParameterFromRouteDateOrQueryString("sortBy", (int)ShareThreadSortBy.DateCreated);
      Stack<SiteCategory> categoryStack = ViewData.Get<Stack<SiteCategory>>("categoryStack", new Stack<SiteCategory>());
      SiteCategory currentCategory = ViewData["CurrentCategory"] as SiteCategory;
      if (currentCategory == null)
          currentCategory = new SiteCategory();
      %>
 
<div class="tn-box tn-widget tn-widget-content tn-corner-all" id="SreachConditions">
  <div class="tn-box-content tn-widget-content tn-corner-all">
  <%if (Model != null)
    { %>
    <div class="tn-directory">
      <h5 class="tn-directory-path">
           <% if (categoryStack != null && categoryStack.Count > 0)
              {%>
             <a href="<%=SPBUrlHelper.Action("ListShareThreadsByCategories", "ChannelShare", new RouteValueDictionary {{ "mediaType", mediaType }, { "applicationID", applicationID }, { "sortBy", sortBy }})%>"><%=GetResourceString("Action_AllCategories",ApplicationIDs.Instance().Share())%></a>
          <%}
              else
              {
                  Response.Write(GetResourceString("Action_AllCategories", ApplicationIDs.Instance().Share()) + GetResourceString("Common_Colon"));
              }%> 
               
          <%SiteCategory category = new SiteCategory();
            while (categoryStack.Count > 0)
            {
                category = categoryStack.Pop();
                Response.Write(string.Format("&gt;<a href=\"{1}\">{0}</a>", category.CategoryName, SPBUrlHelper.Action("ListShareThreadsByCategories", "ChannelShare", new RouteValueDictionary { { "categoryID", currentCategory.CategoryID }, { "mediaType", mediaType }, { "applicationID", applicationID }, { "sortBy", sortBy } })));
            } %>
      </h5>
          
      <div class="tn-directory-level tn-border-gray tn-border-bottom">
      
        <span class="tn-directory-item  <%if (category.CategoryID==currentCategory.CategoryID) Response.Write("tn-text-note tn-selected");%>"><a href="<%=SPBUrlHelper.Action("ListShareThreadsByCategories", "ChannelShare", new RouteValueDictionary { { "categoryID",category.CategoryID  }, { "mediaType", mediaType }, { "applicationID", applicationID }, { "sortBy", sortBy } })%>"><%=GetResourceString("Action_Nolimit",ApplicationIDs.Instance().Share())%></a></span>
      <%foreach (SiteCategory childcategory in Model)
        { %>
        <%if (childcategory.CategoryID != currentCategory.CategoryID)
          {%>
      <span class="tn-directory-item"><a href="<%=SPBUrlHelper.Action("ListShareThreadsByCategories", "ChannelShare", new RouteValueDictionary { { "categoryID", childcategory.CategoryID }, { "mediaType", mediaType }, { "applicationID", applicationID }, { "sortBy", sortBy } })%>"><%=childcategory.CategoryName%></a> <em class="tn-text-note"><%=childcategory.CumulateItemCount%></em></span>
      <%}
          else
          { %>
          <span class="tn-directory-item tn-text-note tn-selected"><strong class="tn-text-note"><%=childcategory.CategoryName%></strong> <em class="tn-text-note"><%=childcategory.CumulateItemCount%></em></span>
          <%} %>
      <%} %>
      </div>
      <h5 class="tn-directory-path"><%=GetResourceString("Title_ShareType",ApplicationIDs.Instance().Share())%><%=GetResourceString("Common_Colon") %></h5>
      <div class="tn-directory-level tn-border-gray tn-border-bottom">
       <%if ((mediaType.HasValue && mediaType.Value > 0) || (applicationID.HasValue && applicationID.Value > 0))
         { %>
          <span class="tn-directory-item">
            <a href="<%=SPBUrlHelper.Action("ListShareThreadsByCategories", "ChannelShare", new RouteValueDictionary { { "categoryID", currentCategory.CategoryID},{ "sortBy", sortBy } })%>">
             <%=GetResourceString("Title_All",ApplicationIDs.Instance().Share())%>
          </a>
          </span>
      <%}
         else
         {%>
         <span class="tn-directory-item tn-text-note tn-selected"><strong class="tn-text-note"><%=GetResourceString("Title_All",ApplicationIDs.Instance().Share())%></strong></span>
         <%} %>
       <%foreach (int type in UrlParserFactory.Instance().UrlMediaTypes.Keys)
         {%>
        <%if (type != mediaType.Value)
          {%>
      <span class="tn-directory-item">
        <a href="<%=SPBUrlHelper.Action("ListShareThreadsByCategories", "ChannelShare", new RouteValueDictionary { { "categoryID", currentCategory.CategoryID}, { "mediaType", type }, { "sortBy", sortBy } })%>">
        <%=UrlParserFactory.Instance().GetMultilingualMediaTypeName(type, CurrentUserLanguage)%>
        </a>
      </span>
      <%}
          else
          { %>
          <span class="tn-directory-item tn-text-note tn-selected"><strong class="tn-text-note"><%=UrlParserFactory.Instance().GetMultilingualMediaTypeName(type, CurrentUserLanguage)%></strong> </span>
          <%} %>
       <%} %>
    <% foreach (int appID in ShareConfiguration.Instance().EnabledSharedApplicationIDs)
       {
           Application application = Applications.GetApplication(appID);
           if (application == null)
               continue;%>
       <%if (appID != applicationID)
         {%>
      <span class="tn-directory-item">
        <a href="<%=SPBUrlHelper.Action("ListShareThreadsByCategories", "ChannelShare", new RouteValueDictionary { { "categoryID", currentCategory.CategoryID}, { "applicationID", appID }, { "sortBy", sortBy } })%>">
         <%=application.GetMultilingualApplicationName(CurrentUserLanguage)%>
      </a>
      </span>
      <%}
         else
         { %>
          <span class="tn-directory-item tn-text-note tn-selected"><strong class="tn-text-note"><%=application.GetMultilingualApplicationName(CurrentUserLanguage)%></strong> </span>
          <%}
       } %>
    </div>
  </div>
    <%}
    else
    { %>
    <div class="tn-directory-result"><%=GetResourceString("Message_NoHaveSiteCategories",ApplicationIDs.Instance().Share())%></div>
    <%} %>
  </div>
</div>
 <div class="tn-blank10">
</div>
<div class="spb-share-list ui-tabs ui-widget ui-widget-content ui-corner-all" id="ListShareByCategories"> 
    <ul class="ui-tabs-nav ui-helper-reset ui-helper-clearfix ui-widget-header ui-corner-all">
      <li class="ui-state-default ui-corner-top"><a href="#ShareThreads"> <span><%=GetResourceString("Action_FreshShare", ApplicationIDs.Instance().Share())%></span></a></li>
      <li class="ui-state-default ui-corner-top"><a href="<%=SPBUrlHelper.Action("Control_ListShareThreads", "ChannelShare", new RouteValueDictionary{{"siteCategoryID",currentCategory.CategoryID},{"mediaType",mediaType},{"applicationID",applicationID},{"sortBy",ShareThreadSortBy.StageUserCount}})%>"> <span><%=GetResourceString("Action_MostShare", ApplicationIDs.Instance().Share())%></span></a></li>
      <% if (!applicationID.HasValue || applicationID.Value <= 0)
         { %>
      <li class="ui-state-default ui-corner-top"> <a href="<%=SPBUrlHelper.Action("Control_ListShareThreads", "ChannelShare", new RouteValueDictionary{{"siteCategoryID",currentCategory.CategoryID},{"mediaType",mediaType},{"applicationID",applicationID},{"sortBy",ShareThreadSortBy.StageHitTimes}})%>"> <span><%=GetResourceString("Action_BrowseMost", ApplicationIDs.Instance().Share())%></span></a></li>
      <li class="ui-state-default ui-corner-top"> <a href="<%=SPBUrlHelper.Action("Control_ListShareThreads", "ChannelShare", new RouteValueDictionary{{"siteCategoryID",currentCategory.CategoryID},{"mediaType",mediaType},{"applicationID",applicationID},{"sortBy",ShareThreadSortBy.CommentCount}})%>"> <span><%=GetResourceString("Title_CommentMost") %></span></a></li>
      <%}%>
    </ul>
    <div id="ShareThreads" class="ui-tabs-panel ui-widget-content ui-corner-bottom ui-tabs-hide">
      <%Html.RenderAction<ChannelShareController>(n => n.Control_ListShareThreads(currentCategory.CategoryID, (MediaTypes)mediaType, applicationID, string.Empty, ShareThreadSortBy.DateCreated, Request.QueryString.GetInt("pageIndex", 1))); %>
    </div>
 </div>
  <script type="text/javascript">
     $(document).ready(function() {
         $(".ui-tabs").tabs({selected:<%=sortBy %>});
     });
 </script>
</asp:content>
<asp:content contentplaceholderid="sidebarContent" runat="server">
  <% Html.RenderAction<ChannelShareController>(n => n.Control_SiteShareTagsBlock(50, SiteTagsSortBy.ItemCount)); %>
</asp:content>
