﻿<%@ Page Language="C#" Inherits="SpaceBuilder.Web.ChannelViewPage<SearchResultDataSet<ShareThread>>" %>

<asp:content contentplaceholderid="setPageID" runat="server">
    id="ChannelPageListShareByTags"
</asp:content>
<asp:content runat="server" contentplaceholderid="subMenusContent">
<% Html.RenderAction<ChannelShareController>(n => n.Control_SubMenus(null,null)); %>
</asp:content>
<asp:content runat="server" contentplaceholderid="mainContent">
<div class="spb-share-list tn-box tn-widget tn-widget-content tn-corner-all">
    <div class="tn-box-content tn-widget-content tn-corner-all"> 
         <%if (Request.IsAuthenticated)
           {

               ShareSearchQuery query = (ShareSearchQuery)ViewData["ShareSearchQuery"];
        %>
        <form id="searchForm" method="post" action="<%=SPBUrlHelper.Action("Search","ChannelShare") %>">
            <div class="spb-search-results-box">
              <div class="tn-form tn-form-single">
                <input type="text" value="<%=query!=null?query.KeyWord:string.Empty%>" class="tn-textbox tn-input-longest tn-border-gray" id="keyword" name="keyword"/>
                <%=SPBHtmlHelper.Instance().SubmitButton("SearchButton",GetResourceString("Button_Search"))%>
            </div>
            </div>
        </form> 
        <%}
           if (ViewData.Model != null)
           {
               if (ViewData.Model.TotalRecords == 0)
               {%>
                   <div class="tn-list-header">
                     <%  Html.RenderPartial("Controls/Search/NoSearchResult.ascx");%>
                     </div>
         <%}
               else
               {%>
        <div id="ShareThreads">
        <div class="tn-list-header">
            <div class="tn-list-header-row tn-helper-clearfix tn-border-gray tn-border-bottom">
                <span class="tn-text-note">
                    <%=string.Format(GetResourceString("Dscription_ShareEnoughCondition", ApplicationIDs.Instance().Share()), Model.TotalRecords, Model.SearchDuration)%>
                </span>
            </div>
        </div>
        <ul class="tn-list tn-helper-reset">
            <%Dictionary<int, Application> applications = Applications.GetApplications();
              foreach (ShareThread thread in Model.Records)
              {
                  string shareThreadUrl = string.Empty;
                  if (thread.ApplicationID > 0)
                      shareThreadUrl = thread.URL;
                  else if (thread.MediaType > 0)
                      shareThreadUrl = SiteUrls.Instance().ShowShareThread(thread.ThreadID);
                  string shareIconPath = string.Empty;
                  if (thread.ApplicationID > 0 && applications.ContainsKey(thread.ApplicationID))
                      shareIconPath = Globals.GetFullUrlInResourceSite(string.Format("~/Themes/Shared/Styles/ApplicationIcons/{0}.png", applications[thread.ApplicationID].ApplicationKey));

                  string bgImage = "background: url(&quot;" + thread.ThumbnailUrl + "&quot;) repeat scroll center center transparent;";
                  string noBgImage = "background: url(&quot;images/movie.jpg&quot;) repeat scroll center center transparent;";
            %>
            <li class="tn-list-item tn-helper-clearfix tn-border-gray tn-border-bottom">
                <div class="tn-list-item-row">
                    <h5 class="tn-helper-reset">
                <%if ((int)thread.MediaType > 0)
                  {
                      switch (thread.MediaType)
                      {
                          case MediaTypes.Music:
                              Response.Write(SPBHtmlHelper.Instance().Icon(IconTypes.Music, thread.GetMultilingualShareTypeName(CurrentUserLanguage), new RouteValueDictionary { { "class", "tn-icon-inline" } }));
                              break;
                          case MediaTypes.Video:
                              Response.Write(SPBHtmlHelper.Instance().Icon(IconTypes.Movie, thread.GetMultilingualShareTypeName(CurrentUserLanguage), new RouteValueDictionary { { "class", "tn-icon-inline" } }));
                              break;
                          case MediaTypes.Website:
                              Response.Write(SPBHtmlHelper.Instance().Icon(IconTypes.World, thread.GetMultilingualShareTypeName(CurrentUserLanguage), new RouteValueDictionary { { "class", "tn-icon-inline" } }));
                              break;
                          default:
                              Response.Write(SPBHtmlHelper.Instance().Icon(IconTypes.World, thread.GetMultilingualShareTypeName(CurrentUserLanguage), new RouteValueDictionary { { "class", "tn-icon-inline" } }));
                              break;
                      }
                  }
                  else
                  {%>
                <img src="<%=shareIconPath %>" height="16px" width="16px" />
                <% }%>
                        <a href="<%=shareThreadUrl %>">
                            <%=thread.Subject %></a></h5>
                </div>
                <div class="tn-list-item-row tn-helper-clearfix">
                    <div class="tn-list-item-area-left">
                        <%if (thread.MediaType == MediaTypes.Video)
                          { %>
                        <div class="spb-video-cover tn-img-sprite">
                            <div class="spb-video-cover-source" <%if (string.IsNullOrEmpty(thread.ThumbnailUrl)) Response.Write(noBgImage); else Response.Write("style=\"" + bgImage + "\""); %>>
                                <a href="<%=shareThreadUrl %>">
                                    <div class="tn-widget-content tn-corner-all">
                                        <span class="tn-icon tn-icon-play">
                                            <%=GetResourceString("Action_Play", ApplicationIDs.Instance().Share())%></span>
                                    </div>
                                </a>
                            </div>
                        </div>
                        <%}
                          else if (!string.IsNullOrEmpty(thread.ThumbnailUrl) && thread.ApplicationID != ApplicationIDs.Instance().User())
                          {%>
                        <a href="<%=shareThreadUrl %>" title="<%=HtmlUtils.StripForPreview(thread.Subject) %>">
                            <img src="<%=thread.ThumbnailUrl %>" alt="" /></a>
                        <%}
                          else if (thread.ApplicationID == ApplicationIDs.Instance().User())
                          {%>
                        <div class="tn-avatar">
                            <%=SPBHtmlHelper.Instance().ShowUserAvatar(thread.UserID, true,HyperLinkTarget._blank, AvatarSizeTypes.Small) %>
                        </div>
                        <%}%>
                    </div>
                    <div class="tn-list-item-area-right">
                        <%--<div class="tn-list-figure tn-widget">
                            <div class="tn-list-figure-count tn-widget-content tn-corner-top">
                                <%=thread.UserCount %></div>
                          <%if (CurrentUser == null)
                            { %>
                        <a href="<%=SiteUrls.Instance().Login(true) %>"
                            class="tn-list-figure-button tn-state-default tn-corner-bottom">
                            <%=GetResourceString("Action_Share", ApplicationIDs.Instance().Share())%></a>
                        <%}
                            else
                            { %>
                            <a href="<%=SiteUrls.Instance().ShareInModal(thread.ThreadID,false) %>" id="shareButton_<%=thread.ThreadID %>"
                                name="shareButton" class="tn-list-figure-button tn-state-default tn-corner-bottom nyroModal">
                                <%=GetResourceString("Action_Share", ApplicationIDs.Instance().Share())%></a>
                         <%} %>
                        </div>--%>
                    </div>
                    <div class="tn-list-item-area-main">
                        <div class="tn-list-item-row tn-list-item-heading">
                            <cite><a href="<%=thread.URL %>">
                                <%=StringUtils.Trim(thread.URL,24) %></a></cite>
                        </div>
                        <div class="tn-list-item-row">
                            <cite>
                                
                                <%=SPBHtmlHelper.Instance().UserDisplayNameLink(thread.UserID,thread.Author,ApplicationIDs.Instance().Share()) %>
                                
                                </cite> <em class="tn-date tn-text-note"><%=GetResourceString("Label_ShareTo",ApplicationIDs.Instance().Share())%>
                                    <%=Formatter.FormatFriendlyDate(thread.DateCreated) %></em>
                        </div>
                        <%if (thread.MediaType == MediaTypes.Music)
                          { %>
                        <div class="tn-list-item-row">
                            <span class="tn-button tn-button-text-icon tn-button-default"><span class="tn-first-child">
                                <span class="tn-icon tn-icon-play"></span><a href="<%=shareThreadUrl %>" class="tn-button-text">
                                    <%=GetResourceString("Action_PlayMusic", ApplicationIDs.Instance().Share())%></a>
                            </span></span>
                        </div>
                        <%} %>
                        <div class="tn-list-item-row tn-list-item-summary">
                            <p class="tn-helper-reset">
                                <%=thread.Body %></p>
                        </div>
                    </div>
                </div>
            </li>
            <%} %>
        </ul>
        <%if (Model.TotalRecords > Model.PageSize)
          { %>
        <div class="tn-pagination tn-helper-align-center">
            <%=SPBHtmlHelper.Instance().PagingButton(PaginationMode.NumericNextPrevious, Model.TotalRecords, Model.PageSize, Model.PageIndex)%>
            <div class="tn-page-results tn-text-note">
            </div>
        </div>
        <%} %>

        <script type="text/javascript">
            var ListShareThreadsID = "ShareThreads";
            $(document).ready(function() {
                $("a[name='shareButton'],a[name='impeachButton']").nyroModal({
                    width: 500
                });
                $("a[name='updateButton']", $('#' + ListShareThreadsID)).nyroModal({
                    endRemove: function(elts, settings) {
                    }
                });
                $("a[name='commentButton']", $('#' + ListShareThreadsID)).click(
         function(e) {
             var $comments = $("#comments__" + $(this).attr("value"));
             var $commentForLoad = $("#commentForLoad__" + $(this).attr("value"));
             if ($commentForLoad.is(":hidden")) {
                 $commentForLoad.show();
                 if (!$comments.find("div").length) {
                     $comments.load($comments.attr("value"));
                 }
             }
             else {
                 $commentForLoad.hide();
             }
         });
                $("a[name='deleteButton']").click(function() {
                    if (confirm('<%=GetResourceString("Message_ConfirmDeleteShare", ApplicationIDs.Instance().Share())%>'))
                        $('#' + ListShareThreadsID).parent().load($(this).attr("value"));
                    return false;
                });
            });
        </script>

    </div>
<%}
           } %>
    </div>
</div>
</asp:content>
<asp:content contentplaceholderid="sidebarContent" runat="server">
    <% Html.RenderAction<ChannelShareController>(n => n.Control_SiteShareTagsBlock(50, SiteTagsSortBy.ItemCount)); %>
</asp:content>
