﻿<%@ Page Language="C#" Inherits="SpaceBuilder.Web.ChannelViewPage<ShareThread>" %>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<spb:Header ID="Header1" runat="server">
    <spb:Script runat="server" ID="jquery" Src="~/Utility/jquery/jquery.min-1.4.2.js"
        SetExpireDays="30" />
    <spb:Script runat="server" ID="core" Src="~/Utility/jquery/ui.core.min-1.8.12.js"
        SetExpireDays="30" />
    <spb:Script runat="server" ID="widget" Src="~/Utility/jquery/ui.widget.min-1.8.12.js"
        SetExpireDays="30" />
    <spb:Script runat="server" ID="global" Src="~/Utility/tunynet_web_ui/global.js" />
    <spb:Script runat="server" ID="validate" Src="~/Utility/jquery/plugin/jquery.validate-1.7.js"
        SetExpireDays="30" />
</spb:Header>
<body>
    <div id="ShareDialog">
        <%
            if (TempData["StatusMessageData"] != null || ViewData["StatusMessageData"] != null)
            {
                StatusMessageData messageData = TempData.Get<StatusMessageData>("StatusMessageData", null);
                if (messageData == null)
                    messageData = ViewData.Get<StatusMessageData>("StatusMessageData", new StatusMessageData(StatusMessageType.Error, string.Empty));
                Response.Write(SPBHtmlHelper.Instance().StatusMessage(messageData));
                if (messageData.MessageType == StatusMessageType.Success)
                {
                    //关闭模式窗口
                    Response.Write(string.Format("<script type=\"text/javascript\" rel=\"forceLoad\">setTimeout('if($.nyroModalRemove)$.nyroModalRemove();else self.close();',2000)</script>"));
                }
                TempData["StatusMessageData"] = null;
                ViewData["StatusMessageData"] = null;
            }
            else
            {
                int maxLengthForBody = ShareConfiguration.Instance().MaxLengthForBody;
                int maxLengthPerReply = ShareConfiguration.Instance().MaxLengthPerReply;

                int applicationID = ApplicationIDs.Instance().Share();
        %>
        <form class="tn-helper-reset nyroModal" class="UpdateUserShareThreadForm" id="UpdateUserShareThreadForm"
        method="post" action="<%=SPBUrlHelper.Action("CreateUserShareThread","ChannelShare",new RouteValueDictionary{{"threadID",Model.ThreadID}}) %>">
        <div class="tn-form tn-label-right">
            <h4 class="tn-text-heading tn-border-gray tn-border-bottom">
                <%=GetResourceString("Action_AddShare",ApplicationIDs.Instance().Share())%></h4>
            <div class="tn-form-row">
                <label class="tn-form-label">
                    <%=GetResourceString("Label_NoteAddress", applicationID)%><%=GetResourceString("Common_Colon") %></label>
                <input type="text" value="<%=Model.URL %>" disabled="disabled" id="url" class="tn-textbox tn-input-long tn-border-gray"
                    name="text">
                <input type="hidden" name="url" value="<%=Model.URL %>" />
            </div>
            <% if (Model.ThreadID <= 0)
               { %>
            <input type="hidden" name="applicationID" value="<%=Model.ApplicationID %>" />
            <input type="hidden" name="contentUserID" value="<%=Model.ContentUserID%>" />
            <input type="hidden" name="contentAuthor" value="<%=Model.ContentAuthor%>" />
            <div class="tn-form-row">
                <label class="tn-form-label">
                    <span class="tn-form-required"></span>
                    <%=GetResourceString("Label_Subject")%><%=GetResourceString("Common_Colon")%></label>
                <input type="text" class="tn-textbox tn-input-long tn-border-gray" id="Text3" name="subject"
                    value="<%=Formatter.FormatSingleLinePlainTextForEdit(Model.Subject) %>">
            </div>
            <div class="tn-form-row tn-textarea-wrap">
                <label class="tn-form-label">
                    <%=GetResourceString("Label_Description")%><%=GetResourceString("Common_Colon")%></label>
                <textarea id="body" name="body" class="tn-textarea tn-input-long tn-border-gray"
                    rows="" cols=""><%=Formatter.FormatMultiLinePlainTextForEdit(Model.Body, true)%></textarea><span
                        style="display: none"></span>
                <div class="tn-text-note">
                    <%=string.Format(GetResourceString("Description_Pattern_WordLimit", applicationID), maxLengthForBody)%></div>
            </div>
            <div class="tn-form-row">
                <label class="tn-form-label">
                    <%=GetResourceString("Label_MiniatureAddress", applicationID)%><%=GetResourceString("Common_Colon")%></label>
                <input type="text" class="tn-textbox tn-input-long tn-border-gray" id="thumbnailUrl"
                    name="thumbnailUrl" value="<%=Formatter.FormatSingleLinePlainTextForEdit(Model.ThumbnailUrl) %>" />
            </div>
            <% if (Model.ApplicationID <= 0)
               {
                   if (Model.MediaType != MediaTypes.Website)
                   {%>
            <div class="tn-form-row">
                <label class="tn-form-label">
                    <%=GetResourceString("Label_PlayAddress", applicationID)%><%=GetResourceString("Common_Colon")%></label>
                <input type="text" id="playerUrl" name="playerUrl" class="tn-textbox tn-input-long tn-border-gray"
                    value="<%=Formatter.FormatSingleLinePlainTextForEdit(Model.PlayerUrl) %>" />
            </div>
            <%}%>
            <div class="tn-form-row">
                <label class="tn-form-label">
                    <%=GetResourceString("Common_SiteCategory",ApplicationIDs.Instance().Share())%><%=GetResourceString("Common_Colon")%></label>
                <%Html.RenderAction<ChannelController>(n => n.Control_SiteCategoryDropDownList(ApplicationIDs.Instance().Share(), ShareConfiguration.Instance().SiteCategoryLevel - 1, "ShareSiteCategoryDDL", Model.SiteCategoryID, "dropDownList")); %>
            </div>
            <%if (Model.MediaType == MediaTypes.Website)
              { %>
            <div class="tn-form-row">
                <label class="tn-form-label">
                    <%=GetResourceString("Label_MultimediaType", applicationID)%><%=GetResourceString("Common_Colon")%></label>
                <select id="mediaType" name="mediaType" class="tn-dropdownlist">
                    <option <%if (Model.MediaType == MediaTypes.Website) Response.Write("select=\"select\""); %>
                        value="<%=(int)MediaTypes.Website %>">
                        <%=GetResourceString("Enum_Else", ApplicationIDs.Instance().Share())%></option>
                    <option <%if(Model.MediaType==MediaTypes.Video) Response.Write("select=\"select\""); %>
                        value="<%=(int)MediaTypes.Video %>">
                        <%=GetResourceString("Enum_Media", ApplicationIDs.Instance().Share())%></option>
                    <option <%if(Model.MediaType==MediaTypes.Music) Response.Write("select=\"select\""); %>
                        value="<%=(int)MediaTypes.Music %>">
                        <%=GetResourceString("Enum_Music", ApplicationIDs.Instance().Share())%></option>
                </select>
            </div>
            <%}
              else
              { %>
            <input type="hidden" name="mediaType" value="<%=(int)MediaTypes.Video %>" />
            <%}
               }
               }
               else
               {%>
            <div class="tn-form-row">
                <label class="tn-form-label">
                    <%=GetResourceString("Label_Body")%><%=GetResourceString("Common_Colon") %></label>
                <% if (!string.IsNullOrEmpty(Model.ThumbnailUrl))
                   {%>
                <img width="100px" id="thumbnailUrl" name="thumbnailUrl" height="70px" src="<%=Model.ThumbnailUrl %>" />
                <%} %>
            </div>
            <div class="tn-form-row">
                <label class="tn-form-label">
                </label>
                <strong>
                    <%=Model.Subject %></strong>
            </div>
            <div class="tn-form-row">
                <label class="tn-form-label">
                </label>
                <%=GetResourceString("Description_From", ApplicationIDs.Instance().Share())%><a id="auther"
                    name="auther" href="<%=SiteUrls.Instance().UserDomainHome(Model.ContentUserID) %>"><%=Model.ContentAuthor %></a>
            </div>
            <div class="tn-form-row">
                <label class="tn-form-label">
                </label>
                <%=StringUtils.Trim(Model.Body, 100)%>
            </div>
            <%} %>
            <div class="tn-form-row">
                <label class="tn-form-label">
                    <%=GetResourceString("Common_UserTag")%><%=GetResourceString("Common_Colon")%></label>
                <%ViewData["TagInputName"] = "userTags";
                  ViewData["userTagItemKey"] = UserTagItemKeys.Instance().UserShareThread();
                  Html.RenderPartial("Controls/UserTagSelector.ascx", ViewData);%>
            </div>
            <div class="tn-form-row">
                <label class="tn-form-label">
                    <%=GetResourceString("Label_BrowsePopedom", applicationID)%><%=GetResourceString("Common_Colon")%></label>
                <%=SPBHtmlHelper.Instance().PrivacyStatusesDropDownList("privacyStatus", "tn-dropdownlist", null, string.Empty)%>
            </div>
            <div class="tn-form-row tn-form-row-button">
                <label class="tn-form-label">
                </label>
                <%=SPBHtmlHelper.Instance().SubmitButton("newShareInDialogButton", GetResourceString("Common_Share"), ButtonSizes.Large, null, null)%>
                <% if (Request.UrlReferrer != null)
                   {%>
                <%=SPBHtmlHelper.Instance().LinkButton("cancelButton", GetResourceString("Action_CancelInput", ApplicationIDs.Instance().Share()), ButtonSizes.Large, HighlightStyles.Secondary, new RouteValueDictionary() { { "onclick", "if($.nyroModalRemove)$.nyroModalRemove();else self.close();" } },null)%>
                <%} %>
            </div>
        </div>
        </form>
        <script type="text/javascript">
    $(document).ready(function() {
        $("#UpdateUserShareThreadForm").validate({
            rules: {
                subject: { required: true, maxBlength: 80 },
                body: { maxBlength:<%=maxLengthForBody %>  },
                commentBody: { maxBlength:<%=maxLengthPerReply %>  }
            },
            messages: {
                subject: { required: "<%=GetResourceString("Validate_MustImport", ApplicationIDs.Instance().Share())%>", maxBlength: "<%=GetResourceString("Validate_MostChar", ApplicationIDs.Instance().Share())%>" },
                body: { maxBlength: "<%=string.Format(GetResourceString("Validate_Pattern_MostImportChar", ApplicationIDs.Instance().Share()), maxLengthForBody)%>" },
                commentBody: { maxBlength: "<%=string.Format(GetResourceString("Validate_Pattern_MostImportChar", ApplicationIDs.Instance().Share()), maxLengthForBody)%>" }
            }
        });
        $("#newShareInDialogButton").click(function() {
            if (!$("#UpdateUserShareThreadForm").valid()) {
                return false;
            }
        });
    });
        </script>
        <%} %>
    </div>
</body>
</html>
