﻿<%@ Page Language="C#" Inherits="SpaceBuilder.Web.ChannelViewPage<ShareThread>" %>

<asp:content contentplaceholderid="setPageID" runat="server">
    id="Share-ShareRanks"
</asp:content>
<asp:content runat="server" contentplaceholderid="subMenusContent">
<% Html.RenderAction<ChannelShareController>(n => n.Control_SubMenus(null, ShareChannelSubMenu.rank)); %>
</asp:content>
<asp:content runat="server" contentplaceholderid="mainContent">
  <%
      int? mediaType = Html.GetParameterFromRouteDateOrQueryString<int>("mediaType");
      mediaType = mediaType.HasValue ? mediaType : (int)MediaTypes.Website;
      int? applicationID = Html.GetParameterFromRouteDateOrQueryString<int>("applicationID");
      applicationID = applicationID.HasValue ? applicationID : applicationID;
      int sortBy = Html.GetParameterFromRouteDateOrQueryString("sortBy", (int)ShareThreadSortBy.DateCreated);
 %>
 
<div class="spb-share-list ui-tabs ui-widget ui-widget-content ui-corner-all" id="ShareRanks"> 
    <ul class="ui-tabs-nav ui-helper-reset ui-helper-clearfix ui-widget-header ui-corner-all">
      <li class="ui-state-default ui-corner-top"><a href="#ShareThreads"> <span><%=GetResourceString("Action_FreshShare", ApplicationIDs.Instance().Share())%></span></a></li>
      <li class="ui-state-default ui-corner-top"><a href="<%=SPBUrlHelper.Action("Control_ListShareThreads", "ChannelShare", new RouteValueDictionary{{"mediaType",mediaType},{"applicationID",applicationID},{"sortBy",ShareThreadSortBy.StageUserCount}})%>"> <span><%=GetResourceString("Action_MostShare", ApplicationIDs.Instance().Share())%></span></a></li>
      <% if (!applicationID.HasValue || applicationID.Value <= 0)
         { %>
      <li class="ui-state-default ui-corner-top"> <a href="<%=SPBUrlHelper.Action("Control_ListShareThreads", "ChannelShare", new RouteValueDictionary{{"mediaType",mediaType},{"applicationID",applicationID},{"sortBy",ShareThreadSortBy.StageHitTimes}})%>"> <span><%=GetResourceString("Action_BrowseMost", ApplicationIDs.Instance().Share())%></span></a></li>
      <li class="ui-state-default ui-corner-top"> <a href="<%=SPBUrlHelper.Action("Control_ListShareThreads", "ChannelShare", new RouteValueDictionary{{"mediaType",mediaType},{"applicationID",applicationID},{"sortBy",ShareThreadSortBy.CommentCount}})%>"> <span><%=GetResourceString("Title_CommentMost") %></span></a></li>
      <%} %>
    </ul>
    <div id="ShareThreads" class="ui-tabs-panel ui-widget-content ui-corner-bottom ui-tabs-hide">
    <%if (TempData["StatusMessageData"] != null)
      {
          Response.Write(SPBHtmlHelper.Instance().StatusMessage(TempData.Get<StatusMessageData>("StatusMessageData"), 2000, false));
          TempData["StatusMessageData"] = null;
      } %>
      <%Html.RenderAction<ChannelShareController>(n => n.Control_ListShareThreads(null, (MediaTypes)mediaType, applicationID, string.Empty, ShareThreadSortBy.DateCreated, Request.QueryString.GetInt("pageIndex", 1))); %>
    </div>
 </div>
  <script type="text/javascript">
     $(document).ready(function() {
         $(".ui-tabs").tabs({selected:<%=sortBy %>});
     });
 </script>
</asp:content>
<asp:content contentplaceholderid="sidebarContent" runat="server">
  <% Html.RenderAction<ChannelShareController>(n => n.Control_SiteShareTagsBlock(50, SiteTagsSortBy.ItemCount)); %>
</asp:content>
