﻿<%@ Page Language="C#" Inherits="SpaceBuilder.Web.ChannelViewPage<ShareThread>" %>

<asp:content runat="server" contentplaceholderid="subMenusContent">
  <% Html.RenderAction<ChannelShareController>(n => n.Control_SubMenus(null, null)); %>
</asp:content>
<asp:content runat="server" contentplaceholderid="mainContent">
  <spb:Script runat="server" ID="jqueryForm" Src="~/Utility/jquery/plugin/jquery.form.min-2.7.3.js" SetExpireDays="30" />
  <spb:Script runat="server" ID="blockUI" Src="~/Utility/jquery/plugin/jquery.blockUI-2.3.3.js" SetExpireDays="30" />
  <%bool hasManagePermission = CurrentUser != null && CurrentUser.IsAdministrator || CurrentUser != null && CurrentUser.IsContentAdministrator || CurrentUser != null && CurrentUser.UserID == Model.UserID;
    bool errorAuditingStatus = ViewData.GetBool("errorAuditingStatus", false);
    bool isShow = ViewData.GetBool("errorPrivacyStatus", true);
    if (!hasManagePermission && !isShow)
    {
        Response.Write(SPBHtmlHelper.Instance().StatusMessage(StatusMessageType.Hint, "该分享禁止浏览！"));
    }
    else if (errorAuditingStatus)
    {
        string errorMessage = ViewData.GetString("errorMessage", string.Empty);%>
  <div class="tn-widget">
    <div class="tn-cue-highlight tn-corner-all tn-message-box"> <span class="tn-helper-right"><a href="<%if (!String.IsNullOrEmpty(Request.RawUrl)) Response.Write(Request.RawUrl); %>"><%=GetResourceString("Action_ReturnList")%></a></span> <span class="tn-helper-left"><span class="tn-icon tn-icon-exclamation"></span></span>
      <div class="tn-helper-flowfix">
        <% Response.Write(errorMessage); %>
        <%if (CurrentUser != null && CurrentUser.IsAdministrator || CurrentUser != null && CurrentUser.IsContentAdministrator)
          {
              int threadid = Model.ThreadID; %>
        <%=GetResourceString("Description_ManagerUseShare", ApplicationIDs.Instance().Share())%> <a href="<%=SPBUrlHelper.Action("updateUserShareThread","ChannelShare",new RouteValueDictionary{{"threadid",threadid}})%>" title="<%=GetResourceString("Description_AuditingShare", ApplicationIDs.Instance().Share())%>"><%=GetResourceString("Action_PastAuditing", ApplicationIDs.Instance().Share())%></a>
        <%}%>
      </div>
    </div>
  </div>
  <% }
    if ((!errorAuditingStatus && isShow) || hasManagePermission)
    {%>
  <div class="tn-box tn-widget tn-widget-content tn-corner-all tn-detail spb-share-video-detail" id="showShareThread">
    <div class="tn-box-content tn-widget-content tn-corner-all">
      <div class="tn-text-heading">
        <h2 class="tn-title"><%=Model.Subject %></h2>
      </div>
      <%if (hasManagePermission)
        { %>
      <div class="tn-actions tn-helper-align-right"> <span class="tn-action"> <a class="nyroModal" href="<%=SPBUrlHelper.Action("Control_EditShareThread","ChannelShare",new RouteValueDictionary{{"threadID",Model.ThreadID}}) %>"><%=GetResourceString("Action_Edit")%></a> </span> <span class="tn-action"> <a href="javascript:;" onclick="if(confirm('<%=GetResourceString("Message_ConfirmDeleteShare", ApplicationIDs.Instance().Share())%>')){window.location.href='<%=SPBUrlHelper.Action("DeleteShareThread", "ChannelShare", new RouteValueDictionary {{ "threadID", Model.ThreadID },{"returnUrl",SPBUrlHelper.Action("ShareRanks","ChannelShare")}})%>';}"><%=GetResourceString("Action_Delete")%></a> </span> </div>
      <%} %>
      <div class="tn-info-part tn-text-note tn-border-gray tn-border-top tn-detail-info">
        <dl>
          <dt><%=GetResourceString("Action_Source", ApplicationIDs.Instance().Share())%><%=GetResourceString("Common_Colon") %></dt>
          <dd><a href="<%=SiteUrls.Instance().UserChannelHome(Model.UserID,ApplicationIDs.Instance().Share()) %>"><b><%=Model.Author%></b></a></dd>
        </dl>
        <dl>
          <dd><%=Formatter.FormatFriendlyDate(Model.DateCreated) %></dd>
        </dl>
        <dl>
          <dt><%=GetResourceString("Label_ShareTotal", ApplicationIDs.Instance().Share())%><%=GetResourceString("Common_Colon") %></dt>
          <dd><%=Model.UserCount%></dd>
        </dl>
        <dl>
          <dt><%=GetResourceString("Label_BrowseTotal", ApplicationIDs.Instance().Share())%><%=GetResourceString("Common_Colon") %></dt>
          <dd><%=Model.HitTimes%></dd>
        </dl>
        <dl>
          <dt><%=GetResourceString("Common_Comment") %><%=GetResourceString("Common_Colon") %></dt>
          <dd><%=Model.CommentCount%></dd>
        </dl>
      </div>
      <div class="spb-share-media">
        <% if (Model.MediaType == MediaTypes.Video)
           { %>
        <div style="text-align:center">
          <embed height="416" width="500" allowscriptaccess="sameDomain" wmode="transparent" allowfullscreen="true" type="application/x-shockwave-flash" src="<%=Model.PlayerUrl %>"></embed>
        </div>
        <% }
           else if (Model.MediaType == MediaTypes.Music)
           {%>
        <div align=center>
          <MARQUEE scrollAmount=3 scrollDelay=30 direction="right" width=400 height=30 >
          <P><FONT size=3><%=Model.Subject%></FONT></P>
          </MARQUEE>
          <object classid="clsid:d27cdb6e-ae6d-11cf-96b8-444553540000" width="400" height="27" codebase=" http://download.macromedia.com/pub/shockwave/cabs/flash/swflash.cab#version=6,0,40,0">
            <param name="bgcolor" value="#ffffff" />
            <param name="flashvars" value="playerMode=embedded" />
            <param name="src" value="<%=WebUtils.ResolveUrl("~/Utility/audio-player.swf")%>?audioUrl=<%=Model.PlayerUrl %>&autoPlay=true" />
            <param name="wmode" value="window" />
            <param name="quality" value="best" />
            <embed type="application/x-shockwave-flash" width="400" height="27" src="<%=WebUtils.ResolveUrl("~/Utility/audio-player.swf")%>?audioUrl=<%=Model.PlayerUrl %>&autoPlay=true" quality="best" bgcolor="#ffffff" wmode="window" flashvars="playerMode=embedded"></embed>
          </object>
        </div>
        <%}%>
      </div>
      <div class="tn-detail-text">
        <%
            if (!String.IsNullOrEmpty(Model.Body))
            {%>
        <p><%=Model.Body%></p>
        <%} %>
      </div>
      <div class="tn-feedback tn-border-gray tn-border-top tn-helper-align-right">
        <%if (CurrentUser != null)
              Response.Write(SPBHtmlHelper.Instance().LinkButton("sharelink", GetResourceString("Action_Share", ApplicationIDs.Instance().Share()), SiteUrls.Instance().ShareInModal(Model.ThreadID), ButtonSizes.Default, HighlightStyles.Default, IconTypes.Share, TextIconLayout.IconText, new RouteValueDictionary { { "class", "nyroModal" } }, null));
          else
              Response.Write(SPBHtmlHelper.Instance().LinkButton(string.Empty, GetResourceString("Action_Share", ApplicationIDs.Instance().Share()), SiteUrls.Instance().Login(true), ButtonSizes.Default, HighlightStyles.Default, IconTypes.Share, TextIconLayout.IconText, null, null));  %>
        <%=SPBHtmlHelper.Instance().LinkButton("",GetResourceString("Common_Comment"),"#comments",ButtonSizes.Default,HighlightStyles.Default,IconTypes.Bubble,TextIconLayout.IconText,null,null) %> <%=SPBHtmlHelper.Instance().LinkButton("", GetResourceString("Action_Drink", ApplicationIDs.Instance().Share()), SiteUrls.Instance().NewImpeachReport(), ButtonSizes.Default, HighlightStyles.Default, IconTypes.Alert, TextIconLayout.IconText, new RouteValueDictionary { { "class", "nyroModal" } }, null)%> </div>
      <%Html.RenderAction<ChannelShareController>(n => n.Control_ListShareComments(Model.ThreadID, "ListShareComments", Request.QueryString.GetInt("pageIndex", 1))); %>
    </div>
  </div>
  <script type="text/javascript">
      $(document).ready(function() {
          $("#updateButton").nyroModal({
              resizeable: true
          });
          $('#sharelink').nyroModal({
              resizeable: true,
              width: 500
          });
      });
</script>
  <%} %>
</asp:content>
<asp:content contentplaceholderid="sidebarContent" runat="server">
  <%Html.RenderAction<ChannelShareController>(n => n.Control_Relations(Model.ThreadID)); %>
</asp:content>
