﻿<%@ Page Language="C#" Inherits="SpaceBuilder.Web.ChannelPublicViewPage<IList<UserActivity>>" %>

<asp:content ID="Content1" contentplaceholderid="setPageID" runat="server"> id="SinpleHome" </asp:content>
<asp:content contentplaceholderid="loginContent" runat="server">
  <spb:Script runat="server" ID="qtip" Src="~/Utility/jquery/plugin/jquery.qtip-1.0.0-rc3.js" SetExpireDays="30" />
  <div id="login" class="tn-box tn-widget tn-widget-content tn-corner-all spb-simple-login">
    <div class="tn-box-content tn-widget-content tn-corner-all">
      <% Html.RenderAction<ChannelUserController>(L => L.Control_LoginInSample()); %>
    </div>
  </div>
</asp:content>
<asp:content contentplaceholderid="activitiesContent" runat="server">
  <div id="siteActivities" class="tn-box tn-widget tn-widget-content tn-corner-all spb-site-feeds">
    <div class="tn-box-header tn-widget-header tn-corner-top tn-border-bottom">
      <h3 class="tn-helper-reset"><%=GetResourceString("Title_ListSiteActivities",ApplicationIDs.Instance().User()) %></h3>
    </div>
    <div id="ListMyNewStories" class="tn-box-content tn-widget-content tn-corner-bottom">
      <% IList<UserActivity> userActivities = ViewData.Model;
               if (userActivities.Count > 0)
               {%>
      <ul class="tn-list tn-helper-reset">
        <% 
                  Dictionary<int, Application> applications = Applications.GetApplications();
                  string applicationKey = "default";
                  string applicationName = GetResourceString("Title_ActivityApplicationName", ApplicationIDs.Instance().User());
                  string userDomainName = Html.GetParameterFromRouteDateOrQueryString("userDomainName");
                  foreach (UserActivity userActivity in userActivities)
                  {
                      if (applications.ContainsKey(userActivity.ApplicationID))
                      {
                          applicationKey = applications[userActivity.ApplicationID].ApplicationKey;
                          applicationName = applications[userActivity.ApplicationID].GetMultilingualApplicationName(CurrentUserLanguage);
                      }
                      string filePath = Globals.GetFullUrlInResourceSite(string.Format("~/Themes/Shared/Styles/Icons/activity_{0}.gif", applicationKey.ToLower()));%>
        <li class="tn-list-item tn-helper-clearfix tn-border-gray tn-border-bottom">
          <div class="tn-list-item-area-left"> <img src="<%=filePath %>" title="<%=applicationName %>" alt="<%=applicationName %>"
                    width="16" height="16" /> </div>
          <div class="tn-list-item-area-main">
            <div class="tn-list-item-row"> <%=userActivity.Subject%><em class="tn-text-note tn-date"><%= Convert.ToString(Formatter.FormatFriendlyDate(userActivity.DateCreated))%></em></div>
            <div class="tn-list-item-row tn-list-item-summary">
              <% if (!string.IsNullOrEmpty(userActivity.Body))
                       {%>
              <p class="tn-helper-reset"> <%=userActivity.Body%></p>
              <%} %>
              <div class="tn-list-item-row"> </div>
            </div>
          </div>
        </li>
        <%} %>
      </ul>
      <%} %>
    </div>
  </div>
</asp:content>
