﻿<%@ Page Language="C#" Inherits="SpaceBuilder.Web.ChannelPublicViewPage<User>" %>

<asp:content contentplaceholderid="setPageID" runat="server"> id="AddRecommendUser" </asp:content>
<asp:content id="wideContent" runat="server" contentplaceholderid="wideContent">
  <%string userDomainName = Html.GetParameterFromRouteDateOrQueryString("userDomainName");
    userDomainName = WebUtils.UrlEncode(userDomainName);
    int applicationID = ApplicationIDs.Instance().User();
    PersonUser pu = Model as PersonUser;  %>
  <div class="tn-box tn-widget tn-widget-content tn-corner-all spb-register-step spb-recommended-friends">
    <div class="tn-box-content tn-widget-content tn-corner-all">
      <div class="tn-instructions">
        <div class="tn-progress-bar tn-widget-content tn-corner-all">
          <div class="tn-progress-bar-value tn-widget-header tn-corner-left tn-border-tbl" style="width: 75%;"></div>
        </div>
        <ul class="tn-helper-clearfix">
          <li class="tn-step"><b class="tn-widget-content tn-widget-header tn-corner-all"></b><span><a href="<%=SiteUrls.Instance().EnterWizardMode(userDomainName) %>">1.上传头像</a></span></li>
          <li class="tn-step"><b class="tn-widget-content tn-widget-header tn-corner-all"></b><span><a href="<%=SPBUrlHelper.Action("EditPersonInfo", "ChannelUser", new RouteValueDictionary { { "userDomainName", userDomainName } })%>">2.填写个人资料</a></span></li>
          <li class="tn-step tn-selected"><b class="tn-widget-content tn-widget-header tn-corner-all"></b><span><a href="javascript:;">3.看看推荐的好友</a></span></li>
          <li class="tn-step"><b class="tn-widget-content tn-corner-all"></b><span><a href="javascript:;">4.完成，进入个人中心</a></span></li>
        </ul>
      </div>
      <div class="tn-list-header">
        <div class="tn-list-header-row tn-helper-clearfix tn-border-gray tn-border-bottom">认识一些感兴趣的人，你将会获得更多的乐趣！</div>
      </div>
      <div class="tn-helper-clearfix tn-body">
        <div class="tn-helper-left"> <strong>热门推荐</strong>
          <ul class="tn-side-menu">
            <li class="tn-selected tn-widget-content tn-bg-light tn-corner-all"><a href="javascript:;" class="tn-menu-text" onclick='$("#listUsers").load("<%=SPBUrlHelper.Action("Control_ListTopPersonInWizardMode", "ChannelUser", new RouteValueDictionary { { "userDomainName", userDomainName }})%>")'>人气关注</a></li>
            <% List<string> listTags = UserTagManager.Instance(UserTagItemKeys.Instance().Person()).GetUserTagsOfItem(Model.UserID, false);
                     Dictionary<string, KeyValuePair<int, SiteTag>> siteTags = UserTagManager.Instance(UserTagItemKeys.Instance().Person()).GetTopSiteTagsSortBy(SiteTagsSortBy.UserCount, 12);
                     int i = 0;
                     int j = 1;
                     foreach (string tag in listTags)
                     {
                         siteTags.Remove(tag);
                         i++; %>
            <li><a href="javascript:;" class="tn-menu-text" onclick='$("#listUsers").load("<%=SPBUrlHelper.Action("Control_ListPersonInWizardMode", "ChannelUser", new RouteValueDictionary { { "userDomainName", userDomainName }, { "TagName", tag } })%>"); '><%=tag %></a></li>
            <%if (i > 2)
                        break;
                     }
                     foreach (var pair in siteTags)
                     {
                         j++;%>
            <li><a href="javascript:;" class="tn-menu-text" onclick='$("#listUsers").load("<%=SPBUrlHelper.Action("Control_ListPersonInWizardMode", "ChannelUser", new RouteValueDictionary { { "userDomainName", userDomainName }, { "TagName", pair.Value.Value.TagName } })%>")'><%=pair.Value.Value.TagName %></a></li>
            <%if ((i + j) > 7)
                           break;
                     }%>
          </ul>
          <strong>个性化推荐</strong>
          <ul class="tn-side-menu">
            <li><a href="javascript:;" class="tn-menu-text" onclick='$("#listUsers").load("<%=SPBUrlHelper.Action("Control_ListPersonInWizardMode", "ChannelUser", new RouteValueDictionary { { "userDomainName", userDomainName }, { "NowAreaCode", pu.NowAreaCode } })%>")'>相同城市</a></li>
            <li><a href="javascript:;" class="tn-menu-text" onclick='$("#listUsers").load("<%=SPBUrlHelper.Action("Control_ListPersonInWizardMode", "ChannelUser", new RouteValueDictionary { { "userDomainName", userDomainName }, { "CompanyTrade", pu.CompanyTrade } })%>")'>相同行业</a></li>
            <li><a href="javascript:;" class="tn-menu-text" onclick='$("#listUsers").load("<%=SPBUrlHelper.Action("Control_ListPersonInWizardMode", "ChannelUser", new RouteValueDictionary { { "userDomainName", userDomainName }, { "CompanyName", pu.CompanyName } })%>")'>你的同事</a></li>
            <li><a href="javascript:;" class="tn-menu-text" onclick='$("#listUsers").load("<%=SPBUrlHelper.Action("Control_ListPersonInWizardMode", "ChannelUser", new RouteValueDictionary { { "userDomainName", userDomainName }, { "HomeAreaCode", pu.HomeAreaCode } })%>")'>你的老乡</a></li>
            <li><a href="javascript:;" class="tn-menu-text" onclick='$("#listUsers").load("<%=SPBUrlHelper.Action("Control_ListPersonInWizardMode", "ChannelUser", new RouteValueDictionary { { "userDomainName", userDomainName }, { "School", pu.School } })%>")'>你的校友</a></li>
          </ul>
        </div>
        <div id="listUsers" class="spb-user-list tn-border-gray tn-border-left">
          <% Html.RenderAction("Control_ListTopPersonInWizardMode", "ChannelUser", new RouteValueDictionary { { "userDomainName", userDomainName } }); %>
        </div>
      </div>
    </div>
  </div>
  <script type="text/javascript">
    $(document).ready(function() {
        $("li > a.tn-menu-text").click(function() {
            $("li > a.tn-menu-text").parent().attr("class", "");
            $(this).parent().addClass("tn-selected tn-widget-content tn-bg-light tn-corner-all");
        });
    });
</script>
</asp:content>
