﻿<%@ Page Language="C#" Inherits="SpaceBuilder.Web.ChannelPublicViewPage" %>

<asp:content contentplaceholderid="setPageID" runat="server"> id="CompanyRegister" </asp:content>
<asp:content id="wideContent" runat="server" contentplaceholderid="wideContent">
  <spb:Script runat="server" ID="qtip" Src="~/Utility/jquery/plugin/jquery.qtip-1.0.0-rc3.js"
        SetExpireDays="30" />
  <spb:Script runat="server" ID="CollapsibleBox" Src="~/Utility/jquery/plugin/jquery.spb.CollapsibleBox.js"
        SetExpireDays="30" />
  <% if (TempData["StatusMessageType"] != null)
     {
         StatusMessageType messageType = (StatusMessageType)TempData.GetInt("StatusMessageType", (int)StatusMessageType.Error);
         Response.Write(SPBHtmlHelper.Instance().StatusMessage(messageType, TempData.GetString("StatusMessageContent", string.Empty)));
         TempData["StatusMessageType"] = null;
     }
     CompanyUser cu = new CompanyUser();
     int applicationID = ApplicationIDs.Instance().User();
     if (TempData["companyUser"] != null)
         cu = TempData["companyUser"] as CompanyUser;
     if (!SiteSettingsManager.GetSiteSettings().IsCloseCompanyUser)
     { 
      %>
  <div class="tn-box tn-widget tn-widget-content tn-corner-all spb-register">
    <div class="tn-box-content tn-widget-content tn-corner-all">
      <div class="tn-text-heading tn-border-light tn-border-bottom">
        <h3 class="tn-helper-reset tn-helper-right">
          <% if (!SiteSettingsManager.GetSiteSettings().IsCloseCompanyUser)
             { %>
          <a href="<%=SPBUrlHelper.Action("Register","ChannelUser") %>"><%=GetResourceString("Title_PersonUserRegister", applicationID)%></a>
          <%} %>
        </h3>
        <h3 class="tn-helper-reset"><%=GetResourceString("Title_CompanyUserRegister", applicationID)%></h3>
      </div>
      <form id="RegisterForm" action="<%=SPBUrlHelper.Action("CompanyRegisterAction","ChannelUser") %>" method="post">
        <div class="tn-form tn-label-right">
          <div class="tn-text-heading tn-border-gray tn-border-bottom">
            <h4 class="tn-helper-reset"><%=GetResourceString("Title_BasicInfo", applicationID)%></h4>
            <span class="tn-form-required"><%=GetResourceString("Description_Required",applicationID)%></span></div>
          <div class="tn-form-row">
            <label class="tn-form-label"><%=GetResourceString("Label_ShowUserName",applicationID)%><%=GetResourceString("Common_Colon") %> </label>
            <input type="text" class="tn-textbox tn-input-long tn-border-gray" id="userName" name="userName" value="<%=cu.UserName %>"  />
          </div>
          <div class="tn-form-row">
            <label class="tn-form-label"> <%=GetResourceString("Common_Password")%><%=GetResourceString("Common_Colon") %> </label>
            <input type="password" id="password" name="password" class="tn-textbox tn-input-long tn-border-gray" maxlength="64" />
          </div>
          <div class="tn-form-row">
            <label class="tn-form-label"><%=GetResourceString("Label_ConfirmPassword",applicationID)%><%=GetResourceString("Common_Colon") %> </label>
            <input type="password" id="password2" name="password2" class="tn-textbox tn-input-long tn-border-gray" maxlength="64" />
          </div>
          <div class="tn-form-row">
            <label class="tn-form-label"> <%=GetResourceString("Label_UserEamilAddress",applicationID)%><%=GetResourceString("Common_Colon") %> </label>
            <input type="text" id="userEmail" name="userEmail" class="tn-textbox tn-input-long tn-border-gray" value="<%=cu.PrivateEmail %>" maxlength="100" />
          </div>
          <div class="tn-form-row">
            <label class="tn-form-label"><%=GetResourceString("Label_CompanyUserName",applicationID) %><%=GetResourceString("Common_Colon") %> </label>
            <input type="text" class="tn-textbox tn-input-long tn-border-gray" id="CommonName" name="CommonName" value="<%=cu.CommonName %>" maxlength="30" />
          </div>
          <div class="tn-form-row">
            <label class="tn-form-label"><%=GetResourceString("Label_CompanyUserLicence",applicationID)%><%=GetResourceString("Common_Colon") %> </label>
            <input type="text" class="tn-textbox tn-input-long tn-border-gray" id="Licence" name="Licence" value="<%=cu.Licence %>"  />
          </div>
          <div class="tn-collapsible tn-collapsible-closed">
            <div class="tn-border-bottom tn-border-gray tn-collapsible-header">
              <h4 class="tn-helper-reset"><%=GetResourceString("Title_CompanyuserDetialInfo",applicationID)%><%=GetResourceString("Common_Colon") %></h4>
              <span class="tn-text-note"><%=GetResourceString("Description_Optional") %></span> </div>
            <div class="tn-collapsible-content" style="display:none;">
              <%
IDictionary<int, CodeItem> dicCompanyPropertys = null;
IDictionary<int, CodeItem> Funds = null;
IDictionary<int, CodeItem> EmployeeCounts = null;
IDictionary<int, CodeItem> Trades = null;
if (ViewData["CompanyPropertys"] != null)
{
    dicCompanyPropertys = ViewData["CompanyPropertys"] as Dictionary<int, CodeItem>;
}
if (ViewData["Trades"] != null)
{
    Trades = ViewData["Trades"] as Dictionary<int, CodeItem>;
}
if (ViewData["Funds"] != null)
{
    Funds = ViewData["Funds"] as Dictionary<int, CodeItem>;
}
if (ViewData["EmployeeCounts"] != null)
{
    EmployeeCounts = ViewData["EmployeeCounts"] as Dictionary<int, CodeItem>;
}
                        %>
              <div class="tn-form-row">
                <label class="tn-form-label"> <%=GetResourceString("Label_CompanyUserTrade",applicationID)%><%=GetResourceString("Common_Colon") %> </label>
                <%=SPBHtmlHelper.Instance().ShowDropDownList("Trades", Trades.ToDictionary(n => n.Key, n => n.Value.Name), new RouteValueDictionary { { "Class", "tn-dropdownlist" } }, cu.Trade)%> </div>
              <div class="tn-form-row">
                <label class="tn-form-label"> <%=GetResourceString("Label_UserAreaCode",applicationID)%><%=GetResourceString("Common_Colon") %> </label>
                <% Html.RenderAction<ChannelController>(n => n.Control_AreasDropDownList("areaCode", UserDomainConfiguration.Instance().RootAreaCode, cu.AreaCode, UserDomainConfiguration.Instance().AreaLevel, "tn-dropdownlist")); %>
              </div>
              <div class="tn-form-row">
                <label class="tn-form-label"><%=GetResourceString("Label_CompanyUserProperty",applicationID)%><%=GetResourceString("Common_Colon") %> </label>
                <%=SPBHtmlHelper.Instance().ShowDropDownList("CompanyPropertys", dicCompanyPropertys.ToDictionary(n => n.Key, n => n.Value.Name), new RouteValueDictionary { { "Class", "tn-dropdownlist" } }, cu.CompanyProperty)%> </div>
              <div class="tn-form-row">
                <label class="tn-form-label"> <%=GetResourceString("Label_CompanyUserFund",applicationID)%><%=GetResourceString("Common_Colon") %> </label>
                <%=SPBHtmlHelper.Instance().ShowDropDownList("Funds", Funds.ToDictionary(n => n.Key, n => n.Value.Name), new RouteValueDictionary { { "Class", "tn-dropdownlist" } }, cu.Fund)%> </div>
              <div class="tn-form-row">
                <label class="tn-form-label"><%=GetResourceString("Label_CompanyUserEmployeeNum",applicationID)%><%=GetResourceString("Common_Colon") %> </label>
                <%=SPBHtmlHelper.Instance().ShowDropDownList("EmployeeCounts", EmployeeCounts.ToDictionary(n => n.Key, n => n.Value.Name), new RouteValueDictionary { { "Class", "tn-dropdownlist" } }, cu.EmployeeNum)%> </div>
              <div class="tn-form-row">
                <label class="tn-form-label"> <%=GetResourceString("Label_CompanyUserLinkman",applicationID)%><%=GetResourceString("Common_Colon") %> </label>
                <input type="text" class="tn-textbox tn-input-long tn-border-gray" id="Linkman" name="Linkman" value="<%=cu.Linkman %>" maxlength="64" />
              </div>
              <div class="tn-form-row">
                <label class="tn-form-label"> <%=GetResourceString("Label_CompanyUserLinkmanDuty",applicationID)%><%=GetResourceString("Common_Colon") %> </label>
                <input type="text" class="tn-textbox tn-input-long tn-border-gray" id="LinkmanDuty" name="LinkmanDuty" value="<%=cu.LinkmanDuty %>" maxlength="64" />
              </div>
              <div class="tn-form-row">
                <label class="tn-form-label"><%=GetResourceString("Label_CompanyUserLinkTel",applicationID)%><%=GetResourceString("Common_Colon") %> </label>
                <input type="text" class="tn-textbox tn-input-long tn-border-gray" id="LinkTel" name="LinkTel" value="<%=cu.LinkTel %>" maxlength="64" />
              </div>
              <div class="tn-form-row">
                <label class="tn-form-label"><%=GetResourceString("Label_CompanyUserFax",applicationID)%><%=GetResourceString("Common_Colon") %> </label>
                <input type="text" class="tn-textbox tn-input-long tn-border-gray" id="Fax" name="Fax" value="<%=cu.Fax %>" maxlength="64" />
              </div>
              <div class="tn-form-row">
                <label class="tn-form-label"><%=GetResourceString("Label_CompanyUserAddress",applicationID)%><%=GetResourceString("Common_Colon") %> </label>
                <input type="text" class="tn-textbox tn-input-long tn-border-gray" id="Address" name="Address" value="<%=cu.Address %>" maxlength="128"/>
                <span class="tn-form-required"></span> </div>
              <div class="tn-form-row">
                <label class="tn-form-label"><%=GetResourceString("Label_CompanyUserIntro",applicationID)%><%=GetResourceString("Common_Colon") %> </label>
                <textarea name="Intro" id="Intro" class="tn-textarea tn-input-long tn-border-gray"><%=cu.Intro %></textarea>
                <span class="tn-text-note"><%=GetResourceString("Description_CompanyUserIntro",applicationID)%></span> </div>
            </div>
          </div>
          <div class="tn-blank10"></div>
          <div class="tn-form-row tn-form-row-verifycode">
            <label class="tn-form-label"><%=GetResourceString("Label_VerifyCode")%><%=GetResourceString("Common_Colon") %> </label>
            <%=SPBHtmlHelper.Instance().ShowVerificationCode("verifyCode",VerificationCodeDifficultyLevel.Hard) %> </div>
          <div class="tn-form-row">
            <label class="tn-form-label"> </label>
            <input type="checkbox" class="tn-checkbox" id="acceptArgeement" name="acceptArgeement" checked="checked" value="<%=GetResourceString("Button_AcceptArgeement",applicationID)%>" />
            <%=string.Format(GetResourceString("Description_Pattern_AcceptedAgreement", applicationID), SPBUrlHelper.Action("Agreement", "ChannelUser"))%> </div>
          <div class="tn-form-row tn-form-row-button"> <%=SPBHtmlHelper.Instance().SubmitButton("createButton", GetResourceString("Action_Register"))%>
            <% if (Request.UrlReferrer != null)
               {%>
            <%=SPBHtmlHelper.Instance().CancelButton(Request.UrlReferrer.AbsoluteUri) %>
            <%} %>
            <%=GetResourceString("Label_ExistingAccount")%><a href="<%=SiteUrls.Instance().Login() %>"><%=GetResourceString("Action_DirectLogin") %></a> </div>
        </div>
      </form>        
    </div>
  </div>
  <span style="display: none" id="messageError"> <%=SPBHtmlHelper.Instance().Icon(IconTypes.CrossCircle,string.Empty,new RouteValueDictionary{{"class"," tn-icon-inline"}}) %></span> <span style="display: none" id="messageSuccess"> <%=SPBHtmlHelper.Instance().Icon(IconTypes.AcceptCircle,string.Empty,new RouteValueDictionary{{"class"," tn-icon-inline"}}) %> </span>
  <script type="text/javascript">
      $(document).ready(function() {
      $("#userName").select();
      $(".tn-collapsible").collapsibleBox();
               $("#userEmail").qtip({content:{prerender: true,text:'<%=GetResourceString("Description_PrivateEmail",applicationID)%>'}});
               $("#userName").qtip({content:{prerender: true,text:'<%=GetResourceString("Description_UserNameSuggest",applicationID)%>'}});
               $("#password").qtip({content:{prerender: true,text:'<%=GetResourceString("Description_PasswordSuggest",applicationID)%>'}});
                $("#Licence").qtip({content:{prerender: true,text:'<%=GetResourceString("Description_CompanyUserLicence",applicationID)%>'}});
         
        
               $("#RegisterForm").validate({
              rules: {
                  userEmail: { required: true,email:true },
                  userName: { required: true,minlength:3 },
                  password: { required: true,minlength:2 },
                  password2: {required: true,equalTo: "#password" },
                  CommonName: { required: true, maxlength: 30 },
                  verifyCode: { required: true },
                  Licence:{required:true,maxlength:64},
                  acceptArgeement: { required: true }
              },
              messages: {
                  userEmail: { required: "<%=GetResourceString("Validate_PrivateEmailRequired",applicationID) %>"},
                   Licence:{required:"请输入营业执照号",maxlength:"营业执照号最长为64位"},
                  userName: { required: "<%=GetResourceString("Validate_UserNameRequired",applicationID) %>",minlength:"用户名最短不能少于3个字符" },
                  password: { required: "<%=GetResourceString("Validate_InputPassword")%>",minlength:"密码最短不能少于4个字符" },
                  password2: { equalTo: "<%=GetResourceString("Validate_NewPassword2_EqualTo",applicationID) %>" },
                  verifyCode: { required: "<%=GetResourceString("Validate_VerifyCode_Required",applicationID) %>" },
                  CommonName: { required: "<%=GetResourceString("Validate_CompanyNameRequired",applicationID) %>", maxlength: "<%=GetResourceString("Validate_UserNameMaxLength",applicationID) %>" },
                  acceptArgeement: { required: "<%=GetResourceString("Validate_AgreementAccept_Required",applicationID) %>" }
              },              
			success: function(label) {
            if(!label.siblings("input").data("qtip"))
				label.html($("#messageSuccess").html());
			}
          });
          
          $("#createButton").click(function() {
              if (!$("#RegisterForm").valid()) {
                  return false;
              }
          });
          
          $("#userEmail").blur(function() {
              if (!$("#RegisterForm").validate().element( "#userEmail"))
                  $('#userEmail').qtip("api").hide();    
              else{   
                  $('#userEmail').qtip("api").disable(true);
                  $.getJSON('<%=SPBUrlHelper.Action("ValidateEmail","ChannelUser") %>', { userEmail: $('#userEmail').attr("value") }, function(data) {
                      if (data.isSuccess) {  
                          $('#userEmail').qtip("api").disable(false).updateContent($("#messageSuccess").html()+data.messageContent).updateStyle("green").show().disable(true);  
                          $("#createButton").removeAttr("disabled");
                      }
                      else {
                          $('#userEmail').qtip("api").disable(false).updateContent($("#messageError").html()+data.messageContent).updateStyle("red").show().disable(true);  
                          $("#createButton").attr("disabled", true);
                      }
                  });
            }                  
          });
          $("#userName").blur(function() {
              if ($("#RegisterForm").validate().element( "#userName"))
              {
                      $('#userName').qtip("api").disable(true);
                      $.getJSON('<%=SPBUrlHelper.Action("ValidateUserName","ChannelUser") %>', { userName: $('#userName').attr("value") }, function(data) {
                      if (data.isSuccess) {
                          $('#userName').qtip("api").disable(false).updateContent($("#messageSuccess").html()+data.messageContent).updateStyle("green").show().disable(true);  
                          $("#createButton").removeAttr("disabled");
                      }
                      else {
                          $('#userName').qtip("api").disable(false).updateContent($("#messageError").html()+data.messageContent).updateStyle("red").show().disable(true);  
                          $("#createButton").attr("disabled", true);
                      }
                  });
               }
              else
                  $('#userName').qtip("api").hide();
          });
          
          $("#password").blur(function() {
              if (!$("#RegisterForm").validate().element( "#password"))
                 $('#password').qtip("api").hide();
              else
              {
                     $('#password').qtip("api").disable(true);
                     $.getJSON('<%=SPBUrlHelper.Action("ValidatePassword","ChannelUser") %>', { password: $('#password').attr("value") }, function(data) {
                      if (data.isSuccess) {
                          $('#password').qtip("api").disable(false).updateContent($("#messageSuccess").html()+data.messageContent).updateStyle("green").show().disable(true);  
                          $("#createButton").removeAttr("disabled");
                      }
                      else {
                          $('#password').qtip("api").disable(false).updateContent($("#messageError").html()+data.messageContent).updateStyle("red").show().disable(true);  
                          $("#createButton").attr("disabled", true);
                      }
                  });
               }
          });
        
      });
    </script>
  
  <%} %>
</asp:content>
