﻿<%@ Page Language="C#" Inherits="SpaceBuilder.Web.ChannelPublicViewPage" %>

<asp:content contentplaceholderid="setPageID" runat="server"> id="CropAvatar" </asp:content>
<asp:content id="wideContent" runat="server" contentplaceholderid="wideContent">
  <spb:Script runat="server" ID="blockUI" Src="~/Utility/jquery/plugin/jquery.blockUI-2.3.3.js" SetExpireDays="30" />
  <spb:Script runat="server" ID="JqueryFormJs" Src="~/Utility/jquery/plugin/jquery.form.min-2.7.3.js" SetExpireDays="30" />
  <spb:Script runat="server" ID="imgareaselect" Src="~/Utility/jquery/plugin/jquery.imgareaselect-0.9.6.js"
        SetExpireDays="30" />
  <%string userDomainName = WebUtils.UrlEncode(Html.GetParameterFromRouteDateOrQueryString("userDomainName"));
    int applicationID = ApplicationIDs.Instance().User(); %>
  <div class="tn-box tn-widget tn-widget-content tn-corner-all spb-register-step">
    <div class="tn-box-content tn-widget-content tn-corner-all">
      <div class="tn-instructions">
        <div class="tn-progress-bar tn-widget-content tn-corner-all">
          <div class="tn-progress-bar-value tn-widget-header tn-corner-left tn-border-tbl" style="width: 24.99%;"> </div>
        </div>
        <ul class="tn-helper-clearfix">
          <li class="tn-step tn-selected"><b class="tn-widget-content tn-widget-header tn-corner-all"> </b><span><a href="javascript:;">1.上传头像</a></span></li>
          <li class="tn-step"><b class="tn-widget-content tn-corner-all"> </b><span><a href="javascript:;">2.填写个人资料</a></span></li>
          <li class="tn-step"><b class="tn-widget-content tn-corner-all"> </b><span><a href="javascript:;">3.看看推荐的好友</a></span></li>
          <li class="tn-step"><b class="tn-widget-content tn-corner-all"> </b><span><a href="javascript:;">4.完成，进入个人中心</a></span></li>
        </ul>
      </div>
      <div class="spb-crop-avatar">
        <div class="tn-text-heading tn-border-gray tn-border-bottom"> <%=GetResourceString("Description_DescriptionForCropClubLogo", ApplicationIDs.Instance().Club())%></div>
        <% if (TempData["StatusMessageType"] != null)
           {
               StatusMessageType messageType = (StatusMessageType)TempData.GetInt("StatusMessageType", (int)StatusMessageType.Error);
               if (messageType == StatusMessageType.Success)
                   Response.Write(SPBHtmlHelper.Instance().StatusMessage(messageType, TempData.GetString("StatusMessageContent", string.Empty), 3000, false));
               else
                   Response.Write(SPBHtmlHelper.Instance().StatusMessage(messageType, TempData.GetString("StatusMessageContent", string.Empty), true));
           }
           TempData["StatusMessageType"] = null;%>
        <div class="spb-avatar-box"> <%=SPBHtmlHelper.Instance().ShowUserAvatar(Html.GetParameterFromRouteDateOrQueryString("userDomainName"), false, HyperLinkTarget._blank, AvatarSizeTypes.Original, false, new RouteValueDictionary {{"id","originalAvatarImage"}}) %> </div>
        <div class="spb-crop-avatar-actions"> <%=SPBHtmlHelper.Instance().LinkButton("corpButton2",GetResourceString("Button_CropSelectRegion",applicationID), "javascript:;", ButtonSizes.Default, HighlightStyles.Primary)%> <%=SPBHtmlHelper.Instance().LinkButton("autoCorpButton2", GetResourceString("Button_AutoCropAvatar", applicationID),"javascript:;", ButtonSizes.Default, HighlightStyles.Primary)%> <%=SPBHtmlHelper.Instance().LinkButton("", GetResourceString("Action_ReUploadAvatar", applicationID), SPBUrlHelper.Action("UploadAvatar", "ChannelUser", new RouteValueDictionary { { "userDomainName", userDomainName } }), ButtonSizes.Default, HighlightStyles.Primary)%>
          <%SiteSettings siteSettings = SiteSettingsManager.GetSiteSettings();%>
          <input id="cropImageWidth" name="cropImageWidth" type="hidden" />
          <input id="cropImageX" name="cropImageX" type="hidden" />
          <input id="cropImageY" name="cropImageY" type="hidden" />
          <input id="autoCrop" name="autoCrop" type="hidden" />
        </div>
      </div>
    </div>
  </div>
  <script type="text/javascript">
        $(document).ready(function() {
           if($('img#originalAvatarImage').width()>=160 && $('img#originalAvatarImage').height()>=160)
           $('img#originalAvatarImage').imgAreaSelect({
            borderColor1:"black",borderColor2:"black",outerColor:"black",outerOpacity:0.6,
            selectionColor: 'white', onSelectEnd: selectionEnd, 
            aspectRatio: "<%=siteSettings.AvatarWidth %> : <%=siteSettings.AvatarHeight %>",
            minWidth:<%=siteSettings.AvatarWidth %>,
            minHeight:<%=siteSettings.AvatarHeight %>,
            x1:0,y1:0,x2:<%=siteSettings.AvatarWidth %>,y2:<%=siteSettings.AvatarHeight %>
            }); 
            
            
            
            
            $("#corpButton2").click(function() { 
                $('#LogoModuleContent').block({ message: '<%=GetResourceString("Message_Loading")%>' });
                $('#autoCrop').attr('value',"false");  
                $.getJSON('<%=Globals.GetFullUrlInFileHandlerSite(Avatars.StorageProviderName,SPBUrlHelper.Action("CropAvatarAction","UserDomainSettings",new RouteValueDictionary{{"userDomainName",userDomainName}})) %>?cropImageWidth='+$('#cropImageWidth').attr("value")+'&cropImageX='+$('#cropImageX').attr("value")+'&cropImageY='+ $('#cropImageY').attr("value")+'&autoCrop='+ $('#autoCrop').attr("value")+'&jsoncallback=?', function(data) {
                            $('#ClubLogoModuleContent').unblock();
                            if (data.Status == 'Success') {
                                alert(data.Message);
                                window.location.href = '<%=SPBUrlHelper.Action("UploadAvatar","ChannelUser",new RouteValueDictionary{{"userDomainName",userDomainName}}) %>';
                            }
                            else {
                                alert(data.Message);
                            }
                        });
             });
             $("#autoCorpButton2").click(function() { 
                $('#LogoModuleContent').block({ message: '<%=GetResourceString("Message_Loading")%>' });
                $('#autoCrop').attr('value',"true");  
                $.getJSON('<%=Globals.GetFullUrlInFileHandlerSite(Avatars.StorageProviderName,SPBUrlHelper.Action("CropAvatarAction","UserDomainSettings",new RouteValueDictionary{{"userDomainName",userDomainName}})) %>?cropImageWidth='+$('#cropImageWidth').attr("value")+'&cropImageX='+$('#cropImageX').attr("value")+'&cropImageY='+ $('#cropImageY').attr("value")+'&autoCrop='+ $('#autoCrop').attr("value")+'&jsoncallback=?', function(data) {
                            $('#ClubLogoModuleContent').unblock();
                            if (data.Status == 'Success') {
                                alert(data.Message);
                                window.location.href = '<%=SPBUrlHelper.Action("UploadAvatar","ChannelUser",new RouteValueDictionary{{"userDomainName",userDomainName}}) %>';
                            }
                            else {
                                alert(data.Message);
                            }
                        });
             });
            
            
            
        });
        
        function selectionEnd(img, selection) 
        {
            $('#cropImageWidth').attr('value',selection.width);
            $('#cropImageX').attr('value',selection.x1);
            $('#cropImageY').attr('value',selection.y1);
        }                    
    </script>
</asp:content>
