﻿<%@ Page Language="C#" Inherits="SpaceBuilder.Web.ChannelPublicViewPage<User>" %>

<asp:content contentplaceholderid="setPageID" runat="server"> id="EditPersonInfo" </asp:content>
<asp:content id="wideContent" runat="server" contentplaceholderid="wideContent">
  <%string userDomainName = Html.GetParameterFromRouteDateOrQueryString("userDomainName");
    PersonUser user = Users.GetUser(userDomainName, false) as PersonUser;
    userDomainName = WebUtils.UrlEncode(userDomainName);
    int applicationID = ApplicationIDs.Instance().User();   %>
  <div class="tn-box tn-widget tn-widget-content tn-corner-all spb-register-step">
    <div class="tn-box-content tn-widget-content tn-corner-all">
      <div class="tn-instructions">
        <div class="tn-progress-bar tn-widget-content tn-corner-all">
          <div class="tn-progress-bar-value tn-widget-header tn-corner-left tn-border-tbl"
                    style="width: 50%;"> </div>
        </div>
        <ul class="tn-helper-clearfix">
          <li class="tn-step"><b class="tn-widget-content tn-widget-header tn-corner-all"> </b><span><a href="<%=SiteUrls.Instance().EnterWizardMode(userDomainName) %>">1.上传头像</a></span></li>
          <li class="tn-step tn-selected"><b class="tn-widget-content tn-widget-header tn-corner-all"> </b><span><a href="javascript:;">2.填写个人资料</a></span></li>
          <li class="tn-step"><b class="tn-widget-content tn-corner-all"> </b><span><a href="javascript:;">3.看看推荐的好友</a></span></li>
          <li class="tn-step"><b class="tn-widget-content tn-corner-all"> </b><span><a href="javascript:;">4.完成，进入个人中心</a></span></li>
        </ul>
      </div>
      <div class="tn-helper-clearfix">
        <form id="EditProfileForm" method="post" action="<%=SPBUrlHelper.Action("UpdateProfile", "ChannelUser", new RouteValueDictionary { { "userDomainName", userDomainName } })%>">
          <input type="hidden" id="type" name="type" value="<%=(int)PersonProfileType.BasicInfo %>" />
          <div class="tn-form tn-label-right">
            <div class="tn-form-row">
              <label class="tn-form-label"> 姓名<%=GetResourceString("Common_Colon") %> </label>
              <input type="text" class="tn-textbox tn-input-long tn-border-gray" id="commonName"
                        name="commonName" value="<%=Formatter.FormatSingleLinePlainTextForEdit(user.CommonName) %>"
                       />
            </div>
            <% if (SiteSettingsManager.GetSiteSettings().EnableNickName)
               { %>
            <div class="tn-form-row">
              <label class="tn-form-label"> <%=GetResourceString("Label_ShowUserNickName",applicationID)%><%=GetResourceString("Common_Colon") %></label>
              <input type="text" class="tn-textbox tn-input-long tn-border-gray" id="nickName"
                            name="nickName" value="<%=Formatter.FormatSingleLinePlainTextForEdit(user.NickName) %>"
                            />
            </div>
            <%} %>
            <div class="tn-form-row">
              <label class="tn-form-label"> <%=GetResourceString("Label_UserAreaCode",applicationID)%><%=GetResourceString("Common_Colon") %></label>
              <% Html.RenderAction<ChannelController>(n => n.Control_AreasDropDownList("nowAreaCode", UserDomainConfiguration.Instance().RootAreaCode, user.NowAreaCode, UserDomainConfiguration.Instance().AreaLevel, "tn-dropdownlist")); %>
              <span class="tn-text-note"> 方便找到你的同城好友哦</span> </div>
            <div class="tn-form-row">
              <label class="tn-form-label"> <%=GetResourceString("Label_UserHomeAreaCode", applicationID)%><%=GetResourceString("Common_Colon") %></label>
              <% Html.RenderAction<ChannelController>(n => n.Control_AreasDropDownList("homeAreaCode", UserDomainConfiguration.Instance().RootAreaCode, user.HomeAreaCode, UserDomainConfiguration.Instance().AreaLevel, "tn-dropdownlist")); %>
              <span class="tn-text-note"> 也许社区里面有你的老乡哦</span> </div>
            <div class="tn-form-row tn-write-tags tn-form-expanded tn-helper-clearfix">
              <label class="tn-form-label"> 我的标签<%=GetResourceString("Common_Colon") %></label>
              <%        
                  ViewData["TagInputName"] = "userTags";
                  ViewData["userTagItemKey"] = UserTagItemKeys.Instance().Person();
                  ViewData["SelectedUserTags"] = UserTagManager.Instance(UserTagItemKeys.Instance().Person()).GetUserTagsOfItem(user.UserID, false);
                    %>
              <%Html.RenderPartial("Controls/UserTagSelector.ascx", ViewData);%>
              <div class="tn-text-note tn-helper-clear">添加描述自己职业、兴趣爱好的词语，  让更多的人找到你，让你找到更多的同类</div>
            </div>
            <div class="tn-form-row">
              <label class="tn-form-label"> <%=GetResourceString("Label_PersonUserBirthday", applicationID)%><%=GetResourceString("Common_Colon") %></label>
              <% DateTime? defaultdate = null;
                 if (user.Birthday > DateTime.MinValue)
                     defaultdate = user.Birthday;
                 Html.RenderAction<ChannelController>(n => n.Control_Datepicker("birthday", 1919, DateTime.Now.Year, defaultdate, false, "tn-textbox tn-input-medium tn-border-gray")); %>
            </div>
            <div class="tn-form-row">
              <% int gender = (int)user.Gender; %>
              <label class="tn-form-label"> <%=GetResourceString("Label_PersonUserGender",applicationID)%><%=GetResourceString("Common_Colon") %></label>
              <div class="tn-input-multiple">
                <input type="radio" class="tn-radiobutton" id="maleItem" name="gender" <%if(gender!=2) Response.Write("checked=\"checked\"");  %>
                            value="1" />
                <label for="maleItem"> <%=GetResourceString("Enum_Genders_Male")%></label>
                <input type="radio" class="tn-radiobutton" id="femaleItem" name="gender" <%if(gender==2) Response.Write("checked=\"checked\"");  %>
                            value="2" />
                <label for="femaleItem"> <%=GetResourceString("Enum_Genders_Female") %></label>
              </div>
              <%=SPBHtmlHelper.Instance().Icon(IconTypes.Lock, "私密信息", new RouteValueDictionary { { "class", "tn-icon-inline" } })%> </div>
            <div class="tn-form-row">
              <label class="tn-form-label"> 职业<%=GetResourceString("Common_Colon") %></label>
              <div class="tn-input-multiple">
                <input type="radio" class="tn-radiobutton" id="atSchool" name="professional" />
                <label for="atSchool"> 我在上学</label>
                <input type="radio" class="tn-radiobutton" id="atWork" name="professional" />
                <label for="atWork"> 我已工作</label>
                <input type="radio" class="tn-radiobutton" id="noSay" name="professional" />
                <label for="noSay"> 我不想说</label>
              </div>
            </div>
            <div id="atSchoolDiv" style="display: none">
              <div class="tn-form-row">
                <label id="schoolLabel" class="tn-form-label"> </label>
                <input type="text" class="tn-textbox tn-input-long tn-border-gray" maxlength="100"
                            id="school" name="school" value="<%=user.School %>" >
                <%=SPBHtmlHelper.Instance().Button("selectSchool","选择学校",ButtonSizes.Default,HighlightStyles.Secondary,null,null)%>
                <input type="hidden" id="schoolID" name="schoolID" value="<%=user.SchoolID %>" />
              </div>
            </div>
            <div id="atWorkDiv" style="display: none">
              <div class="tn-form-row">
                <label class="tn-form-label"> <%=GetResourceString("Label_PersonUserCompanyName",applicationID)%><%=GetResourceString("Common_Colon") %></label>
                <input type="text" class="tn-textbox tn-input-medium tn-border-gray" id="companyName"
                            name="companyName" value="<%=user.CompanyName %>"  />
                &nbsp;&nbsp;&nbsp;<%=SPBHtmlHelper.Instance().Icon(IconTypes.Lock, "私密信息", new RouteValueDictionary { { "class", "tn-icon-inline" } })%> </div>
              <div class="tn-form-row">
                <label class="tn-form-label"> <%=GetResourceString("Label_PersonUserJobSort",applicationID)%><%=GetResourceString("Common_Colon") %></label>
                <%=SPBHtmlHelper.Instance().ShowJobSortsDropDownList("jobSort", new RouteValueDictionary { { "class", "tn-dropdownlist" } }, user.JobSort)%>&nbsp;&nbsp;&nbsp;<%=SPBHtmlHelper.Instance().Icon(IconTypes.Lock, "私密信息", new RouteValueDictionary { { "class", "tn-icon-inline" } })%> </div>
              <div class="tn-form-row">
                <label class="tn-form-label"> <%=GetResourceString("Label_CompanyUserTrade",applicationID)%><%=GetResourceString("Common_Colon") %></label>
                <% Dictionary<int, CodeItem> Trades = CodeItems.GetCodeItems(CodeSetCodes.Instance().Trade()); %>
                <%=SPBHtmlHelper.Instance().ShowDropDownList<int, string>("companyTrade", Trades.ToDictionary(n => n.Key, n => n.Value.GetMultilingualName(CurrentUserLanguage)), new RouteValueDictionary { { "class", "tn-dropdownlist" } }, user.CompanyTrade)%> </div>
            </div>
            <div class="tn-form-row tn-form-row-button">
              <label class="tn-form-label"> </label>
              <%=SPBHtmlHelper.Instance().SubmitButton("postButton", "提交", ButtonSizes.Large, null, null)%> 
              <%=SPBHtmlHelper.Instance().Button("跳过", SPBUrlHelper.Action("AddRecommendUser", "ChannelUser", new RouteValueDictionary { { "userDomainName", userDomainName } }), ButtonSizes.Large, HighlightStyles.Default)%>
             </div>
          </div>
        </form>        
      </div>
    </div>
    <script type="text/javascript">
        $(document).ready(function() {

            $("#EditProfileForm").validate({
                rules: {
                    commonName: { maxBlength: 30 },
                    nickName: { maxBlength: 30 },
                    companyName: { maxBlength: 60 },
                    school: { maxBlength: 60 }
                },
                messages: {
                    commonName: { maxBlength: "最多可输入30个字" },
                    nickName: { maxBlength: "最多可输入30个字" },
                    companyName: { maxBlength: "最多可输入60个字" },
                    school: { maxBlength: "最多可输入60个字" }
                }
            });


            $("#commonName").watermark("输入真实姓名让更多的人找到你");
            $("#nickName").watermark("不想透露姓名，那就写个网名吧");
            $("#companyName").watermark("");

            $("#atSchool").click(function() {
                document.getElementById("schoolLabel").innerHTML = "学校名称：";
                $("#atWork").attr("checked", false);
                $("#noSay").attr("checked", false);
                $("#atSchoolDiv").show();
                $("#atWorkDiv").hide();
                setCookie('professional' + <%=CurrentUser.UserID %>, 'atSchool');
            });
            $("#atWork").click(function() {
                document.getElementById("schoolLabel").innerHTML = "毕业学校：";
                $("#atSchool").attr("checked", false);
                $("#noSay").attr("checked", false);
                $("#atSchoolDiv").show();
                $("#atWorkDiv").show();
                setCookie('professional' + <%=CurrentUser.UserID %>, 'atWork');

            });
            $("#noSay").click(function() {
                $("#atWork").attr("checked", false);
                $("#atSchool").attr("checked", false);
                $("#atSchoolDiv").hide();
                $("#atWorkDiv").hide();
                setCookie('professional' + <%=CurrentUser.UserID %>, 'noSay');
            });
            
            var pf = getCookie('professional' + <%=CurrentUser.UserID %>);
            if(pf) $('#' + pf).click();
            
            $('#selectSchool').click(function(e) {
                e.preventDefault();
                $.nyroModalManual({
                    modal: false,
                    width: 700,
                    height: 400,
                    url: '<%=SPBUrlHelper.Action("Control_SchoolSelector","Channel",new RouteValueDictionary{{"textBoxID","school"},{"hiddenID","schoolID"}}) %>'
                });
                return false;
            });



        });
    </script>
  </div>
</asp:content>
