﻿<%@ Page Language="C#" Inherits="SpaceBuilder.Web.ChannelPublicViewPage" %>

<asp:content contentplaceholderid="setPageID" runat="server"> id="ForgotPassword" </asp:content>
<asp:content contentplaceholderid="wideContentRegion" runat="server">
  <div class="tn-grid">
    <% int appliactionID = ApplicationIDs.Instance().User(); %>
    <div class="tn-box tn-widget tn-widget-content tn-corner-all spb-forget-password">
      <div class="tn-box-content tn-widget-content tn-corner-all">
        <% if (TempData["StatusMessageType"] != null)
           {
               StatusMessageType messageType = (StatusMessageType)TempData.GetInt("StatusMessageType", (int)StatusMessageType.Error);
               Response.Write(SPBHtmlHelper.Instance().StatusMessage(messageType, TempData.GetString("StatusMessageContent", string.Empty)));
               TempData["StatusMessageType"] = null;
           }
           else
           {
               Response.Write(SPBHtmlHelper.Instance().StatusMessage(StatusMessageType.Hint, GetResourceString("Description_GetPasswordBack", appliactionID), false));
           } %>
        <form id="ForgotPasswordForm" action="<%=SPBUrlHelper.Action("RecoverPassword","ChannelUser") %>" method="post" class="tn-helper-reset">
          <div class="tn-form tn-label-right">
            <div class="tn-form-row">
              <label class="tn-form-label"> <%=GetResourceString("Label_UserEamilAddress",appliactionID)%><%=GetResourceString("Common_Colon") %> </label>
              <input name="email" type="text" id="email" class="tn-textbox tn-input-medium tn-border-gray" maxlength="100" />
            </div>
            <div class="tn-form-row tn-form-row-button">
              <label class="tn-form-label"></label>
              <%=SPBHtmlHelper.Instance().SubmitButton("recoverButton", GetResourceString("Button_GetPasswordBack", appliactionID))%> <a href="<%=SiteUrls.Instance().Login() %>">返回登录</a></div>
          </div>
        </form>
      </div>
      <script type="text/javascript">
        $(document).ready(function() {
            $("#ForgotPasswordForm").validate({
                rules: {
                    email: { required: true, email: true }
                },
                messages: {
                    email: { required: "<%=GetResourceString("Validate_PrivateEmailRequired",appliactionID)%>", email: "<%=GetResourceString("Validate_PrivateEmailStyle",appliactionID)%>" }
                }
            });
            $("#recoverButton").click(function() {
                if (!$("#ForgotPasswordForm").valid()) {
                    return false;
                }
            });
        });
    </script>
    </div>
  </div>
</asp:content>
