﻿<%@ Page Language="C#" Inherits="SpaceBuilder.Web.ChannelPublicViewPage" %>

<asp:content contentplaceholderid="setPageID" runat="server"> id="Login" </asp:content>
<asp:content runat="server" contentplaceholderid="wideContentRegion">
  <div class="tn-grid">
  <%   
      string token = Html.GetParameterFromRouteDateOrQueryString("token");
      int applicationID = ApplicationIDs.Instance().User();
      if (string.IsNullOrEmpty(token))
          token = TempData.GetString("token", string.Empty);
      int? accountType = Request.QueryString.Get<int?>("accountType", null);
      string openID = Html.GetParameterFromRouteDateOrQueryString("openID");
      string OauthToken = Html.GetParameterFromRouteDateOrQueryString("OauthToken");
      string OauthTokenSecret = Html.GetParameterFromRouteDateOrQueryString("OauthTokenSecret");
      SiteSettings settings = SiteSettingsManager.GetSiteSettings();
      bool enableSina = !string.IsNullOrEmpty(ConfigurationSettings.AppSettings["Sina_AppKey"]) && !string.IsNullOrEmpty(ConfigurationSettings.AppSettings["Sina_AppSecret"]);
      bool enableQQ = !string.IsNullOrEmpty(ConfigurationSettings.AppSettings["QQ_AppKey"]) && !string.IsNullOrEmpty(ConfigurationSettings.AppSettings["QQ_AppSecret"]);%>
  <div class="tn-box tn-widget tn-widget-content tn-corner-all spb-login">
    <div class="tn-box-content tn-widget-content tn-corner-all">
      <div class="tn-text-heading tn-border-light tn-border-bottom"> <a class="tn-helper-right" href="<%=SiteUrls.Instance().Home() %>"> <%=GetResourceString("Action_GoAround", applicationID)%></a>
        <h4> <%=GetResourceString("Title_UserLogin",applicationID)%></h4>
      </div>
      <div class="tn-widget">
        <% 
            if (TempData["StatusMessageType"] != null)
            {
                StatusMessageType messageType = (StatusMessageType)TempData.GetInt("StatusMessageType", (int)StatusMessageType.Error);
                Response.Write(SPBHtmlHelper.Instance().StatusMessage(messageType, TempData.GetString("StatusMessageContent", string.Empty), true));
                TempData["StatusMessageType"] = null;
            }
            else if (!string.IsNullOrEmpty(Request.QueryString.GetString("returnUrl", string.Empty)))
            {
                if (Request.IsAuthenticated)
                {%>
        <div class="tn-cue-highlight tn-corner-all tn-message-box"> <span class="tn-helper-left"> <%=SPBHtmlHelper.Instance().Icon(IconTypes.Exclamation) %></span>
          <div class="tn-helper-flowfix"> <%= GetResourceString("Message_NoEnoughAuthority", applicationID)%></div>
        </div>
        <% }
                else
                {%>
        <div class="tn-cue-highlight tn-corner-all tn-message-box"> <span class="tn-helper-left"> <%=SPBHtmlHelper.Instance().Icon(IconTypes.Exclamation) %></span>
          <div class="tn-helper-flowfix"> <%= GetResourceString("Message_LoginRequire", applicationID)%></div>
        </div>
        <%}
            }
                %>
      </div>
      <form id="loginForm" name="loginForm" action="<%=SPBUrlHelper.Action("LoginAction","ChannelUser",new RouteValueDictionary{{"loginInModal",false},{"returnUrl",WebUtils.UrlEncode(ViewData.GetString("returnUrl",""))},{"token",token},{"accountType",accountType},{"openID",openID}, { "OauthToken", OauthToken }, { "OauthTokenSecret", OauthTokenSecret }}) %>" method="post">
        <div class="tn-form tn-label-right">
          <div class="tn-form-row">
            <label for="userName" class="tn-form-label"> <%=GetResourceString("Label_UserCount",applicationID)%><%=GetResourceString("Common_Colon") %></label>
            <input type="text" class="tn-textbox tn-input-medium tn-border-gray" id="userName"
                        name="userName" maxlength="64" value="<%=TempData.GetString("userName",string.Empty) %>" />
          </div>
          <div class="tn-form-row">
            <label for="password" class="tn-form-label"> <%=GetResourceString("Common_Password")%><%=GetResourceString("Common_Colon") %></label>
            <input type="password" class="tn-textbox tn-input-medium tn-border-gray" id="password"
                        name="password" maxlength="64" value="<%=TempData.GetString("password",string.Empty) %>" />
          </div>
          <div class="tn-form-row tn-form-row-verifycode">
            <label for="verifyCode" class="tn-form-label"> <%=GetResourceString("Label_VerifyCode")%><%=GetResourceString("Common_Colon") %></label>
            <%=SPBHtmlHelper.Instance().ShowVerificationCode("verifyCode", VerificationCodeDifficultyLevel.Normal,true)%> </div>
          <div class="tn-form-row">
            <label class="tn-form-label"> </label>
            <input type="checkbox" id="autoLogin" name="autoLogin" value="true" class="tn-checkbox">
            <%=GetResourceString("Label_RememberPassword",applicationID)%>
            </input>
            <a href="<%=SiteUrls.Instance().ForgotPassword() %>"> <%=GetResourceString("Action_GetPasswordBack",applicationID)%></a></div>
          <div class="tn-form-row tn-form-row-button">
            <label class="tn-form-label"> </label>
            <%=SPBHtmlHelper.Instance().SubmitButton(string.Empty, GetResourceString("Button_UserLogin", applicationID))%>
            <%
                UserTypes regUserType = TempData.Get<UserTypes>("regUserType", UserTypes.PersonUser);
                if (settings.RegistrationMode == RegistrationModes.EnableAll)
                {
                    if (regUserType == UserTypes.PersonUser)
                    {
                    %>
            <%=GetResourceString("Description_NoAccountDescription",applicationID)%><a href="<%=SiteUrls.Instance().UserRegister() %>"><%=GetResourceString("Action_RegisterAccount",applicationID)%></a>
            <%
                }
                    else
                    {
                    %>
            <%=GetResourceString("Description_NoAccountDescription",applicationID)%><a href="<%=SPBUrlHelper.Action("CompanyRegister","ChannelUser") %>"><%=GetResourceString("Action_RegisterAccount",applicationID)%></a>
            <%
                }
                }                             
                    %>
          </div>
        </div>
        <%--<div class="tn-form-row tn-form-row-button">
                <label class="tn-form-label">
                </label>
                <a href="<%=SiteUrls.Instance().Home() %>">
                    <%=settings.SiteName %></a></b>&nbsp; &nbsp;<%=GetResourceString("Description_UserAccountDescription",applicationID)%>
            </div>--%>
      </form>
      <%if (enableQQ || enableSina)
        { %>
      <div class="spb-third-id-login tn-border-gray tn-border-top">
        <strong>使用第三方账号登录</strong>
        <p class="tn-helper-clearfix">
        <%if (enableSina)
          { %>
            <a href="javascript:;" onclick="openSina();return false;" class="tn-img-sprite spb-third-id-btn spb-third-id-sina">
                使用新浪微博账号登录</a>
                <%}
          if (enableQQ)
          {%>
                <a href="javascript:;" onclick="openQQ();return false;" class="tn-img-sprite spb-third-id-btn spb-third-id-qq">
                    使用QQ号登录</a>
                  <%}%></p>
        </div>
        <%} %>
    </div>
  </div>
  <script type="text/javascript">

        $(document).ready(function() {
            $("#userName").watermark("<%=GetResourceString("Validate_PleaseUserNameOrEmail_Required",applicationID)%>").focus();
            $("#verifyCode").watermark("<%=GetResourceString("Title_NotCaseSensitive",applicationID)%>");
            $("#loginForm").validate({
                rules: {
                    userName: "required",
                    password: "required",
                    verifyCode: "required"
                },
                messages: {
                    userName: "<%=GetResourceString("Validate_PleaseUserNameOrEmail_Required",applicationID)%>",
                    password: "<%=GetResourceString("Validate_PleasePassword_Required",applicationID)%>",
                    verifyCode: "<%=GetResourceString("Validate_FillInValidate",applicationID)%>"
                },
                showErrors: $.dialog.showErrors,
                onfocusout: false,
                onclick: false,
                onkeyup:false,
                onsubmit:false
            });

            $("#loginForm").submit(function() {
                if (!$("#loginForm").valid()) {
                    return false;
                }
            });
        });
            function openQQ() {
            var A = window.open("<%=SiteUrls.Instance().LoginToQQ() %>", "TencentLogin", "width=600,height=500,menubar=0,scrollbars=0, status=1,titlebar=0,toolbar=0,location=1");
        }
            function openSina() {
            var B = window.open("<%=SiteUrls.Instance().LoginToSina() %>", "SinaLogin", "width=600,height=500,menubar=0,scrollbars=0, status=1,titlebar=0,toolbar=0,location=1");
        }

    </script>
   </div>
</asp:content>
