﻿<%@ Page Language="C#" Inherits="SpaceBuilder.Web.ChannelPublicViewPage" %>

<asp:content contentplaceholderid="setPageID" runat="server"> id="Register" </asp:content>
<asp:content runat="server" contentplaceholderid="wideContentRegion">
  <div class="tn-grid">
 <spb:Script runat="server" ID="password" Src="~/Utility/jquery/plugin/jquery.validate.password.js"
        SetExpireDays="30" />
  <%int applicationID = ApplicationIDs.Instance().User();
    bool enableSina = !string.IsNullOrEmpty(ConfigurationSettings.AppSettings["Sina_AppKey"]) && !string.IsNullOrEmpty(ConfigurationSettings.AppSettings["Sina_AppSecret"]);
    bool enableQQ = !string.IsNullOrEmpty(ConfigurationSettings.AppSettings["QQ_AppKey"]) && !string.IsNullOrEmpty(ConfigurationSettings.AppSettings["QQ_AppSecret"]);%>
  <div class="tn-box tn-widget tn-widget-content tn-corner-all spb-register">
    <div class="tn-box-content tn-widget-content tn-corner-all">
      <div class="tn-text-heading tn-border-light tn-border-bottom">
        <%--<h3 class="tn-helper-reset tn-helper-right">
          <% if (!SiteSettingsManager.GetSiteSettings().IsCloseCompanyUser)
             { %>
          <a href="<%=SPBUrlHelper.Action("CompanyRegister","ChannelUser") %>"><%=GetResourceString("Title_CompanyUserRegister",applicationID)%></a>
          <%} %>
        </h3>--%>
        <h3 class="tn-helper-reset"><%=GetResourceString("Title_PersonUserRegister",applicationID)%></h3>
      </div>

      <div class="spb-login-directly tn-border-gray tn-border-left">
              <div class="spb-have-id">
                <p>已有帐号？</p>
                <p><span class="tn-button tn-button-default">
                <span class="tn-first-child">
                <a class="tn-button-text" href="<%=SiteUrls.Instance().Login() %>">现在登录</a></span></span></p>
              </div>
              <%if (enableSina || enableQQ)
                { %>
              <div class="spb-third-id-login"><strong>使用第三方账号登录</strong>
                <p>
                <%if (enableSina)
                  { %>
                <a href="javascript:;" onclick="openSina();return false;" class="tn-img-sprite spb-third-id-btn spb-third-id-sina">
                    使用新浪微博账号登录</a>
                    <%}
                  if (enableQQ)
                  { %> <a href="javascript:;" onclick="openQQ();return false;" class="tn-img-sprite spb-third-id-btn spb-third-id-qq">
                    使用QQ号登录</a>
                    <%} %>
                    </p>
              </div>
              <%} %>
            </div>

      <form id="RegisterForm"  class="tn-helper-flowfix" action="<%=SPBUrlHelper.Action("RegisterAction","ChannelUser",new RouteValueDictionary{{"token",Html.GetParameterFromRouteDateOrQueryString("Token")}}) %>" method="post">
        <% if (TempData["StatusMessageType"] != null)
           {
               StatusMessageType messageType = (StatusMessageType)TempData.GetInt("StatusMessageType", (int)StatusMessageType.Error);
               Response.Write(SPBHtmlHelper.Instance().StatusMessage(messageType, TempData.GetString("StatusMessageContent", string.Empty)));
           }
           PersonUser personUser = TempData.Get<PersonUser>("personUser", new PersonUser());
           SiteSettings setting = SiteSettingsManager.GetSiteSettings();
             %>
        <div class="tn-form tn-label-right">
           <div class="tn-form-row spb-reg-id">
            <label class="tn-form-label"> <%=GetResourceString("Label_ShowUserName",applicationID)%><%=GetResourceString("Common_Colon") %> </label>
            <span class="spb-reg-input">
            <input type="text" class="tn-textbox tn-input-long tn-border-gray" id="userName" name="userName" value="<%=personUser.UserName %>"  />
            </span>
            <div class="spb-reg-msg">
            <div id="usernameMsgClass">
          
<span id="usernameIconMsg"></span>
   <p id="usernameMessageNormal"></p> 
            </div>
            </div>
          </div>
          <div class="tn-form-row spb-reg-password">
            <label class="tn-form-label"> <%=GetResourceString("Common_Password")%><%=GetResourceString("Common_Colon") %> </label>
            <span class="spb-reg-input">
            <input type="password" id="password" name="password" class="tn-textbox tn-input-long tn-border-gray password" maxlength="64" onfocus='$("#passwordStrong").attr("style","visibility: visible; ");' />
            </span>
              <div class="spb-reg-msg">
            <div id="passwordMsgClass">
    <span id="passwordIconMsg"></span>
 <p id="passwordMessageNormal"></p> 
        </div>
        </div>
          </div>
          <div id="passwordStrong" style="visibility: hidden;" class="tn-form-row spb-password-meter">
            <div class="password-meter">
              <div class="password-meter-message"> &nbsp;</div>
              <div class="password-meter-bg">
                <div class="password-meter-bar"> </div>
              </div>
            </div>
          </div>
          <div class="tn-form-row spb-reg-confirm">
            <label class="tn-form-label"> <%=GetResourceString("Label_ConfirmPassword",applicationID)%><%=GetResourceString("Common_Colon") %> </label>
            <span class="spb-reg-input">
            <input type="password" id="password2" name="password2" class="tn-textbox tn-input-long tn-border-gray" maxlength="64" />
            </span>
             <div class="spb-reg-msg">
            <div id="password2MsgClass">
<span id="password2IconMsg"></span>
  <p id="password2MessageNormal"></p>
        </div>
        </div> 
          </div>
           <div class="tn-form-row spb-reg-email">
            <label class="tn-form-label"> <%=GetResourceString("Label_UserEamilAddress",applicationID)%><%=GetResourceString("Common_Colon") %> </label>
            <span class="spb-reg-input">
            <input type="text" id="userEmail" name="userEmail" class="tn-textbox tn-input-long tn-border-gray" value="<%=personUser.PrivateEmail %>" maxlength="100"  />
            </span>
             <div class="spb-reg-msg">
            <div id="emailMsgClass">
         <span id="emailIconMsg"></span>

          <span id="emailMessageNormal"></span> 
            </div>
            </div>
          </div>
         
          <div class="tn-form-row tn-form-row-verifycode">
            <label class="tn-form-label"> <%=GetResourceString("Label_VerifyCode")%><%=GetResourceString("Common_Colon") %> </label>
            <span class="spb-reg-input">
            <%=SPBHtmlHelper.Instance().ShowVerificationCode("verifyCode", VerificationCodeDifficultyLevel.Hard,true)%> 
            </span>
             <div class="spb-reg-msg">
            <div id="verifyCodeMsgClass"  style="display: none">
             <%=SPBHtmlHelper.Instance().Icon(IconTypes.Alert, string.Empty, new RouteValueDictionary { { "class", "tn-icon-inline" } })%> 
             <span id="verifyCodeMessageNormal"></span> 
             </div>
             </div>
            
            </div>
          <div class="tn-form-row spb-reg-agreement">
            <span class="spb-reg-input">
            <input class="tn-checkbox" type="checkbox" id="acceptArgeement" name="acceptArgeement" checked="checked" value="<%=GetResourceString("Button_AcceptArgeement",applicationID)%>" />
           <label for="acceptArgeement">我已看过并完全同意  <%//=string.Format(GetResourceString("Description_Pattern_AcceptedAgreement", applicationID), SPBUrlHelper.Action("Control_Agreement", "ChannelUser"))%> </label>
            <a href="<%=SPBUrlHelper.Action("Control_Agreement", "ChannelUser") %>" id="seeArgeement" class="tn-action-text">
            《会员服务条款》</a>
            </span>
             <div class="spb-reg-msg">
            <div style="display: none"  id="acceptArgeementMsgClass">
             <%=SPBHtmlHelper.Instance().Icon(IconTypes.Alert, string.Empty, new RouteValueDictionary { { "class", "tn-icon-inline" } })%> 
             <span id="acceptArgeementMessageNormal"></span> 
             </div>
             </div>
            </div>
          <div class="tn-form-row tn-form-row-button">
            <span class="tn-button-large tn-button tn-button-primary">
                <span class="tn-first-child">
                    <button type="submit"  id="createButton" class="tn-button-text"><span id="createButton1"><%=GetResourceString("Action_Register")%></span></button>
                </span>
            </span>
            <% if (Request.UrlReferrer != null)
               {%>
            <%=SPBHtmlHelper.Instance().CancelButton(Request.UrlReferrer.AbsoluteUri) %>
            <%} %>
          </div>
        </div>
      </form>
    </div>
  </div>

   <script type="text/javascript">
       $.validator.passwordRating.messages = {
           "similar-to-username": "Zu ähnlich zum Benutzername",
           "too-short": "太短",
           "very-weak": "很弱",
           "weak": "弱",
           "good": "好",
           "strong": "强"
       }

       $(document).ready(function() {
       
       
       
       
        $("#seeArgeement").dialog({
            id: 'seeArgeementDialog',
            title:false,
            width: 400,
            height:350,
            closeFn:function(){
               $('#acceptArgeement').attr('checked',true);
            }
        });
       
      
            <%if (TempData["StatusMessageType"] == null) { Response.Write("$('#userName').attr('value', '');"); } %>
           $("#password").attr("value", "");

           $("#RegisterForm").validate();
           $("#userEmail").focus(function() {
               $("#emailMsgClass").show();
               $("#emailMsgClass").attr("class", "tn-cue-highlight tn-message-box");
               $("#emailMessageNormal").text('<%=GetResourceString("Description_PrivateEmail",applicationID)%>');
               $("#emailIconMsg").attr("class", "tn-icon tn-icon-exclamation");
           });

           $("#userEmail").blur(function() {
               if ($('#userEmail').val()) {
                   $.getJSON('<%=SPBUrlHelper.Action("ValidateEmail","ChannelUser") %>', { userEmail: $('#userEmail').val() }, function(data) {
                       $("#emailMessageNormal").html(data.messageContent);
                       if (data.isSuccess) {
                           $("#emailMsgClass").attr("class", "tn-cue-success tn-message-box");
                           $("#emailIconMsg").attr("class", "tn-icon tn-icon-accept-circle");
                           $("#createButton").removeAttr("disabled");
                       }
                       else {
                           $("#emailMsgClass").attr("class", "tn-cue-error tn-message-box");
                           $("#emailIconMsg").attr("class", "tn-icon tn-icon-alert");
                           $("#createButton").attr("disabled", true);
                       }
                   });
               }
               else {
                   $("#emailMsgClass").hide();
                   $("#emailMessageNormal").text('');
               }
           });


           $("#userName").focus(function() {
               $("#usernameMsgClass").show();
               $("#usernameMsgClass").attr("class", "tn-cue-highlight tn-message-box");
               $("#usernameIconMsg").attr("class", "tn-icon tn-icon-exclamation");
               $("#usernameMessageNormal").text('<%=GetResourceString("Description_UserNameSuggest",applicationID)%>');
           });
           $("#userName").blur(function() {
               if ($('#userName').val()) {
                   $.getJSON('<%=SPBUrlHelper.Action("ValidateUserName","ChannelUser") %>', { userName: $('#userName').val() }, function(data) {
                       $("#usernameMessageNormal").text(data.messageContent);
                       if (data.isSuccess) {
                           $("#usernameMsgClass").attr("class", "tn-cue-success tn-message-box");
                           $("#usernameIconMsg").attr("class", "tn-icon tn-icon-accept-circle");
                           $("#createButton").removeAttr("disabled");
                       }
                       else {
                           $("#usernameMsgClass").attr("class", "tn-cue-error tn-message-box");
                           $("#usernameIconMsg").attr("class", "tn-icon tn-icon-alert");
                           $("#createButton").attr("disabled", true);
                       }
                   });
               }
               else {
                   $("#usernameMsgClass").hide();
                   $("#usernameMessageNormal").text('');
               }
           });


           $("#password").focus(function() {
               $("#password").attr("value", "");
               $("#passwordMsgClass").show();
               $("#passwordMsgClass").attr("class", "tn-cue-highlight tn-message-box");
               $("#passwordIconMsg").attr("class", "tn-icon tn-icon-exclamation");
               $("#passwordMessageNormal").text('<%=GetResourceString("Description_PasswordSuggest",applicationID)%>');
           });

           $("#password").blur(function() {
               if ($('#password').val()) {
                   $.getJSON('<%=SPBUrlHelper.Action("ValidatePassword","ChannelUser") %>', { password: $('#password').val() }, function(data) {
                       $("#passwordMessageNormal").text(data.messageContent);
                       if (data.isSuccess) {
                           $("#passwordMsgClass").attr("class", "tn-cue-success tn-message-box");
                           $("#passwordIconMsg").attr("class", "tn-icon tn-icon-accept-circle");
                           $("#createButton").removeAttr("disabled");
                       }
                       else {
                           $("#passwordMsgClass").attr("class", "tn-cue-error tn-message-box");
                           $("#passwordIconMsg").attr("class", "tn-icon tn-icon-alert");
                           $("#createButton").attr("disabled", true);
                       }
                   });
               } else {
                   $("#passwordMsgClass").hide();
                   $("#passwordMessageNormal").text('');
               }
               if ($("#password2").val() && this.value != $("#password2").val()) {
                   $("#password2MsgClass").attr("class", "tn-cue-error tn-message-box");
                   $("#password2IconMsg").attr("class", "tn-icon tn-icon-alert");
                   $("#password2MessageNormal").text('<%=GetResourceString("Validate_NewPassword2_EqualTo",applicationID) %>');
                   $("#createButton").attr("disabled", true);
               }
           });
           $("#password2").blur(function() {
               if (this.value == $("#password").val()) {
                   if ($("#password2").val()) {
                       $("#password2MsgClass").attr("class", "");
                       $("#password2IconMsg").attr("class", "tn-icon tn-icon-accept-circle");
                       $("#password2MessageNormal").text('');
                       $("#createButton").removeAttr("disabled");
                   }
                   else
                       return;
               }
               else {
                   $("#password2MsgClass").attr("class", "tn-cue-error tn-message-box");
                   $("#password2IconMsg").attr("class", "tn-icon tn-icon-alert");
                   $("#password2MessageNormal").text('<%=GetResourceString("Validate_NewPassword2_EqualTo",applicationID) %>');
                   $("#createButton").attr("disabled", true);
               }
           });

           $("#verifyCode").focus(function() {
               $("#verifyCodeMsgClass").hide();
               $("#verifyCodeMessageNormal").text('');

           });

           $("input[name=acceptArgeement]").focus(function() {
               $("#acceptArgeementMsgClass").hide();
           });

           $("#createButton").click(function() {
               var isReight = true;

               if (!$('#userName').val()) {
               
                   $("#usernameMsgClass").show();
                   $("#usernameMsgClass").attr("class", "tn-cue-error tn-message-box");
                   $("#usernameIconMsg").attr("class", "tn-icon tn-icon-alert");
                   $("#usernameMessageNormal").text('<%=GetResourceString("Validate_UserNameRequired",applicationID) %>');
                   isReight = false;
               };

               if (!$('#userEmail').val()) {
                   $("#emailMsgClass").show();
                   $("#emailMsgClass").attr("class", "tn-cue-error tn-message-box");
                   $("#emailIconMsg").attr("class", "tn-icon tn-icon-alert");
                   $("#emailMessageNormal").text('<%=GetResourceString("Validate_PrivateEmailRequired",applicationID) %>');
                   isReight = false;
               };

               if (!$('#password').val()) {
                   $("#passwordMsgClass").show();
                   $("#passwordMsgClass").attr("class", "tn-cue-error tn-message-box");
                   $("#passwordIconMsg").attr("class", "tn-icon tn-icon-alert");
                   $("#passwordMessageNormal").text('<%=GetResourceString("Validate_InputPassword")%>');
                   isReight = false;
               };
               if ($("#password").val() != $("#password2").val()) {
             
                   $("#password2MsgClass").attr("class", "tn-cue-error tn-message-box");
                   $("#password2IconMsg").attr("class", "tn-icon tn-icon-alert");
                   $("#password2MessageNormal").text('<%=GetResourceString("Validate_NewPassword2_EqualTo",applicationID) %>');
                   isReight = false;
               }

               if (!$('#verifyCode').val()) {
                   $("#verifyCodeMsgClass").show();
                   $("#verifyCodeMsgClass").attr("class", "tn-cue-error tn-message-box");
                   $("#verifyCodeMessageNormal").text('<%=GetResourceString("Validate_VerifyCode_Required",applicationID) %>');
                   isReight = false;
               };

               if (!acceptArgeementCheck()) {
                   $("#acceptArgeementMsgClass").attr("class", "tn-cue-error tn-message-box");
                   $("#acceptArgeementMsgClass").show();
                   $("#acceptArgeementMessageNormal").text('<%=GetResourceString("Validate_AgreementAccept_Required",applicationID) %>');
                   isReight = false;
               }

               if (!isReight) {
                   return false;
               }
               else {
                   document.getElementById("createButton1").innerHTML = "处理中";
               }
           });

       });
       function acceptArgeementCheck() {
           if ($("input[name=acceptArgeement]:checked").length > 0)
               return true;
       };
           function openQQ() {
        var A = window.open("<%=SiteUrls.Instance().LoginToQQ() %>", "TencentLogin", "width=600,height=500,menubar=0,scrollbars=0, status=1,titlebar=0,toolbar=0,location=1");
    }
    function openSina() {
        var B = window.open("<%=SiteUrls.Instance().LoginToSina() %>", "SinaLogin", "width=600,height=500,menubar=0,scrollbars=0, status=1,titlebar=0,toolbar=0,location=1");
    }

    </script>
    </div>
   </asp:content>
