﻿<%@ Page Language="C#" Inherits="SpaceBuilder.Web.ChannelPublicViewPage" %>

<asp:content contentplaceholderid="setPageID" runat="server">
    id="ResetPassword"
</asp:content>
<asp:content contentplaceholderid="wideContentRegion" runat="server">

  <div class="tn-grid">
<spb:Script runat="server" ID="qtip" Src="~/Utility/jquery/plugin/jquery.qtip-1.0.0-rc3.js"
        SetExpireDays="30" />
<% int applicationID = ApplicationIDs.Instance().User(); %>
 <div class="tn-box tn-widget tn-widget-content tn-corner-all">
          <div class="tn-box-content tn-widget-content tn-corner-bottom">
    <form id="ResetPasswordForm" action="<%=SPBUrlHelper.Action("DealResetPassword","ChannelUser",new RouteValueDictionary{{"userName",Request.QueryString.GetString("userName",string.Empty)},{"token",Request.QueryString.GetString("token",string.Empty)}}) %>"
    method="post" class="tn-helper-reset">
     <div class="tn-blank10"></div>
   <div class="tn-form tn-label-right">
     <div class="tn-form-row">
         <label class="tn-form-label"></label>
            <%
                StatusMessageData statusMessageData = ViewData.Get<StatusMessageData>("StatusMessageData", null);
                if (statusMessageData == null)
                    statusMessageData = TempData.Get<StatusMessageData>("StatusMessageData", null);
                if (statusMessageData != null)
                {
                    Response.Write(SPBHtmlHelper.Instance().StatusMessage(statusMessageData));
                    statusMessageData = null;
                }
                else
                {
                    Response.Write(SPBHtmlHelper.Instance().StatusMessage(StatusMessageType.Hint, GetResourceString("Description_AfterResetPassword", applicationID)));
                }
            %>
            </div>
 <div class="tn-form-row">
         <label class="tn-form-label">
                    <%=GetResourceString("Label_ShowUserName",applicationID) %><%=GetResourceString("Common_Colon") %></label>
                <input name="textfield4" type="text" class="tn-textbox tn-input-long tn-border-gray" disabled="disabled" value="<%=Request.QueryString.GetString("userName",string.Empty) %>" />
            </div>
             <div class="tn-form-row">
         <label class="tn-form-label">
                    <%=GetResourceString("Label_NewPassword",applicationID)%><%=GetResourceString("Common_Colon") %></label>
                <input type="password" id="password" name="password" class="tn-textbox tn-input-long tn-border-gray" maxlength="64" title="<%=GetResourceString("Description_PasswordSuggest",applicationID) %>" />
                <span id="passwordMessageError">
                    <img src="<%=Globals.GetFullUrlInResourceSite("~/Themes/Shared/Styles/Icons/exclamation.gif") %>" />
                </span><span id="passwordMessageSuccess">
                    <img src="<%=Globals.GetFullUrlInResourceSite("~/Themes/Manages/Default/Appearances/Default/Images/icon_true.gif") %>" />
                </span><span id="passwordMessageNormal"></span>
            </div>
            
             <div class="tn-form-row">
         <label class="tn-form-label">
                    确认新密码<%=GetResourceString("Common_Colon") %></label>
                <input type="password" id="password2" name="password2" class="tn-textbox tn-input-long tn-border-gray" maxlength="64" />
            </div>
            <div class="tn-form-row tn-form-row-button">
                <label class="tn-form-label"></label>
                <%=SPBHtmlHelper.Instance().SubmitButton("resetButton",GetResourceString("Button_UpdateUserPassword",applicationID)) %>
                   <% if (Request.UrlReferrer != null)
                      {
                 %>
                   <%=SPBHtmlHelper.Instance().CancelButton(Request.UrlReferrer.AbsoluteUri)%>
              <%} %>
            </div>
    </div>
    </form>
</div>
    <script type="text/javascript">
        $(document).ready(function() {
            $("#ResetPasswordForm").validate({
                rules: {
                    password: { required: true },
                    password2: { equalTo: "#password" }
                },
                messages: {
                    password: { required: "<%=GetResourceString("Validate_InputPassword")%>" },
                    password2: { equalTo: "<%=GetResourceString("Validate_NewPassword2_EqualTo",applicationID)%>" }
                }
            });
            $("#resetButton").click(function() {
                if (!$("#ResetPasswordForm").valid()) {
                    return false;
                }
            });
            $("#passwordMessageSuccess").hide();
            $("#passwordMessageError").hide();
            $("#password").blur(function() {
                if ($('#password').attr("value"))
                    $.get('<%=SPBUrlHelper.Action("ValidatePassword","ChannelUser") %>', { password: $('#password').attr("value") }, function(data) {
                        data = eval("(" + data + ")");
                        $("#passwordMessageNormal").text(data.MessageContent.toString());
                        if (data.IsSuccess == "True") {
                            $("#passwordMessageSuccess").show();
                            $("#passwordMessageError").hide();
                        }
                        else {
                            $("#passwordMessageError").show();
                            $("#passwordMessageSuccess").hide();
                        }
                    });
            });
            
            	 $('#password,#password2[title]').qtip({
                position: {
                    corner: {
                        target: 'rightMiddle',
                        tooltip: 'leftMiddle'
                    }
                },
                show: "focusin",
                 hide: 'focusout',
                style: {
                    name: 'cream',
                    tip: true
                }
            });
        });
    </script>
</div>
</div>
</asp:content>
