﻿<%@ Page Language="C#" Inherits="SpaceBuilder.Web.ChannelPublicViewPage" %>

<asp:content contentplaceholderid="setPageID" runat="server"> id="ThirdRegister" </asp:content>
<asp:content runat="server" contentplaceholderid="wideContentRegion">
  <div class="tn-grid">
 <spb:Script runat="server" ID="password" Src="~/Utility/jquery/plugin/jquery.validate.password.js"
        SetExpireDays="30" />
  <%     int applicationID = ApplicationIDs.Instance().User();
         int? accountType = Request.QueryString.Get<int?>("accountType", null);
         string openID = Html.GetParameterFromRouteDateOrQueryString("openID");
         string OauthToken = Html.GetParameterFromRouteDateOrQueryString("OauthToken");
         string OauthTokenSecret = Html.GetParameterFromRouteDateOrQueryString("OauthTokenSecret");
         string figureurl = ViewData.GetString("Figureurl", string.Empty);
         string accountName = "QQ";
         if (accountType == AccountTypes.Instance().SinaWeibo())
             accountName = "新浪微博";
  %>
  <div class="tn-box tn-widget tn-widget-content tn-corner-all spb-register">
    <div class="tn-box-content tn-widget-content tn-corner-all">
      <div class="tn-text-heading tn-border-light tn-border-bottom">         
        <h3 class="tn-helper-reset">完善账号资料，下次直接使用<%=accountName %>账号登录</h3>
      </div>
      <% if (TempData["StatusMessageType"] != null)
         {
             StatusMessageType messageType = (StatusMessageType)TempData.GetInt("StatusMessageType", (int)StatusMessageType.Error);
             Response.Write(SPBHtmlHelper.Instance().StatusMessage(messageType, TempData.GetString("StatusMessageContent", string.Empty)));
         } %>
      <div class="spb-login-directly tn-border-gray tn-border-left">
              <div class="spb-have-id">
                <p>已有帐号？</p>
                <p><span class="tn-button tn-button-large tn-button-default">
                <span class="tn-first-child">
                <a class="tn-button-text" id="loginInModalButton" href="<%=SPBUrlHelper.Action("LoginInModal","ChannelUser",new RouteValueDictionary{{"accountType",accountType},{"openID",openID}, { "OauthToken", OauthToken }, { "OauthTokenSecret", OauthTokenSecret }}) %>">立即绑定</a>
                </span>
                </span>
                </p>
              </div>
      </div>
      <form id="RegisterForm"  class="tn-helper-flowfix" action="<%=SPBUrlHelper.Action("ThirdRegisterAction","ChannelUser",new RouteValueDictionary{{"accountType",accountType},{"openID",openID}, { "OauthToken", OauthToken }, { "OauthTokenSecret", OauthTokenSecret }}) %>" method="post">
        <%
            PersonUser personUser = TempData.Get<PersonUser>("personUser", new PersonUser());
            string nickName = ViewData.GetString("Nickname", string.Empty);
            if (string.IsNullOrEmpty(personUser.UserName) && !string.IsNullOrEmpty(nickName))
                personUser.UserName = nickName;
            SiteSettings setting = SiteSettingsManager.GetSiteSettings();
             %>
        <div class="tn-form tn-label-right">
           <div class="tn-form-row spb-reg-id">
            <label class="tn-form-label"> <%=GetResourceString("Label_ShowUserName",applicationID)%><%=GetResourceString("Common_Colon") %> </label>
            <span class="spb-reg-input">
            <input type="text" class="tn-textbox tn-input-long tn-border-gray" id="userName" name="userName" value="<%=personUser.UserName %>" maxlength="25" />
            </span>
            <div class="spb-reg-msg">
            <div id="usernameMsgClass">
            <span id="usernameIconMsg"></span>
               <p id="usernameMessageNormal"></p> 
            </div>
            </div>
          </div>
           <div class="tn-form-row spb-reg-email">
            <label class="tn-form-label"> <%=GetResourceString("Label_UserEamilAddress",applicationID)%><%=GetResourceString("Common_Colon") %> </label>
            <span class="spb-reg-input">
            <input type="text" id="userEmail" name="userEmail" class="tn-textbox tn-input-long tn-border-gray" value="<%=personUser.PrivateEmail %>" maxlength="100"  />
            </span>
             <div class="spb-reg-msg">
            <div id="emailMsgClass">
         <span id="emailIconMsg"></span>

          <span id="emailMessageNormal"></span> 
            </div>
            </div>
          </div>
          <div class="tn-form-row">
                  <label class="tn-form-label">头像：</label>
                  <input type="checkbox" checked="checked" name="useAvatar" value="true" class="tn-checkbox"/>
                  使用<%=accountName %>上的头像 </div>
                  <div class="tn-form-row">
                  <label class="tn-form-label"></label>
                  <img width="46" height="46" src="<%=figureurl %>"/></div>
                  <input type="hidden" name="figureurl" value="<%=figureurl %>" />
          <div class="tn-form-row spb-reg-agreement">
            <span class="spb-reg-input">
            <input class="tn-checkbox" type="checkbox" id="acceptArgeement" name="acceptArgeement" checked="checked" value="<%=GetResourceString("Button_AcceptArgeement",applicationID)%>" />
           <label for="acceptArgeement">我已看过并完全同意  <%//=string.Format(GetResourceString("Description_Pattern_AcceptedAgreement", applicationID), SPBUrlHelper.Action("Control_Agreement", "ChannelUser"))%> </label>
            <a href="<%=SPBUrlHelper.Action("Control_Agreement", "ChannelUser") %>" id="seeArgeement" class="tn-action-text">
            《会员服务条款》</a>
            </span>
             <div class="spb-reg-msg">
            <div style="display: none"  id="acceptArgeementMsgClass">
             <%=SPBHtmlHelper.Instance().Icon(IconTypes.Alert, string.Empty, new RouteValueDictionary { { "class", "tn-icon-inline" } })%> 
             <span id="acceptArgeementMessageNormal"></span> 
             </div>
             </div>
            </div>
          <div class="tn-form-row tn-form-row-button">
            <span class="tn-button-large tn-button tn-button-primary">
                <span class="tn-first-child">
                    <button type="submit"  id="createButton" class="tn-button-text"><span id="createButton1"><%=GetResourceString("Button_OK")%></span></button>
                </span>
            </span>
          </div>
        </div>
      </form>
    </div>
  </div>

   <script type="text/javascript">
       $(document).ready(function () {
           $("#seeArgeement").dialog({
               id: 'seeArgeementDialog',
               title: false,
               width: 400,
               height: 350,
               closeFn: function () {
                   $('#acceptArgeement').attr('checked', true);
               }
           });
           $('#loginInModalButton').dialog({
               id: 'loginDialog',
               title: '绑定',
               width: 300
           });
           $("#userEmail").focus(function () {
               $("#emailMsgClass").show();
               $("#emailMsgClass").attr("class", "tn-cue-highlight tn-message-box");
               $("#emailMessageNormal").text('<%=GetResourceString("Description_PrivateEmail",applicationID)%>');
               $("#emailIconMsg").attr("class", "tn-icon tn-icon-exclamation");
           });

           $("#userEmail").blur(function () {
               if ($('#userEmail').val()) {
                   $.getJSON('<%=SPBUrlHelper.Action("ValidateEmail","ChannelUser") %>', { userEmail: $('#userEmail').val() }, function (data) {
                       $("#emailMessageNormal").html(data.messageContent);
                       if (data.isSuccess) {
                           $("#emailMsgClass").attr("class", "tn-cue-success tn-message-box");
                           $("#emailIconMsg").attr("class", "tn-icon tn-icon-accept-circle");
                           $("#createButton").removeAttr("disabled");
                       }
                       else {
                           $("#emailMsgClass").attr("class", "tn-cue-error tn-message-box");
                           $("#emailIconMsg").attr("class", "tn-icon tn-icon-alert");
                           $("#createButton").attr("disabled", true);
                       }
                   });
               }
               else {
                   $("#emailMsgClass").hide();
                   $("#emailMessageNormal").text('');
                   $("#createButton").attr("disabled", true);
               }
           });

           $("#userName").focus(function () {
               $("#usernameMsgClass").show();
               $("#usernameMsgClass").attr("class", "tn-cue-highlight tn-message-box");
               $("#usernameIconMsg").attr("class", "tn-icon tn-icon-exclamation");
               $("#usernameMessageNormal").text('<%=GetResourceString("Description_UserNameSuggest",applicationID)%>');
           });
           $("#userName").blur(function () {
               if ($('#userName').val()) {
                   $.getJSON('<%=SPBUrlHelper.Action("ValidateUserName","ChannelUser") %>', { userName: $('#userName').val() }, function (data) {
                       $("#usernameMessageNormal").text(data.messageContent);
                       if (data.isSuccess) {
                           $("#usernameMsgClass").attr("class", "tn-cue-success tn-message-box");
                           $("#usernameIconMsg").attr("class", "tn-icon tn-icon-accept-circle");
                           $("#createButton").removeAttr("disabled");
                       }
                       else {
                           $("#usernameMsgClass").attr("class", "tn-cue-error tn-message-box");
                           $("#usernameIconMsg").attr("class", "tn-icon tn-icon-alert");
                           $("#createButton").attr("disabled", true);
                       }
                   });
               }
               else {
                   $("#usernameMsgClass").hide();
                   $("#usernameMessageNormal").text('');
                   $("#createButton").attr("disabled", true);
               }
           });


           $("input[name=acceptArgeement]").focus(function () {
               $("#acceptArgeementMsgClass").hide();
           });

           $("#createButton").click(function () {
               var isReight = true;
               if (!$('#userName').val()) {
                   $("#usernameMsgClass").show();
                   $("#usernameMsgClass").attr("class", "tn-cue-error tn-message-box");
                   $("#usernameIconMsg").attr("class", "tn-icon tn-icon-alert");
                   $("#usernameMessageNormal").text('<%=GetResourceString("Validate_UserNameRequired",applicationID) %>');
                   isReight = false;
               };
               if (!$('#userEmail').val()) {
                   $("#emailMsgClass").show();
                   $("#emailMsgClass").attr("class", "tn-cue-error tn-message-box");
                   $("#emailIconMsg").attr("class", "tn-icon tn-icon-alert");
                   $("#emailMessageNormal").text('<%=GetResourceString("Validate_PrivateEmailRequired",applicationID) %>');
                   isReight = false;
               };
               if ($("input[name=acceptArgeement]:checked").length == 0) {
                   $("#acceptArgeementMsgClass").attr("class", "tn-cue-error tn-message-box");
                   $("#acceptArgeementMsgClass").show();
                   $("#acceptArgeementMessageNormal").text('<%=GetResourceString("Validate_AgreementAccept_Required",applicationID) %>');
                   isReight = false;
               }
               if (!isReight)
                   return false;
               $("#createButton1").html("处理中");
           });
       });
        

    </script>
    </div>
   </asp:content>
