﻿<%@ Page Language="C#" Inherits="SpaceBuilder.Web.ChannelPublicViewPage<User>" %>

<asp:content contentplaceholderid="setPageID" runat="server"> id="UploadAvatar" </asp:content>
<asp:content id="wideContent" runat="server" contentplaceholderid="wideContent">
  <%string userDomainName = Html.GetParameterFromRouteDateOrQueryString("userDomainName");
    int applicationID = ApplicationIDs.Instance().User();
    PersonUser pu = Users.GetUser(userDomainName, false) as PersonUser;  %>
  <% if (TempData["StatusMessageType"] != null)
     {
         StatusMessageType messageType = (StatusMessageType)TempData.GetInt("StatusMessageType", (int)StatusMessageType.Error);
         if (messageType == StatusMessageType.Success)
             Response.Write(SPBHtmlHelper.Instance().StatusMessage(messageType, TempData.GetString("StatusMessageContent", string.Empty), 3000, false));
         else
             Response.Write(SPBHtmlHelper.Instance().StatusMessage(messageType, TempData.GetString("StatusMessageContent", string.Empty), true));
     }
     TempData["StatusMessageType"] = null;%>
  <div class="tn-box tn-widget tn-widget-content tn-corner-all spb-register-step">
    <div class="tn-box-content tn-widget-content tn-corner-all">
      <div class="tn-instructions">
        <div class="tn-progress-bar tn-widget-content tn-corner-all">
          <div class="tn-progress-bar-value tn-widget-header tn-corner-left tn-border-tbl"
                    style="width: 24.99%;"> </div>
        </div>
        <ul class="tn-helper-clearfix">
          <li class="tn-step tn-selected"><b class="tn-widget-content tn-widget-header tn-corner-all"> </b><span><a href="javascript:;">1.上传头像</a></span></li>
          <li class="tn-step"><b class="tn-widget-content tn-corner-all"> </b><span><a href="javascript:;">2.填写个人资料</a></span></li>
          <li class="tn-step"><b class="tn-widget-content tn-corner-all"> </b><span><a href="javascript:;">3.看看推荐的好友</a></span></li>
          <li class="tn-step"><b class="tn-widget-content tn-corner-all"> </b><span><a href="javascript:;">4.完成，进入个人中心</a></span></li>
        </ul>
      </div>
      <% StatusMessageData statusMessageData = TempData.Get<StatusMessageData>("StatusMessageData", null);
         if (statusMessageData != null)
         {
             Response.Write(SPBHtmlHelper.Instance().StatusMessage(statusMessageData));
             statusMessageData = null;
            %>
      <div class="tn-blank10"></div>
      <% }%>
      <div class="spb-upload-avatar">
        <div class="tn-widget">
          <div class="tn-cue-highlight tn-corner-all tn-message-box"> <span class="tn-helper-left"><span class="tn-icon tn-icon-exclamation"></span></span>
            <div class="tn-helper-flowfix"> <strong>友情提示：</strong>Hi，欢迎进入完善个人资料向导，你目前的档案完整度是<b><%=pu.ProfileIntegrity%>%</b></div>
          </div>
        </div>
        <div class="tn-blank20"></div>
        <div class="spb-avatar-box"> <%= SPBHtmlHelper.Instance().ShowUserAvatar(Html.GetParameterFromRouteDateOrQueryString("userDomainName"),false, HyperLinkTarget._blank, AvatarSizeTypes.Normal,false,null)  %> </div>
        <div class="spb-upload-main">
          <div class="spb-upload-files">
            <div class="spb-upload-tips tn-border-gray tn-border-bottom tn-text-note"> <%=String.Format(GetResourceString("Description_Pattern_UploadAvatar", applicationID),SiteSettingsManager.GetSiteSettings().SmallAvatarWidth + "x" + SiteSettingsManager.GetSiteSettings().SmallAvatarWidth)%></div>
            <div class="spb-upload-wrapper tn-border-gray tn-border-rbl">
              <div class="spb-upload-fieldset tn-border-gray tn-border-top" id="fsUploadProgress"> <span class="spb-upload-legend">上传新头像</span></div>
              <div style="display: none;" id="divStatus"> </div>
              <div class="spb-upload-actions tn-border-gray tn-border-top">
                <% string handdlerUrl = Globals.GetFullUrlInFileHandlerSite(Avatars.StorageProviderName, WebUtils.ResolveUrl("~/Services/UserUploadAvatar.ashx"));
                   string flashUrl = Globals.GetFullUrlInFileHandlerSite(Avatars.StorageProviderName, WebUtils.ResolveUrl("~/Utility/UploadFiles/swfupload.swf"));
                   string uploadFileTypes = "*.gif;*.jpg;*.jpeg;*.png;*.bmp;";
                   int maxFileSize = 5 * 1024;
                                    %>
                <% Html.RenderAction<ChannelController>(n => n.Control_UploadAvatarAttachment(userDomainName, handdlerUrl, flashUrl, Model.UserID, uploadFileTypes, maxFileSize.ToString(), true, SPBUrlHelper.Action("CropAvatar", "ChannelUser", new RouteValueDictionary { { "userDomainName", WebUtils.UrlEncode(userDomainName) } }))); %>
              </div>
            </div>
          </div>
        </div>
        <div class="tn-form-row-button">
         <%--<span class="tn-helper-right"><a href="<%=SPBUrlHelper.Action("SetShowWizardMode", "ChannelUser", new RouteValueDictionary { { "userDomainName", userDomainName }})%>">跳出向导，直接进入个人中心</a>
        
        </span>--%>
         <span class="tn-button tn-button-large tn-button-primary tn-button-text-icon-right"> <span class="tn-first-child"><a href="<%=SPBUrlHelper.Action("EditPersonInfo", "ChannelUser", new RouteValueDictionary { { "userDomainName", WebUtils.UrlEncode(userDomainName) } })%>"
                    class="tn-button-text"> <%if (pu.HasAvatar) Response.Write("下一步"); else Response.Write("跳过"); %>   <span class="tn-icon tn-icon-slide-next"></span></a> </span></span>
                    
                    </div>
      </div>
    </div>
  </div>
</asp:content>
