﻿<%@ Page Language="C#" Inherits="SpaceBuilder.Web.ChannelViewPage<VoteThread>" %>

<asp:content contentplaceholderid="setPageID" runat="server"> id="Vote-ShowVote" </asp:content>
<asp:content runat="server" contentplaceholderid="subMenusContent">
  <%Html.RenderPartial("Controls/Votes/Submenu.ascx");%>
</asp:content>
<asp:content contentplaceholderid="mainContent" runat="server">
  <spb:Script runat="server" ID="jqueryForm" Src="~/Utility/jquery/plugin/jquery.form.min-2.7.3.js" SetExpireDays="30" />
  <spb:Script runat="server" ID="blockUI" Src="~/Utility/jquery/plugin/jquery.blockUI-2.3.3.js" SetExpireDays="30" />
  <%
      bool errorAuditingStatus = ViewData.GetBool("errorAuditingStatus", false);

      User currentDomainUser = ViewData.Get<User>("currentDomainUser");
      bool hasManagePermission = CurrentUser != null && CurrentUser.IsContentAdministrator || CurrentUser != null && CurrentUser.IsAdministrator || CurrentUser != null && CurrentUser.UserID == Model.UserID;
      if (TempData["StatusMessageData"] != null)
      {
          StatusMessageData messageData = TempData.Get<StatusMessageData>("StatusMessageData", new StatusMessageData(StatusMessageType.Error, string.Empty));
          Response.Write(SPBHtmlHelper.Instance().StatusMessage(messageData, 2000, false));
      }
      TempData["StatusMessageData"] = null;
      bool isShow = ViewData.GetBool("isShow", true);
      %>
  <%if (errorAuditingStatus)
    {
        int threadID = 0;
        if (Model != null)
            threadID = Model.ThreadID;
        string errorMessage = ViewData.GetString("errorMessage", string.Empty);%>
  <div class="tn-widget">
    <div class="tn-cue-highlight tn-corner-all tn-message-box"><span class="tn-helper-right"><a href="<%=SPBUrlHelper.Action("VoteThreadRanks", "ChannelVote") %>"><%=GetResourceString("Action_ReturnList")%></a></span><span class="tn-helper-left"><span class="tn-icon tn-icon-exclamation"></span></span>
      <div class="tn-helper-flowfix">
        <% Response.Write(errorMessage); %>
        <%if (CurrentUser != null && CurrentUser.IsAdministrator || CurrentUser != null && CurrentUser.IsContentAdministrator)
          {%>
        <%= GetResourceString("Label_ManagerCurrent",ApplicationIDs.Instance().Vote())%> <a href="<%=SPBUrlHelper.Action("UpdateVoteAuditingStatuses","ChannelVote",new RouteValueDictionary{{"threadID", threadID}})%>" title="<%=GetResourceString("Label_PastVoteLimit",ApplicationIDs.Instance().Vote())%>" id="SetIsPassButton"><%=GetResourceString("Label_IsPastVote",ApplicationIDs.Instance().Vote())%></a>
        <%}%>
      </div>
    </div>
  </div>
  <div class="tn-blank10"></div>
  <%}
    if (!errorAuditingStatus || hasManagePermission)
    {

        if (isShow && Model != null)
        {
            bool isResult = ViewData.GetBool("isResult", false);
            bool isVote = ViewData.GetBool("isVote", false);
            string errorMessage = ViewData.GetString("errorMessage", string.Empty);%>
  <div class="tn-box tn-widget tn-widget-content tn-corner-all spb-vote-main" id="showVote">
    <div class="tn-box-content tn-widget-content tn-corner-all">
      <div class="tn-text-heading">
        <h2><%=Model.Subject%>
          <%switch (Model.PrivacyStatus)
            {
                case PrivacyStatuses.OnlyFriend:
                    Response.Write(SPBHtmlHelper.Instance().Icon(IconTypes.Limit, string.Empty, new RouteValueDictionary { { "class", "tn-icon tn-icon-inline" } }));
                    break;
                case PrivacyStatuses.Privacy:
                    Response.Write(SPBHtmlHelper.Instance().Icon(IconTypes.Lock, string.Empty, new RouteValueDictionary { { "class", "tn-icon tn-icon-inline" } }));
                    break;
                default:
                    break;
            } %>
        </h2>
        <span class="tn-text-note">
        <% if (Model.IsMultiple)
           { %>
        <%=string.Format(GetResourceString("Label_TheMostSelectItemsis", ApplicationIDs.Instance().Vote()), Model.MaxChooseCount)%>
        <%} %>
        </span> </div>
      <div class="tn-summaries"><%=Model.Body%></div>
      <div class="tn-info-part tn-text-note">
        <dl>
          <dt><%=GetResourceString("Label_StartTimes", ApplicationIDs.Instance().Vote())%><%=GetResourceString("Common_Colon")%></dt>
          <dd><%=Formatter.FormatDate(Model.DateCreated, true)%></dd>
        </dl>
        <dl>
          <dt><%=GetResourceString("Label_IsTime", ApplicationIDs.Instance().Vote())%><%=GetResourceString("Common_Colon")%></dt>
          <dd><%=Formatter.FormatDate(Model.EndDate,true)%></dd>
        </dl>
        <dl>
          <dt><%=GetResourceString("Label_BrowseTotal", ApplicationIDs.Instance().Vote())%><%=GetResourceString("Common_Colon")%></dt>
          <dd><%=Model.HitTimes%></dd>
        </dl>
        <dl>
          <dt><%= GetResourceString("Label_BrowseCountOfWeeks", ApplicationIDs.Instance().Vote())%><%=GetResourceString("Common_Colon")%></dt>
          <dd><%=Model.StageHitTimes%></dd>
        </dl>
        <dl>
          <dt><%=GetResourceString("Label_PartIn", ApplicationIDs.Instance().Vote())%><%=GetResourceString("Common_Colon")%></dt>
          <dd><%=Model.VoterCount%></dd>
        </dl>
        <dl>
          <dt><%=GetResourceString("Common_Comment")%><%=GetResourceString("Common_Colon")%></dt>
          <dd><%=Model.CommentCount%></dd>
        </dl>
      </div>
      <div class="<%if (isResult) Response.Write("spb-vote-form spb-vote-result"); else Response.Write("spb-vote-form"); %>">
        <form id="VoteForm" name="VoteForm" action="<%=SPBUrlHelper.Action("Vote","ChannelVote",new RouteValueDictionary{{"threadID",Model.ThreadID}}) %>" method="post">
          <div class="tn-histogram">
            <% int totalVoteCount = Model.TotalVoteCount;
               int rateValue = 0;
               int i = 1;
               foreach (VoteOption option in Model.VoteOptions.Values)
               {
                   if (totalVoteCount > 0)
                       rateValue = option.VoteCount * 100 / totalVoteCount;
         %>
            <div class="tn-histogram-item tn-helper-clearfix"> <span class="tn-histogram-input">
              <%if (!isVote && CurrentUser != null)
                {
                    if (Model.IsMultiple)
                    { %>
              <input type="checkbox" name="optionID" id="optionID_<%=option.OptionID%>" value="<%=option.OptionID%>" class="tn-checkbox">
              <%}
                    else
                    { %>
              <input type="radio" name="optionID" value="<%=option.OptionID%>" class="tn-radiobutton" id="optionID_<%=option.OptionID%>"/>
              <%}
                } %>
              </span>
              <%if (isResult)
                { %>
              <div class="tn-histogram-value">
                <%if (option.VoteCount > 0 && isResult && isVote)
                  {%>
                <a href="javascript:;" onclick="toggleVoteRecords('<%=option.OptionID %>')">（<%=rateValue%>%）<%=option.VoteCount%></a>
                <%}
                  else Response.Write("（" + rateValue + "%）" + option.VoteCount);%>
              </div>
              <div class="tn-histogram-chart tn-img-sprite" name="result_<%=Model.ThreadID %>">
                <div style="width: <%=rateValue %>%;" class="tn-histogram-plan tn-img-sprite tn-histogram-item<%=i%10 %>"><em class="tn-img-sprite"></em></div>
              </div>
              <%}%>
              <label class="tn-histogram-label" for="optionID_<%=option.OptionID%>"><%=option.OptionName%></label>
            </div>
            <%if (isResult && isVote)
              { %>
            <div class="tn-widget tn-bubble-box tn-bubble-box-arrow-top" id="Record_<%=option.OptionID %>" style="display:none">
              <div class="tn-bubble-box-arrow"> <b class="tn-arrow-b1 tn-widget-content tn-border-gray"></b><b class="tn-arrow-b2 tn-widget-content tn-border-gray"> </b><b class="tn-arrow-b3 tn-widget-content tn-border-gray"></b><b class="tn-arrow-b4 tn-widget-content tn-border-gray"> </b><b class="tn-arrow-b5 tn-widget-content tn-border-gray"></b> </div>
              <div class="tn-bubble-box-content tn-widget-content tn-border-gray tn-corner-all" id="RecordForLoad_<%=option.OptionID %>">
                <div class="tn-loading"></div>
              </div>
            </div>
            <%}
               }%>
          </div>
          <%if (!isVote)
            { %>
          <div class="tn-form tn-border-gray tn-border-top">
            <%if (CurrentUser != null && (!isResult || !isVote))
              {%>
            <div class="tn-form-row">
              <input type="checkbox" name="IsAnonymousVote" value="true" class="tn-checkbox" id="IsAnonymousVote" />
              <label for="IsAnonymousVote"> <%=GetResourceString("Label_AnonymousVote", ApplicationIDs.Instance().Vote())%></label>
            </div>
            <div class="tn-form-row tn-form-row-button">
              <input type="hidden" name="isResult" value="<%=isResult %>" />
              <%=SPBHtmlHelper.Instance().SubmitButton("postVoteButton", GetResourceString("Action_Vote", ApplicationIDs.Instance().Vote()), ButtonSizes.Large, null, null)%>
              <%if (!isResult)
                { %>
              <span class="tn-action"><a class="tn-action-text" href="<%=SiteUrls.Instance().ShowVoteThread(Model.ThreadID,true) %>"><%=GetResourceString("Action_LookVoteResult", ApplicationIDs.Instance().Vote())%></a></span>
              <%--<span class="tn-action"><a class="tn-action-text" href="<%=SPBUrlHelper.Action("Control_InviteFriends", "ChannelVote", new RouteValueDictionary {{"threadID",Model.ThreadID} })%>">邀请好友</a> </span>--%>
              <%}%>
            </div>
            <%}
              else if (CurrentUser == null)
              {%>
            <div class="tn-form-row tn-form-row-button"> <%=SPBHtmlHelper.Instance().LinkButton(string.Empty, GetResourceString("Label_LoadAndVote", ApplicationIDs.Instance().Vote()), SiteUrls.Instance().Login(true), ButtonSizes.Default, HighlightStyles.Default)%> </div>
            <%} %>
          </div>
          <%} %>
        </form>
      </div>
      <%if (hasManagePermission)
        { %>
      <div class="tn-actions tn-helper-align-right"> <span class="tn-action"><a href="javascript:;" id="addVoteOption"><%=GetResourceString("Action_AddOtherItem",ApplicationIDs.Instance().Vote())%></a></span> <span class="tn-action"><a href="javascript:;" id="updatePrivacyStatus"><%= GetResourceString("Action_UpdateSet",ApplicationIDs.Instance().Vote())%></a></span> <span class="tn-action"><a href="<%=SPBUrlHelper.Action("Control_UpdateEndDate", "ChannelVote", new RouteValueDictionary { {"threadID",Model.ThreadID}})%>" id="updateEndDate"><%=GetResourceString("Action_UpdateIsTime",ApplicationIDs.Instance().Vote())%></a></span> <span class="tn-action"><a onclick="if(!confirm('<%=GetResourceString("Validate_AskDeleteVote",ApplicationIDs.Instance().Vote())%>')) return false;" href="<%=SPBUrlHelper.Action("DeleteVoteThread","ChannelVote",new RouteValueDictionary{{"threadID",Model.ThreadID}}) %>"><%= GetResourceString("Action_DeleteThisVote",ApplicationIDs.Instance().Vote())%></a></span> </div>
      <%} %>
      <div class="tn-feedback tn-border-gray tn-border-top tn-helper-align-right"> <span class="tn-button tn-button-text-icon tn-button-default"><span class="tn-first-child"><span class="tn-icon tn-icon-bubble"></span> <a class="tn-button-text" href="javascript:;" onclick="$('#commentBody').focus();"><%=GetResourceString("Common_Comment") %></a> </span></span> <span class="tn-button tn-button-text-icon tn-button-default">
        <% if (Model.PrivacyStatus != PrivacyStatuses.Privacy)
           {
               if (CurrentUser != null)
               { %>
        <span class="tn-first-child"><span class="tn-icon tn-icon-share"></span> <a class="tn-button-text" id="sharelink" href="<%=SiteUrls.Instance().ShareInModal(true,Request.RawUrl, Model.Subject, HtmlUtils.TrimHtml(Model.Body, 140), string.Empty, ApplicationIDs.Instance().Vote(), Model.OwnerID, Model.Author)%> "><%=GetResourceString("Common_Share")%></a></span>
        <%}
               else
               { %>
        <span class="tn-first-child"><span class="tn-icon tn-icon-share"></span> <a class="tn-button-text" href="<%=SiteUrls.Instance().Login(true) %>"><%=GetResourceString("Common_Share")%></a></span>
        <%}
           }%>
        </span> <span class="tn-button tn-button-text-icon tn-button-default"><span class="tn-first-child"><span class="tn-icon tn-icon-alert"></span> <a class="tn-button-text nyroModal" href="<%=SiteUrls.Instance().NewImpeachReport() %>"><%=GetResourceString("Action_Report",ApplicationIDs.Instance().Vote())%></a> </span></span> </div>
      <%=SPBHtmlHelper.Instance().ShowAdvertisingInChannel("001002410002", new RouteValueDictionary { { "class", "spb-ad-main-bottom" } })%>
      <%Html.RenderAction<ChannelVoteController>(n => n.Control_ListVoteThreadComments(Model.ThreadID, Request.QueryString.GetInt("pageIndex", 1))); %>
    </div>
  </div>
  <%if (hasManagePermission)
    {
        string updatevoteThreadUrl = SPBUrlHelper.Action("UpdateVoteThread", "ChannelVote", new RouteValueDictionary { { "ThreadID", Model.ThreadID } });%>
  <div id="addVoteOptionDiv" style="display:none">
    <form id="addVoteOptionForm" action="<%=updatevoteThreadUrl %>" method="post">
      <div class="tn-form tn-form-single spb-vote-add-option">
        <input class="tn-textbox tn-input-medium tn-border-gray required" size="80" style="width:150px" type="text" name="optionName" />
        <%=SPBHtmlHelper.Instance().SubmitButton("addVoteOptionButton",GetResourceString("Action_Add", ApplicationIDs.Instance().Vote()),ButtonSizes.Default,null,null)%> </div>
    </form>
  </div>
  <div id="updatePrivacyStatusDiv" style="display:none">
    <form class="tn-helper-reset" action="<%=updatevoteThreadUrl %>" method="post">
      <div class="tn-form tn-form-single"> <%=SPBHtmlHelper.Instance().ShowDropDownList<int, string>("privacyStatus", new Dictionary<int, string> { { (int)PrivacyStatuses.Public, GetResourceString("Enum_PermitAllPersonLook", ApplicationIDs.Instance().Vote()) }, { (int)PrivacyStatuses.OnlyFriend, GetResourceString("Enum_OnlyFriendLook", ApplicationIDs.Instance().Vote()) }, { (int)PrivacyStatuses.Privacy, GetResourceString("Enum_ImpermanentClose", ApplicationIDs.Instance().Vote()) } }, new RouteValueDictionary { { "class", "tn-dropdownlist" } }, (int)Model.PrivacyStatus, -1, GetResourceString("Common_PleaseChoose"))%> <%=SPBHtmlHelper.Instance().SubmitButton("updatePrivacyStatusButton", GetResourceString("Button_Update"),ButtonSizes.Default, null, null)%> </div>
    </form>
  </div>
  <%} %>
  <script type="text/javascript">
  $(document).ready(function() {
       $("#addVoteOptionForm").validate({
          rules: {
              optionName: { required: true, maxBlength: 60 }
          },
          messages: {
              optionName: { required: "<%=GetResourceString("Validate_PleaseInputName",ApplicationIDs.Instance().Vote()) %>", maxBlength: "<%=string.Format(GetResourceString("Validate_Pattern_WordMaxLengthCannot",ApplicationIDs.Instance().Vote()),60) %>" }
          }
      });
     $('#sharelink').nyroModal({
         resizeable: true,
         width: 500
      });
     $('.showModal').nyroModal({
         resizeable: true,
         width: 300,
         height: 300,
         endRemove: function() { }
     });
      $("#addVoteOptionButton").click(function() {
          if (!$("#addVoteOptionForm").valid()) 
             return false;
          else{
             $("#addVoteOptionButton").hide();
             $("#addVoteOptionButton_ForHide").show();
          }
      });
      
     $("#VoteForm").validate({
         rules: {
             optionID: {required:true,maxlength:<%=Model.MaxChooseCount %>}
         },
         messages: {
             optionID:{required: "<%=GetResourceString("Validate_PleaseSelectVoteOptions",ApplicationIDs.Instance().Vote()) %>", maxlength: "<%=string.Format(GetResourceString("Validate_MoreSelect",ApplicationIDs.Instance().Vote()),Model.MaxChooseCount) %>"}
         },
        showErrors: $.dialog.showErrors,
        onfocusout: false,
        onclick: false,
        onkeyup:false,
        onsubmit:true
     });
      
      $("#postVoteButton").click(function() {
          if (!$("#VoteForm").valid()) 
          {
              return false;
          }
      });
        
      $('#addVoteOption').click(function(){
      $.dialog({ id: 'dialogidOption', content:$("#addVoteOptionDiv").html(),title: '<%=GetResourceString("Action_AddOtherItem",ApplicationIDs.Instance().Vote())%>',  width: 300 ,resizable:false});
           return false;
            $('input[name=optionName]').focus();
            });
          
      $('#updatePrivacyStatus').click(function() {
            $.dialog({ id: 'dialogidPrivacy', content:$("#updatePrivacyStatusDiv").html(),title: '<%=GetResourceString("Action_UpdateSet",ApplicationIDs.Instance().Vote())%>',  width: 300,resizable:false });
            return false;
      });
      $('#updateEndDate').dialog({ id: 'dialogidDate',title: '<%=GetResourceString("Action_UpdateIsTime",ApplicationIDs.Instance().Vote())%>',  width: 300,resizable:false });
           
      $("div[name = result_"+ <%=Model.ThreadID %> + "]").click(function(event){

            var $cr = $(this).parent().find(":radio,:checkbox");
            if($cr.attr("checked"))
              $cr.removeAttr("checked");
            else
              $cr.attr("checked",true);
      });
  });   
function toggleVoteRecords(optionID, url) {
    if ($("#Record_"+ optionID).is(":hidden")) {
        $("div[id^='Record_']").hide();
        if(!$("#Record_" + optionID).children().length || $("#Record_" + optionID).find("div.tn-loading").length)
        {
            $("#RecordForLoad_" + optionID).load('<%=SPBUrlHelper.Action("Control_ListOptionVoters", "ChannelVote")%>?optionID=' + optionID);
        }
        $("#Record_" + optionID).show();            
    }
    else {
        $("#Record_"+ optionID).hide();            
    }
}

</script>
  <%}
        else
        {
            Response.Write(SPBHtmlHelper.Instance().StatusMessage(new StatusMessageData(StatusMessageType.Error, GetResourceString("Exception_SorryNotLimitVote", ApplicationIDs.Instance().Vote()))));
        }
    }%>
</asp:content>
<asp:content contentplaceholderid="sidebarContent" runat="server">
  <div class="tn-box tn-widget tn-widget-content tn-corner-all">
    <%
        int applicationID = ApplicationIDs.Instance().Vote();
        VoteUserData userData = VoteUserDatas.GetUserData(Model.UserID, false);
        if (userData == null)
            userData = new VoteUserData();
          %>
    <div class="tn-box-content tn-widget-content tn-corner-all">
      <div class="tn-card tn-card-mini">
        <div class="tn-helper-left">
          <div class="tn-avatar"><%=SPBHtmlHelper.Instance().ShowUserAvatar(Model.UserID,true,HyperLinkTarget._blank,AvatarSizeTypes.Small) %></div>
        </div>
        <div class="tn-info">
          <div class="tn-id-name"><strong> <%=SPBHtmlHelper.Instance().UserDisplayNameLink(Model.UserID, Model.Author,applicationID)%> </strong></div>
          <%MicroBlogUserData mbUserData = MicroBlogUserDatas.GetUserData(Model.UserID, false);
            mbUserData = mbUserData == null ? new MicroBlogUserData() : mbUserData;
            if (!string.IsNullOrEmpty(mbUserData.MostRecentThreadBody))
            {%>
          <div class="spb-i-said">&nbsp;<span class="tn-icon tn-icon-quotes-before tn-icon-inline"></span><%=mbUserData.MostRecentThreadBody%><span class="tn-icon tn-icon-quotes-after tn-icon-inline"></span></div>
          <%} %>
        </div>
        <div class="tn-info-part">
          <div class="tn-blank1 tn-helper-clearfix"></div>
          <dl class="tn-text-note">
            <dt><%=GetResourceString("Title_CreateVoteCount",applicationID)%><%=GetResourceString("Common_Colon")%></dt>
            <dd><%=userData.TotalThreadCount%></dd>
          </dl>
        </div>
        <%if (CurrentUser != null && Model.UserID != CurrentUser.UserID)
          {
              if (!Friends.IsFriend(CurrentUser.UserID, Model.UserID))
              { %>
        <span class="tn-action"><a class="tn-action-text nyroModal" href="<%=SiteUrls.Instance().NewFriendInvitation(CurrentUser.UserName,Model.UserID) %>"><%= GetResourceString("Action_AddFriend")%></a></span>
        <%} %>
        <span class="tn-action"><a class="tn-action-text" href="<%=SiteUrls.Instance().NewMessage(CurrentUser.UserName,Model.UserID) %>"><%=GetResourceString("Action_SendInfo", applicationID)%></a></span>
        <%} %>
        <span class="tn-action"><a class="tn-action-text" href="<%=SiteUrls.Instance().UserChannelHome(Model.UserID,applicationID) %>"><%=GetResourceString("Action_HeAllVote", applicationID)%></a></span> </div>
      <div class="tn-blank10 tn-border-gray tn-border-bottom"></div>
      <div class="tn-blank10"></div>
      <ul class="tn-helper-reset tn-list">
        <%IList<VoteThread> topThreads = ViewData["TopThreads"] as IList<VoteThread>;
          if (topThreads != null)
          {
              foreach (VoteThread thread in topThreads)
              {%>
        <li><em class="tn-count tn-text-note tn-helper-right"><%=thread.VoterCount %></em><a href="<%=SiteUrls.Instance().ShowVoteThread(thread.ThreadID) %>"><%=StringUtils.Trim(thread.Subject,15) %></a> </li>
        <%}
          }%>
      </ul>
    </div>
  </div>
  <div class="tn-blank10"></div>
  <%Html.RenderAction<ChannelVoteController>(n => n.Control_SideVoteSortBlock(VoteThreadSortBy.DateCreated, VoteStatuses.Publishing, GetResourceString("Title_TheNewVote", ApplicationIDs.Instance().Vote()), 7)); %>
  <%Html.RenderAction<ChannelVoteController>(n => n.Control_SideVoteSortBlock(VoteThreadSortBy.StageHitTimes, VoteStatuses.Publishing, GetResourceString("Title_ThisWeekHost", ApplicationIDs.Instance().Vote()), 7)); %>
</asp:content>
