﻿<%@ Control Language="C#" Inherits="SpaceBuilder.Web.SPBViewUserControl" %>
<% ChannelClubSubMenu subMenu = ViewData.Get<ChannelClubSubMenu>("currentSubMenu", ChannelClubSubMenu.Home);
   ViewData["currentSubMenu"] = null;
   
   int applicationId = ApplicationIDs.Instance().Club();
   ViewData["applicationID"] = applicationId;
   Html.RenderPartial("Controls/SubMenu.ascx", ViewData);
%>
<div class="spb-nav2-area">
    <div class="tn-wrapper-inner">
        <ul class="spb-nav2 tn-helper-reset tn-helper-clearfix sf-menu">
            <li <% if (subMenu == ChannelClubSubMenu.Home) Response.Write("class=\"spb-nav-item tn-text-note tn-selected\""); else Response.Write("class=\"spb-nav-item\""); %>>
                <a href="<%=Globals.GetFullUrlInMainSite(SiteUrls.Instance().ChannelClubHome()) %>">
                    <span>
                        <%=GetResourceString("Navigation_ClubHome", applicationId)%></span></a></li>
            <li <% if (subMenu == ChannelClubSubMenu.Search) Response.Write("class=\"spb-nav-item tn-text-note tn-selected\""); else Response.Write("class=\"spb-nav-item\""); %>>
                <a href="<%=Globals.GetFullUrlInMainSite(SPBUrlHelper.Action("Search","ChannelClub")) %>">
                    <span>
                        <%=GetResourceString("Title_ClubSearch", applicationId)%></span></a></li>
            <li <% if (subMenu == ChannelClubSubMenu.Rank) Response.Write("class=\"spb-nav-item tn-text-note tn-selected\""); else Response.Write("class=\"spb-nav-item\""); %>>
                <a href="<%=Globals.GetFullUrlInMainSite(SPBUrlHelper.Action("ClubRanks","ChannelClub")) %>">
                    <span>
                        <%=GetResourceString("Navigation_ClubRank", applicationId)%></span></a></li>
            <% if (CurrentUser != null)
               { %>
            <li class="spb-nav-item"><a target="_blank" href="<%=Globals.GetFullUrlInMainSite(SPBUrlHelper.Action("ListMyClubs", "ClubUserDomain", new RouteValueDictionary { { "userDomainName", Globals.GetCurrentUser().UserName },{"isCreater",true},{"pageIndex",1}}))%>">
                <span>
                    <%=GetResourceString("Navigation_MyClub", applicationId)%></span></a></li>
            <%} %>
        </ul>
    </div>
</div>
<div class="spb-header-bottom">
    <div class="tn-wrapper-inner tn-helper-clearfix">
        <div class="tn-shortcut">
            <% if (ClubPermission.Validate(new Club(), Globals.GetCurrentUser(), PermissionItemKeys.Instance().CreateClub()))
               { %>
            <%=SPBHtmlHelper.Instance().LinkButton(string.Empty, GetResourceString("Button_CreateNewClub", applicationId), Globals.GetFullUrlInMainSite(SPBUrlHelper.Action("NewClub", "ChannelClub")), ButtonSizes.Default, HighlightStyles.Primary, IconTypes.Add, TextIconLayout.IconText)%>
            <%} %>
        </div>
        <spb:BreadCrumb ID="BreadCrumb" runat="server" />
    </div>
</div>
