﻿<%@ Control Language="C#" Inherits="SpaceBuilder.Web.SPBViewUserControl" %>
<%        
    int FileApplicationID = ApplicationIDs.Instance().File();
    ChannelFileSubMenu? subMenu = null;
    if (ViewData["ChannelFileSubMenu"] != null)
        subMenu = (ChannelFileSubMenu)ViewData["ChannelFileSubMenu"];
    
    ViewData["applicationID"] = FileApplicationID;
    Html.RenderPartial("Controls/SubMenu.ascx", ViewData);
%>
<div class="spb-nav2-area">
    <div class="tn-wrapper-inner">
        <ul class="spb-nav2 tn-helper-reset tn-helper-clearfix sf-menu sf-js-enabled sf-shadow">
            <li <% if (subMenu == ChannelFileSubMenu.Home) Response.Write("class=\"spb-nav-item tn-text-note tn-selected\""); else Response.Write("class=\"spb-nav-item\""); %>>
                <a href="<%=Globals.GetFullUrlInMainSite(SiteUrls.Instance().ChannelFileHome()) %>">
                    <span>
                        <%=GetResourceString("Title_FileFirst",ApplicationIDs.Instance().File())%></span></a></li>
            <li <% if (subMenu == ChannelFileSubMenu.Search) Response.Write("class=\"spb-nav-item tn-text-note tn-selected\""); else Response.Write("class=\"spb-nav-item\""); %>>
                <a href="<%=Globals.GetFullUrlInMainSite(SPBUrlHelper.Action("Search", "ChannelFile"))%>">
                    <span>
                        <%=GetResourceString("Title_FileSearch",ApplicationIDs.Instance().File())%></span>
                </a></li>
            <li <% if (subMenu == ChannelFileSubMenu.FileRanks) Response.Write("class=\"spb-nav-item tn-text-note tn-selected\""); else Response.Write("class=\"spb-nav-item\""); %>>
                <a href="<%=SPBUrlHelper.Action("FileRanks", "ChannelFile", new RouteValueDictionary { { "rankBy", FileThreadSortBy.StageDownloadCount} })%>">
                    <span>
                        <%=GetResourceString("Title_FileRank",ApplicationIDs.Instance().File())%></span></a></li>
            <% if (CurrentUser != null)
               { %>
            <li <% if (subMenu == ChannelFileSubMenu.MyFiles) Response.Write("class=\"spb-nav-item tn-text-note tn-selected\""); else Response.Write("class=\"spb-nav-item\""); %>>
                <a target="_blank" href="<%=Globals.GetFullUrlInMainSite(SPBUrlHelper.Action("Home", "File", new RouteValueDictionary { {"userDomainName", CurrentUser.UserName }}))%>">
                    <span>
                        <%=GetResourceString("Title_MyFile",ApplicationIDs.Instance().File())%></span></a></li>
            <%} %>
        </ul>
    </div>
</div>
<div class="spb-header-bottom">
    <div class="tn-wrapper-inner tn-helper-clearfix">
        <div class="tn-shortcut">
            <% if (CurrentUser != null)
               { %>
            <%=SPBHtmlHelper.Instance().LinkButton(string.Empty, GetResourceString("Label_UploadFile", ApplicationIDs.Instance().File()), Globals.GetFullUrlInMainSite(SPBUrlHelper.Action("UploadFiles", "File", new RouteValueDictionary { { "userDomainName", UserID2UserNameDictionary.GetUserName(Globals.GetCurrentUser().UserID) } })), ButtonSizes.Default, HighlightStyles.Primary, IconTypes.Add, TextIconLayout.IconText)%>
            <%} %>
        </div>
        <spb:BreadCrumb ID="BreadCrumb" runat="server" />
    </div>
</div>
