﻿<%@ Control Language="C#" Inherits="SpaceBuilder.Web.SPBViewUserControl" %>
<% 
    

    int? mediaTypes = Html.GetParameterFromRouteDateOrQueryString<int>("MediaType");
    int? applicationID = Html.GetParameterFromRouteDateOrQueryString<int>("applicationID");
    ViewData["applicationID"] = ApplicationIDs.Instance().Share();
    Html.RenderPartial("Controls/SubMenu.ascx", ViewData);
%>
<spb:Script runat="server" ID="JqueryFormJs" Src="~/Utility/jquery/plugin/jquery.form.min-2.7.3.js"
    SetExpireDays="30" />
<div class="spb-nav2-area">
    <div class="tn-wrapper-inner">
        <ul class="spb-nav2 tn-helper-reset tn-helper-clearfix sf-menu sf-js-enabled sf-shadow">
            <li class="spb-nav-item"><a href="<%=SPBUrlHelper.Action("ShareRanks", "ChannelShare")%>">
                <span>
                    <%=GetResourceString("Action_ShareCompositor", ApplicationIDs.Instance().Share())%></span>
            </a></li>
            <%foreach (int type in UrlParserFactory.Instance().UrlMediaTypes.Keys)
              {%>
            <li class="spb-nav-item"><a href="<%=SPBUrlHelper.Action("ShareRanks", "ChannelShare", new RouteValueDictionary { { "MediaType", type }})%>">
                <span>
                    <%=UrlParserFactory.Instance().GetMultilingualMediaTypeName(type, CurrentUserLanguage)%></span>
            </a></li>
            <%} %>
            <% foreach (int appID in ShareConfiguration.Instance().EnabledSharedApplicationIDs)
               {
                   Application application = Applications.GetApplication(appID);
                   if (application == null)
                       continue;
               
            %>
            <li class="spb-nav-item"><a href="<%=SPBUrlHelper.Action("ShareRanks", "ChannelShare", new RouteValueDictionary { { "applicationID", appID } })%>">
                <span>
                    <%=application.GetMultilingualApplicationName(CurrentUserLanguage)%></span></a>
            </li>
            <%} %>
            <%if (CurrentUser != null)
              { %>
            <li class="spb-nav-item"><a href="<%=SiteUrls.Instance().UserChannelHome(CurrentUser.UserID,ApplicationIDs.Instance().Share()) %>">
                <span>
                    <%=GetResourceString("Action_MineShare", ApplicationIDs.Instance().Share())%></span>
            </a></li>
            <%} %>
        </ul>
    </div>
</div>
<div class="spb-header-bottom">
    <div class="tn-wrapper-inner tn-helper-clearfix">
        <div class="tn-shortcut">
            <%if (Globals.GetCurrentUser()==null)
              { %>
            <%=SPBHtmlHelper.Instance().LinkButton(string.Empty, GetResourceString("Action_AddShare", ApplicationIDs.Instance().Share()),SiteUrls.Instance().Login(true), ButtonSizes.Default, HighlightStyles.Primary, IconTypes.Add, TextIconLayout.IconText)%>
            <%}
              else
              { %>
            <%=SPBHtmlHelper.Instance().LinkButton("ShareInChnannelButton", GetResourceString("Action_AddShare", ApplicationIDs.Instance().Share()), SPBUrlHelper.Action("Control_AddShare", "ChannelShare"), ButtonSizes.Default, HighlightStyles.Primary, IconTypes.Add, TextIconLayout.IconText)%>
            <%} %>
        </div>
        <spb:BreadCrumb ID="BreadCrumb1" runat="server" />
    </div>
</div>

<script type="text/javascript">
    $(document).ready(function() {
        $('#ShareInChnannelButton').dialog({ id: 'dialogID', title: '<%=GetResourceString("Action_AddShare",ApplicationIDs.Instance().Share())%>', height: 70, width: 450});
            
    });   
</script>

