﻿<%@ Control Language="C#" Inherits="SpaceBuilder.Web.SPBViewUserControl" %>
<% 
    VoteChannelSubMenu? subMenu = null;
    if (ViewData["VoteChannelSubMenu"] != null)
        subMenu = (VoteChannelSubMenu)ViewData["VoteChannelSubMenu"];
    
    int applicationID = ApplicationIDs.Instance().Vote();
    ViewData["applicationID"] = applicationID;
    Html.RenderPartial("Controls/SubMenu.ascx", ViewData);
%>
<div class="spb-nav2-area">
    <div class="tn-wrapper-inner">
        <ul class="spb-nav2 tn-helper-reset tn-helper-clearfix sf-menu sf-js-enabled sf-shadow">
            <li <% if(subMenu!=null && subMenu== VoteChannelSubMenu.voteHome) Response.Write("class=\"spb-nav-item tn-text-note tn-selected\""); else Response.Write("class=\"spb-nav-item\"");%>>
                <a href="<%=SPBUrlHelper.Action("Home","ChannelVote")%>"><span>
                    <%= GetResourceString("Action_Home",applicationID)%></span></a></li>
            <li <% if(subMenu!=null && subMenu== VoteChannelSubMenu.voteSortby)  Response.Write("class=\"spb-nav-item tn-text-note tn-selected\""); else Response.Write("class=\"spb-nav-item\""); %>>
                <a href="<%=SPBUrlHelper.Action("VoteThreadRanks","ChannelVote")%>"><span>
                    <%= GetResourceString("Action_StocksRank",applicationID)%></span></a></li>
            <%if (CurrentUser != null)
              { %>
            <li class="spb-nav-item"><a href="<%=SPBUrlHelper.Action("ListMyVoteThreads","UserDomainVote",new RouteValueDictionary{{"userDomainName",CurrentUser.UserName}})%>">
                <span>
                    <%=GetResourceString("Action_MyVote", applicationID)%></span></a></li>
            <%} %>
        </ul>
    </div>
</div>
<div class="spb-header-bottom">
    <div class="tn-wrapper-inner tn-helper-clearfix">
        <div class="tn-shortcut">
            <%if (Globals.GetCurrentUser() == null)
              { %>
            <%=SPBHtmlHelper.Instance().LinkButton(string.Empty, GetResourceString("Label_StartVote",applicationID),SiteUrls.Instance().Login(true), ButtonSizes.Default, HighlightStyles.Primary, IconTypes.Add, TextIconLayout.IconText)%>
            <%}
              else
              { %>
            <%=SPBHtmlHelper.Instance().LinkButton(string.Empty, GetResourceString("Label_StartVote",applicationID), SPBUrlHelper.Action("NewVoteThread", "UserDomainVote", new RouteValueDictionary { { "userDomainName", CurrentUser !=null ? CurrentUser.UserName : string.Empty } }), ButtonSizes.Default, HighlightStyles.Primary, IconTypes.Add, TextIconLayout.IconText)%>
            <%} %>
        </div>
        <spb:BreadCrumb ID="BreadCrumb" runat="server" />
    </div>
</div>
