﻿<%@ Control Language="C#" Inherits="SpaceBuilder.Web.SPBViewUserControl" %>
<%
    List<Link> ListLinks = null;
    if (ViewData["ListLinks"] != null)
        ListLinks = ViewData["ListLinks"] as List<Link>;
    if (ListLinks != null && ListLinks.Count > 0)
    {
%>
<div class="spb-friendly-links">
    <%
        List<LinkCategory> ListLinkCategory = null;
        if (ListLinks != null && ViewData["ListLinkCategory"] != null)
        {
            ListLinkCategory = ViewData["ListLinkCategory"] as List<LinkCategory>;
            foreach (var itemCate in ListLinkCategory)
            {%>
    <div class="tn-list-header">
        <div class="tn-list-header-row tn-helper-clearfix tn-border-gray tn-border-bottom">
            <strong>
                <%=itemCate.CategoryName%></strong>
        </div>
    </div>
    <ul class="tn-helper-reset tn-list">
        <% foreach (var itemLink in ListLinks)
           {
               if (itemLink.CategoryID == itemCate.CategoryID)
               {
                   if (itemLink.LinkType == LinkTypes.Text)
                   {
                       Response.Write(string.Format("<li><a rel=\"nofollow\" target=\"_blank\" title=\"{0}\" href=\"{1}\">{2}</a></li>", itemLink.LinkTitle, itemLink.LinkHref, itemLink.Title));
                   }
                   else
                   {
                       Response.Write(string.Format("<li><a rel=\"nofollow\" target=\"_blank\" title=\"{0}\" href=\"{1}\"><img src=\"{2}\" /></a></li>", itemLink.LinkTitle, itemLink.LinkHref, SiteUrls.Instance().LinkPhoto(itemLink, LinkPosition.Club)));
                   }
               }
           }
        %></ul>
    <%
        }
        }
    %>
</div>
<%} %>