﻿<%@ Control Language="C#" Inherits="SpaceBuilder.Web.SPBViewUserControl<User>" %>
<%ICollection<ClubMember> clubAssistants = ViewData.Get<ICollection<ClubMember>>("clubAssistants", null); %>
<ul class="tn-list tn-helper-reset">
    <li class="tn-list-item tn-helper-clearfix">
        <div class="tn-list-item-area-left">
            <div class="tn-avatar">
                <%=SPBHtmlHelper.Instance().ShowUserAvatar(Model.UserID, true, HyperLinkTarget._blank, AvatarSizeTypes.Small,null)%>
            </div>
        </div>
        <div class="tn-list-item-area-main">
            <div class="tn-list-item-row tn-list-item-heading">
                <h5 class="tn-helper-reset">&nbsp; <span title="<%=GetResourceString("Title_ClubOwner",ApplicationIDs.Instance().Club()) %>" class="tn-icon tn-icon-creator tn-icon-inline"></span>
                    <a target="_blank" href="<%=SiteUrls.Instance().UserDomainHome(Model) %>">
                        <%=Model.DisplayName%></a></h5>
            </div>
            <div class="tn-list-item-row tn-list-item-summary">
                <%string userData = MicroBlogUserDatas.GetUserData(Model.UserID, false).MostRecentThreadBody;
                  if (!string.IsNullOrEmpty(userData))
                  { %>
                <div class="spb-i-said">
                    &nbsp;<span class="tn-icon tn-icon-quotes-before tn-icon-inline"></span>
                    <%=userData%>
                    <span class="tn-icon tn-icon-quotes-after tn-icon-inline"></span>
                </div>
                <%} %>
            </div>
        </div>
    </li>
    <%if (clubAssistants != null)
      {
          foreach (ClubMember member in clubAssistants)
          { %>
        <li class="tn-list-item tn-helper-clearfix">
        <div class="tn-list-item-area-left">
            <div class="tn-avatar">
                <%=SPBHtmlHelper.Instance().ShowUserAvatar(member.UserID, true, HyperLinkTarget._blank, AvatarSizeTypes.Small,null)%>
            </div>
        </div>
        <div class="tn-list-item-area-main">
            <div class="tn-list-item-row tn-list-item-heading">
                <h5 class="tn-helper-reset">
               &nbsp; <span title="<%=GetResourceString("Title_ClubAssistant",ApplicationIDs.Instance().Club()) %>" class="tn-icon tn-icon-manager tn-icon-inline"></span>
                    <a target="_blank" href="<%=SiteUrls.Instance().UserDomainHome(member.User) %>">
                        <%=member.DisplayName %></a></h5>
            </div>
            <div class="tn-list-item-row tn-list-item-summary">
                <% userData = MicroBlogUserDatas.GetUserData(member.UserID, false).MostRecentThreadBody;
                  if (!string.IsNullOrEmpty(userData))
                  { %>
                <div class="spb-i-said">
                    &nbsp;<span class="tn-icon tn-icon-quotes-before tn-icon-inline"></span>
                    <%=userData%>
                    <span class="tn-icon tn-icon-quotes-after tn-icon-inline"></span>
                </div>
                <%} %>
            </div>
        </div>
    </li>
    <%}
      } %>
</ul>
