﻿<%@ Control Language="C#" Inherits="SpaceBuilder.Web.SPBViewUserControl" %>
<% Club currentClub = Clubs.GetClub(Html.GetParameterFromRouteDateOrQueryString("clubDomainName"), false);

   string excetionType = ExceptionTypes.Instance().AccessDenied();
   int applicationID = ApplicationIDs.Instance().Club();
   if (currentClub != null)
   {
       bool isClubMember = false;
       if (CurrentUser != null)
       {
           ClubMember member = ClubMembers.GetClubMember(currentClub.ClubID, CurrentUser.UserID, true);
           if (member != null)
               isClubMember = true;
       }

%>
<div class="spb-club-panel">
    <div class="spb-avatar-area">
        <div class="tn-avatar-big">
            <%=SPBHtmlHelper.Instance().ShowClubLogo(currentClub.ClubID, ClubLogoSizeTypes.Normal,false,null)%>
        </div>
        <% if (CurrentUser != null && !currentClub.HasLogo && ClubPermission.Validate(currentClub.DomainName, CurrentUser, PermissionItemKeys.Instance().EditClub()))
           { %>
        <span class="tn-action"><a class="tn-action-text" href="<%=SPBUrlHelper.Action("ClubLogo","ClubManage",new RouteValueDictionary{{"clubDomainName",Html.GetParameterFromRouteDateOrQueryString("clubDomainName")}}) %>">
            <% if (currentClub.HasLogo) Response.Write(GetResourceString("Action_UpdateClubLog", applicationID)); else Response.Write(GetResourceString("Action_AddClubLog", applicationID)); %>
        </a></span>
        <%} %>
    </div>
    <ul class="tn-side-menu">
        <% if (CurrentUser != null && isClubMember && CurrentUser.UserID != currentClub.ClubOwnerUserID)
           {  %>
        <li class="tn-border-gray tn-border-bottom">
            <%=SPBHtmlHelper.Instance().Icon(IconTypes.Quit) %><a onclick="if(!confirm('<%=GetResourceString("Message_ConfirmExitThisClub",applicationID) %>')) return false;"
                class="tn-menu-text" href="<%=SPBUrlHelper.Action("QuitFromClub","ClubDomain",new RouteValueDictionary{{"clubDomainName",Html.GetParameterFromRouteDateOrQueryString("clubDomainName")},{"userID",CurrentUser != null ? CurrentUser.UserID : 0}}) %>">
                <%=GetResourceString("Action_QuitFromClub", applicationID)%></a></li>
        <% }%>
        <li class="tn-border-gray tn-border-bottom">
            <%=SPBHtmlHelper.Instance().Icon(IconTypes.Share) %>
            <%if (CurrentUser != null)
              { %>
            <a class="tn-menu-text" id="shareLink" href="<%=SiteUrls.Instance().ShareInModal(false,Request.RawUrl, currentClub.DomainName, HtmlUtils.TrimHtml(currentClub.Brief, 140),SiteUrls.Instance().ClubLogoUrl(currentClub.ClubID,ClubLogoSizeTypes.Small,false), ApplicationIDs.Instance().Club(), currentClub.ClubOwnerUserID, currentClub.ClubOwner.UserName)%>">
                <span>
                    <%=GetResourceString("Common_Share")%></span></a>
            <%}
              else
              { %><a class="tn-menu-text" href="<%=SiteUrls.Instance().Login(true)%>"> <span>
                  <%=GetResourceString("Common_Share")%></span></a><%} %>
        </li>
    </ul>
    <div class="tn-info-part tn-text-note">
        <% if (currentClub.ClubSiteCategoy != null)
           {%>
        <dl>
            <dt>
                <%=GetResourceString("Label_BelongCategory", applicationID)%><%=GetResourceString("Common_Colon") %></dt>
            <dd>
                <a href="<%=SPBUrlHelper.Action("Search", "ChannelClub", new RouteValueDictionary { { "categoryID", currentClub.CategoryID } })%>"
                    target="_blank">
                    <%=currentClub.ClubSiteCategoy.GetMultilingualCategoryName(CurrentUserLanguage)%></a></dd>
        </dl>
        <% } %>
        <%if (currentClub.Area != null)
          { %>
        <dl>
            <dt>
                <%=GetResourceString("Label_BelongArea", applicationID)%><%=GetResourceString("Common_Colon") %></dt>
            <dd>
                <a href="<%=SPBUrlHelper.Action("Search","ChannelClub",new RouteValueDictionary{{"areaCode",currentClub.AreaCode}}) %>"
                    target="_blank">
                    <%=Formatter.FormatArea(currentClub.AreaCode,true) %></a></dd>
        </dl>
        <%} %>
        <dl>
            <dt>
                <%=GetResourceString("Label_ClubPublic", applicationID)%><%=GetResourceString("Common_Colon") %></dt>
            <dd>
                <% if (currentClub.IsPublic) Response.Write("公开群组"); else Response.Write("私有群组"); %>
            </dd>
        </dl>
        <dl>
            <dt>
                <%=GetResourceString("Label_DateCreated")%><%=GetResourceString("Common_Colon") %></dt>
            <dd>
                <%=Formatter.FormatDate(currentClub.DateCreated) %></dd>
        </dl>
        <dl>
            <dt>
                <%=GetResourceString("Label_HitTimesCount", applicationID)%><%=GetResourceString("Common_Colon") %></dt>
            <dd>
                <%=currentClub.HitTimes %></dd>
        </dl>
        <dl>
            <dt>
                <%=GetResourceString("Label_WeekHitTimesCount", applicationID)%><%=GetResourceString("Common_Colon") %></dt>
            <dd>
                <%=currentClub.StageHitTimes %></dd>
        </dl>
        <dl>
            <dt>
                <%=GetResourceString("Label_Point") %><%=GetResourceString("Common_Colon") %></dt>
            <dd>
                <%=currentClub.Points %></dd>
        </dl>
        <dl>
            <dt>
                <%=GetResourceString("Label_ClubMemberCount", applicationID)%><%=GetResourceString("Common_Colon") %></dt>
            <dd>
                <%=currentClub.MemberCount %></dd>
        </dl>
        <%--<div>
            <% Dictionary<int, ClubApplicationSettings> applicationSettingss = ClubApplicationSettingss.GetClubApplicationSettingss(currentClub.ClubID);
               Dictionary<int, Application> applications = Applications.GetApplications();
            %>
            <% foreach (KeyValuePair<int, ClubApplicationSettings> pair in applicationSettingss)
               { %>
            <% if (applications.ContainsKey(pair.Key) && pair.Value.ItemCount > 0)
               { %>
            <dl>
                <dt>
                    <%=applications[pair.Key].GetMultilingualApplicationName(CurrentUserLanguage)%><%=GetResourceString("Common_Colon") %></dt>
                <dd>
                    <%=pair.Value.ItemCount %></dd>
            </dl>
            <%}
           } %>
           </div>--%>
    </div>
</div>
<script type="text/javascript">
    $(document).ready(function () {
        $('#recommendClubModel').nyroModal({
            resizeable: true,
            height: 450,
            width: 400
        });
        $('#shareLink').nyroModal({
            resizeable: true,
            width: 500
        });
    }); 
</script>
<%}%>
