﻿<%@ Control Language="C#" Inherits="SpaceBuilder.Web.SPBViewUserControl<IList<EventThread>>" %>
<div class="spb-club-events-list">
    <% int applicationID = ApplicationIDs.Instance().Club();
       if (Model.Count <= 0)
       { %>
    <%=GetResourceString("Description_NoEvent", applicationID)%>
    <%}
       else
       {%>
    <ul class="tn-list">
        <% foreach (EventThread thread in ViewData.Model)
           { %>
        <li class="tn-list-item tn-helper-clearfix">
            <div class="tn-list-item-area-left">
                <div class="tn-avatar">
                    <%=SPBHtmlHelper.Instance().ShowEventLogo(thread, true, "_self", EventPhotoTypes.SmallLogo)%></div>
            </div>
            <div class="tn-list-item-area-main">
                <div class="tn-list-item-row tn-list-item-heading">
                    <h5 class="tn-helper-reset">
                        <a target="_blank" href="<%=SiteUrls.Instance().ShowEvent(thread.EventID) %>">
                            <%=StringUtils.Trim(thread.EventName,14) %></a></h5>
                </div>
                <div class="tn-list-item-row tn-text-note">
                    <cite class="tn-date"><%=GetResourceString("Label_Time", ApplicationIDs.Instance().Event())%><%=GetResourceString("Common_Colon")%></em><%=Formatter.FormatDate(thread.DateCreated) %></cite> 
                    <cite class="tn-location"><%=GetResourceString("Label_Place", ApplicationIDs.Instance().Event())%><%=GetResourceString("Common_Colon")%><a href="<%=SiteUrls.Instance().ListEventsByAreaCode(thread.AreaCode) %>"><%=Formatter.FormatArea(thread.AreaCode,1,2) %></a></cite>
                </div>
            </div>
        </li>
        <%}%></ul>
    <%} %>
</div>
