﻿<%@ Control Language="C#" Inherits="SpaceBuilder.Web.SPBViewUserControl" %>
<%
    ForumPost forumPost = ViewData.Get<ForumPost>("forumPost", null);
    ForumSection forumSection = ViewData.Get<ForumSection>("forumSection", null);
    int forumsApplication = ApplicationIDs.Instance().Forum();
    int replyUserID = Html.GetParameterFromRouteDateOrQueryString<int>("replyUserID");
    bool isDesc = Html.GetParameterFromRouteDateOrQueryString<bool>("isDesc");
    string clubDomainName = Html.GetParameterFromRouteDateOrQueryString("clubDomainName");
    bool hasEditPermission = (CurrentUser != null && CurrentUser.UserID == forumPost.UserID) || (CurrentUser != null && ClubPermission.Validate(clubDomainName, CurrentUser, PermissionItemKeys.Instance().EditClubForumPost()));
    string postBody = forumPost.GetBody(hasEditPermission);
    int postCount = 0;
    string signature = string.Empty;
    ForumUserData userData = ForumUserDatas.GetUserData(forumPost.UserID, false);
    if (userData != null)
    {
        postCount = userData.PostCount;
        signature = userData.Signature;
    }
    int number = ViewData.GetInt("number", 0);
    int threadID = Html.GetParameterFromRouteDateOrQueryString<int>("threadID");
    int pageIndex = Html.GetParameterFromRouteDateOrQueryString<int>("pageIndex");
    bool isShowReply = ViewData.GetBool("isShowReply", false);%>
<div class="tn-widget-content spb-post-floor spb-reply-floor">
    <a name="<%=forumPost.PostID %>"></a>
    <a name="f_<%=number %>"></a>
    <table>
        <tbody>
            <tr>
                <td class="tn-widget-content spb-post-side" rowspan="2">
                    <span class="tn-user-name">
                        <a href="<%=SiteUrls.Instance().UserChannelHome(forumPost.UserID,ApplicationIDs.Instance().Forum()) %>">
                            <strong>
                                <%=forumPost.Author %></strong></a>
                        <% if (forumPost.AuthorUser != null && forumPost.AuthorUser.IsOnline)
                           { %>
                        <img alt="<%=GetResourceString("Action_OnLine", forumsApplication)%>" src="<%=Globals.GetFullUrlInResourceSite("~/Themes/Shared/Styles/Icons/user_IsOnline.gif")%>" />
                        <% }
                           else
                           { %>
                        <img alt="<%=GetResourceString("Action_Offline", forumsApplication)%>" src="<%=WebUtils.FullPath(Globals.GetFullUrlInResourceSite("~/Themes/Shared/Styles/Icons/user_IsOffline.gif"))%>" />
                        <%} %>
                    </span>
                    <div class="tn-avatar-medium" value="<%=forumPost.UserID %>">
                        <%=SPBHtmlHelper.Instance().ShowUserAvatar(forumPost.UserID, true, HyperLinkTarget._blank, AvatarSizeTypes.Card)%>
                    </div>
                    <% if (forumPost.AuthorUser != null)
                       {
                    %>
                    <div class="tn-info-part">
                        <% string roleIcons = SPBHtmlHelper.Instance().ShowUserRoleIcons(forumPost.AuthorUser);
                           if (!string.IsNullOrEmpty(roleIcons))
                           { %>
                        <dl>
                            <dt>
                                <%=GetResourceString("Label_PersonUserTitle",ApplicationIDs.Instance().User())%><%=GetResourceString("Common_Colon") %></dt>
                            <dd>
                                <span class="spb-user-type">
                                    <%=roleIcons %></span></dd>
                        </dl>
                        <%} %>
                        <dl>
                            <dt>
                                <%=GetResourceString("Label_Rank")%><%=GetResourceString("Common_Colon")%></dt>
                            <dd>
                                <span class="spb-user-type">
                                    <%=SPBHtmlHelper.Instance().ShowUserRankIcons(forumPost.AuthorUser) %>
                                </span>
                            </dd>
                        </dl>
                        <% if (forumPost.AuthorUser.UserType == UserTypes.PersonUser && (forumPost.AuthorUser as PersonUser) != null)
                           { %>
                        <dl>
                            <dt></dt>
                            <dd>
                                <span class="spb-user-type">
                                    <%=Formatter.FormatArea((forumPost.AuthorUser as PersonUser).NowAreaCode, true)%>
                                </span>
                            </dd>
                        </dl>
                        <%} %>
                        <dl>
                            <dt>
                                <%=GetResourceString("Label_SendTopic", forumsApplication)%><%=GetResourceString("Common_Colon")%></dt>
                            <dd>
                                <%=postCount%></dd>
                        </dl>
                        <dl>
                            <dt>
                                <%=GetResourceString("Action_RegistrationDate", forumsApplication)%><%=GetResourceString("Common_Colon")%></dt>
                            <dd>
                                <%=Formatter.FormatDate(forumPost.AuthorUser.DateCreated) %></dd>
                        </dl>
                    </div>
                    <%} %>
                </td>
                <td class="spb-post-content">
                    <div class="spb-post-meta tn-border-gray tn-border-bottom">
                        <span class="spb-post-number tn-helper-right">
                            <%  if (number > 2)
                                    Response.Write(number + GetResourceString("Label_Floor", forumsApplication));
                                else if (number == 1)
                                    Response.Write(GetResourceString("Action_Sofa", forumsApplication));
                                else if (number == 2)
                                    Response.Write(GetResourceString("Action_Woodenbench", forumsApplication));
                            %></span><em class="tn-date"><%=GetResourceString("Label_AppearOf",forumsApplication)%><%=GetResourceString("Common_Colon")%><%=Formatter.FormatDate(forumPost.PostDate,true) %></em>
                        <% 
                            if (replyUserID == forumPost.UserID)
                                Response.Write(SPBHtmlHelper.Instance().ActionLink(GetResourceString("Action_SeeAll", forumsApplication), SiteUrls.Instance().ShowForumThread(forumPost.ThreadID, null, isDesc)));
                            else if (replyUserID <= 0)
                                Response.Write(SPBHtmlHelper.Instance().ActionLink(GetResourceString("Action_SeeAuthor", forumsApplication), SiteUrls.Instance().ShowForumThread(forumPost.ThreadID, forumPost.UserID, isDesc)));
                            Response.Write(SPBHtmlHelper.Instance().ActionLink(isDesc ? GetResourceString("Action_ASC", forumsApplication) : GetResourceString("Action_DESC", forumsApplication), SiteUrls.Instance().ShowForumThread(forumPost.ThreadID, replyUserID, !isDesc)));                           
                        %>
                    </div>
                    <div class="tn-detail-text">
                        <%=SPBHtmlHelper.Instance().ShowAdvertisingInClubDomain("001302110002", clubDomainName, new RouteValueDictionary { { "class", "spb-ad-flag" } })%>
                        <strong class="spb-reply-title">
                            <a href="<%=SiteUrls.Instance().ShowForumThreadGotoLastPost(forumPost.ThreadID,forumPost.ParentID) %>"
                                title="<%=GetResourceString("Description_PointTurning",forumsApplication)%>">
                                <%=forumPost.Subject  %></a></strong>
                        <%=postBody %>
                    </div>
                    <%
                        if (CurrentUser != null && forumPost.HasAttachment && ClubPermission.Validate(clubDomainName, CurrentUser, PermissionItemKeys.Instance().DownClubForumAttachment()))
                        {
                            List<Attachment> attachments = ForumAttachmentManager.Instance().GetAttachmentsByAssociateID(forumPost.PostID, hasEditPermission);
                            if (attachments != null && attachments.Count(n => !n.IsImage) > 0)
                            {  %>
                    <div class="tn-annex-fix">
                        <div class="tn-text-heading tn-border-bottom tn-border-gray">
                            <h4>
                                <%=GetResourceString("Label_Attachment")%></h4>
                            <span class="tn-icon tn-icon-paper-clip"></span>
                        </div>
                        <ul class="tn-helper-reset tn-list tn-annex-list">
                            <%
                                foreach (Attachment attachment in attachments)
                                {
                                    ForumAttachment forumAttachment = attachment as ForumAttachment;
                                    if (attachment.IsImage)
                                        continue;
                            %>
                            <li class="tn-annex-item">
                                <span class="tn-annex-icon">
                                    <%=SPBHtmlHelper.Instance().ContentTypeThumbnail(attachment.FileName, ContentTypeThumbnailSize.Small)%></span>
                                <% if (forumAttachment != null && forumAttachment.IsHidden && !ForumPosts.IsReplyer(forumPost.ThreadID, CurrentUser != null ? CurrentUser.UserID : 0))
                                   {
                                       Response.Write(string.Format("{0}(需要回复才可下载)", attachment.FriendlyFileName));
                                   }
                                   else if (CurrentUser != null && attachment.Price > 0
                                        && !ForumAttachmentManager.Instance().IsPayOut(attachment.AttachmentID, CurrentUser.UserID)
                                        && !hasEditPermission)
                                   {%>
                                <% if (CurrentUser == null)
                                       Response.Write(attachment.FriendlyFileName);
                                   else
                                   {%>
                                <a href="<%=Url.Action("ExchangeAttachmentAction", "ChannelForum", new { attachmentID = attachment.AttachmentID }) %>"
                                    onclick="if(!confirm('<%=string.Format(GetResourceString("Message_ConfirmShopping", forumsApplication), attachment.Price)%>')){return false;}"
                                    target="_self">
                                    <%=attachment.FriendlyFileName%></a>
                                <%} %>
                                <em class="tn-count tn-text-note">（<%=attachment.Friendlylength%>）</em>
                                <%=GetResourceString("Label_NeedIntegral",forumsApplication)%><%=GetResourceString("Common_Colon") %><%=attachment.Price%>，
                                <% if (CurrentUser == null)
                                   {%>
                                <%=string.Format(GetResourceString("Label_Pattern_NotLogin", forumsApplication), SiteUrls.Instance().Login(true), GetResourceString("Action_Login"))%>
                                <% 
                                    }
                                   else
                                   {  %>
                                <a href="<%=Url.Action("ExchangeAttachmentAction", "ChannelForum", new { attachmentID = attachment.AttachmentID }) %>"
                                    onclick="if(!confirm('<%=string.Format(GetResourceString("Message_ConfirmShopping", forumsApplication), attachment.Price)%>')){return false;}"
                                    target="_self">[<%=GetResourceString("Action_Buy",forumsApplication)%>]</a>
                                <%}
                                   }
                                   else
                                   {%>
                                <a href="<%=SiteUrls.Instance().DownloadForumAttachment(attachment.AttachmentID) %>"
                                    target="_blank">
                                    <%=attachment.FriendlyFileName%></a><em class="tn-count tn-text-note">（<%=attachment.Friendlylength%>）</em>
                                <%
                                    if (attachment.Price > 0)
                                    {
                                        if (CurrentUser != null && ForumAttachmentManager.Instance().IsPayOut(attachment.AttachmentID, CurrentUser.UserID))
                                        { 
                                %>
                                <%=string.Format(GetResourceString("Description_Pattern_DirectnessDownload", forumsApplication), attachment.Price)%>
                                <%}
                                        else
                                        {
                                %>
                                <%=string.Format(GetResourceString("Description_Pattern_AdminLimitDownload", forumsApplication), attachment.Price)%>
                                <%}
                                    }
                                   }
                                %>
                            </li>
                            <%} %>
                        </ul>
                    </div>
                    <%} %>
                    <%} %>
                </td>
            </tr>
            <tr>
                <td class="spb-post-content">
                    <% if (forumPost.IsUseSignature && !string.IsNullOrEmpty(signature))
                       { %>
                    <div class="spb-sign tn-border-gray tn-border-top">
                        <span class="tn-icon tn-icon-pen"></span>
                        <%=signature %></div>
                    <%} %>
                </td>
            </tr>
            <tr>
                <td class="tn-widget-content spb-post-side">
                    <div class="tn-info-part">
                        <dl>
                            <dt>IP:</dt>
                            <dd>
                                <%=SPBHtmlHelper.Instance().ShowPostIPAddress(forumPost.UserHostAddress)%></dd>
                        </dl>
                    </div>
                </td>
                <td class="spb-post-content">
                    <%=SPBHtmlHelper.Instance().ShowAdvertisingInClubDomain("001302110003", clubDomainName, new RouteValueDictionary { { "class", "spb-ad-topic" } })%>
                    <div class="tn-actions tn-border-gray tn-border-top">
                        <span class="tn-helper-right">
                            <% if (CurrentUser == null) Response.Write(SPBHtmlHelper.Instance().ActionLink(string.Empty, GetResourceString("Button_Report"), SiteUrls.Instance().NewImpeachReport(), IconTypes.Alert, TextIconLayout.IconText, new RouteValueDictionary { { "class", "nyroModal" } }, null));%>
                            <%=SPBHtmlHelper.Instance().ActionLink(string.Empty, GetResourceString("Action_GotoTop",forumsApplication), "javascript:;", null, TextIconLayout.TextOnly, new RouteValueDictionary { { "onclick", "scrollTo(0,0);" } }, null)%>
                        </span>
                        <% if (CurrentUser != null)
                           {
                               if (isShowReply)
                               {
                                   //回复
                                   Response.Write(SPBHtmlHelper.Instance().ActionLink(string.Empty, GetResourceString("Common_Reply"), SPBUrlHelper.Action("NewForumPost", "ClubForum", new RouteValueDictionary { { "clubDomainName", clubDomainName }, { "parentID", forumPost.PostID } }), IconTypes.Bubble, TextIconLayout.IconText, new RouteValueDictionary { { "name", "quickReplyButton" }, { "class", "{author:'" + forumPost.Author + "',postID:'" + forumPost.PostID + "',number:'" + number + GetResourceString("Label_Floor", forumsApplication) + "'}" } }, null));
                                   //引用
                                   Response.Write(SPBHtmlHelper.Instance().ActionLink(string.Empty, GetResourceString("Action_Quote", forumsApplication), SPBUrlHelper.Action("NewForumPost", "ClubForum", new RouteValueDictionary { { "clubDomainName", clubDomainName }, { "parentID", forumPost.PostID }, { "quote", true } }), IconTypes.QuotesBefore));
                               }
                           }
                           else
                           {
                               //回复
                               Response.Write(SPBHtmlHelper.Instance().ActionLink(string.Empty, GetResourceString("Common_Reply"), SiteUrls.Instance().Login(true), IconTypes.Bubble, TextIconLayout.IconText, new RouteValueDictionary { { "name", "quickReplyButton" } }, null));
                               //引用
                               Response.Write(SPBHtmlHelper.Instance().ActionLink(string.Empty, GetResourceString("Action_Quote", forumsApplication), SiteUrls.Instance().Login(true), IconTypes.QuotesBefore));
                           }
                           if (hasEditPermission)
                           {
                               Response.Write(SPBHtmlHelper.Instance().ActionLink(string.Empty, GetResourceString("Action_Edit"), SPBUrlHelper.Action("EditForumPost", "ClubForum", new RouteValueDictionary { { "clubDomainName", clubDomainName }, { "postID", forumPost.PostID } }), IconTypes.Write));
                               Response.Write(SPBHtmlHelper.Instance().ActionLink(string.Empty, GetResourceString("Action_Delete"), SPBUrlHelper.Action("DeleteForumPost", "ClubForum", new RouteValueDictionary { { "clubDomainName", clubDomainName }, { "postID", forumPost.PostID }, { "returnUrl", SPBUrlHelper.Action("ShowForumThread", "ClubForum", new RouteValueDictionary { { "clubDomainName", clubDomainName }, { "threadID", threadID }, { "pageIndex", pageIndex } }) } }), IconTypes.Cross, TextIconLayout.IconText, new RouteValueDictionary { { "name", "deletePostButton" } }, null));
                           }
                        %>
                    </div>
                </td>
            </tr>
            <tr class="spb-post-space">
                <td class="tn-widget-content spb-post-side tn-bg-light">
                </td>
                <td class="tn-widget-content spb-post-content tn-bg-light">
                </td>
            </tr>
        </tbody>
    </table>
</div>
