﻿<%@ Control Language="C#" Inherits="SpaceBuilder.Web.SPBViewUserControl<PagingDataSet<ForumThread>>" %>
<%int applicationID = ApplicationIDs.Instance().Forum();
  int sortBy = ViewData.GetInt("SortBy", (int)ForumThreadSortBy.PostDate);
  bool? isEssential = ViewData.GetBool("isEssential");
  if (!isEssential.Value) isEssential = null;
  string clubDomainName = Html.GetParameterFromRouteDateOrQueryString("clubDomainName");
%>
<table class="tn-table-grid" id="listFourms_<%=sortBy %>">
    <tbody>
        <tr class="tn-table-grid-header">
            <td class="tn-border-gray tn-border-bottom" colspan="2">
                <input type="checkbox" name="isEssential_<%=sortBy %>" id="isEssential_<%=sortBy %>"
                    class="tn-checkbox" value="<%=isEssential %>" <%if(isEssential.HasValue && isEssential.Value) Response.Write("checked=\"checked\"");%> />
                <label for="isEssential_<%=sortBy %>">
                    <%=GetResourceString("Action_Essential",applicationID)%></label>
            </td>
            <td class="tn-border-gray tn-border-bottom tn-text-note">
                <%=GetResourceString("Label_Author")%>
            </td>
            <td class="tn-border-gray tn-border-bottom tn-text-note">
                <%=GetResourceString("Common_Reply")%>/
                <%=GetResourceString("Common_Browse")%>
            </td>
            <td class="tn-border-gray tn-border-bottom tn-text-note">
                <%=GetResourceString("Label_LastRepliedDate", applicationID)%>
            </td>
        </tr>
        <%string iconClass = string.Empty;
          foreach (var forumThread in Model.Records)
          {%>
        <tr class="tn-table-grid-row">
            <td class="tn-border-gray tn-border-bottom spb-topic-icon">
                <a target="_blank" title="<%=GetResourceString("Action_Blank",applicationID)%>" href="<%=SPBUrlHelper.Action("ShowForumThread","ClubForum",new RouteValueDictionary{{"clubDomainName",clubDomainName},{"threadID",forumThread.ThreadID}})%>">
                    <%bool isLock = false;
                      bool IsElite = false;
                      bool isHot = false;

                      if (forumThread.IsLocked)
                      {
                          Response.Write("<span class=\"tn-icon tn-icon-big tn-icon-topic-lock\" title=\"锁定主题\"></span>");
                          isLock = true;
                      }
                      else if (forumThread.IsEssential)
                      {
                          Response.Write("<span class=\"tn-icon tn-icon-big tn-icon-topic-elite\" title=\"精华主题\"></span>");
                          IsElite = true;
                      }
                      else if (forumThread.IsHot)
                      {
                          Response.Write("<span class=\"tn-icon tn-icon-big tn-icon-topic-fire\" title=\"热门主题\"></span>");
                          isHot = true;
                      }
                      else
                      {
                          Response.Write("<span class=\"tn-icon tn-icon-big tn-icon-topic-normal\"  title=\"普通主题\"></span>");
                      }%>
                </a>
            </td>
            <td class="tn-border-gray tn-border-bottom tn-width-auto">
                <% if (forumThread.ForumSection != null)
                   { %>
                <a class="tn-category" href="<%=SPBUrlHelper.Action("ShowForumSection", "ClubForum",new RouteValueDictionary {  { "clubDomainName", clubDomainName },{"sectionID",forumThread.ForumSection.SectionID}}) %>">
                    【<%=forumThread.ForumSection.SectionName%>】</a>
                <%} %>
                <a class="tn-text-heading" <%=forumThread.HighlightStyle %> href="<%=SPBUrlHelper.Action("ShowForumThread","ClubForum",new RouteValueDictionary{{"clubDomainName",clubDomainName},{"threadID",forumThread.ThreadID}})%>">
                    <%=forumThread.Subject %></a>
                <%Response.Write(StampManager.Instance().GetStamp(forumThread.StampID, true));
                  if (forumThread.IsSticky)
                      Response.Write(SPBHtmlHelper.Instance().Icon(IconTypes.Top, GetResourceString("Action_Top", applicationID), new RouteValueDictionary { { "class", "tn-icon-inline" } }));
                  if (forumThread.IsEssential && !IsElite)
                      Response.Write(SPBHtmlHelper.Instance().Icon(IconTypes.Elite, GetResourceString("Action_Essential", applicationID), new RouteValueDictionary { { "class", "tn-icon-inline" } }));
                  if (forumThread.Price > 0)
                      Response.Write(SPBHtmlHelper.Instance().Icon(IconTypes.Coins, string.Format(GetResourceString("Action_Takes", applicationID), forumThread.Price), new RouteValueDictionary { { "class", "tn-icon-inline" } }));
                  if (forumThread.IsHot && !isHot)
                      Response.Write(SPBHtmlHelper.Instance().Icon(IconTypes.Fire, GetResourceString("Action_HotTopic", applicationID), new RouteValueDictionary { { "class", "tn-icon-inline" } }));
                  if (forumThread.IsLocked && !isLock)
                      Response.Write(SPBHtmlHelper.Instance().Icon(IconTypes.Lock, GetResourceString("Action_Lock", applicationID), new RouteValueDictionary { { "class", " tn-icon-inline" } }));%>
                <%=SPBHtmlHelper.Instance().ContentTypeThumbnail(forumThread.AttachmentFilename,ContentTypeThumbnailSize.Small)%>
                <%if (forumThread.ReplyCount > ForumConfiguration.Instance().PostsPerPage)
                  { %>
                <span class="spb-topic-pages tn-text-note">
                    <%=SPBHtmlHelper.Instance().ShowForumThreadPager(forumThread,null) %></span>
                <%} %>
            </td>
            <td class="tn-border-gray tn-border-bottom tn-width-user-name tn-nowrap">
                <cite>
                    <a href="<%=SiteUrls.Instance().UserChannelHome(forumThread.UserID,ApplicationIDs.Instance().Forum()) %>">
                        <%=forumThread.Author %></a></cite> <em class="tn-text-note">
                            <%=Formatter.FormatFriendlyDate(forumThread.PostDate) %></em> </td>
            <td class="tn-border-gray tn-border-bottom tn-width-number tn-nowrap">
                <cite>
                    <a href="<%=SPBUrlHelper.Action("ShowForumThread","ClubForum",new RouteValueDictionary{{"clubDomainName",clubDomainName},{"threadID",forumThread.ThreadID}})%>">
                        <%=forumThread.ReplyCount %></a></cite> <em class="tn-text-note">
                            <%=forumThread.HitTimes %></em> </td>
            <td class="tn-border-gray tn-border-bottom tn-width-user-name tn-nowrap">
                <%if (forumThread.MostRecentPostAuthorID > 0)
                  { %>
                <cite>
                    <a href="<%=SiteUrls.Instance().UserChannelHome(forumThread.MostRecentPostAuthorID,ApplicationIDs.Instance().Forum()) %>">
                        <%=forumThread.MostRecentPostAuthor %></a></cite><a href="<%=SiteUrls.Instance().ShowForumThreadGotoLastPost(forumThread.ThreadID, forumThread.MostRecentPostID)%>"
                            title="<%=forumThread.LastRepliedDate %>"><em class="tn-text-note">
                                <%=Formatter.FormatFriendlyDate(forumThread.LastRepliedDate) %></em></a>
                <%} %>
            </td>
        </tr>
        <%} %>
    </tbody>
</table>
<div class="tn-pagination tn-helper-align-center">
    <%if (Model.TotalRecords > Model.PageSize)
      {%>
    <%=SPBHtmlHelper.Instance().AjaxPagingButton(PaginationMode.NumericNextPrevious, Model.TotalRecords, Model.PageSize, Model.PageIndex, 7, SPBUrlHelper.Action("Control_ListForumThreads", "ClubForum", new RouteValueDictionary {{"clubDomainName",clubDomainName},{ "sortBy", (int)sortBy }, { "isEssential", isEssential }, { "pageIndex", "{0}" } }), "pageIndexChange")%>
    <%} %>
    <div class="tn-page-results tn-text-note">
        <%if (Model.PageIndex > 1)
          {
              int count = Model.PageSize * Model.PageIndex;

              Response.Write((count - Model.PageSize) + "-" + count);
          }%>共
        <%=Model.TotalRecords %>个</div>
</div>

<script type="text/javascript">
    $(document).ready(function() {
        $('#isEssential_<%=sortBy %>').click(function() {
            if ($(this).attr("checked"))
                $('#listFourms_<%=sortBy %>').parent().load('<%=SPBUrlHelper.Action("Control_ListForumThreads", "ClubForum", new RouteValueDictionary {{"clubDomainName",clubDomainName}, { "sortBy", (int)sortBy }, { "isEssential", true }}) %>');
            else
                $('#listFourms_<%=sortBy %>').parent().load('<%=SPBUrlHelper.Action("Control_ListForumThreads", "ClubForum", new RouteValueDictionary {{"clubDomainName",clubDomainName}, { "sortBy", (int)sortBy }}) %>');
        });
    });
    function pageIndexChange(url) {
        $('#listFourms_<%=sortBy %>').parent().load(url);
    }
</script>

