﻿<%@ Control Language="C#" Inherits="SpaceBuilder.Web.SPBViewUserControl<IList<ForumThread>>" %>
<% string clubDomainName = Html.GetParameterFromRouteDateOrQueryString("clubDomainName");
   int applicationID = ApplicationIDs.Instance().Club();
%>
<%if (Model != null && Model.Count > 0)
  { %>

<table class="tn-table-grid">
  <tbody>
    <tr class="tn-table-grid-header">
      <th class="tn-border-gray tn-border-bottom tn-text-note"> 主题</th>
      <th class="tn-border-gray tn-border-bottom tn-text-note">&nbsp; </th>
      <td class="tn-border-gray tn-border-bottom tn-text-note"><%=GetResourceString("Label_Auto",applicationID)%></td>
      <td class="tn-border-gray tn-border-bottom tn-text-note"><%=GetResourceString("Label_ReplyNum",applicationID)%></td>
      <td class="tn-border-gray tn-border-bottom tn-text-note"><%=GetResourceString("Label_LastReplyData",applicationID)%></td>
    </tr>
    <%foreach (ForumThread thread in Model)
          {             
        %>
    <tr class="tn-table-grid-row">
      <th class="tn-border-gray tn-border-bottom"> <a href="<%=SiteUrls.Instance().ShowForumThreadInClub(clubDomainName,thread.ThreadID) %>"> <%=thread.Subject%></a> </th>
      <th class="tn-border-gray tn-border-bottom"> <%=SPBHtmlHelper.Instance().ContentTypeThumbnail(thread.AttachmentFilename,ContentTypeThumbnailSize.Small)%> </th>
      <td class="tn-border-gray tn-border-bottom tn-nowrap"><a target="_blank" href="<%=SiteUrls.Instance().UserChannelHome(thread.UserID, UserDomainSpecialAppIDs.Instance().Home()) %>"> <%=thread.Author %></a></td>
      <td class="tn-border-gray tn-border-bottom"><em class="tn-text-note"> <%=thread.ReplyCount%></em></td>
      <td class="tn-border-gray tn-border-bottom tn-nowrap"><em class="tn-text-note"> <%=Formatter.FormatDate(thread.LastRepliedDate)%></em></td>
    </tr>
    <%} %>
  </tbody>
</table>
<div class="tn-blank10"> </div>
<%} %>
