﻿<%@ Control Language="C#" Inherits="SpaceBuilder.Web.SPBViewUserControl<PagingDataSet<ForumThread>>" %>
<% string clubDomainName = Html.GetParameterFromRouteDateOrQueryString("clubDomainName");
   int forumApplication = ApplicationIDs.Instance().Forum();%>
<div id="ListMyForums">
    <table class="tn-table-grid">
        <tr class="tn-table-grid-header">
            <td class="tn-border-gray tn-border-bottom" colspan="2">
            </td>
            <td class="tn-border-gray tn-border-bottom tn-text-note">
                <%=GetResourceString("Label_SectionOrClub",forumApplication)%>
            </td>
            <td class="tn-border-gray tn-border-bottom tn-text-note">
                <%=GetResourceString("Label_ReplayScan",forumApplication)%>
            </td>
            <td class="tn-border-gray tn-border-bottom tn-text-note">
                <%=GetResourceString("Label_LastRepliedDate",forumApplication)%>
            </td>
        </tr>
        <%  string showFromUrl = string.Empty;
            foreach (ForumThread thread in ViewData.Model.Records)
            {
                showFromUrl = SiteUrls.Instance().ShowForumThreadInClub(clubDomainName, thread.ThreadID);%>
        <tr class="tn-table-grid-row">
            <td class="tn-border-gray tn-border-bottom spb-topic-icon">
                <a target="_blank" title="普通主题" href="<%=showFromUrl %>"><span class="tn-icon tn-icon-big tn-icon-topic-normal">
                </span></a>
            </td>
            <td class="tn-border-gray tn-border-bottom tn-width-auto">
                <a href="<%=showFromUrl %>" title="<%=thread.Subject %>">
                    <%=StringUtils.Trim(thread.Subject,20)%></a>
                <%if (thread.IsSticky)
                      Response.Write(SPBHtmlHelper.Instance().Icon(IconTypes.Top, GetResourceString("Action_Top", forumApplication), new RouteValueDictionary { { "class", "tn-icon-inline" } }));
                  if (thread.IsEssential)
                      Response.Write(SPBHtmlHelper.Instance().Icon(IconTypes.Elite, GetResourceString("Action_Essential", forumApplication), new RouteValueDictionary { { "class", "tn-icon-inline" } }));
                  if (thread.Price > 0)
                      Response.Write(SPBHtmlHelper.Instance().Icon(IconTypes.Coins, string.Format(GetResourceString("Action_Takes", forumApplication), thread.Price), new RouteValueDictionary { { "class", "tn-icon-inline" } }));
                  if (thread.IsHot)
                      Response.Write(SPBHtmlHelper.Instance().Icon(IconTypes.Fire, GetResourceString("Action_HotTopic", forumApplication), new RouteValueDictionary { { "class", "tn-icon-inline" } }));
                  if (thread.IsLocked)
                      Response.Write(SPBHtmlHelper.Instance().Icon(IconTypes.Lock, GetResourceString("Action_Lock", forumApplication), new RouteValueDictionary { { "class", " tn-icon-inline" } }));%>
                <%=SPBHtmlHelper.Instance().ContentTypeThumbnail(thread.AttachmentFilename,ContentTypeThumbnailSize.Small)%>
                <%if (thread.ReplyCount > ForumConfiguration.Instance().PostsPerPage)
                  { %>
                <span class="spb-topic-pages tn-text-note">
                    <%=SPBHtmlHelper.Instance().ShowForumThreadPager(thread,null) %></span>
                <%} %>
            </td>
            <td class="tn-border-gray tn-border-bottom tn-width-user-name tn-nowrap">
                <%if (thread.ForumSection != null)
                  {%>
                <a href="<%=SiteUrls.Instance().ShowForumSectionInClub(clubDomainName,thread.ForumSection.SectionID)%>"
                    title="<%=thread.ForumSection.SectionName %>">
                    <%=StringUtils.Trim(thread.ForumSection.SectionName,8)%></a>
                <%} %>
            </td>
            <td class="tn-border-gray tn-border-bottom tn-width-number tn-nowrap">
                <cite><a href="<%=showFromUrl %>">
                    <%=thread.ReplyCount %></a></cite> <em class="tn-text-note">
                        <%=thread.HitTimes %></em>
            </td>
            <td class="tn-border-gray tn-border-bottom tn-width-user-name tn-nowrap">
                <%if (thread.MostRecentPostID > 0)
                  { %>
                <cite>
                    <%if (thread.MostRecentPostAuthorID > 0)
                      { %>
                    <a href="<%=SiteUrls.Instance().UserChannelHome(thread.MostRecentPostAuthorID,forumApplication)  %>"
                        title="<%=thread.MostRecentPostAuthor%>" target="_blank">
                        <%=thread.MostRecentPostAuthor%></a>
                    <%}
                      else
                          Response.Write(thread.MostRecentPostAuthor); %>
                </cite><a href="<%=SiteUrls.Instance().ShowForumThreadGotoLastPostInClub(clubDomainName,thread.ThreadID,thread.MostRecentPostID) %>"
                    title="<%=thread.LastRepliedDate %>"><em class="tn-text-note">
                        <%=Formatter.FormatFriendlyDate(thread.LastRepliedDate)%></em></a>
                <%} %>
            </td>
        </tr>
        <%} %>
    </table>
    <div class="tn-pagination tn-helper-align-center">
        <%=SPBHtmlHelper.Instance().AjaxPagingButton(ViewData.Model.TotalRecords, ViewData.Model.PageSize, ViewData.Model.PageIndex, 11, SPBUrlHelper.Action("Control_ListMyForums", "ClubForum", new RouteValueDictionary { { "clubDomainName", clubDomainName }, { "pageIndex", "{0}" } }), "pageIndexChange")%>
        <div class="tn-page-results tn-text-note">
            <%=string.Format(GetResourceString("Label_Pattern_TotalRecords"), ViewData.Model.TotalRecords)%></div>
    </div>
</div>
<script type="text/javascript">
    function pageIndexChange(url) {
        $('#ListMyForums').parent().load(url);
    }
</script>
