﻿<%@ Control Language="C#" Inherits="SpaceBuilder.Web.SPBViewUserControl<PagingDataSet<ForumPost>>" %>
<%Dictionary<int, ForumThread> forumThreads = ViewData["forumThreads"] as Dictionary<int, ForumThread>; %>
<% string clubDomainName = Html.GetParameterFromRouteDateOrQueryString("clubDomainName");
   int forumApplication = ApplicationIDs.Instance().Forum();

%>
<div id="ListPostForums">
    <table class="tn-table-grid">
        <tr class="tn-table-grid-header">
            <td class="tn-border-gray tn-border-bottom">
            </td>
            <td class="tn-border-gray tn-border-bottom tn-text-note">
                <%=GetResourceString("Label_ReplayScan",forumApplication)%>
            </td>
            <td class="tn-border-gray tn-border-bottom tn-text-note">
                <%=GetResourceString("Label_LastRepliedDate",forumApplication)%>
            </td>
        </tr>
        <%foreach (ForumPost post in Model.Records)
          {
              ForumThread thread = forumThreads[post.ThreadID];
        %>
        <tr class="tn-table-grid-row">
            <td class="tn-border-gray tn-border-bottom tn-width-auto">
                <%if (forumThreads[post.ThreadID].ForumSection != null)
                  { %>
                <a href="<%=SiteUrls.Instance().ShowForumSection(thread.ForumSection.SectionID) %>"
                    class="tn-category" title="<%=forumThreads[post.ThreadID].ForumSection.SectionName%>">
                    【<%=forumThreads[post.ThreadID].ForumSection.SectionName%>】</a>
                <%} %>
                <a href="<%=SiteUrls.Instance().ShowForumThread(thread.ThreadID)%>" class="tn-text-heading"
                    title="<%=post.Subject%>">
                    <%=StringUtils.Trim(post.Subject,20)%></a>
                <p>
                    <%=HtmlUtils.TrimHtml(post.Body,30)%></p>
            </td>
            <td class="tn-border-gray tn-border-bottom tn-width-number tn-nowrap">
                <cite>
                    <a href="<%=SiteUrls.Instance().ShowForumThread(thread.ThreadID)%>">
                        <%=thread.ReplyCount %></a></cite> <em class="tn-text-note">
                            <%=thread.HitTimes %></em> </td>
            <td class="tn-border-gray tn-border-bottom tn-width-user-name tn-nowrap">
                <cite>
                    <a href="<%=SiteUrls.Instance().UserDomainHome(thread.MostRecentPostAuthorID)%>"
                        title="<%=thread.MostRecentPostAuthor %>">
                        <%=thread.MostRecentPostAuthor %></a></cite> <em class="tn-text-note">
                            <%=Formatter.FormatDate(thread.LastRepliedDate)%></em> </td>
        </tr>
        <%} %>
    </table>
    <div class="tn-pagination tn-helper-align-center">
        <%=SPBHtmlHelper.Instance().AjaxPagingButton(ViewData.Model.TotalRecords, ViewData.Model.PageSize, ViewData.Model.PageIndex, 11, SPBUrlHelper.Action("Control_ListPostForums", "ClubForum", new RouteValueDictionary { { "clubDomainName", clubDomainName }, { "pageIndex", "{0}" } }), "ListPostForumsPageIndexChange")%>
        <div class="tn-page-results tn-text-note">
            <%=string.Format(GetResourceString("Label_Pattern_TotalRecords"), ViewData.Model.TotalRecords)%></div>
    </div>
</div>

<script type="text/javascript">
    function ListPostForumsPageIndexChange(url) {
        $('#ListPostForums').parent().load(url);
    }
</script>

