﻿<%@ Control Language="C#" Inherits="SpaceBuilder.Web.SPBViewUserControl" %>
<spb:Script runat="server" ID="JqueryFormJs" Src="~/Utility/jquery/plugin/jquery.form.min-2.7.3.js"
    SetExpireDays="30" />
<spb:Script runat="server" ID="artDialog" Src="~/Utility/jquery/plugin/jquery.artDialog.min-3.0.5.js"
    SetExpireDays="30" />
<spb:Script runat="server" ID="blockUI" Src="~/Utility/jquery/plugin/jquery.blockUI-2.3.3.js"
    SetExpireDays="30" />
<spb:Script runat="server" ID="superfish" Src="~/Utility/jquery/plugin/jquery.superfish-1.4.8.js"
    SetExpireDays="30" />
<%
    
    string clubDomainName = Html.GetParameterFromRouteDateOrQueryString("clubDomainName");
    Club currentClub = Clubs.GetClub(clubDomainName, false);
    if (currentClub == null)
        throw new SPBException(ExceptionTypes.Instance().ClubDomainNotFond());
    int notReadMessageCount = 0;
    int unsettledInvitationTotalCount = 0;
    int notReadNoticeCount = 0;
    int applicationID = ViewData.GetInt("applicationID", 0);
    bool isShow = ViewData.GetBool("isShow", false);
    if (CurrentUser != null)
    {
        //获取未读消息
        notReadMessageCount = PrivateMessages.GetNoReadCount(CurrentUser.UserID);

        //获取未处理邀请字典集合
        Dictionary<int, int> unsettledInvitationCounts = Invitations.GetUnsettledCounts(CurrentUser.UserID);

        foreach (KeyValuePair<int, int> pair in unsettledInvitationCounts)
        {
            unsettledInvitationTotalCount += pair.Value;
        }
        notReadNoticeCount = InstationNotices.GetNoReadCount(CurrentUser.UserID);
    }
    int currentUserPresentAreaID = PresentAreaIDs.Instance().ClubDomain();
    int totalCount = notReadMessageCount + unsettledInvitationTotalCount + notReadNoticeCount;
    //IList<Navigation> channelNavigations = Navigations.GetChannelNavigations();
    bool isRealTime = CurrentUser != null && ClubPermission.Validate(currentClub, CurrentUser, PermissionItemKeys.Instance().EditClub());
    IList<OwnerNavigation> clubNavigations = Navigations.GetOwnerNavigations(currentUserPresentAreaID, currentClub.ClubID, isRealTime);
    IList<OwnerNavigation> userNavigations = null;
    if (CurrentUser != null)
        userNavigations = Navigations.GetOwnerNavigations(PresentAreaIDs.Instance().UserDomain(), CurrentUser.UserID, true);
    SiteCategory siteCategory = SiteCategories.Instance(ApplicationIDs.Instance().Club()).Get(currentClub.CategoryID, false);
    string clubDomainHomeUrl;
    if (ClubDomainConfiguration.Instance().UseFriendlyUrl)
        clubDomainHomeUrl = string.Format(ClubDomainConfiguration.Instance().FriendlyUrlPattern, currentClub.DomainName);
    else
        clubDomainHomeUrl = WebUtils.FullPath(SiteUrls.Instance().ClubDomainHome(clubDomainName));
    int clubApplicationID = ApplicationIDs.Instance().Club();
    PresentArea presentArea = PresentAreas.GetPresentArea(PresentAreaIDs.Instance().ClubDomain(), false);
    IList<Club> clubs = Clubs.GetMyClubs(CurrentUser != null ? CurrentUser.UserID : 0, 30);
%>
<div class="spb-top-menubar">
    <div class="tn-wrapper-inner tn-helper-clearfix">
        <div class="spb-home-link">
            <span class="tn-icon tn-icon-home"></span><a class="spb-top-logo-link" href="<%=SiteUrls.Instance().Home() %>">
                <%=Globals.SiteName %></a>
        </div>
        <div class="tn-search-box">
            <form id="searchForm" name="searchForm" action="<%=SPBUrlHelper.Action("Search","ChannelClub") %>" method="post">
            <input class="tn-search-input tn-border-gray tn-border-tbl" type="text" maxlength="50" name="keyword" />
            <span class="tn-search-button tn-search-ico-button tn-border-gray tn-bg-gray">
                <button onclick="$('#searchForm').submit();">
                    <span class="tn-icon tn-icon-find"></span>
                </button>
            </span>
            </form>
        </div>
        <div class="spb-user-menu">
            <% 
                if (CurrentUser != null)
                { %>
            <ul class="sf-menu">
                <li><a href="<%=WebUtils.ResolveUrl("~/Help/Home.html") %>" target="_blank">
                    <%=GetResourceString("Action_Help")%></a></li>
                <li><a href="<%=SPBUrlHelper.Action("Logout", "ChannelUser")%>">
                    <%=GetResourceString("Action_Logout")%></a></li>
                <li>
                    <%if (clubs.Count <= 0)
                      {%>
                    <a href="<%=Globals.GetFullUrlInMainSite(SPBUrlHelper.Action("NewClub", "ChannelClub"))%>">
                        <%=GetResourceString("Button_CreateClub",clubApplicationID) %></a>
                    <%}
                      else
                      { %>
                    <a href="javascript:;" class="sf-with-ul">
                        <%=GetResourceString("Title_MyClub",clubApplicationID) %></a>
                    <ul class="tn-widget tn-widget-content tn-bg-light tn-corner-all" style="visibility: hidden;
                        display: none;">
                        <%foreach (Club club in clubs)
                          {
                              if (club == null || club.ClubID <= 0)
                                  continue; 
                        %>
                        <li><a href="<%=SiteUrls.Instance().ClubDomainHome(club.ClubID)%>">
                            <%=club.ClubName %></a></li>
                        <%} %>
                    </ul>
                    <%} %>
                </li>
                <li class="tn-msg-bubble-position"><a class="sf-with-ul" href="<%=SiteUrls.Instance().UserDomainHome(CurrentUser) %>">
                    <%=SPBHtmlHelper.Instance().UserDisplayName(CurrentUser)%></a>
                    <ul class="tn-widget tn-widget-content tn-bg-light tn-corner-all" style="display: none;
                        visibility: hidden;">
                        <li><a href="<%=Globals.GetFullUrlInMainSite(SiteUrls.Instance().UserDomainHome(CurrentUser.UserName))%>">
                            <% if (CurrentUser.UserType == UserTypes.PersonUser) Response.Write(GetResourceString("Navigation_UserDomain_MyHome")); else Response.Write(GetResourceString("Navigation_UserDomain_Home"));%></a></li>
                        <li><a href="<%=SiteUrls.Instance().UserSettingsHome(CurrentUser.UserName) %>">
                            <%=GetResourceString("Action_SettingsHome")%></a></li>
                        <%  if (CurrentUser.IsInRoles(SiteSettingsManager.GetSiteSettings().RoleNamesForEnterControlPanel))
                            { %>
                        <li class="spb-separator tn-border-light tn-border-bottom"></li>
                        <li><a target="_blank" href="<%=SiteUrls.Instance().ManageHome() %>">
                            <%=GetResourceString("Navigation_Manage_Home")%></a></li>
                        <%}
                            if (userNavigations != null)
                            { %>
                        <li class="spb-separator tn-border-light tn-border-bottom"></li>
                        <%  foreach (OwnerNavigation navigation in userNavigations)
                            { %>
                        <li><a href="<%=navigation.GetUserNavigationUrl(CurrentUser.UserName)%>">
                            <%=string.Format(GetResourceString("Navigation_Pattern_MyNavigation"), navigation.GetMultilingualNavigationName(CurrentUserLanguage))%></a></li>
                        <%}
                            } %>
                    </ul>
                </li>
            </ul>
            <%}
                else
                { %>
            <ul id="AnonymousPanel">
                <li><a href="<%=WebUtils.ResolveUrl("~/Help/Home.html") %>" target="_blank">
                    <%=GetResourceString("Common_Help")%></a></li>
                <%if (SiteSettingsManager.GetSiteSettings().RegistrationMode == RegistrationModes.EnableAll)
                  { %>
                <li><a href="<%=SiteUrls.Instance().UserRegister() %>">
                    <%=GetResourceString("Action_Register")%></a></li>
                <%} %>
                <li><a href="<%=SiteUrls.Instance().LoginInModal() %>" id="loginInModalButton">
                    <%=GetResourceString("Action_Login")%></a></li>
            </ul>
            <%} %>
        </div>
    </div>
</div>
<div class="spb-branding-area">
    <div class="tn-wrapper-inner">
        <%if (currentClub.ClubHeaderShowTypes != ClubHeaderShowTypes.OnlyShowText && currentClub.HasBanner)
          { %>
        <div class="spb-club-image">
            <%=SPBHtmlHelper.Instance().ShowClubBanner(currentClub.ClubID, true,null)%>
        </div>
        <%} %>
        <%if (currentClub.ClubHeaderShowTypes != ClubHeaderShowTypes.OnlyShowBanner)
          { %>
        <h1 class="spb-club-name">
            <%=currentClub.ClubName%></h1>
        <p class="spb-club-intro">
            <%=currentClub.Brief %></p>
        <%} %>
    </div>
</div>
<div class="spb-nav1-area">
    <div class="tn-wrapper-inner tn-helper-clearfix">
        <%if (isShow)
          { %>
        <div class="tn-shortcut">
            <% if (CurrentUser != null && ClubMembers.HasClubManagerPermission(currentClub.ClubID, CurrentUser.UserID) || CurrentUser != null && CurrentUser.IsContentAdministrator)
               {%>
            <%=SPBHtmlHelper.Instance().LinkButton("clubManage", GetResourceString("Action_Manage"), SPBUrlHelper.Action("Home", "ClubManage", new RouteValueDictionary { { "clubDomainName", currentClub.DomainName } }), ButtonSizes.Default, HighlightStyles.Default, IconTypes.TriangleDown, TextIconLayout.MenuButton, new RouteValueDictionary { { "menu", "#manage" }, { "class", "tn-menu-button-active" } }, null)%>
            <ul id="manage" class="tn-menu-button-position tn-menu tn-menu-text-icon tn-helper-reset tn-widget-content">
                <%if (presentArea != null && presentArea.EnableThemes)
                  { %>
                <li class="tn-menu-item"><a class="tn-menu-text" href="<%=SPBUrlHelper.Action("ModifyHome","ClubManage",new RouteValueDictionary{{"clubDomainName", currentClub.DomainName}}) %>">
                    <%=GetResourceString("Action_ModifyClubHome", clubApplicationID)%></a></li>
                <%} %>
                <li class="tn-menu-item"><a class="tn-menu-text" href="<%=SPBUrlHelper.Action("Home", "ClubManage", new RouteValueDictionary { { "clubDomainName", currentClub.DomainName } }) %>">
                    <%=GetResourceString("Button_EnterControlPanel", clubApplicationID)%></a></li>
                <% if (CurrentUser.IsContentAdministrator)
                   {%>
                <li class="tn-menu-item"><a class="tn-menu-text" id="recommendClubModel" href="<%=SiteUrls.Instance().RecommendItem(ApplicationIDs.Instance().Club(),currentClub.ClubOwnerUserID,currentClub.ClubID,currentClub.ClubName)%>">
                    <%=GetResourceString("Common_ManagerRecommend")%></a></li>
                <%}%>
            </ul>
            <%} %>
            <%    bool isClubMember = false;
                  if (CurrentUser != null)
                  {
                      ClubMember member = ClubMembers.GetClubMember(currentClub.ClubID, CurrentUser != null ? CurrentUser.UserID : 0, true);
                      if (member != null)
                          isClubMember = true;
                  } if (currentClub.IsPublic && CurrentUser != null && !isClubMember)
                  {%>
            <%=SPBHtmlHelper.Instance().LinkButton("applyJionClub", GetResourceString("Action_ApplyClubMember", clubApplicationID), SPBUrlHelper.Action("ApplyClubMember", "ClubDomain", new RouteValueDictionary { { "clubDomainName", currentClub.DomainName }, { "inviteUserID", -1 } }), ButtonSizes.Default, HighlightStyles.Primary, IconTypes.Join, TextIconLayout.IconText)%>
            <%}
                  string excetionType = ExceptionTypes.Instance().AccessDenied();
                  if (CurrentUser != null && ClubPermission.Validate(currentClub, CurrentUser, PermissionItemKeys.Instance().InviteFriendJoinClub(), ref excetionType) && isClubMember)
                  {%>
            <%=SPBHtmlHelper.Instance().LinkButton("inviteFirends", GetResourceString("Action_InvitationFriend"), SPBUrlHelper.Action("NewJoinClubInvitation", "ClubDomain", new RouteValueDictionary { { "clubDomainName", currentClub.DomainName } }), ButtonSizes.Default, HighlightStyles.Primary, IconTypes.UserInvite, TextIconLayout.IconText)%>
            <%}%>
        </div>
        <%} %>
        <ul class="spb-nav1">
            <li <% if(applicationID==ClubDomainSpecialAppIDs.Instance().Home()) Response.Write("class=\"spb-nav-item tn-selected\""); else Response.Write("class=\"spb-nav-item\""); %>>
                <a href="<%=SPBUrlHelper.Action("Home","ClubDomain",new RouteValueDictionary{{"clubDomainName",currentClub.DomainName}}) %>">
                    <span>
                        <%=GetResourceString("Navigation_ClubDomain_Home")%></span></a></li>
            <%
                foreach (var navigation in clubNavigations)
                {
                    if (navigation.IsEnabled)
                        Response.Write(string.Format("<li class=\"{2}\"><a target=\"{0}\" href=\"{1}\"><span>{3}</span></a></li>", navigation.NavigationTarget, navigation.GetClubNavigationUrl(currentClub.DomainName), applicationID == navigation.ApplicationID ? "spb-nav-item tn-selected" : "spb-nav-item", HtmlUtils.TrimHtml(navigation.GetMultilingualNavigationName(CurrentUserLanguage), 6)));
                }
            %>
            <li <% if(applicationID==ClubDomainSpecialAppIDs.Instance().Share()) Response.Write("class=\"spb-nav-item tn-selected\""); else Response.Write("class=\"spb-nav-item\""); %>>
                <a href="<%=SPBUrlHelper.Action("Share","ClubDomain",new RouteValueDictionary{{"clubDomainName",currentClub.DomainName}}) %>">
                    <span>
                        <%=GetResourceString("Navigation_ClubDomain_Share")%></span></a></li>
            <%--<% if (ClubMembers.HasClubManagerPermission(currentClub.ClubID, CurrentUser != null ? CurrentUser.UserID : 0) || CurrentUser.IsContentAdministrator)
               {%>--%>
            <li <% if(applicationID==ClubDomainSpecialAppIDs.Instance().Activities()) Response.Write("class=\"spb-nav-item tn-selected\""); else Response.Write("class=\"spb-nav-item\""); %>>
                <a href="<%=SPBUrlHelper.Action("ListClubActivities","ClubDomain",new RouteValueDictionary{{"clubDomainName",currentClub.DomainName}}) %>">
                    <span>
                        <%=GetResourceString("Title_ClubDynamic",clubApplicationID) %></span></a></li>
            <li <% if(applicationID==ClubDomainSpecialAppIDs.Instance().Members()) Response.Write("class=\"spb-nav-item tn-selected\""); else Response.Write("class=\"spb-nav-item\""); %>>
                <a href="<%=SPBUrlHelper.Action("Home","ClubMember",new RouteValueDictionary{{"clubDomainName",currentClub.DomainName}}) %>">
                    <span>
                        <%=GetResourceString("Title_ClubMember",clubApplicationID) %></span></a></li>
            <%--<%} %>--%>
        </ul>
    </div>
</div>
<script type="text/javascript">
    $(document).ready(function() {
        $("#keyword").watermark('<%=GetResourceString("Label_FindClubs",clubApplicationID) %>');
        $("a[menu]").menuButton();
        $('ul.sf-menu').superfish();
        $('#loginInModalButton').dialog({
                id: 'loginDialog',
                title: '登录',
                width: 400             
            });
        $('#recommendClubModel').nyroModal({
            resizeable: true,
            height: 450,
            width: 400
        });
       if(<%=totalCount %> > 0)
        newMessageHint('<%=GetResourceString("Description_NewMessage")%>');

    });  
</script>
