﻿<%@ Control Language="C#" Inherits="SpaceBuilder.Web.SPBViewUserControl<PagingDataSet<ClubActivity>>" %>
<% string clubDomainName = Html.GetParameterFromRouteDateOrQueryString("clubDomainName");%>
<div id="ListClubActivities">
    <% 
        if (TempData["StatusMessageData"] != null)
        {
            StatusMessageData statusMessageData = TempData.Get<StatusMessageData>("StatusMessageData", new StatusMessageData(StatusMessageType.Error, string.Empty));
            if (statusMessageData.MessageType == StatusMessageType.Success)
                Response.Write(SPBHtmlHelper.Instance().StatusMessage(statusMessageData, 3000, false));
            else
                Response.Write(SPBHtmlHelper.Instance().StatusMessage(statusMessageData));
            TempData["StatusMessageData"] = null;
        }

        int returnPageIndex = Model.PageIndex;
        if (Model.TotalRecords == (returnPageIndex * Model.PageSize + 1))
            returnPageIndex = returnPageIndex - 1;
        bool HasClubManagerPermission = ViewData.GetBool("HasClubManagerPermission", false);
        int applicationID = ApplicationIDs.Instance().Club();
    %>
    <div class="tn-box tn-widget tn-widget-content tn-corner-all">
        <div class="tn-box-header tn-widget-header tn-corner-top tn-border-bottom">
            <h3 class="tn-helper-reset">
                <%=GetResourceString("Title_ClubDynamic",applicationID)%></h3>
        </div>
        <div class="tn-box-content tn-widget-content tn-corner-bottom">
            <%if (Model.Records.Count > 0)
              {%>
            <ul class="tn-list tn-helper-reset">
                <% 
                    Dictionary<int, Application> applications = Applications.GetApplications();
                    string applicationKey = "default";
                    string applicationName = GetResourceString("Description_ClubDynamic", applicationID);

                    foreach (ClubActivity clubActivity in Model.Records)
                    {%>
                <li class="tn-list-item tn-helper-clearfix tn-border-gray tn-border-bottom">
                    <div class="tn-list-item-area-left">
                        <%
                            if (applications.ContainsKey(clubActivity.ApplicationID))
                            {
                                applicationKey = applications[clubActivity.ApplicationID].ApplicationKey;
                                applicationName = applications[clubActivity.ApplicationID].GetMultilingualApplicationName(CurrentUserLanguage);
                            }
                            string filePath = Globals.GetFullUrlInResourceSite(string.Format("~/Themes/Shared/Styles/Icons/activity_{0}.gif", applicationKey.ToLower()));
                        %>
                        <img src="<%=filePath %>" title="<%=string.Format(GetResourceString("Description_Pattern_ClubDynamic",ApplicationIDs.Instance().Club()),applicationName)%>"
                            alt="<%=string.Format(GetResourceString("Description_Pattern_ClubDynamic",ApplicationIDs.Instance().Club()),applicationName)%>"
                            width="16" height="16" />
                    </div>
                    <% if (HasClubManagerPermission)
                       {                               
                    %>
                    <div class="tn-list-item-area-right">
                        <%=SPBHtmlHelper.Instance().LinkButton("del", HighlightStyles.Lite, IconTypes.Cross, new RouteValueDictionary { { "onclick", "DeleteThisActivity('"+SPBUrlHelper.Action("DeleteClubActivity","ClubDomain",new RouteValueDictionary{{"clubDomainName",clubDomainName},{"applicationID",clubActivity.ApplicationID},{"activityID",clubActivity.ActivityID},{"pageIndex",returnPageIndex }})+"')" }, { "title", GetResourceString("Action_Delete") } }, null)%>
                    </div>
                    <%} %>
                    <div class="tn-list-item-area-main">
                        <div class="tn-list-item-row tn-list-item-heading">
                            <a href="<%=SiteUrls.Instance().UserDomainHome(clubActivity.LeadingActorUserID) %>"
                                target="_blank">
                                <%=SPBHtmlHelper.Instance().UserDisplayName(clubActivity.LeadingActorUserID, true)%></a><%=clubActivity.Subject%><em class="tn-text-note tn-date"><%= Convert.ToString(Formatter.FormatFriendlyDate(clubActivity.DateCreated))%></em></div>
                        <div class="tn-list-item-row tn-list-item-summary">
                            <p class="tn-helper-reset">
                                <%=clubActivity.Body%></p>
                            <div class="tn-list-item-row">
                            </div>
                        </div>
                    </div>
                </li>
                <%} %>
            </ul>
            <%}
              else
              {  %>
            <p>
                <%=GetResourceString("Description_ThisPageNotHaveClubDynamic", applicationID)%><a
                    href="<%=SiteUrls.Instance().ClubDomainHome(clubDomainName) %>"><%=GetResourceString("Description_GoClubDomain", applicationID)%></a>
            </p>
            <%} %>
        </div>
    </div>
    <div class="tn-pagination tn-helper-align-center">
        <%=SPBHtmlHelper.Instance().AjaxPagingButton(PaginationMode.NumericNextPrevious, Model.TotalRecords, Model.PageSize, Model.PageIndex, 11, SPBUrlHelper.Action("Control_ListClubActivities", "ClubDomain", new RouteValueDictionary { { "clubDomainName", clubDomainName }, { "pageIndex", "{0}" } }), "pageIndexChange")%>
    </div>

    <script type="text/javascript">
        function DeleteThisActivity(url) {
            $('#ListClubActivities').parent().load(url);
        }
        function pageIndexChange(url) {
            $('#ListClubActivities').parent().load(url);
        }

    </script>

</div>
